-- MySQL dump 10.13  Distrib 8.0.36, for Linux (x86_64)
--
-- Host: server    Database: budsies_staging
-- ------------------------------------------------------
-- Server version	8.0.36

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_adobe_ims_webapi`
--

DROP TABLE IF EXISTS `admin_adobe_ims_webapi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_adobe_ims_webapi` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `access_token_hash` varchar(255) DEFAULT NULL COMMENT 'Access Token Hash',
  `access_token` text COMMENT 'Access Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `last_check_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Last check time',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ADOBE_IMS_WEBAPI_ACCESS_TOKEN_HASH` (`access_token_hash`),
  KEY `ADMIN_ADOBE_IMS_WEBAPI_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `ADMIN_ADOBE_IMS_WEBAPI_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin Adobe IMS Webapi';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_analytics_usage_version_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_passwords` (
  `password_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_PASSWORDS_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user` (
  `user_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_user_expiration`
--

DROP TABLE IF EXISTS `admin_user_expiration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user_expiration` (
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `expires_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'User Expiration Date',
  PRIMARY KEY (`user_id`),
  CONSTRAINT `ADMIN_USER_EXPIRATION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Admin User expiration dates table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_user_session` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(1) DEFAULT NULL COMMENT 'Deprecated: Session ID value no longer used',
  `user_id` int unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `ADMIN_USER_SESSION_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2873 DEFAULT CHARSET=utf8mb3 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  `is_amasty` smallint NOT NULL DEFAULT '0' COMMENT 'Is Amasty Notification',
  `expiration_date` datetime DEFAULT NULL COMMENT 'Expiration Date',
  `image_url` text COMMENT 'Image Url',
  `aitoc_notification` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Aitoc Notification',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=366 DEFAULT CHARSET=utf8mb3 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `adobe_stock_asset`
--

DROP TABLE IF EXISTS `adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_asset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` (`media_gallery_id`),
  KEY `ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `ADOBE_STOCK_ASSET_CATEGORY_ID_ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_CREATOR_ID_ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ADOBE_STOCK_ASSET_MEDIA_GALLERY_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `adobe_stock_category`
--

DROP TABLE IF EXISTS `adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `adobe_stock_creator`
--

DROP TABLE IF EXISTS `adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_stock_creator` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `adobe_user_profile`
--

DROP TABLE IF EXISTS `adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `adobe_user_profile` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `ADOBE_USER_PROFILE_ADMIN_USER_ID` (`admin_user_id`),
  CONSTRAINT `ADOBE_USER_PROFILE_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_attribute`
--

DROP TABLE IF EXISTS `amasty_acart_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_attribute` (
  `attr_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `code` varchar(255) NOT NULL COMMENT 'Email',
  PRIMARY KEY (`attr_id`),
  KEY `AMASTY_ACART_ATTRIBUTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  CONSTRAINT `AMASTY_ACART_ATTRIBUTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_blacklist`
--

DROP TABLE IF EXISTS `amasty_acart_blacklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_blacklist` (
  `blacklist_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Blacklist Id',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  PRIMARY KEY (`blacklist_id`),
  UNIQUE KEY `AMASTY_ACART_BLACKLIST_CUSTOMER_EMAIL` (`customer_email`)
) ENGINE=InnoDB AUTO_INCREMENT=502 DEFAULT CHARSET=utf8mb3 COMMENT='amasty_acart_blacklist';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_email_template`
--

DROP TABLE IF EXISTS `amasty_acart_email_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_email_template` (
  `template_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Template Id',
  `schedule_id` int unsigned NOT NULL COMMENT 'Schedule Id',
  `template_code` varchar(150) NOT NULL DEFAULT '' COMMENT 'Template Name',
  `template_text` text NOT NULL COMMENT 'Template Content',
  `template_styles` text COMMENT 'Template Styles',
  `template_type` int unsigned DEFAULT NULL COMMENT 'Template Type',
  `template_subject` varchar(200) NOT NULL COMMENT 'Template Subject',
  `orig_template_variables` text COMMENT 'Original Template Variables',
  `is_legacy` tinyint(1) NOT NULL COMMENT 'Is Legacy',
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `AMASTY_ACART_EMAIL_TEMPLATE_TEMPLATE_CODE` (`template_code`),
  KEY `FK_F4B32E69000BFF66607568C4933D66BA` (`schedule_id`),
  CONSTRAINT `FK_F4B32E69000BFF66607568C4933D66BA` FOREIGN KEY (`schedule_id`) REFERENCES `amasty_acart_schedule` (`schedule_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart Email Template Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_guest_customer_quotes`
--

DROP TABLE IF EXISTS `amasty_acart_guest_customer_quotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_guest_customer_quotes` (
  `customer_id` int unsigned NOT NULL COMMENT 'Customer Id',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote Id',
  `orig_quote_id` int unsigned NOT NULL COMMENT 'Original Quote Id',
  PRIMARY KEY (`customer_id`,`quote_id`,`orig_quote_id`),
  KEY `AMASTY_ACART_GUEST_CUSTOMER_QUOTES_QUOTE_ID_QUOTE_ENTITY_ID` (`quote_id`),
  KEY `AMASTY_ACART_GUEST_CUSTOMER_QUOTES_ORIG_QUOTE_ID_QUOTE_ENTITY_ID` (`orig_quote_id`),
  CONSTRAINT `AMASTY_ACART_GUEST_CSTR_QUOTES_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_ACART_GUEST_CUSTOMER_QUOTES_ORIG_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`orig_quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_ACART_GUEST_CUSTOMER_QUOTES_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart Guest Customer Quotes Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_history`
--

DROP TABLE IF EXISTS `amasty_acart_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_history` (
  `history_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'History Id',
  `rule_quote_id` int unsigned DEFAULT NULL COMMENT 'Rule Quote ID',
  `schedule_id` int unsigned DEFAULT NULL COMMENT 'Schedule ID',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `public_key` varchar(255) DEFAULT NULL COMMENT 'Public Key',
  `email_subject` varchar(255) DEFAULT NULL COMMENT 'Email Subject',
  `email_body` mediumtext COMMENT 'Email Body',
  `sales_rule_id` int unsigned DEFAULT NULL COMMENT 'Sales Rule ID',
  `sales_rule_coupon_id` int unsigned DEFAULT NULL COMMENT 'Sales Rule Coupon ID',
  `sales_rule_coupon` varchar(255) DEFAULT NULL COMMENT 'Sales Rule Coupon',
  `scheduled_at` timestamp NULL DEFAULT NULL COMMENT 'Dcheduled Date',
  `executed_at` timestamp NULL DEFAULT NULL COMMENT 'Executed Date',
  `finished_at` timestamp NULL DEFAULT NULL COMMENT 'Finished Date',
  `sales_rule_coupon_expiration_date` timestamp NULL DEFAULT NULL COMMENT 'Expiration Date',
  `opened` int NOT NULL DEFAULT '0' COMMENT 'Email open counter',
  PRIMARY KEY (`history_id`),
  KEY `FK_819FFF7D7B22D8B71DEF484849FC07B4` (`rule_quote_id`),
  KEY `AMASTY_ACART_HISTORY_SALES_RULE_ID_SALESRULE_RULE_ID` (`sales_rule_id`),
  KEY `FK_CF4615181E7052E66CC2B0BB51853F2F` (`sales_rule_coupon_id`),
  KEY `FK_A2FF7CCCBC2589647A3585E511AE08D7` (`schedule_id`),
  KEY `AMASTY_ACART_HISTORY_STATUS` (`status`),
  CONSTRAINT `AMASTY_ACART_HISTORY_SALES_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`sales_rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_819FFF7D7B22D8B71DEF484849FC07B4` FOREIGN KEY (`rule_quote_id`) REFERENCES `amasty_acart_rule_quote` (`rule_quote_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A2FF7CCCBC2589647A3585E511AE08D7` FOREIGN KEY (`schedule_id`) REFERENCES `amasty_acart_schedule` (`schedule_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_CF4615181E7052E66CC2B0BB51853F2F` FOREIGN KEY (`sales_rule_coupon_id`) REFERENCES `salesrule_coupon` (`coupon_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='amasty_acart_history';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_history_details`
--

DROP TABLE IF EXISTS `amasty_acart_history_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_history_details` (
  `detail_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Detail Id',
  `history_id` int unsigned NOT NULL COMMENT 'Associated History Id',
  `product_name` text NOT NULL COMMENT 'Product Name',
  `sku` text NOT NULL COMMENT 'Product SKU',
  `price` decimal(10,0) unsigned NOT NULL COMMENT 'Product Price',
  `qty` int unsigned NOT NULL COMMENT 'Product Qty',
  `store_id` int unsigned NOT NULL COMMENT 'Associated Store ID to quote item',
  `currency_code` text NOT NULL COMMENT 'Associated currency code to quote item',
  PRIMARY KEY (`detail_id`),
  KEY `FK_C7E6BE039262C00423961543E039EC67` (`history_id`),
  CONSTRAINT `FK_C7E6BE039262C00423961543E039EC67` FOREIGN KEY (`history_id`) REFERENCES `amasty_acart_history` (`history_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart History Product Details Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_quote_email`
--

DROP TABLE IF EXISTS `amasty_acart_quote_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_quote_email` (
  `quote_email_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Quote Email Id',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote ID',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  PRIMARY KEY (`quote_email_id`),
  UNIQUE KEY `AMASTY_ACART_QUOTE_EMAIL_QUOTE_ID` (`quote_id`),
  CONSTRAINT `AMASTY_ACART_QUOTE_EMAIL_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='amasty_acart_quote_email';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_rule`
--

DROP TABLE IF EXISTS `amasty_acart_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `is_active` smallint NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `priority` smallint NOT NULL DEFAULT '1' COMMENT 'Priority',
  `conditions_serialized` mediumtext COMMENT 'Conditions Serialized',
  `cancel_condition` varchar(255) NOT NULL DEFAULT '' COMMENT 'Cancel Condition',
  `utm_source` varchar(255) DEFAULT NULL COMMENT 'Utm Source',
  `utm_medium` varchar(255) DEFAULT NULL COMMENT 'Utm Medium',
  `utm_term` varchar(255) DEFAULT NULL COMMENT 'Utm Term',
  `utm_content` varchar(255) DEFAULT NULL COMMENT 'Utm Content',
  `utm_campaign` varchar(255) DEFAULT NULL COMMENT 'Utm Campaign',
  PRIMARY KEY (`rule_id`),
  FULLTEXT KEY `FTI_20E92A70B7022B6D3721BA343A07BC85` (`name`,`utm_source`,`utm_medium`,`utm_term`,`utm_content`,`utm_campaign`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart Rule Grid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_rule_customer_group`
--

DROP TABLE IF EXISTS `amasty_acart_rule_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_rule_customer_group` (
  `rule_customer_group_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule-Customer Relation Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group Id',
  PRIMARY KEY (`rule_customer_group_id`),
  KEY `AMASTY_ACART_RULE_CSTR_GROUP_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  KEY `FK_898E5863210B2932733BE8D92E7347DC` (`customer_group_id`),
  CONSTRAINT `AMASTY_ACART_RULE_CSTR_GROUP_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_898E5863210B2932733BE8D92E7347DC` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart Rule-Customer Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_rule_quote`
--

DROP TABLE IF EXISTS `amasty_acart_rule_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_rule_quote` (
  `rule_quote_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Quote Id',
  `quote_id` int unsigned DEFAULT NULL COMMENT 'Quote ID',
  `rule_id` int unsigned DEFAULT NULL COMMENT 'Rule ID',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `store_id` smallint unsigned DEFAULT '0' COMMENT 'Store Id',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer Id',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  `customer_firstname` varchar(255) DEFAULT NULL COMMENT 'Customer Firstname',
  `customer_lastname` varchar(255) DEFAULT NULL COMMENT 'Customer Lastname',
  `test_mode` smallint NOT NULL DEFAULT '0' COMMENT 'Test Mode',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Date',
  `abandoned_status` varchar(25) NOT NULL DEFAULT 'notrestored' COMMENT 'Abandoned Cart Status',
  `customer_phone` varchar(50) DEFAULT NULL COMMENT 'Phone Number',
  PRIMARY KEY (`rule_quote_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` (`quote_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_STORE_ID_STORE_STORE_ID` (`store_id`),
  KEY `AMASTY_ACART_RULE_QUOTE_STATUS` (`status`),
  KEY `AMASTY_ACART_RULE_QUOTE_CUSTOMER_EMAIL` (`customer_email`),
  CONSTRAINT `AMASTY_ACART_RULE_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_ACART_RULE_QUOTE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_ACART_RULE_QUOTE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='amasty_acart_rule_quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_rule_store`
--

DROP TABLE IF EXISTS `amasty_acart_rule_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_rule_store` (
  `rule_store_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule-Store Relation Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store Id',
  PRIMARY KEY (`rule_store_id`),
  KEY `AMASTY_ACART_RULE_STORE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  KEY `AMASTY_ACART_RULE_STORE_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `AMASTY_ACART_RULE_STORE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_ACART_RULE_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Acart Rule-Store Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_acart_schedule`
--

DROP TABLE IF EXISTS `amasty_acart_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_acart_schedule` (
  `schedule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Schedule Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `template_id` int unsigned DEFAULT NULL COMMENT 'Template ID',
  `days` smallint unsigned DEFAULT NULL COMMENT 'Days',
  `hours` smallint unsigned DEFAULT NULL COMMENT 'Hours',
  `minutes` smallint unsigned DEFAULT NULL COMMENT 'Minutes',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `expired_in_days` smallint unsigned DEFAULT NULL COMMENT 'Expired In Days',
  `discount_qty` decimal(12,4) DEFAULT NULL COMMENT 'Discount Qty',
  `discount_step` int unsigned NOT NULL COMMENT 'Discount Step',
  `subtotal_is_greater_than` smallint unsigned DEFAULT NULL COMMENT 'Subtotal Is Greater Than',
  `use_shopping_cart_rule` tinyint(1) NOT NULL COMMENT 'Use Shopping Cart Rule',
  `sales_rule_id` int unsigned DEFAULT NULL COMMENT 'Sales Rule ID',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Date',
  `send_same_coupon` smallint NOT NULL DEFAULT '0' COMMENT 'Send Same Coupon',
  `use_campaign_utm` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Use Schedule Google Analytics UTM Parameters',
  `utm_source` varchar(255) DEFAULT NULL COMMENT 'Utm Source',
  `utm_medium` varchar(255) DEFAULT NULL COMMENT 'Utm Medium',
  `utm_campaign` varchar(255) DEFAULT NULL COMMENT 'Utm Campaign',
  PRIMARY KEY (`schedule_id`),
  KEY `AMASTY_ACART_SCHEDULE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` (`rule_id`),
  KEY `AMASTY_ACART_SCHEDULE_TEMPLATE_ID_EMAIL_TEMPLATE_TEMPLATE_ID` (`template_id`),
  KEY `AMASTY_ACART_SCHEDULE_SALES_RULE_ID_SALESRULE_RULE_ID` (`sales_rule_id`),
  CONSTRAINT `AMASTY_ACART_SCHEDULE_RULE_ID_AMASTY_ACART_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_acart_rule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_ACART_SCHEDULE_SALES_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`sales_rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_ACART_SCHEDULE_TEMPLATE_ID_EMAIL_TEMPLATE_TEMPLATE_ID` FOREIGN KEY (`template_id`) REFERENCES `email_template` (`template_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COMMENT='amasty_acart_schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_attribute`
--

DROP TABLE IF EXISTS `amasty_amfollowup_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_attribute` (
  `attr_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `code` varchar(255) NOT NULL COMMENT 'Email',
  PRIMARY KEY (`attr_id`),
  KEY `AMASTY_AMFOLLOWUP_ATTR_RULE_ID_AMASTY_AMFOLLOWUP_RULE_RULE_ID` (`rule_id`),
  CONSTRAINT `AMASTY_AMFOLLOWUP_ATTR_RULE_ID_AMASTY_AMFOLLOWUP_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `amasty_amfollowup_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_blacklist`
--

DROP TABLE IF EXISTS `amasty_amfollowup_blacklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_blacklist` (
  `blacklist_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Blacklist Id',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`blacklist_id`),
  UNIQUE KEY `AMASTY_AMFOLLOWUP_BLACKLIST_EMAIL` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=4439 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Blacklist';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_history`
--

DROP TABLE IF EXISTS `amasty_amfollowup_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_history` (
  `history_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'History Id',
  `order_id` int unsigned DEFAULT NULL COMMENT 'Order Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `schedule_id` int unsigned DEFAULT NULL COMMENT 'Schedule ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store Id',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `increment_id` varchar(255) DEFAULT NULL COMMENT 'Increment Id',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer Id',
  `customer_name` varchar(255) DEFAULT NULL COMMENT 'Customer_Name',
  `body` mediumtext COMMENT 'Email Body',
  `subject` varchar(255) DEFAULT NULL COMMENT 'Email Subject',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `scheduled_at` timestamp NULL DEFAULT NULL COMMENT 'Scheduled At',
  `executed_at` timestamp NULL DEFAULT NULL COMMENT 'Executed Date',
  `finished_at` timestamp NULL DEFAULT NULL COMMENT 'Finished Date',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `reason` varchar(32) DEFAULT NULL COMMENT 'Reason',
  `public_key` varchar(32) DEFAULT NULL COMMENT 'Public Key',
  `sales_rule_id` int unsigned DEFAULT NULL COMMENT 'Sales Rule ID',
  `coupon_code` varchar(255) DEFAULT NULL COMMENT 'Coupon Code',
  `coupon_to_date` date DEFAULT NULL COMMENT 'Coupon To Date',
  `coupon_id` int unsigned DEFAULT NULL COMMENT 'Coupon Id',
  `opened` int NOT NULL DEFAULT '0' COMMENT 'Email Open Counter',
  PRIMARY KEY (`history_id`),
  KEY `AMASTY_AMFOLLOWUP_HISTORY_STORE_ID_STORE_STORE_ID` (`store_id`),
  KEY `AMASTY_AMFOLLOWUP_HISTORY_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` (`customer_id`),
  KEY `AMASTY_AMFOLLOWUP_HISTORY_ORDER_ID_SALES_ORDER_ENTITY_ID` (`order_id`),
  KEY `AMASTY_AMFOLLOWUP_HISTORY_STATUS` (`status`),
  KEY `AMASTY_AMFOLLOWUP_HISTORY_SALES_RULE_ID_SALESRULE_RULE_ID` (`sales_rule_id`),
  KEY `amasty_amfollowup_history_email_IDX` (`email`) USING BTREE,
  KEY `amasty_amfollowup_history_finished_at_IDX` (`finished_at` DESC) USING BTREE,
  CONSTRAINT `AMASTY_AMFOLLOWUP_HISTORY_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_AMFOLLOWUP_HISTORY_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE SET NULL,
  CONSTRAINT `AMASTY_AMFOLLOWUP_HISTORY_SALES_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`sales_rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_AMFOLLOWUP_HISTORY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up History';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_link`
--

DROP TABLE IF EXISTS `amasty_amfollowup_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link Id',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer Id',
  `history_id` int unsigned DEFAULT NULL COMMENT 'History Id',
  `link` varchar(255) DEFAULT NULL COMMENT 'Link',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`link_id`),
  KEY `AMASTY_AMFOLLOWUP_LINK_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` (`customer_id`),
  CONSTRAINT `AMASTY_AMFOLLOWUP_LINK_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_rule`
--

DROP TABLE IF EXISTS `amasty_amfollowup_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Id',
  `start_event_type` text COMMENT 'Start Event Type',
  `cancel_event_type` varchar(255) DEFAULT NULL COMMENT 'Cancel Event Type',
  `name` text COMMENT 'Name',
  `is_active` int unsigned NOT NULL DEFAULT '1' COMMENT 'Is active',
  `to_subscribers` int unsigned NOT NULL DEFAULT '0' COMMENT 'To Subscribers',
  `sender_name` text NOT NULL COMMENT 'Sender Name',
  `sender_email` text NOT NULL COMMENT 'Sender Email',
  `sender_cc` text NOT NULL COMMENT 'Sender CC',
  `utm_source` text NOT NULL COMMENT 'Utm Source',
  `utm_medium` text NOT NULL COMMENT 'Utm Medium',
  `utm_term` text NOT NULL COMMENT 'Utm Term',
  `utm_content` text NOT NULL COMMENT 'Utm Content',
  `utm_campaign` text NOT NULL COMMENT 'Utm Campaign',
  `conditions_serialized` text NOT NULL COMMENT 'Conditions Serialized',
  `customer_date_event` date DEFAULT NULL COMMENT 'Customer Date Event',
  PRIMARY KEY (`rule_id`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Rules';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_rule_customer_group`
--

DROP TABLE IF EXISTS `amasty_amfollowup_rule_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_rule_customer_group` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group Id',
  PRIMARY KEY (`rule_id`,`customer_group_id`),
  KEY `FK_58B5BB34254B447492E9EF922B3E03E2` (`customer_group_id`),
  CONSTRAINT `FK_58B5BB34254B447492E9EF922B3E03E2` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C1E69EB274518E7E1F21E3A474939DBE` FOREIGN KEY (`rule_id`) REFERENCES `amasty_amfollowup_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Rule-Customer Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_rule_segment`
--

DROP TABLE IF EXISTS `amasty_amfollowup_rule_segment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_rule_segment` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `segment_id` int unsigned NOT NULL COMMENT 'Segment Id',
  PRIMARY KEY (`rule_id`,`segment_id`),
  CONSTRAINT `FK_253A4D7564DDA872CC9930148E455D44` FOREIGN KEY (`rule_id`) REFERENCES `amasty_amfollowup_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Rule-Segment Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_rule_store`
--

DROP TABLE IF EXISTS `amasty_amfollowup_rule_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_rule_store` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule Id',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store Id',
  PRIMARY KEY (`rule_id`,`store_id`),
  KEY `AMASTY_AMFOLLOWUP_RULE_STORE_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `AMASTY_AMFOLLOWUP_RULE_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DFF87E13D326F3A0780CB90B0E9B7A5C` FOREIGN KEY (`rule_id`) REFERENCES `amasty_amfollowup_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Rule-Store Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_amfollowup_schedule`
--

DROP TABLE IF EXISTS `amasty_amfollowup_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_amfollowup_schedule` (
  `schedule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Schedule Id',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `email_template_id` int unsigned DEFAULT NULL COMMENT 'Email Template ID',
  `delayed_start` int DEFAULT NULL COMMENT 'Delayed Start',
  `coupon_type` varchar(32) DEFAULT NULL COMMENT 'Coupon Type',
  `discount_amount` int NOT NULL DEFAULT '0' COMMENT 'Discount Amount',
  `expired_in_days` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Expired In Days',
  `discount_qty` int unsigned DEFAULT NULL COMMENT 'Discount Qty',
  `discount_step` int unsigned DEFAULT NULL COMMENT 'Discount Step',
  `promo_sku` varchar(255) DEFAULT NULL COMMENT 'Promo Sku',
  `promo_cats` varchar(255) DEFAULT NULL COMMENT 'Promo Categoies',
  `ampromo_type` varchar(255) DEFAULT '0' COMMENT 'Ampromo Type',
  `subtotal_greater_than` decimal(12,4) DEFAULT NULL COMMENT 'Subtotal Greater Than',
  `use_rule` tinyint(1) NOT NULL COMMENT 'Use Rule',
  `sales_rule_id` int unsigned DEFAULT NULL COMMENT 'Sales Rule Id',
  PRIMARY KEY (`schedule_id`),
  KEY `FK_6A9F02888D51E53DD65F8D5ED9C0455D` (`rule_id`),
  KEY `FK_B47BE63CF9EAD3F174D33E775CAF1B59` (`email_template_id`),
  CONSTRAINT `FK_6A9F02888D51E53DD65F8D5ED9C0455D` FOREIGN KEY (`rule_id`) REFERENCES `amasty_amfollowup_rule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_B47BE63CF9EAD3F174D33E775CAF1B59` FOREIGN KEY (`email_template_id`) REFERENCES `email_template` (`template_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Follow Up Schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_base_instance_data`
--

DROP TABLE IF EXISTS `amasty_base_instance_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_base_instance_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AMASTY_BASE_INSTANCE_DATA_CODE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Base Instance Data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_base_instance_hash`
--

DROP TABLE IF EXISTS `amasty_base_instance_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_base_instance_hash` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `value` mediumtext COMMENT 'Value',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Last Send Date Timestamp',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AMASTY_BASE_INSTANCE_HASH_CODE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Base Data Send Schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_base_schedule`
--

DROP TABLE IF EXISTS `amasty_base_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_base_schedule` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `last_send_date` int unsigned NOT NULL COMMENT 'Last Send Date Timestamp',
  `time_intervals` varchar(255) DEFAULT NULL COMMENT 'Time Intervals to Send',
  PRIMARY KEY (`id`),
  UNIQUE KEY `AMASTY_BASE_SCHEDULE_CODE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Base Data Send Schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_geoip_block`
--

DROP TABLE IF EXISTS `amasty_geoip_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_geoip_block` (
  `block_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Block Id',
  `start_ip_num` int unsigned NOT NULL COMMENT 'Start Ip Num',
  `end_ip_num` int unsigned NOT NULL COMMENT 'End Ip Num',
  `geoip_loc_id` int unsigned NOT NULL COMMENT 'Geoip Loc Id',
  `postal_code` text COMMENT 'Postal Code',
  `latitude` float(10,0) DEFAULT NULL COMMENT 'Latitude',
  `longitude` float(10,0) DEFAULT NULL COMMENT 'Longitude',
  PRIMARY KEY (`block_id`),
  KEY `AMASTY_GEOIP_BLOCK_GEOIP_LOC_ID` (`geoip_loc_id`),
  KEY `AMASTY_GEOIP_BLOCK_START_IP_NUM_END_IP_NUM` (`start_ip_num`,`end_ip_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Geoip Block Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_geoip_block_v6`
--

DROP TABLE IF EXISTS `amasty_geoip_block_v6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_geoip_block_v6` (
  `block_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Block Id',
  `start_ip_num` varchar(40) NOT NULL COMMENT 'Start Ip Num',
  `end_ip_num` varchar(40) NOT NULL COMMENT 'End Ip Num',
  `geoip_loc_id` int unsigned NOT NULL COMMENT 'Geoip Loc Id',
  `postal_code` text COMMENT 'Postal Code',
  `latitude` float(10,0) DEFAULT NULL COMMENT 'Latitude',
  `longitude` float(10,0) DEFAULT NULL COMMENT 'Longitude',
  PRIMARY KEY (`block_id`),
  KEY `AMASTY_GEOIP_BLOCK_V6_GEOIP_LOC_ID` (`geoip_loc_id`),
  KEY `AMASTY_GEOIP_BLOCK_V6_START_IP_NUM_END_IP_NUM` (`start_ip_num`,`end_ip_num`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Geoip Block Table IpV6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_geoip_ip_log`
--

DROP TABLE IF EXISTS `amasty_geoip_ip_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_geoip_ip_log` (
  `log_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Ip Log Id',
  `ip` varchar(45) NOT NULL COMMENT 'Ip v4 or v6',
  `last_visit` date NOT NULL COMMENT 'Last Visit Date',
  `last_sync` date DEFAULT NULL COMMENT 'Last Sync With Service Date',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `AMASTY_GEOIP_IP_LOG_IP` (`ip`),
  KEY `AMASTY_GEOIP_IP_LOG_LAST_SYNC` (`last_sync`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Visitors Ip Log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_geoip_location`
--

DROP TABLE IF EXISTS `amasty_geoip_location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_geoip_location` (
  `location_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Location Id',
  `geoip_loc_id` int unsigned NOT NULL COMMENT 'Geoip Loc Id',
  `country` text COMMENT 'Country',
  `city` text COMMENT 'City',
  `region` text COMMENT 'Region',
  PRIMARY KEY (`location_id`),
  KEY `AMASTY_GEOIP_LOCATION_GEOIP_LOC_ID` (`geoip_loc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Geoip Location Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_account`
--

DROP TABLE IF EXISTS `amasty_giftcard_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_account` (
  `account_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Account ID',
  `code_id` int unsigned NOT NULL COMMENT 'Code ID',
  `image_id` int unsigned DEFAULT NULL COMMENT 'Image ID',
  `order_item_id` int unsigned DEFAULT NULL COMMENT 'Order Item ID',
  `website_id` smallint unsigned DEFAULT NULL COMMENT 'Website ID',
  `store` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `status` smallint unsigned NOT NULL COMMENT 'Status',
  `initial_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Initial Value',
  `current_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Current Value',
  `expired_date` datetime DEFAULT NULL COMMENT 'Date of Expiration',
  `comment` text COMMENT 'Comment',
  `date_delivery` datetime DEFAULT NULL COMMENT 'Delivery Date',
  `is_sent` tinyint(1) NOT NULL COMMENT 'Is Email Sent',
  `customer_created_id` int unsigned DEFAULT NULL COMMENT 'Customer Created ID',
  `recipient_email` text COMMENT 'Recipient Email',
  `is_redeemable` smallint DEFAULT NULL COMMENT 'Redeemable',
  `usage` varchar(15) NOT NULL DEFAULT 'multiple' COMMENT 'Usage',
  `mobilenumber` text COMMENT 'Recipient Phone',
  `image_generated` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Email Image Generated',
  `sender_name` varchar(255) DEFAULT NULL COMMENT 'Sender Name',
  `recipient_name` varchar(255) DEFAULT NULL COMMENT 'Recipient Name',
  `message` text COMMENT 'Message',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`account_id`),
  UNIQUE KEY `AMASTY_GIFTCARD_ACCOUNT_CODE_ID` (`code_id`),
  KEY `AMASTY_GIFTCARD_ACCOUNT_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` (`website_id`),
  KEY `AMASTY_GIFTCARD_ACCOUNT_IMAGE_ID` (`image_id`),
  KEY `AMASTY_GIFTCARD_ACCOUNT_CREATED_AT` (`created_at`),
  CONSTRAINT `AMASTY_GIFTCARD_ACCOUNT_CODE_ID_AMASTY_GIFTCARD_CODE_CODE_ID` FOREIGN KEY (`code_id`) REFERENCES `amasty_giftcard_code` (`code_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_GIFTCARD_ACCOUNT_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Account Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_account_transaction`
--

DROP TABLE IF EXISTS `amasty_giftcard_account_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_account_transaction` (
  `transaction_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Account Transaction ID',
  `account_id` int unsigned NOT NULL COMMENT 'Account ID',
  `started_in` datetime DEFAULT NULL COMMENT 'Started In',
  PRIMARY KEY (`transaction_id`),
  UNIQUE KEY `AMASTY_GIFTCARD_ACCOUNT_TRANSACTION_ACCOUNT_ID` (`account_id`),
  CONSTRAINT `FK_4436F8BC93E45537FED0592C6E798859` FOREIGN KEY (`account_id`) REFERENCES `amasty_giftcard_account` (`account_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Account Transaction Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_code`
--

DROP TABLE IF EXISTS `amasty_giftcard_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_code` (
  `code_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Code ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `code_pool_id` int unsigned NOT NULL COMMENT 'Code Pool ID',
  `status` smallint NOT NULL DEFAULT '0' COMMENT 'Code Status',
  PRIMARY KEY (`code_id`),
  KEY `AMASTY_GIFTCARD_CODE_CODE_POOL_ID` (`code_pool_id`),
  KEY `AMASTY_GIFTCARD_CODE_STATUS` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=23827 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty GiftCard Code Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_code_pool`
--

DROP TABLE IF EXISTS `amasty_giftcard_code_pool`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_code_pool` (
  `pool_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Code Pool ID',
  `title` varchar(225) NOT NULL COMMENT 'Code Pool Title',
  `template` varchar(225) NOT NULL COMMENT 'Code Pool Template',
  `qty` int unsigned DEFAULT NULL COMMENT 'Qty',
  PRIMARY KEY (`pool_id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty GiftCard Code Pool Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_code_pool_rule`
--

DROP TABLE IF EXISTS `amasty_giftcard_code_pool_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_code_pool_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Code Pool Rule ID',
  `code_pool_id` int unsigned NOT NULL COMMENT 'Code Pool ID',
  `conditions_serialized` text NOT NULL COMMENT 'Serialized Conditions',
  PRIMARY KEY (`rule_id`),
  KEY `FK_2C085299BFEDB52D0339AF9F08BA6561` (`code_pool_id`),
  CONSTRAINT `FK_2C085299BFEDB52D0339AF9F08BA6561` FOREIGN KEY (`code_pool_id`) REFERENCES `amasty_giftcard_code_pool` (`pool_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty GiftCard Code Pool Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_creditmemo`
--

DROP TABLE IF EXISTS `amasty_giftcard_creditmemo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_creditmemo` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `creditmemo_id` int unsigned NOT NULL COMMENT 'Credit Memo ID',
  `gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Gift Cards Amount',
  `base_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Gift Cards Amount',
  PRIMARY KEY (`entity_id`),
  KEY `FK_23A68702E520CAD37C37455AE288E91C` (`creditmemo_id`),
  CONSTRAINT `FK_23A68702E520CAD37C37455AE288E91C` FOREIGN KEY (`creditmemo_id`) REFERENCES `sales_creditmemo` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Account Credit Memo Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_customer_card`
--

DROP TABLE IF EXISTS `amasty_giftcard_customer_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_customer_card` (
  `customer_card_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Customer Card ID',
  `account_id` int unsigned NOT NULL COMMENT 'Account ID',
  `customer_id` int unsigned NOT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`customer_card_id`),
  UNIQUE KEY `AMASTY_GIFTCARD_CUSTOMER_CARD_ACCOUNT_ID_CUSTOMER_ID` (`account_id`,`customer_id`),
  KEY `AMASTY_GIFTCARD_CSTR_CARD_CSTR_ID_CSTR_ENTT_ENTT_ID` (`customer_id`),
  CONSTRAINT `AMASTY_GIFTCARD_CSTR_CARD_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_51B69DE42967A4C0267E0FAAA3B0961A` FOREIGN KEY (`account_id`) REFERENCES `amasty_giftcard_account` (`account_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Customer Card Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_image`
--

DROP TABLE IF EXISTS `amasty_giftcard_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_image` (
  `image_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Image ID',
  `title` varchar(255) NOT NULL COMMENT 'Image Title',
  `gcard_title` varchar(255) DEFAULT NULL COMMENT 'Gift Card Title',
  `status` smallint NOT NULL DEFAULT '0' COMMENT 'Image Status',
  `width` int unsigned NOT NULL DEFAULT '580' COMMENT 'Gift Card Image Width',
  `height` int unsigned NOT NULL DEFAULT '390' COMMENT 'Gift Card Image Height',
  `image_path` varchar(255) DEFAULT NULL COMMENT 'Image Path',
  `user_upload` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Image Uploaded by User',
  PRIMARY KEY (`image_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty GiftCard Image Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_image_elements`
--

DROP TABLE IF EXISTS `amasty_giftcard_image_elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_image_elements` (
  `element_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Image Element ID',
  `image_id` int unsigned NOT NULL COMMENT 'Image ID',
  `name` varchar(225) NOT NULL COMMENT 'Image Element Name',
  `width` int unsigned NOT NULL DEFAULT '0' COMMENT 'Image Element Width',
  `height` int unsigned NOT NULL DEFAULT '0' COMMENT 'Image Element Height',
  `pos_x` int unsigned NOT NULL DEFAULT '0' COMMENT 'Image Element X Position',
  `pos_y` int unsigned NOT NULL DEFAULT '0' COMMENT 'Image Element Y Position',
  `custom_css` varchar(225) DEFAULT NULL COMMENT 'Image Element Name',
  PRIMARY KEY (`element_id`),
  KEY `FK_AC5B89EB02A523E571342A31CBBBAA5E` (`image_id`),
  CONSTRAINT `FK_AC5B89EB02A523E571342A31CBBBAA5E` FOREIGN KEY (`image_id`) REFERENCES `amasty_giftcard_image` (`image_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty GiftCard Image Elements Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_invoice`
--

DROP TABLE IF EXISTS `amasty_giftcard_invoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_invoice` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `invoice_id` int unsigned NOT NULL COMMENT 'Invoice ID',
  `gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Gift Cards Amount',
  `base_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Gift Cards Amount',
  PRIMARY KEY (`entity_id`),
  KEY `AMASTY_GIFTCARD_INVOICE_INVOICE_ID_SALES_INVOICE_ENTITY_ID` (`invoice_id`),
  CONSTRAINT `AMASTY_GIFTCARD_INVOICE_INVOICE_ID_SALES_INVOICE_ENTITY_ID` FOREIGN KEY (`invoice_id`) REFERENCES `sales_invoice` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Account Invoice Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_order`
--

DROP TABLE IF EXISTS `amasty_giftcard_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_order` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `gift_cards` text COMMENT 'Gift Cards Applied To Order',
  `gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Gift Cards Amount',
  `base_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Gift Cards Amount',
  `invoice_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Invoice Gift Cards Amount',
  `base_invoice_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Invoiced Gift Cards Amount',
  `refund_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Refunded Gift Cards Amount',
  `base_refund_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Refunded Gift Cards Amount',
  PRIMARY KEY (`entity_id`),
  KEY `AMASTY_GIFTCARD_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` (`order_id`),
  CONSTRAINT `AMASTY_GIFTCARD_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Account Order Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_price`
--

DROP TABLE IF EXISTS `amasty_giftcard_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_price` (
  `price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Price ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `value` decimal(12,2) unsigned NOT NULL COMMENT 'Price Value',
  PRIMARY KEY (`price_id`),
  KEY `AMASTY_GIFTCARD_PRICE_PRODUCT_ID` (`product_id`),
  KEY `AMASTY_GIFTCARD_PRICE_WEBSITE_ID` (`website_id`),
  KEY `AMASTY_GIFTCARD_PRICE_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `AMASTY_GIFTCARD_PRICE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_GIFTCARD_PRICE_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `AMASTY_GIFTCARD_PRICE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb3 COMMENT='Amasty GiftCard Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amasty_giftcard_quote`
--

DROP TABLE IF EXISTS `amasty_giftcard_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amasty_giftcard_quote` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote ID',
  `gift_cards` text COMMENT 'Gift Cards Applied To Quote',
  `gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Gift Cards Amount',
  `base_gift_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Gift Cards Amount',
  `gift_amount_used` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Used Gift Cards Amount',
  `base_gift_amount_used` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Used Gift Cards Amount',
  PRIMARY KEY (`entity_id`),
  KEY `AMASTY_GIFTCARD_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` (`quote_id`),
  CONSTRAINT `AMASTY_GIFTCARD_QUOTE_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amasty Gift Card Account Quote Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amazon_customer`
--

DROP TABLE IF EXISTS `amazon_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_customer` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `customer_id` int unsigned NOT NULL COMMENT 'Customer_id',
  `amazon_id` varchar(255) NOT NULL COMMENT 'Amazon_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID_AMAZON_ID` (`customer_id`,`amazon_id`),
  UNIQUE KEY `AMAZON_CUSTOMER_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `AMAZON_CUSTOMER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Amazon PayV2 Customer Link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `amazon_payv2_async`
--

DROP TABLE IF EXISTS `amazon_payv2_async`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `amazon_payv2_async` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned DEFAULT NULL COMMENT 'Order ID',
  `is_pending` tinyint unsigned NOT NULL DEFAULT '1' COMMENT 'Is pending?',
  `pending_action` varchar(20) NOT NULL COMMENT 'Pending Action',
  `pending_id` varchar(50) DEFAULT NULL COMMENT 'Pending Action',
  `created_at` datetime DEFAULT NULL COMMENT 'Created At',
  `updated_at` datetime DEFAULT NULL COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`),
  KEY `AMAZON_PAYV2_ASYNC_IS_PENDING` (`is_pending`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COMMENT='Amazon PayV2 Async Pending';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `astound_affirm_attribute`
--

DROP TABLE IF EXISTS `astound_affirm_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `astound_affirm_attribute` (
  `attr_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute ID',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `code` varchar(255) DEFAULT NULL COMMENT 'Code',
  PRIMARY KEY (`attr_id`),
  KEY `ASTOUND_AFFIRM_ATTRIBUTE_RULE_ID_ASTOUND_AFFIRM_RULE_RULE_ID` (`rule_id`),
  CONSTRAINT `ASTOUND_AFFIRM_ATTRIBUTE_RULE_ID_ASTOUND_AFFIRM_RULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `astound_affirm_rule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Affirm Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `astound_affirm_rule`
--

DROP TABLE IF EXISTS `astound_affirm_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `astound_affirm_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `for_admin` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'For Admin',
  `is_active` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `all_stores` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'All Stores',
  `all_groups` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'All Groups',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  `stores` varchar(255) NOT NULL COMMENT 'Stores',
  `cust_groups` varchar(255) NOT NULL COMMENT 'Customer Groups',
  `message` text NOT NULL COMMENT 'Message',
  `methods` text COMMENT 'Methods',
  `conditions_serialized` text COMMENT 'Serialized Conditions',
  PRIMARY KEY (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Affirm Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `auctane_shipstation_order_address_timestamp`
--

DROP TABLE IF EXISTS `auctane_shipstation_order_address_timestamp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `auctane_shipstation_order_address_timestamp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`),
  KEY `AUCTANE_SHIPSTATION_ORDER_ADDRESS_TIMESTAMP_UPDATED_AT` (`updated_at`),
  CONSTRAINT `FK_C510F0BD44A8E513CFB2D88F6A40BD0D` FOREIGN KEY (`entity_id`) REFERENCES `sales_order_address` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Auctane Shipstation Order Address Timestamp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorization_role` (
  `role_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `authorization_rule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `AUTHORIZATION_RULE_ROLE_ID_AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8685 DEFAULT CHARSET=utf8mb3 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `braintree_credit_prices`
--

DROP TABLE IF EXISTS `braintree_credit_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `braintree_credit_prices` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product Id',
  `term` int NOT NULL COMMENT 'Credit Term',
  `monthly_payment` decimal(12,2) NOT NULL COMMENT 'Monthly Payment',
  `instalment_rate` decimal(12,2) NOT NULL COMMENT 'Instalment Rate',
  `cost_of_purchase` decimal(12,2) NOT NULL COMMENT 'Cost of purchase',
  `total_inc_interest` decimal(12,2) NOT NULL COMMENT 'Total Inc Interest',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID_TERM` (`product_id`,`term`),
  KEY `BRAINTREE_CREDIT_PRICES_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Braintree credit rates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `braintree_transaction_details`
--

DROP TABLE IF EXISTS `braintree_transaction_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `braintree_transaction_details` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order Id',
  `transaction_source` varchar(12) DEFAULT NULL COMMENT 'Transaction Source',
  PRIMARY KEY (`entity_id`),
  KEY `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID` (`order_id`),
  CONSTRAINT `BRAINTREE_TRANSACTION_DETAILS_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Braintree transaction details table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_bulkrequest_link`
--

DROP TABLE IF EXISTS `budsies_backendintegration_bulkrequest_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_bulkrequest_link` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_id` int unsigned NOT NULL COMMENT 'Bulkrequest Id Column',
  `production_backend_id` varchar(36) NOT NULL COMMENT 'Production Backend Id Column',
  PRIMARY KEY (`id`),
  KEY `FK_D621ADAFBC2DAF09731A8185E2B56164` (`bulkrequest_id`),
  CONSTRAINT `FK_D621ADAFBC2DAF09731A8185E2B56164` FOREIGN KEY (`bulkrequest_id`) REFERENCES `budsies_bulkrequest` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3705 DEFAULT CHARSET=utf8mb3 COMMENT='BulkRequestLink';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_customization_export_setting`
--

DROP TABLE IF EXISTS `budsies_backendintegration_customization_export_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_customization_export_setting` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `type_id` varchar(36) NOT NULL COMMENT 'Customization Export Type ID',
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_1ADFE0BDE3ABEB573301E0894D23691A` (`customization_id`,`type_id`),
  KEY `BUDSIES_BACKENDINTEGRATION_CUSTOMIZATION_EXPORT_SETTING_TYPE_ID` (`type_id`),
  CONSTRAINT `FK_8AD15B39FFE6182F7D8189463E859FAF` FOREIGN KEY (`type_id`) REFERENCES `budsies_backendintegration_customization_export_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_EBF0F3A3AB0E3DB789AC3AD7D75E6BA2` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_customization_export_type`
--

DROP TABLE IF EXISTS `budsies_backendintegration_customization_export_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_customization_export_type` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BACKENDINTEGRATION_CUSTOMIZATION_EXPORT_TYPE_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_customization_option_export_setting`
--

DROP TABLE IF EXISTS `budsies_backendintegration_customization_option_export_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_customization_option_export_setting` (
  `customization_export_setting_id` varchar(36) NOT NULL COMMENT 'Customization Export Setting ID',
  `export_code` varchar(255) NOT NULL COMMENT 'Export Code',
  PRIMARY KEY (`customization_export_setting_id`),
  CONSTRAINT `FK_A4D4A81C74111CE6FE948E243EC673D8` FOREIGN KEY (`customization_export_setting_id`) REFERENCES `budsies_backendintegration_customization_export_setting` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_customization_value_export_setting`
--

DROP TABLE IF EXISTS `budsies_backendintegration_customization_value_export_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_customization_value_export_setting` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `customization_export_setting_id` varchar(36) NOT NULL COMMENT 'Customization Export Setting ID',
  `customization_option_value_id` varchar(36) NOT NULL COMMENT 'Customization Option Value ID',
  `export_code` varchar(255) NOT NULL COMMENT 'Export Code',
  `skip_for_holiday_plushie` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Skip for Holiday Plushie',
  `is_exportable` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Is exportable Value setting',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_49A0195076A3E004966E6D89964CB5DD` (`customization_option_value_id`),
  KEY `IDX_6B0DDC0F7466F3E441809E30F2DE99FF` (`customization_export_setting_id`),
  CONSTRAINT `FK_1249FF8330F6274DFACECC7C274C3BE6` FOREIGN KEY (`customization_option_value_id`) REFERENCES `budsies_product_customization_option_value` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8CC5F4A6524B2F7CC3CEB8E6D440C57E` FOREIGN KEY (`customization_export_setting_id`) REFERENCES `budsies_backendintegration_customization_export_setting` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_customization_variant_export_setting`
--

DROP TABLE IF EXISTS `budsies_backendintegration_customization_variant_export_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_customization_variant_export_setting` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `customization_export_setting_id` varchar(36) NOT NULL COMMENT 'Customization Export Setting ID',
  `customization_variant_id` varchar(36) NOT NULL COMMENT 'Customization Variant ID',
  `export_code` varchar(255) NOT NULL COMMENT 'Export Code',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_269A2A5701847A0317A668228A0DF47B` (`customization_variant_id`),
  KEY `IDX_14F5006CE6FE0E11EF254D906A49CDEC` (`customization_export_setting_id`),
  CONSTRAINT `FK_41D2D10582FB20657E32DD080A2A100F` FOREIGN KEY (`customization_variant_id`) REFERENCES `budsies_product_customization_variant` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_91FAB02F79550CD8D025E6A37276F3C6` FOREIGN KEY (`customization_export_setting_id`) REFERENCES `budsies_backendintegration_customization_export_setting` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_plushie_production_cost`
--

DROP TABLE IF EXISTS `budsies_backendintegration_plushie_production_cost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_plushie_production_cost` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `plushie_id` int unsigned NOT NULL,
  `cost` decimal(10,2) unsigned NOT NULL,
  `calculation_method` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BACKENDINTEGRATION_PLUSHIE_PRODUCTION_COST_PLUSHIE_ID` (`plushie_id`),
  CONSTRAINT `FK_A152A518A36B06494B487FD399D19A73` FOREIGN KEY (`plushie_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_product_export_setting`
--

DROP TABLE IF EXISTS `budsies_backendintegration_product_export_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_product_export_setting` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `backend_product_id` int unsigned NOT NULL COMMENT 'Backend Product ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BACKENDINTEGRATION_PRODUCT_EXPORT_SETTING_PRODUCT_ID` (`product_id`),
  CONSTRAINT `FK_22F6C15621FE932F58BFC23FE2C2AC0C` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_backendintegration_store_export_setting`
--

DROP TABLE IF EXISTS `budsies_backendintegration_store_export_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_backendintegration_store_export_setting` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `backend_store_id` int unsigned NOT NULL COMMENT 'Backend Store ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BACKENDINTEGRATION_STORE_EXPORT_SETTING_STORE_ID` (`store_id`),
  CONSTRAINT `FK_00B600CEA2F660C2DAB5B6DAB14873FF` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_budsie_artist`
--

DROP TABLE IF EXISTS `budsies_budsie_artist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_budsie_artist` (
  `artist_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Artist Id',
  `customer_id` int unsigned DEFAULT NULL,
  `email` varchar(42) NOT NULL COMMENT 'Email',
  `name` varchar(30) NOT NULL COMMENT 'Child Name',
  `birth_month` int unsigned NOT NULL COMMENT 'Birth Month',
  `birth_day` int unsigned NOT NULL COMMENT 'Birth Day',
  `store_id` smallint unsigned NOT NULL,
  PRIMARY KEY (`artist_id`),
  KEY `BUDSIES_BUDSIE_ARTIST_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `BUDSIES_BUDSIE_ARTIST_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_budsie_attribute`
--

DROP TABLE IF EXISTS `budsies_budsie_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_budsie_attribute` (
  `attribute_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `production_backend_id` varchar(36) DEFAULT NULL COMMENT 'Production Backend Plushie GUID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `sales_flat_quote_item_id` int unsigned DEFAULT NULL COMMENT 'Quote Item ID',
  `sales_flat_order_item_id` int unsigned DEFAULT NULL COMMENT 'Order Item ID',
  `status_id` int unsigned NOT NULL COMMENT 'Status ID',
  `factory_name` varchar(255) DEFAULT NULL COMMENT 'Factory Name',
  `factory_tracking_number` varchar(255) DEFAULT NULL COMMENT 'Factory Name',
  `turnaround_time` int unsigned DEFAULT NULL COMMENT 'Turnaround Time in Weeks',
  `estimated_shipment_date` timestamp NULL DEFAULT NULL COMMENT 'Estimated Shipment Date',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Update Time',
  `source_attribute_id` int unsigned DEFAULT NULL COMMENT 'Source Plushie ID',
  PRIMARY KEY (`attribute_id`),
  KEY `BUDSIES_BUDSIE_ATTRIBUTE_STORE_ID_STORE_STORE_ID` (`store_id`),
  KEY `BUDSIES_BUDSIE_ATTR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  KEY `FK_24297A3530E13CCC59CFE3FF6E289C43` (`sales_flat_order_item_id`),
  KEY `BUDSIES_BUDSIE_ATTR_STS_ID_BUDSIES_BUDSIE_STS_STS_ID` (`status_id`),
  KEY `BUDSIES_BUDSIE_ATTRIBUTE_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `BUDSIES_BUDSIE_ATTR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`),
  CONSTRAINT `BUDSIES_BUDSIE_ATTR_STS_ID_BUDSIES_BUDSIE_STS_STS_ID` FOREIGN KEY (`status_id`) REFERENCES `budsies_budsie_status` (`status_id`),
  CONSTRAINT `BUDSIES_BUDSIE_ATTRIBUTE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`),
  CONSTRAINT `FK_24297A3530E13CCC59CFE3FF6E289C43` FOREIGN KEY (`sales_flat_order_item_id`) REFERENCES `sales_order_item` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_budsie_attribute_status_history`
--

DROP TABLE IF EXISTS `budsies_budsie_attribute_status_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_budsie_attribute_status_history` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `attribute_id` int unsigned NOT NULL COMMENT 'Attribute ID',
  `status_id` int unsigned NOT NULL COMMENT 'Status ID',
  `assign_date` timestamp NOT NULL COMMENT 'Assigned Time',
  `quit_date` timestamp NULL DEFAULT NULL COMMENT 'Quit Time',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_BUDSIE_ATTR_STS_HISTORY_STS_ID_BUDSIES_BUDSIE_STS_STS_ID` (`status_id`),
  KEY `BUDSIES_BUDSIE_ATTRIBUTE_STATUS_HISTORY_ATTRIBUTE_ID_STATUS_ID` (`attribute_id`,`status_id`),
  CONSTRAINT `BUDSIES_BUDSIE_ATTR_STS_HISTORY_STS_ID_BUDSIES_BUDSIE_STS_STS_ID` FOREIGN KEY (`status_id`) REFERENCES `budsies_budsie_status` (`status_id`),
  CONSTRAINT `FK_713DAFDE43E07D2B26B84A3A6336440D` FOREIGN KEY (`attribute_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_budsie_status`
--

DROP TABLE IF EXISTS `budsies_budsie_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_budsie_status` (
  `status_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  PRIMARY KEY (`status_id`),
  KEY `BUDSIES_BUDSIE_STATUS_STATUS_ID` (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest`
--

DROP TABLE IF EXISTS `budsies_bulkrequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_product_id` int unsigned NOT NULL COMMENT 'Bulkrequest Product Id Column',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At Column',
  `status_id` int unsigned NOT NULL COMMENT 'Status Id Column',
  `first_name` varchar(255) NOT NULL COMMENT 'First Name Column',
  `last_name` varchar(255) DEFAULT 'NULL' COMMENT 'Last Name Column',
  `email` varchar(255) NOT NULL COMMENT 'Email Column',
  `phone` varchar(255) DEFAULT 'NULL' COMMENT 'Phone Column',
  `qty` int unsigned NOT NULL COMMENT 'Qty Column',
  `alternative_qty` int unsigned DEFAULT NULL COMMENT 'Alternative Qty Column',
  `size` int unsigned NOT NULL COMMENT 'Size Column',
  `country_id` int unsigned NOT NULL COMMENT 'Country Id Column',
  `deadline_date` timestamp NULL DEFAULT NULL COMMENT 'Deadline Date Column',
  `project_name` varchar(40) DEFAULT 'NULL' COMMENT 'Project Name Column',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'Description Column',
  `chosen_quote_id` int unsigned DEFAULT NULL COMMENT 'Chosen Quote Id Column',
  `sample_order_id` int unsigned DEFAULT NULL COMMENT 'Sample Order Id Column',
  `sample_plushie_id` int unsigned DEFAULT NULL COMMENT 'Sample Plushie Id Column',
  `ordering_goal` varchar(128) DEFAULT NULL COMMENT 'Ordering Goal Column',
  `client_type_id` int unsigned DEFAULT NULL COMMENT 'Client Type Id Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BULKREQUEST_SAMPLE_PLUSHIE_ID` (`sample_plushie_id`),
  KEY `FK_24718221BAF0319F126AB7C82FE2296D` (`bulkrequest_product_id`),
  KEY `BUDSIES_BULKREQUEST_STATUS_ID_BUDSIES_BULKREQUEST_STATUS_ID` (`status_id`),
  KEY `BUDSIES_BULKREQUEST_SAMPLE_ORDER_ID_SALES_ORDER_ENTITY_ID` (`sample_order_id`),
  KEY `FK_D2360DA0E2D39A40DA9A9EF6854AB3CC` (`client_type_id`),
  CONSTRAINT `BUDSIES_BULKREQUEST_SAMPLE_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`sample_order_id`) REFERENCES `sales_order` (`entity_id`),
  CONSTRAINT `BUDSIES_BULKREQUEST_STATUS_ID_BUDSIES_BULKREQUEST_STATUS_ID` FOREIGN KEY (`status_id`) REFERENCES `budsies_bulkrequest_status` (`id`),
  CONSTRAINT `FK_24718221BAF0319F126AB7C82FE2296D` FOREIGN KEY (`bulkrequest_product_id`) REFERENCES `budsies_bulkrequest_product` (`id`),
  CONSTRAINT `FK_D2360DA0E2D39A40DA9A9EF6854AB3CC` FOREIGN KEY (`client_type_id`) REFERENCES `budsies_bulkrequest_client_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='BulkRequest';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_action_log`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_action_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_action_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_product_id` int unsigned NOT NULL COMMENT 'Bulkrequest Product Id Column',
  `type_id` int unsigned NOT NULL COMMENT 'Type Id Column',
  `admin_user_id` int unsigned NOT NULL COMMENT 'Admin User Id Column',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At Column',
  `content` text COMMENT 'Content of Action in JSON',
  PRIMARY KEY (`id`),
  KEY `FK_C3B526B3E5D8D9FC88A64A21FD66CFA9` (`bulkrequest_product_id`),
  KEY `FK_4D2C2F18CDCFB8B486FB7E7EBC60F471` (`type_id`),
  KEY `BUDSIES_BULKREQUEST_ACTION_LOG_ADMIN_USER_ID_ADMIN_USER_USER_ID` (`admin_user_id`),
  CONSTRAINT `BUDSIES_BULKREQUEST_ACTION_LOG_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`),
  CONSTRAINT `FK_4D2C2F18CDCFB8B486FB7E7EBC60F471` FOREIGN KEY (`type_id`) REFERENCES `budsies_bulkrequest_action_log_type` (`id`),
  CONSTRAINT `FK_C3B526B3E5D8D9FC88A64A21FD66CFA9` FOREIGN KEY (`bulkrequest_product_id`) REFERENCES `budsies_bulkrequest_product` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb3 COMMENT='ActionLog';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_action_log_type`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_action_log_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_action_log_type` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `name` varchar(150) NOT NULL COMMENT 'Name Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BULKREQUEST_ACTION_LOG_TYPE_NAME` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='ActionLogType';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_color_palette_values`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_color_palette_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_color_palette_values` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `bulkrequest_id` int unsigned NOT NULL,
  `color_palette_value_id` int unsigned DEFAULT NULL COMMENT 'Color Palette Value Id Column',
  `customization_id` varchar(36) DEFAULT NULL,
  `customization_state_value` text,
  PRIMARY KEY (`id`),
  KEY `FK_C1713CD317BD87B82C249FA1B96813D7` (`customization_id`),
  KEY `FK_95B679DF7D4799D6E1391DB92AF2DB80` (`bulkrequest_id`),
  CONSTRAINT `FK_95B679DF7D4799D6E1391DB92AF2DB80` FOREIGN KEY (`bulkrequest_id`) REFERENCES `budsies_bulkrequest` (`id`),
  CONSTRAINT `FK_C1713CD317BD87B82C249FA1B96813D7` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='ColorPaletteValues';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_image`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_image` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_id` int unsigned NOT NULL COMMENT 'Bulkrequest Id Column',
  `file_storage_id` varchar(36) DEFAULT 'NULL' COMMENT 'File Storage Id Column',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BULKREQUEST_IMAGE_FILE_STORAGE_ID` (`file_storage_id`),
  KEY `BUDSIES_BULKREQUEST_IMAGE_BULKREQUEST_ID_BUDSIES_BULKREQUEST_ID` (`bulkrequest_id`),
  CONSTRAINT `BUDSIES_BULKREQUEST_IMAGE_BULKREQUEST_ID_BUDSIES_BULKREQUEST_ID` FOREIGN KEY (`bulkrequest_id`) REFERENCES `budsies_bulkrequest` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Image';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_product`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_product` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `name` varchar(150) NOT NULL COMMENT 'Name Column',
  `sample_product_id` int unsigned NOT NULL COMMENT 'Sample Product Id Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BULKREQUEST_PRODUCT_NAME` (`name`),
  UNIQUE KEY `BUDSIES_BULKREQUEST_PRODUCT_SAMPLE_PRODUCT_ID` (`sample_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_production_price`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_production_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_production_price` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_product_id` int unsigned NOT NULL COMMENT 'Bulkrequest Product Id Column',
  `qty_from` int unsigned NOT NULL COMMENT 'Qty From Column',
  `qty_to` int unsigned NOT NULL COMMENT 'Qty To Column',
  `size_from` int unsigned NOT NULL COMMENT 'Size From Column',
  `size_to` int unsigned NOT NULL COMMENT 'Size To Column',
  `price` decimal(12,2) unsigned NOT NULL COMMENT 'Price Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_9A5097C000678395DA4BF7EFAEFF4719` (`qty_from`,`size_from`,`bulkrequest_product_id`),
  UNIQUE KEY `UNQ_359CF00BA4876D85185C3D0A9F330838` (`qty_to`,`size_to`,`bulkrequest_product_id`),
  UNIQUE KEY `UNQ_2436D4DF5946B4B73E5254A5323E1AFE` (`qty_from`,`size_to`,`bulkrequest_product_id`),
  UNIQUE KEY `UNQ_1AD0C612B93BD2F9A1B6744F65990551` (`qty_to`,`size_from`,`bulkrequest_product_id`),
  KEY `FK_9CB25EA2D6473DCA405B2F6E88CEED27` (`bulkrequest_product_id`),
  CONSTRAINT `FK_9CB25EA2D6473DCA405B2F6E88CEED27` FOREIGN KEY (`bulkrequest_product_id`) REFERENCES `budsies_bulkrequest_product` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1051 DEFAULT CHARSET=utf8mb3 COMMENT='ProductionPrice';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_quote`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_quote` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_id` int unsigned NOT NULL COMMENT 'Bulkrequest Id Column',
  `qty` int unsigned NOT NULL COMMENT 'Qty Column',
  `production_price` decimal(12,2) unsigned NOT NULL COMMENT 'Production Price Column',
  `shipping_price` decimal(12,2) unsigned NOT NULL COMMENT 'Shipping Price Column',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_BULKREQUEST_QUOTE_BULKREQUEST_ID_BUDSIES_BULKREQUEST_ID` (`bulkrequest_id`),
  CONSTRAINT `BUDSIES_BULKREQUEST_QUOTE_BULKREQUEST_ID_BUDSIES_BULKREQUEST_ID` FOREIGN KEY (`bulkrequest_id`) REFERENCES `budsies_bulkrequest` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_shipping_rate`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_shipping_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_shipping_rate` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `bulkrequest_product_id` int unsigned NOT NULL COMMENT 'Bulkrequest Product Id Column',
  `country_id` int unsigned DEFAULT NULL COMMENT 'Country Id Column',
  `size_from` int unsigned NOT NULL COMMENT 'Size From Column',
  `size_to` int unsigned NOT NULL COMMENT 'Size To Column',
  `value` decimal(12,2) unsigned NOT NULL COMMENT 'Value Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_3CCA59B7D3B2C1F0E35553BAF276929F` (`country_id`,`size_from`,`bulkrequest_product_id`),
  UNIQUE KEY `UNQ_EFCA24DA207BFC299F64CCFC6CE1C586` (`country_id`,`size_to`,`bulkrequest_product_id`),
  KEY `FK_D112CF49BB7A60ACE795770BAEBD28D3` (`bulkrequest_product_id`),
  CONSTRAINT `FK_D112CF49BB7A60ACE795770BAEBD28D3` FOREIGN KEY (`bulkrequest_product_id`) REFERENCES `budsies_bulkrequest_product` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4050 DEFAULT CHARSET=utf8mb3 COMMENT='ShippingRate';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_bulkrequest_status`
--

DROP TABLE IF EXISTS `budsies_bulkrequest_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_bulkrequest_status` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `name` varchar(150) NOT NULL COMMENT 'Name Column',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_BULKREQUEST_STATUS_NAME` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_event`
--

DROP TABLE IF EXISTS `budsies_communication_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_event` (
  `event_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Event id',
  `event_type_id` int unsigned DEFAULT NULL COMMENT 'Event type id',
  `values` text COMMENT 'Values',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Date',
  `store_id` int unsigned NOT NULL DEFAULT '1' COMMENT 'Store ID',
  `is_processed` tinyint unsigned NOT NULL COMMENT 'Is Processed',
  PRIMARY KEY (`event_id`),
  KEY `FK_AA3F269F066FA4FFC40C16EC1EAAB1B2` (`event_type_id`),
  KEY `BUDSIES_COMMUNICATION_EVENT_IS_PROCESSED` (`is_processed`),
  CONSTRAINT `FK_AA3F269F066FA4FFC40C16EC1EAAB1B2` FOREIGN KEY (`event_type_id`) REFERENCES `budsies_communication_event_type` (`event_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies_communication_event';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_event_type`
--

DROP TABLE IF EXISTS `budsies_communication_event_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_event_type` (
  `event_type_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Event type id',
  `code` varchar(150) NOT NULL COMMENT 'Code',
  `name` varchar(150) NOT NULL COMMENT 'Name',
  `params` text COMMENT 'Params',
  `description` text COMMENT 'Description',
  PRIMARY KEY (`event_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COMMENT='budsies_communication_event_type';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_sequence`
--

DROP TABLE IF EXISTS `budsies_communication_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_sequence` (
  `sequence_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence id',
  `name` varchar(150) NOT NULL COMMENT 'Name',
  `sequence_category_id` int unsigned DEFAULT NULL COMMENT 'Sequence category id',
  `trigger_event_type_id` int unsigned DEFAULT NULL COMMENT 'Trigger event type id',
  `abort_event_type_id` int unsigned DEFAULT NULL COMMENT 'Abort event type id',
  `trigger_event_filter` text NOT NULL COMMENT 'Trigger event filter',
  `abort_event_filter` text COMMENT 'Abort event filter',
  `is_active` tinyint NOT NULL DEFAULT '1' COMMENT 'Is active',
  `is_deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'Is moved to trash',
  `one_per_user` tinyint NOT NULL DEFAULT '0' COMMENT 'One per user',
  `one_per_user_lifetime` tinyint NOT NULL DEFAULT '0' COMMENT 'One per user lifetime',
  `store_id` int NOT NULL DEFAULT '1' COMMENT 'Store ID',
  PRIMARY KEY (`sequence_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_ABORT_EVENT_TYPE_ID` (`abort_event_type_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_IS_ACTIVE` (`is_active`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_ONE_PER_USER` (`one_per_user`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_ONE_PER_USER_LIFETIME` (`one_per_user_lifetime`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_SEQUENCE_CATEGORY_ID` (`sequence_category_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_TRIGGER_EVENT_TYPE_ID` (`trigger_event_type_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_IS_DELETED` (`is_deleted`),
  CONSTRAINT `FK_1BC1BDEAA1C4918A13FAD9D73111B9F5` FOREIGN KEY (`abort_event_type_id`) REFERENCES `budsies_communication_event_type` (`event_type_id`),
  CONSTRAINT `FK_24A743F94076A3AECDC5931B0DF4AED6` FOREIGN KEY (`sequence_category_id`) REFERENCES `budsies_communication_sequence_category` (`sequence_category_id`),
  CONSTRAINT `FK_E892929D50C4A1576EEEEBBD3488B728` FOREIGN KEY (`trigger_event_type_id`) REFERENCES `budsies_communication_event_type` (`event_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication sequence';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_sequence_category`
--

DROP TABLE IF EXISTS `budsies_communication_sequence_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_sequence_category` (
  `sequence_category_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence category id',
  `code` varchar(150) NOT NULL COMMENT 'Code',
  `name` varchar(150) NOT NULL COMMENT 'Name',
  `email_from` varchar(150) NOT NULL COMMENT 'Email from',
  `email_reply` varchar(150) NOT NULL COMMENT 'Email reply',
  `description` text COMMENT 'Category description',
  PRIMARY KEY (`sequence_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication sequence category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_sequence_email`
--

DROP TABLE IF EXISTS `budsies_communication_sequence_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_sequence_email` (
  `sequence_email_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence email id',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store id',
  `sequence_progress_id` int unsigned DEFAULT NULL COMMENT 'Sequence progress id',
  `email` varchar(150) NOT NULL COMMENT 'Email',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer id',
  `sender_email` varchar(150) NOT NULL COMMENT 'Sender email',
  `subject` varchar(150) NOT NULL COMMENT 'Subject',
  `email_content` text COMMENT 'Email content',
  `is_sent` tinyint NOT NULL COMMENT 'Is sent',
  `sender_name` varchar(150) DEFAULT NULL COMMENT 'Sender name',
  PRIMARY KEY (`sequence_email_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_EMAIL_CUSTOMER_ID` (`customer_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_EMAIL_SENDER_EMAIL` (`sender_email`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_EMAIL_SEQUENCE_PROGRESS_ID` (`sequence_progress_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_EMAIL_STORE_ID` (`store_id`),
  CONSTRAINT `BUDSIES_COMMUNICATION_SEQUENCE_EMAIL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`),
  CONSTRAINT `FK_7F8A8D3ABE1AD45A7F234288A41BE6F5` FOREIGN KEY (`sequence_progress_id`) REFERENCES `budsies_communication_sequence_progress` (`sequence_progress_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication sequence email';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_sequence_progress`
--

DROP TABLE IF EXISTS `budsies_communication_sequence_progress`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_sequence_progress` (
  `sequence_progress_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_progress_id',
  `sequence_id` int unsigned NOT NULL COMMENT 'Sequence_id',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer_id',
  `guest_email` varchar(150) NOT NULL COMMENT 'Guest_email',
  `step_id` int unsigned NOT NULL COMMENT 'Step_id',
  `available_at` datetime DEFAULT NULL COMMENT 'Next Step Available At',
  `step_state_id` int unsigned DEFAULT NULL COMMENT 'Step_state_id',
  `last_step_executed_at` datetime DEFAULT NULL COMMENT 'Last_step_executed_at',
  `event_id` int unsigned DEFAULT NULL COMMENT 'Event_id',
  `start_date` datetime DEFAULT NULL COMMENT 'Start_date',
  `end_date` datetime DEFAULT NULL COMMENT 'End_date',
  `is_aborted` smallint NOT NULL DEFAULT '0' COMMENT 'Is_aborted',
  `is_completed` smallint NOT NULL DEFAULT '0' COMMENT 'Is_completed',
  `store_id` int NOT NULL DEFAULT '1' COMMENT 'Store ID',
  PRIMARY KEY (`sequence_progress_id`),
  KEY `FK_EEA59D6E9E8A1C5537230038A6753FEE` (`step_state_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_PROGRESS_GUEST_EMAIL` (`guest_email`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_PROGRESS_CUSTOMER_ID` (`customer_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_PROGRESS_EVENT_ID` (`event_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_PROGRESS_SEQUENCE_ID` (`sequence_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_PROGRESS_STEP_ID` (`step_id`),
  KEY `BUDSIES_COMMUNICATION_SEQUENCE_PROGRESS_IS_COMPLETED_IS_ABORTED` (`is_completed`,`is_aborted`),
  CONSTRAINT `FK_70393731D990B4586AD5666C6EE86183` FOREIGN KEY (`step_id`) REFERENCES `budsies_communication_step` (`step_id`),
  CONSTRAINT `FK_74011A907214164E35AFC6278C53EB3C` FOREIGN KEY (`sequence_id`) REFERENCES `budsies_communication_sequence` (`sequence_id`),
  CONSTRAINT `FK_D37BE40E31946A10A31FA0901546C0B1` FOREIGN KEY (`event_id`) REFERENCES `budsies_communication_event` (`event_id`),
  CONSTRAINT `FK_EEA59D6E9E8A1C5537230038A6753FEE` FOREIGN KEY (`step_state_id`) REFERENCES `budsies_communication_step_state` (`step_state_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication sequence progress';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_step`
--

DROP TABLE IF EXISTS `budsies_communication_step`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_step` (
  `step_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Step_id',
  `sequence_id` int unsigned NOT NULL COMMENT 'Sequence_id',
  `step_type_id` int unsigned NOT NULL COMMENT 'Step_type_id',
  `sn` smallint NOT NULL COMMENT 'Sn',
  PRIMARY KEY (`step_id`),
  KEY `BUDSIES_COMMUNICATION_STEP_SEQUENCE_ID` (`sequence_id`),
  KEY `BUDSIES_COMMUNICATION_STEP_STEP_TYPE_ID` (`step_type_id`),
  CONSTRAINT `FK_125D4E682C3031E0C0B01768D93438DE` FOREIGN KEY (`step_type_id`) REFERENCES `budsies_communication_step_type` (`step_type_id`),
  CONSTRAINT `FK_BF65C5FCF329B2BAA1B3A26BDEEE9095` FOREIGN KEY (`sequence_id`) REFERENCES `budsies_communication_sequence` (`sequence_id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication step';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_step_param_value`
--

DROP TABLE IF EXISTS `budsies_communication_step_param_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_step_param_value` (
  `step_param_value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Step_param_value_id',
  `step_id` int unsigned NOT NULL COMMENT 'Step_id',
  `step_type_param_id` int unsigned NOT NULL COMMENT 'Step_type_param_id',
  `value` text NOT NULL COMMENT 'Value',
  PRIMARY KEY (`step_param_value_id`),
  KEY `BUDSIES_COMMUNICATION_STEP_PARAM_VALUE_STEP_ID` (`step_id`),
  KEY `BUDSIES_COMMUNICATION_STEP_PARAM_VALUE_STEP_TYPE_PARAM_ID` (`step_type_param_id`),
  CONSTRAINT `FK_6CDFAB5471743D2936573D9F3B9729E8` FOREIGN KEY (`step_id`) REFERENCES `budsies_communication_step` (`step_id`),
  CONSTRAINT `FK_E74264E09DDB48A1678385FECB9856CF` FOREIGN KEY (`step_type_param_id`) REFERENCES `budsies_communication_step_type_param` (`step_type_param_id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication step param value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_step_state`
--

DROP TABLE IF EXISTS `budsies_communication_step_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_step_state` (
  `step_state_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Step_state_id',
  `code` varchar(150) NOT NULL COMMENT 'Code',
  PRIMARY KEY (`step_state_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication step state';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_step_type`
--

DROP TABLE IF EXISTS `budsies_communication_step_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_step_type` (
  `step_type_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Step_type_id',
  `code` varchar(150) NOT NULL COMMENT 'Code',
  `name` varchar(150) NOT NULL COMMENT 'Name',
  PRIMARY KEY (`step_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication step type';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_step_type_param`
--

DROP TABLE IF EXISTS `budsies_communication_step_type_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_step_type_param` (
  `step_type_param_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Step_type_param_id',
  `step_type_id` int unsigned DEFAULT NULL COMMENT 'Step_type_id',
  `code` varchar(150) NOT NULL COMMENT 'Code',
  `name` varchar(150) NOT NULL COMMENT 'Name',
  PRIMARY KEY (`step_type_param_id`),
  KEY `BUDSIES_COMMUNICATION_STEP_TYPE_PARAM_STEP_TYPE_ID` (`step_type_id`),
  CONSTRAINT `FK_3BE39D5845B321CEB839CA8885A5A76E` FOREIGN KEY (`step_type_id`) REFERENCES `budsies_communication_step_type` (`step_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication step type param';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_communication_unsubscribe`
--

DROP TABLE IF EXISTS `budsies_communication_unsubscribe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_communication_unsubscribe` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
  `sequence_category_id` int unsigned DEFAULT NULL COMMENT 'Sequence category id',
  `email` varchar(255) NOT NULL COMMENT 'Email',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store id',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_DB2483E1E88D493CD9E0CEF5C5632A3C` (`sequence_category_id`,`email`,`store_id`),
  KEY `BUDSIES_COMMUNICATION_UNSUBSCRIBE_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `BUDSIES_COMMUNICATION_UNSUBSCRIBE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_D8D9A034674B3EB4B9102986C0818CFC` FOREIGN KEY (`sequence_category_id`) REFERENCES `budsies_communication_sequence_category` (`sequence_category_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16144 DEFAULT CHARSET=utf8mb3 COMMENT='budsies communication unsubscribe';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_country`
--

DROP TABLE IF EXISTS `budsies_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_country` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(2) NOT NULL,
  `name` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_custom_product_deliverable`
--

DROP TABLE IF EXISTS `budsies_custom_product_deliverable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_custom_product_deliverable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `custom_product_id` int unsigned NOT NULL COMMENT 'Custom Product ID',
  `storage_item_id` varchar(36) NOT NULL COMMENT 'Storage Item ID',
  `storage_item_url` varchar(1024) NOT NULL COMMENT 'Storage Item URL',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_CUSTOM_PRD_DELIVERABLE_CUSTOM_PRD_ID_STORAGE_ITEM_ID` (`custom_product_id`,`storage_item_id`),
  KEY `BUDSIES_CUSTOM_PRODUCT_DELIVERABLE_CUSTOM_PRODUCT_ID` (`custom_product_id`),
  CONSTRAINT `FK_776D147B96FB5F05C423B020D0771192` FOREIGN KEY (`custom_product_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_customer_lifetime_value`
--

DROP TABLE IF EXISTS `budsies_customer_lifetime_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_customer_lifetime_value` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store_id',
  `customer_email` varchar(255) NOT NULL COMMENT 'Customer_email',
  `value` decimal(12,2) DEFAULT '0.00' COMMENT 'Value',
  `orders_qty` int DEFAULT NULL COMMENT 'Orders_qty',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_CUSTOMER_LIFETIME_VALUE_STORE_ID_CUSTOMER_EMAIL` (`store_id`,`customer_email`),
  KEY `BUDSIES_CUSTOMER_LIFETIME_VALUE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies customer lifetime value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_followup_history_attribute`
--

DROP TABLE IF EXISTS `budsies_followup_history_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_followup_history_attribute` (
  `history_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'History Id',
  `attribute_id` int unsigned NOT NULL COMMENT 'Attibute Id',
  PRIMARY KEY (`history_id`),
  KEY `FK_D64A87BE5B624DAC5EC5E2FD558523AF` (`attribute_id`),
  CONSTRAINT `FK_7EF34B4E3930F60332307ECF86F63238` FOREIGN KEY (`history_id`) REFERENCES `amasty_amfollowup_history` (`history_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_D64A87BE5B624DAC5EC5E2FD558523AF` FOREIGN KEY (`attribute_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=249774 DEFAULT CHARSET=utf8mb3 COMMENT='Follow Up History with Product Customization Attribute relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_freshsales_bulkrequest_export`
--

DROP TABLE IF EXISTS `budsies_freshsales_bulkrequest_export`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_freshsales_bulkrequest_export` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `bulkrequest_id` int unsigned NOT NULL,
  `crm_ticket_id` bigint unsigned NOT NULL,
  `crm_type` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_2142648A5BA2F6712ED7A284ECDA8780` (`bulkrequest_id`),
  CONSTRAINT `FK_2142648A5BA2F6712ED7A284ECDA8780` FOREIGN KEY (`bulkrequest_id`) REFERENCES `budsies_bulkrequest` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=40947 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_holiday_action_log`
--

DROP TABLE IF EXISTS `budsies_holiday_action_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_holiday_action_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `holiday_period_id` int unsigned NOT NULL,
  `admin_user_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `FK_263DD1AA17D2052D53FAD15E56522E1B` (`holiday_period_id`),
  KEY `BUDSIES_HOLIDAY_ACTION_LOG_ADMIN_USER_ID_ADMIN_USER_USER_ID` (`admin_user_id`),
  CONSTRAINT `BUDSIES_HOLIDAY_ACTION_LOG_ADMIN_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_263DD1AA17D2052D53FAD15E56522E1B` FOREIGN KEY (`holiday_period_id`) REFERENCES `budsies_holiday_period` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_holiday_period`
--

DROP TABLE IF EXISTS `budsies_holiday_period`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_holiday_period` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_holiday_period_plushie`
--

DROP TABLE IF EXISTS `budsies_holiday_period_plushie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_holiday_period_plushie` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `holiday_period_id` int unsigned NOT NULL,
  `plushie_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_HOLIDAY_PERIOD_PLUSHIE_HOLIDAY_PERIOD_ID_PLUSHIE_ID` (`holiday_period_id`,`plushie_id`),
  KEY `FK_063F22442A9AD3777441C2A392DC24EB` (`plushie_id`),
  CONSTRAINT `FK_063F22442A9AD3777441C2A392DC24EB` FOREIGN KEY (`plushie_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_E8FF2D0B6099DCC5B0AD0A4C797C83BC` FOREIGN KEY (`holiday_period_id`) REFERENCES `budsies_holiday_period` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38790 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_holiday_period_product_settings`
--

DROP TABLE IF EXISTS `budsies_holiday_period_product_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_holiday_period_product_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `holiday_period_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `period_start_date` timestamp NULL DEFAULT NULL,
  `period_end_date` timestamp NULL DEFAULT NULL,
  `intl_regular_cutoff_date` timestamp NULL DEFAULT NULL,
  `intl_rush_cutoff_date` timestamp NULL DEFAULT NULL,
  `domestic_regular_cutoff_date` timestamp NULL DEFAULT NULL COMMENT 'Domestic regular cutoff date',
  `domestic_rush_cutoff_date` timestamp NULL DEFAULT NULL COMMENT 'Domestic rush cutoff date',
  `estimated_shipment_date` timestamp NULL DEFAULT NULL COMMENT 'Estimated shipment date',
  PRIMARY KEY (`id`),
  KEY `FK_31320594BB616D5C2DC391E017B37C5A` (`holiday_period_id`),
  KEY `BUDSIES_HOLIDAY_PERIOD_PRD_SETTINGS_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  CONSTRAINT `BUDSIES_HOLIDAY_PERIOD_PRD_SETTINGS_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_31320594BB616D5C2DC391E017B37C5A` FOREIGN KEY (`holiday_period_id`) REFERENCES `budsies_holiday_period` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1280 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_inspirationmachine_character`
--

DROP TABLE IF EXISTS `budsies_inspirationmachine_character`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_inspirationmachine_character` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(150) NOT NULL COMMENT 'Character Name',
  `icon_path` varchar(255) NOT NULL COMMENT 'Path to Image',
  `image_path` varchar(255) NOT NULL COMMENT 'Path to Image',
  `theme_id` int unsigned NOT NULL COMMENT 'Theme ID',
  PRIMARY KEY (`id`),
  KEY `FK_DB8FB1B7CFEC5E54E5DE6C4242678D69` (`theme_id`),
  CONSTRAINT `FK_DB8FB1B7CFEC5E54E5DE6C4242678D69` FOREIGN KEY (`theme_id`) REFERENCES `budsies_inspirationmachine_theme` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COMMENT='Inspirationmachine Character';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_inspirationmachine_extra`
--

DROP TABLE IF EXISTS `budsies_inspirationmachine_extra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_inspirationmachine_extra` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(150) NOT NULL COMMENT 'Extra Name',
  `icon_path` varchar(255) NOT NULL COMMENT 'Path to Image',
  `image_path` varchar(255) NOT NULL COMMENT 'Path to Image',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_INSPIRATIONMACHINE_EXTRA_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `BUDSIES_INSPIRATIONMACHINE_EXTRA_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COMMENT='Inspirationmachine Extra';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_inspirationmachine_theme`
--

DROP TABLE IF EXISTS `budsies_inspirationmachine_theme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_inspirationmachine_theme` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(150) NOT NULL COMMENT 'Guide Theme Name',
  `description` varchar(150) NOT NULL COMMENT 'Guide Theme Description',
  `icon_path` varchar(255) NOT NULL COMMENT 'Path to Image',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_INSPIRATIONMACHINE_THEME_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `BUDSIES_INSPIRATIONMACHINE_THEME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COMMENT='Inspirationmachine Theme';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_low_stock_notification_product_timestamp`
--

DROP TABLE IF EXISTS `budsies_low_stock_notification_product_timestamp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_low_stock_notification_product_timestamp` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `stock_id` int unsigned NOT NULL COMMENT 'Stock ID',
  `last_notification_at` timestamp NOT NULL COMMENT 'Last Notification Timestamp',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_LOW_STOCK_NTFC_PRD_TIMESTAMP_PRD_ID_STOCK_ID` (`product_id`,`stock_id`),
  KEY `BUDSIES_LOW_STOCK_NTFC_PRD_TIMESTAMP_STOCK_ID_INV_STOCK_STOCK_ID` (`stock_id`),
  CONSTRAINT `BUDSIES_LOW_STOCK_NTFC_PRD_TIMESTAMP_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `BUDSIES_LOW_STOCK_NTFC_PRD_TIMESTAMP_STOCK_ID_INV_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `inventory_stock` (`stock_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COMMENT='Low Stock Notification Product Timestamp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_portless_order`
--

DROP TABLE IF EXISTS `budsies_portless_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_portless_order` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `sales_order_entity_id` int unsigned NOT NULL COMMENT 'Sales Order Entity ID',
  `portless_order_id` varchar(255) NOT NULL COMMENT 'Portless Order ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PORTLESS_ORDER_SALES_ORDER_ENTITY_ID` (`sales_order_entity_id`),
  UNIQUE KEY `BUDSIES_PORTLESS_ORDER_PORTLESS_ORDER_ID` (`portless_order_id`),
  CONSTRAINT `BUDSIES_PORTLESS_ORDER_SALES_ORDER_ENTT_ID_SALES_ORDER_ENTT_ID` FOREIGN KEY (`sales_order_entity_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3942 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies Portless Order Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_portless_order_item`
--

DROP TABLE IF EXISTS `budsies_portless_order_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_portless_order_item` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID Reference',
  `attribute_id` int unsigned DEFAULT NULL COMMENT 'Plushie Attribute ID',
  `sales_order_item_id` int unsigned NOT NULL COMMENT 'Sales Order Item ID',
  `unique_id` varchar(255) NOT NULL COMMENT 'Unique Line Item Identifier',
  `sku` varchar(255) NOT NULL COMMENT 'SKU',
  `quantity` int unsigned NOT NULL DEFAULT '1' COMMENT 'Quantity',
  `requires_shipping` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Requires Shipping',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PORTLESS_ORDER_ITEM_SALES_ORDER_ITEM_ID` (`sales_order_item_id`),
  UNIQUE KEY `BUDSIES_PORTLESS_ORDER_ITEM_UNIQUE_ID` (`unique_id`),
  UNIQUE KEY `BUDSIES_PORTLESS_ORDER_ITEM_ATTRIBUTE_ID` (`attribute_id`),
  KEY `BUDSIES_PORTLESS_ORDER_ITEM_ORDER_ID_BUDSIES_PORTLESS_ORDER_ID` (`order_id`),
  CONSTRAINT `BUDSIES_PORTLESS_ORDER_ITEM_ATTR_ID_BUDSIES_BUDSIE_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `BUDSIES_PORTLESS_ORDER_ITEM_ORDER_ID_BUDSIES_PORTLESS_ORDER_ID` FOREIGN KEY (`order_id`) REFERENCES `budsies_portless_order` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_68BC17F93696EB80FC15145B10863419` FOREIGN KEY (`sales_order_item_id`) REFERENCES `sales_order_item` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4904 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies Portless Order Item Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_portless_shipment_notification_task`
--

DROP TABLE IF EXISTS `budsies_portless_shipment_notification_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_portless_shipment_notification_task` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `shipment_id` int unsigned NOT NULL COMMENT 'Shipment ID',
  `is_processed` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Processed',
  `shipment_creation_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Shipment creation time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PORTLESS_SHIPMENT_NOTIFICATION_TASK_SHIPMENT_ID` (`shipment_id`),
  KEY `IDX_C423545AA04B589B0724E8F0D6D15223` (`is_processed`,`shipment_creation_time`),
  CONSTRAINT `FK_DB48B0E20DC051DA1A5A2F0F1033A60B` FOREIGN KEY (`shipment_id`) REFERENCES `sales_shipment` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2647 DEFAULT CHARSET=utf8mb3 COMMENT='Portless Shipment Notification Task';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization`
--

DROP TABLE IF EXISTS `budsies_product_customization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `parent_id` varchar(36) DEFAULT NULL COMMENT 'Parent GUID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `type_id` varchar(36) NOT NULL COMMENT 'Type GUID',
  `show_in_order_details` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Show in Order Details',
  `show_in_cart` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Show in Cart',
  `sn` int unsigned NOT NULL COMMENT 'Serial Number',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Is Enabled',
  `bundle_option_id` int unsigned DEFAULT NULL COMMENT 'Bundle Option ID',
  `availability_rules` text COMMENT 'Availability Rules',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Locked',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_PRODUCT_ID_NAME_IS_ENABLED` (`product_id`,`name`,`is_enabled`),
  KEY `FK_951FB604AB2F7030B644F7FB5DB262D2` (`type_id`),
  KEY `BUDSIES_PRD_CUSTOMIZATION_BNDL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` (`bundle_option_id`),
  KEY `BUDSIES_PRD_CUSTOMIZATION_PARENT_ID_BUDSIES_PRD_CUSTOMIZATION_ID` (`parent_id`),
  CONSTRAINT `BUDSIES_PRD_CUSTOMIZATION_BNDL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`bundle_option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE SET NULL,
  CONSTRAINT `BUDSIES_PRD_CUSTOMIZATION_PARENT_ID_BUDSIES_PRD_CUSTOMIZATION_ID` FOREIGN KEY (`parent_id`) REFERENCES `budsies_product_customization` (`id`) ON DELETE SET NULL,
  CONSTRAINT `BUDSIES_PRD_CUSTOMIZATION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`),
  CONSTRAINT `FK_951FB604AB2F7030B644F7FB5DB262D2` FOREIGN KEY (`type_id`) REFERENCES `budsies_product_customization_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_display_widget`
--

DROP TABLE IF EXISTS `budsies_product_customization_display_widget`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_display_widget` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_DISPLAY_WIDGET_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_gallery_image_type`
--

DROP TABLE IF EXISTS `budsies_product_customization_gallery_image_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_gallery_image_type` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_GALLERY_IMAGE_TYPE_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_option`
--

DROP TABLE IF EXISTS `budsies_product_customization_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_option` (
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization GUID',
  `sku` varchar(255) DEFAULT NULL COMMENT 'SKU',
  `description` text COMMENT 'Description',
  `hint` text COMMENT 'Hint',
  `preview_storage_item_id` varchar(36) DEFAULT NULL COMMENT 'Preview Storage Item GUID',
  `max_values_count` int unsigned NOT NULL DEFAULT '1' COMMENT 'Max Values Count',
  `has_weight` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Has Weight',
  `has_gallery_images` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Has Gallery Images',
  `has_detailed_description` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Has Detailed Description',
  `show_in_url_query` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Show in URL query',
  `is_required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Required',
  `option_type_id` varchar(36) NOT NULL COMMENT 'Option Type GUID',
  `display_widget_id` varchar(36) NOT NULL COMMENT 'Display Widget GUID',
  `display_widget_options` text COMMENT 'JSON with Display Widget Options',
  PRIMARY KEY (`customization_id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_OPTION_PREVIEW_STORAGE_ITEM_ID` (`preview_storage_item_id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_OPTION_CUSTOMIZATION_ID_SKU` (`customization_id`,`sku`),
  KEY `FK_5B4A7E0FFE413E5460894E00AFB45957` (`option_type_id`),
  KEY `FK_AB9E17BB0AE1B35BEF7D2616AF8BC98C` (`display_widget_id`),
  CONSTRAINT `FK_02FD571B8F02DB8CB91CE95F8FCAC0A4` FOREIGN KEY (`preview_storage_item_id`) REFERENCES `budsies_product_customization_storage_item` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_5B4A7E0FFE413E5460894E00AFB45957` FOREIGN KEY (`option_type_id`) REFERENCES `budsies_product_customization_option_type` (`id`),
  CONSTRAINT `FK_939282B8D7DFD8711D822F84953935A0` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`),
  CONSTRAINT `FK_AB9E17BB0AE1B35BEF7D2616AF8BC98C` FOREIGN KEY (`display_widget_id`) REFERENCES `budsies_product_customization_display_widget` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_option_type`
--

DROP TABLE IF EXISTS `budsies_product_customization_option_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_option_type` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_OPTION_TYPE_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_option_value`
--

DROP TABLE IF EXISTS `budsies_product_customization_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_option_value` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization GUID',
  `bundle_option_item_id` int unsigned DEFAULT NULL COMMENT 'Bundle Option Item ID',
  `sku` varchar(255) DEFAULT NULL COMMENT 'SKU',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `thumbnail_storage_item_id` varchar(36) DEFAULT NULL COMMENT 'Thumbnail Storage Item GUID',
  `thumbnail_url` text COMMENT 'Thumbnail URL',
  `attachment_storage_item_id` varchar(36) DEFAULT NULL COMMENT 'Attachment Storage Item GUID',
  `attachment_url` text COMMENT 'Attachment URL',
  `color` varchar(255) DEFAULT NULL COMMENT 'Color',
  `price` decimal(12,2) unsigned DEFAULT NULL COMMENT 'Price',
  `weight` decimal(12,4) unsigned DEFAULT NULL COMMENT 'Weight',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Is Enabled',
  `is_default` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `availability_rules` text COMMENT 'Availability Rules',
  `actions` text COMMENT 'Actions',
  `sn` int unsigned NOT NULL COMMENT 'Serial Number',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `special_price` decimal(12,4) unsigned DEFAULT NULL COMMENT 'Special Price',
  `special_price_from_date` timestamp NULL DEFAULT NULL COMMENT 'Special Price From Date',
  `special_price_to_date` timestamp NULL DEFAULT NULL COMMENT 'Special Price To Date',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_8813486B6F27F996C72F731474BFE98B` (`customization_id`,`name`,`is_enabled`),
  UNIQUE KEY `BUDSIES_PRD_CUSTOMIZATION_OPT_VAL_THUMBNAIL_STORAGE_ITEM_ID` (`thumbnail_storage_item_id`),
  UNIQUE KEY `BUDSIES_PRD_CUSTOMIZATION_OPT_VAL_ATTACHMENT_STORAGE_ITEM_ID` (`attachment_storage_item_id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_OPTION_VALUE_CUSTOMIZATION_ID_SKU` (`customization_id`,`sku`),
  KEY `FK_91F9B39C5FF52F0CD0E30B93F9BF5394` (`bundle_option_item_id`),
  CONSTRAINT `FK_24F1655B96F410C6398812020A61E9EE` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`),
  CONSTRAINT `FK_7C9EAC0D79FE59C73B3D209907269085` FOREIGN KEY (`attachment_storage_item_id`) REFERENCES `budsies_product_customization_storage_item` (`id`) ON DELETE SET NULL,
  CONSTRAINT `FK_91F9B39C5FF52F0CD0E30B93F9BF5394` FOREIGN KEY (`bundle_option_item_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE SET NULL,
  CONSTRAINT `FK_C74CCF5359CD8004CE422B5A680C310A` FOREIGN KEY (`thumbnail_storage_item_id`) REFERENCES `budsies_product_customization_storage_item` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_option_value_gallery_image`
--

DROP TABLE IF EXISTS `budsies_product_customization_option_value_gallery_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_option_value_gallery_image` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `option_value_id` varchar(36) NOT NULL COMMENT 'Option Value GUID',
  `storage_item_id` varchar(36) DEFAULT NULL COMMENT 'Storage Item GUID',
  `storage_item_url` text COMMENT 'Storage Item URL',
  `sn` int unsigned NOT NULL COMMENT 'Serial Number',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `type_id` varchar(36) NOT NULL DEFAULT '8ffd617d-d4b9-401a-b781-b38aae325bde' COMMENT 'Type GUID',
  `alt_text` varchar(255) NOT NULL DEFAULT '' COMMENT 'Alt Text',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRD_CUSTOMIZATION_OPT_VAL_GLR_IMAGE_STORAGE_ITEM_ID` (`storage_item_id`),
  KEY `FK_D439F90A2DBDFD81A18AC78CEA595710` (`option_value_id`),
  KEY `FK_3BDCC32EC997E6945CC2078998F64A16` (`store_id`),
  KEY `FK_2F8FE308642804F69B5E89A480485641` (`type_id`),
  CONSTRAINT `FK_2F8FE308642804F69B5E89A480485641` FOREIGN KEY (`type_id`) REFERENCES `budsies_product_customization_gallery_image_type` (`id`),
  CONSTRAINT `FK_3BDCC32EC997E6945CC2078998F64A16` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`),
  CONSTRAINT `FK_C8C0A63DC4C96AB9C2599A12F3512450` FOREIGN KEY (`storage_item_id`) REFERENCES `budsies_product_customization_storage_item` (`id`),
  CONSTRAINT `FK_D439F90A2DBDFD81A18AC78CEA595710` FOREIGN KEY (`option_value_id`) REFERENCES `budsies_product_customization_option_value` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_order_attributes`
--

DROP TABLE IF EXISTS `budsies_product_customization_order_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_order_attributes` (
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `attribute_ids` varchar(1024) NOT NULL COMMENT 'Attribute IDs',
  PRIMARY KEY (`order_id`),
  KEY `BUDSIES_PRODUCT_CUSTOMIZATION_ORDER_ATTRIBUTES_ATTRIBUTE_IDS` (`attribute_ids`),
  CONSTRAINT `FK_6954A983B61FE0C6643808593362A83E` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_plushie_state`
--

DROP TABLE IF EXISTS `budsies_product_customization_plushie_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_plushie_state` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `attribute_id` int unsigned NOT NULL COMMENT 'Plushie ID',
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization GUID',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'Value',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  KEY `FK_A6E76D8B16965BDBAF57609EF4822D46` (`attribute_id`),
  KEY `FK_A2EE359319F67BB95D650362F3017358` (`customization_id`),
  CONSTRAINT `FK_A2EE359319F67BB95D650362F3017358` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`),
  CONSTRAINT `FK_A6E76D8B16965BDBAF57609EF4822D46` FOREIGN KEY (`attribute_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_plushie_state_history`
--

DROP TABLE IF EXISTS `budsies_product_customization_plushie_state_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_plushie_state_history` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `attribute_id` int unsigned NOT NULL COMMENT 'Plushie ID',
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization GUID',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'Value',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_57EE8AF4C7F0810F5363BDF759D9BD06` (`attribute_id`,`customization_id`),
  KEY `FK_51E9F5E9A698E911D7584E686AB08966` (`customization_id`),
  CONSTRAINT `FK_51E9F5E9A698E911D7584E686AB08966` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`),
  CONSTRAINT `FK_6B4BBC0C5189A315A8A4A0D20C0DE9CD` FOREIGN KEY (`attribute_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_storage_item`
--

DROP TABLE IF EXISTS `budsies_product_customization_storage_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_storage_item` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `storage_item_type_id` varchar(36) NOT NULL COMMENT 'Storage Item Type GUID',
  `key` varchar(255) NOT NULL COMMENT 'Key',
  `url` varchar(255) NOT NULL COMMENT 'URL',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_STORAGE_ITEM_KEY` (`key`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_STORAGE_ITEM_URL` (`url`),
  KEY `FK_306F120FBC3141DE09CE1AC48961ABB4` (`storage_item_type_id`),
  CONSTRAINT `FK_306F120FBC3141DE09CE1AC48961ABB4` FOREIGN KEY (`storage_item_type_id`) REFERENCES `budsies_product_customization_storage_item_type` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_storage_item_type`
--

DROP TABLE IF EXISTS `budsies_product_customization_storage_item_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_storage_item_type` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_STORAGE_ITEM_TYPE_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_type`
--

DROP TABLE IF EXISTS `budsies_product_customization_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_type` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_TYPE_CODE` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_variant`
--

DROP TABLE IF EXISTS `budsies_product_customization_variant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_variant` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `bundle_option_item_id` int unsigned DEFAULT NULL COMMENT 'Bundle Option Item ID',
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization GUID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `price` decimal(12,2) unsigned DEFAULT NULL COMMENT 'Price',
  `weight` decimal(12,4) unsigned DEFAULT NULL COMMENT 'Weight',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_CUSTOMIZATION_VARIANT_CUSTOMIZATION_ID_NAME` (`customization_id`,`name`),
  KEY `FK_AB9608C5B46024A13D553F0C8DF101DC` (`bundle_option_item_id`),
  CONSTRAINT `FK_66240BA1671322D31392792AF454F6CF` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`),
  CONSTRAINT `FK_AB9608C5B46024A13D553F0C8DF101DC` FOREIGN KEY (`bundle_option_item_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_customization_variant_option_value`
--

DROP TABLE IF EXISTS `budsies_product_customization_variant_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_customization_variant_option_value` (
  `id` varchar(36) NOT NULL COMMENT 'GUID',
  `variant_id` varchar(36) NOT NULL COMMENT 'Variant GUID',
  `option_value_id` varchar(36) NOT NULL COMMENT 'Option Value GUID',
  PRIMARY KEY (`id`),
  KEY `FK_811A0F5FC46B8A6FA45A999ADEC3D59D` (`variant_id`),
  KEY `FK_271A84ECAFA15BDF390C11CE171A5315` (`option_value_id`),
  CONSTRAINT `FK_271A84ECAFA15BDF390C11CE171A5315` FOREIGN KEY (`option_value_id`) REFERENCES `budsies_product_customization_option_value` (`id`),
  CONSTRAINT `FK_811A0F5FC46B8A6FA45A999ADEC3D59D` FOREIGN KEY (`variant_id`) REFERENCES `budsies_product_customization_variant` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_feed_product_customization_data`
--

DROP TABLE IF EXISTS `budsies_product_feed_product_customization_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_feed_product_customization_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `customization_id` varchar(36) NOT NULL COMMENT 'Customization GUID',
  `is_feed_relevant` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Feed Relevant',
  `sn` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sequence Number',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRODUCT_FEED_PRODUCT_CUSTOMIZATION_DATA_CUSTOMIZATION_ID` (`customization_id`),
  KEY `FK_EBD58301CEB6CA41FFCDF6BCEC5589B6` (`product_id`),
  CONSTRAINT `FK_1A9B585D476EC3FE6D6C0644D85F84AF` FOREIGN KEY (`customization_id`) REFERENCES `budsies_product_customization` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_EBD58301CEB6CA41FFCDF6BCEC5589B6` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COMMENT='Product Customization Data for Feed';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_product_feed_product_customization_value_data`
--

DROP TABLE IF EXISTS `budsies_product_feed_product_customization_value_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_product_feed_product_customization_value_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `product_customization_data_id` int unsigned NOT NULL COMMENT 'Product Customization Data ID',
  `customization_value_id` varchar(36) NOT NULL COMMENT 'Customization Value GUID',
  `product_attributes_json` text COMMENT 'Product Attributes JSON',
  `sn` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sequence Number',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PRD_FEED_PRD_CUSTOMIZATION_VAL_DATA_CUSTOMIZATION_VAL_ID` (`customization_value_id`),
  KEY `FK_99B6FFE07D85BE9990973523804C65BE` (`product_customization_data_id`),
  CONSTRAINT `FK_051590393506CA1C35A696589E773711` FOREIGN KEY (`customization_value_id`) REFERENCES `budsies_product_customization_option_value` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_99B6FFE07D85BE9990973523804C65BE` FOREIGN KEY (`product_customization_data_id`) REFERENCES `budsies_product_feed_product_customization_data` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb3 COMMENT='Product Customization Value Data for Feed';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  `start_date` datetime NOT NULL COMMENT 'Start date',
  `end_date` datetime NOT NULL COMMENT 'End date',
  `is_active` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `for_all_visitors` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'For All Visitors',
  `days_promotion_period` smallint unsigned DEFAULT NULL COMMENT 'Promotion period in days',
  `promotion_period_weekday` varchar(10) DEFAULT NULL COMMENT 'Day of week for promotion period expiration',
  `link_parameter` varchar(255) DEFAULT NULL COMMENT 'Link parameter',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PROMOTION_CAMPAIGN_LINK_PARAMETER` (`link_parameter`),
  KEY `BUDSIES_PROMOTION_CAMPAIGN_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `BUDSIES_PROMOTION_CAMPAIGN_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign_countdown_banner`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign_countdown_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign_countdown_banner` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` smallint unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `text_color` varchar(6) NOT NULL,
  `numbers_color` varchar(6) NOT NULL,
  `background_color` varchar(6) NOT NULL,
  `blacklist_urls` text NOT NULL,
  `version` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `BUDSIES_PROMOTION_CAMPAIGN_COUNTDOWN_BANNER_ID` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign_discount_type`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign_discount_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign_discount_type` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `code` varchar(150) NOT NULL COMMENT 'Code Column',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_PROMOTION_CAMPAIGN_DISCOUNT_TYPE_ID` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='DiscountType';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign_image_banner`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign_image_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign_image_banner` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int unsigned NOT NULL,
  `regular_img` varchar(255) NOT NULL,
  `mobile_img` varchar(255) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `version` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `is_open_in_new_window` tinyint DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK_9C6C14323E08FC404B6683AAD9D60AC3` (`campaign_id`),
  KEY `BUDSIES_PROMOTION_CAMPAIGN_IMAGE_BANNER_ID` (`id`),
  CONSTRAINT `FK_9C6C14323E08FC404B6683AAD9D60AC3` FOREIGN KEY (`campaign_id`) REFERENCES `budsies_promotion_campaign` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign_module`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign_module` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_PROMOTION_CAMPAIGN_MODULE_CODE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign_module_link`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign_module_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign_module_link` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `campaign_id` int unsigned NOT NULL COMMENT 'Campaign ID',
  `module_id` int unsigned NOT NULL COMMENT 'Module ID',
  PRIMARY KEY (`id`),
  KEY `FK_8998A19BCA207A4F19B0D58FF3EC3C30` (`campaign_id`),
  KEY `FK_8A0A1F6966010179968003E1E41989D1` (`module_id`),
  CONSTRAINT `FK_8998A19BCA207A4F19B0D58FF3EC3C30` FOREIGN KEY (`campaign_id`) REFERENCES `budsies_promotion_campaign` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_8A0A1F6966010179968003E1E41989D1` FOREIGN KEY (`module_id`) REFERENCES `budsies_promotion_campaign_module` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=339 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_campaign_product_discount`
--

DROP TABLE IF EXISTS `budsies_promotion_campaign_product_discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_campaign_product_discount` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `campaign_id` int unsigned NOT NULL COMMENT 'Campaign Id Column',
  `product_id` int unsigned NOT NULL COMMENT 'Product Id Column',
  `discount_type_id` int unsigned NOT NULL COMMENT 'Discount Type Id Column',
  `discount_value` float NOT NULL COMMENT 'Discount Value Column',
  PRIMARY KEY (`id`),
  KEY `FK_E6C3B0EA57D1DB9D3C50DB4D6FCA7572` (`campaign_id`),
  KEY `FK_21B718941B5D05A50E34098126DF4FCE` (`product_id`),
  KEY `FK_B8D0013B795165486D1E2D924519CCDF` (`discount_type_id`),
  KEY `BUDSIES_PROMOTION_CAMPAIGN_PRODUCT_DISCOUNT_ID` (`id`),
  CONSTRAINT `FK_21B718941B5D05A50E34098126DF4FCE` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_B8D0013B795165486D1E2D924519CCDF` FOREIGN KEY (`discount_type_id`) REFERENCES `budsies_promotion_campaign_discount_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_E6C3B0EA57D1DB9D3C50DB4D6FCA7572` FOREIGN KEY (`campaign_id`) REFERENCES `budsies_promotion_campaign` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb3 COMMENT='ProductDiscount';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_promoevent`
--

DROP TABLE IF EXISTS `budsies_promotion_promoevent`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_promoevent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
  `name` varchar(150) NOT NULL COMMENT 'Name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='budsies_promotion_promoevent';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_quote_campaign`
--

DROP TABLE IF EXISTS `budsies_promotion_quote_campaign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_quote_campaign` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote ID',
  `campaign_id` int unsigned NOT NULL COMMENT 'Campaign ID',
  `expiration_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Expiration timestamp of the assigned promo campaign',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_PROMOTION_QUOTE_CAMPAIGN_QUOTE_ID_QUOTE_ENTITY_ID` (`quote_id`),
  KEY `FK_6943FE1762B553726699CEDDC7876988` (`campaign_id`),
  CONSTRAINT `BUDSIES_PROMOTION_QUOTE_CAMPAIGN_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_6943FE1762B553726699CEDDC7876988` FOREIGN KEY (`campaign_id`) REFERENCES `budsies_promotion_campaign` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=235302 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_promotion_reminder`
--

DROP TABLE IF EXISTS `budsies_promotion_reminder`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_promotion_reminder` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created_at',
  `promoevent_id` int unsigned NOT NULL COMMENT 'Promoevent_id',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer_id',
  `customer_email` varchar(255) NOT NULL COMMENT 'Customer_email',
  `notification_date` date DEFAULT NULL COMMENT 'Notification_date',
  `is_sent` smallint NOT NULL DEFAULT '0' COMMENT 'Is_sent',
  `store_id` int NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_PROMOTION_REMINDER_CUSTOMER_ID` (`customer_id`),
  KEY `BUDSIES_PROMOTION_REMINDER_PROMOEVENT_ID` (`promoevent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies_promotion_reminder';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_quickbooks_api_token`
--

DROP TABLE IF EXISTS `budsies_quickbooks_api_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_quickbooks_api_token` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
  `type` varchar(50) NOT NULL COMMENT 'Token type',
  `token` varchar(50) NOT NULL COMMENT 'Token',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_QUICKBOOKS_API_TOKEN_TYPE` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies quickbooks api token';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_raffle_participant`
--

DROP TABLE IF EXISTS `budsies_raffle_participant`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_raffle_participant` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `email` varchar(150) NOT NULL,
  `firstname` varchar(150) DEFAULT NULL,
  `lastname` varchar(150) DEFAULT NULL,
  `referral_hashcode` varchar(150) NOT NULL,
  `short_referral_url` varchar(150) NOT NULL,
  `access_hashcode` varchar(150) NOT NULL,
  `can_purchase_petsie` int unsigned DEFAULT NULL,
  `can_purchase_spec_comm` tinyint DEFAULT NULL,
  `referrer_id` int unsigned DEFAULT NULL,
  `is_verified` tinyint NOT NULL,
  `verification_hashcode` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_RAFFLE_PARTICIPANT_ACCESS_HASHCODE` (`access_hashcode`),
  UNIQUE KEY `BUDSIES_RAFFLE_PARTICIPANT_EMAIL` (`email`),
  UNIQUE KEY `BUDSIES_RAFFLE_PARTICIPANT_REFERRAL_HASHCODE` (`referral_hashcode`),
  KEY `FK_8A878AC3BBAC6444F0A3450051FCF486` (`referrer_id`),
  CONSTRAINT `FK_8A878AC3BBAC6444F0A3450051FCF486` FOREIGN KEY (`referrer_id`) REFERENCES `budsies_raffle_participant` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='budsies_raffle_participant';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_raffle_participant_plushie`
--

DROP TABLE IF EXISTS `budsies_raffle_participant_plushie`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_raffle_participant_plushie` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `participant_id` int unsigned NOT NULL,
  `plushie_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_RAFFLE_PARTICIPANT_PLUSHIE_PLUSHIE_ID` (`plushie_id`),
  KEY `FK_453CD17FDF0DAAFFA46814001E83A231` (`participant_id`),
  CONSTRAINT `FK_453CD17FDF0DAAFFA46814001E83A231` FOREIGN KEY (`participant_id`) REFERENCES `budsies_raffle_participant` (`id`),
  CONSTRAINT `FK_55BC6F43E269AFC20C72655F6A247B0F` FOREIGN KEY (`plushie_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Budsies raffle participant plushie';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_raffle_round`
--

DROP TABLE IF EXISTS `budsies_raffle_round`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_raffle_round` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=354 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies raffle round';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_raffle_ticket`
--

DROP TABLE IF EXISTS `budsies_raffle_ticket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_raffle_ticket` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `raffle_participant_id` int unsigned NOT NULL,
  `code` varchar(150) NOT NULL,
  `raffle_ticket_status_id` int unsigned NOT NULL,
  `raffle_round_id` int unsigned DEFAULT NULL,
  `needs_notification` tinyint NOT NULL,
  `order_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_RAFFLE_TICKET_CODE` (`code`),
  KEY `BUDSIES_RAFFLE_TICKET_RAFFLE_PARTICIPANT_ID` (`raffle_participant_id`),
  KEY `BUDSIES_RAFFLE_TICKET_RAFFLE_TICKET_STATUS_ID` (`raffle_ticket_status_id`),
  KEY `BUDSIES_RAFFLE_TICKET_ORDER_ID` (`order_id`),
  KEY `BUDSIES_RAFFLE_TICKET_RAFFLE_ROUND_ID` (`raffle_round_id`),
  CONSTRAINT `BUDSIES_RAFFLE_TICKET_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`),
  CONSTRAINT `BUDSIES_RAFFLE_TICKET_RAFFLE_ROUND_ID_BUDSIES_RAFFLE_ROUND_ID` FOREIGN KEY (`raffle_round_id`) REFERENCES `budsies_raffle_round` (`id`),
  CONSTRAINT `FK_29D4C5C182135ABE5EA1946D276B191B` FOREIGN KEY (`raffle_participant_id`) REFERENCES `budsies_raffle_participant` (`id`),
  CONSTRAINT `FK_43F85E6552C93ABC29D5CF3202D1DD6F` FOREIGN KEY (`raffle_ticket_status_id`) REFERENCES `budsies_raffle_ticket_status` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Budsies raffle ticket';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_raffle_ticket_status`
--

DROP TABLE IF EXISTS `budsies_raffle_ticket_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_raffle_ticket_status` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies raffle ticket status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_sales_quote_item_totals`
--

DROP TABLE IF EXISTS `budsies_sales_quote_item_totals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_sales_quote_item_totals` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `quote_item_id` int unsigned NOT NULL COMMENT 'Quote Item Id Column',
  `regular_price` decimal(20,4) unsigned NOT NULL COMMENT 'Regular Price Column',
  `savings_amount` decimal(20,4) NOT NULL COMMENT 'Savings Amount Column',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_SALES_QUOTE_ITEM_TOTALS_QUOTE_ITEM_ID_QUOTE_ITEM_ITEM_ID` (`quote_item_id`),
  KEY `BUDSIES_SALES_QUOTE_ITEM_TOTALS_ID` (`id`),
  CONSTRAINT `BUDSIES_SALES_QUOTE_ITEM_TOTALS_QUOTE_ITEM_ID_QUOTE_ITEM_ITEM_ID` FOREIGN KEY (`quote_item_id`) REFERENCES `quote_item` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Quote Item Totals';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_sales_quote_totals`
--

DROP TABLE IF EXISTS `budsies_sales_quote_totals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_sales_quote_totals` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id Column',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote Id Column',
  `regular_subtotal` decimal(20,4) unsigned DEFAULT NULL COMMENT 'Regular Subtotal Column',
  `savings_total` decimal(20,4) DEFAULT NULL COMMENT 'Savings Total Column',
  `discounts_total` decimal(20,4) DEFAULT NULL COMMENT 'Discounts Total Column',
  PRIMARY KEY (`id`),
  KEY `BUDSIES_SALES_QUOTE_TOTALS_QUOTE_ID_QUOTE_ENTITY_ID` (`quote_id`),
  KEY `BUDSIES_SALES_QUOTE_TOTALS_ID` (`id`),
  CONSTRAINT `BUDSIES_SALES_QUOTE_TOTALS_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=69528 DEFAULT CHARSET=utf8mb3 COMMENT='Quote Totals';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_shopify_order`
--

DROP TABLE IF EXISTS `budsies_shopify_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_shopify_order` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `shopify_order_gid` varchar(255) NOT NULL COMMENT 'Shopify Order GID',
  `shopify_fulfillment_order_gid` varchar(255) NOT NULL COMMENT 'Shopify Fulfillment Order GID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `total_price` decimal(12,2) NOT NULL COMMENT 'Total Price',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `processed_at` timestamp NULL DEFAULT NULL COMMENT 'Processed At',
  `sales_order_id` int unsigned DEFAULT NULL COMMENT 'Sales Order ID',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_SHOPIFY_ORDER_SHOPIFY_ORDER_GID` (`shopify_order_gid`),
  UNIQUE KEY `BUDSIES_SHOPIFY_ORDER_SHOPIFY_FULFILLMENT_ORDER_GID` (`shopify_fulfillment_order_gid`),
  KEY `BUDSIES_SHOPIFY_ORDER_STORE_ID_STORE_STORE_ID` (`store_id`),
  KEY `BUDSIES_SHOPIFY_ORDER_SALES_ORDER_ID_SALES_ORDER_ENTITY_ID` (`sales_order_id`),
  CONSTRAINT `BUDSIES_SHOPIFY_ORDER_SALES_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`sales_order_id`) REFERENCES `sales_order` (`entity_id`),
  CONSTRAINT `BUDSIES_SHOPIFY_ORDER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies Shopify Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_shopify_order_item`
--

DROP TABLE IF EXISTS `budsies_shopify_order_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_shopify_order_item` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `shopify_order_id` int unsigned NOT NULL COMMENT 'Shopify Order ID',
  `shopify_order_item_gid` varchar(255) NOT NULL COMMENT 'Shopify Order Item GID',
  `unit_price` decimal(12,2) NOT NULL COMMENT 'Unit Price',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_SHOPIFY_ORDER_ITEM_SHOPIFY_ORDER_ITEM_GID` (`shopify_order_item_gid`),
  KEY `FK_8B3FCA1926D92D7D803CD16ADEB22747` (`shopify_order_id`),
  CONSTRAINT `FK_8B3FCA1926D92D7D803CD16ADEB22747` FOREIGN KEY (`shopify_order_id`) REFERENCES `budsies_shopify_order` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies Shopify Order Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_shopify_order_item_budsie_attribute`
--

DROP TABLE IF EXISTS `budsies_shopify_order_item_budsie_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_shopify_order_item_budsie_attribute` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `shopify_order_item_id` int unsigned NOT NULL COMMENT 'Shopify Order Item ID',
  `shopify_fulfillment_gid` varchar(255) DEFAULT NULL COMMENT 'Shopify Fulfillment GID',
  `budsie_attribute_id` int unsigned NOT NULL COMMENT 'Budsie Attribute ID',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_SHOPIFY_ORDER_ITEM_BUDSIE_ATTRIBUTE_BUDSIE_ATTRIBUTE_ID` (`budsie_attribute_id`),
  KEY `FK_59E1D689E0DE79672C937AE96335BBCA` (`shopify_order_item_id`),
  CONSTRAINT `FK_59E1D689E0DE79672C937AE96335BBCA` FOREIGN KEY (`shopify_order_item_id`) REFERENCES `budsies_shopify_order_item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `FK_E1A149B3A76ADB97B481421A0C451261` FOREIGN KEY (`budsie_attribute_id`) REFERENCES `budsies_budsie_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COMMENT='Budsies Shopify Order Item Budsie Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `budsies_storyblok_story`
--

DROP TABLE IF EXISTS `budsies_storyblok_story`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `budsies_storyblok_story` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Story ID',
  `space_id` int unsigned NOT NULL COMMENT 'Space Id',
  `story_id` int unsigned NOT NULL COMMENT 'Storyblok Story ID',
  `slug` varchar(255) NOT NULL COMMENT 'Story Slug',
  PRIMARY KEY (`id`),
  UNIQUE KEY `BUDSIES_STORYBLOK_STORY_STORY_ID` (`story_id`)
) ENGINE=InnoDB AUTO_INCREMENT=334 DEFAULT CHARSET=utf8mb3 COMMENT='budsies_storyblok_story';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int NOT NULL COMMENT 'Position',
  `level` int NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DTIME_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=513 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_DEC_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_INT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2270 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_TEXT_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2550 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_ENTT_VCHR_ENTT_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3381 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product` (
  `entity_id` int NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_CTGR_PRD_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_CTGR_PRD_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2296 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store1` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_4B965DC45C352D6E4C9DC0FF50B1FCF5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_47AB760CD6A893ACEA69A9C2E0112C60` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store10`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store10`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store10` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE10_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_F8ACF7CDE70069E0E1260FAB3C7FAF7E` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store10';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store10_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store10_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store10_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_BF8E9C147B9E369FA5F75474BF410B76` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_399EE76B5BD4142D9CCF0511849161E3` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store10 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store11`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store11`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store11` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE11_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_9F0B77094AF348D2A235C90B326004F3` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store11';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store11_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store11_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store11_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_C745732E55C32D6FA5D2C9868E174B08` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_8E65224CF04CDBE62BE589AFCF1494B1` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store11 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store12`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store12`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store12` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE12_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_26FC86C5E205CE457A898997567F236E` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store12';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store12_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store12_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store12_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_16609E051506ED4B6244E0113C273205` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_4428CAC3271DF82611D82D3FF2E50FBB` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store12 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store13`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store13`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store13` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE13_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_755D4F0D55D5EE6C608F4FF47294DEAF` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store13';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store13_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store13_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store13_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_8389A453B1D17695872A3F5AB53CED55` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_15E0763074BBF12DA79E845D659BCC7F` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store13 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store14`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store14`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store14` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE14_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_0E7866384855D9DF5A459DF1F4331653` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store14';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store14_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store14_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store14_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_9B9988D49BCDD4DDA85639A10275AF55` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_4397C9A49019C8638DCA278481D2BA08` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store14 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store1_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_216E521C8AD125E066D2B0BAB4A08412` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store2`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store2` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_87FCED52F67C72BB6992C79EB4DCFA8A` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_15B841C92B67D986A980051DF109F9D1` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store2_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store2_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store2_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE2_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_2AB6FE58F086547FA7E4590837296849` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store2 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store3`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store3` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_43726D149468373EB56B59700A89860C` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_3A62575144A54728FACD3A0D6309E61D` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store3';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store3_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store3_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store3_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE3_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_E9342558FA31C65508E1FE75E6242607` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store3 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store4`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store4` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_966AADF0F2BFAFFC1235C826759845CC` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_F43ABBF162395BE3A1D5B1AE17C24FE2` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store4';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store4_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store4_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store4_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE4_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_ABB606D1CB36CD160DB880F39838BC3F` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store4 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store5`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store5` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_78288F76D618C4C378D1DE1DB362C05F` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_04B1890D19F381013371F9182F62C602` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store5_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store5_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store5_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE5_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_D66B6557126C2DE627A049511C72BE10` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store5 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store6`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store6` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_60907034DE58E5F1696F31290F80B9B6` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_65189DCB54C58237E1298BDD7727D150` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store6_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store6_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store6_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE6_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_715799A609D876BA8BC3889F4D0D2350` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store6 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store7`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store7`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store7` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_E9F919EC2BB507793EE19DA7C71D1C68` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_429013479D97EE179DF15355662AC756` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store7';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store7_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store7_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store7_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE7_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_FC3C465EAA213CB948AAD83C52813CCF` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store7 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store8`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store8`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store8` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_57B5E46D5E5C9F39BB7CE63D46A21EF5` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_72A17E5BDF6BE100A92393EED4942631` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store8';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store8_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store8_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store8_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE8_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_4D42D0D334EFF63D3E99C6D90D3F3E39` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store8 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store9`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store9`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store9` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_ADE8510F1BBEC8E64D9E49D2B86DF6A6` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_CAE8981A33EEF72C92B0DA20D82E8789` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_store9_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_store9_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_store9_replica` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_STORE9_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_ADAF96EF1972B57CCB3A89BA1A467864` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Index Store9 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `list_id` int unsigned DEFAULT NULL COMMENT 'List ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `CATALOG_COMPARE_ITEM_LIST_ID_CATALOG_COMPARE_LIST_LIST_ID` (`list_id`),
  KEY `CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_COMPARE_ITEM_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_LIST_ID_CATALOG_COMPARE_LIST_LIST_ID` FOREIGN KEY (`list_id`) REFERENCES `catalog_compare_list` (`list_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_COMPARE_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_compare_list`
--

DROP TABLE IF EXISTS `catalog_compare_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_compare_list` (
  `list_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare List ID',
  `list_id_mask` varchar(32) DEFAULT NULL COMMENT 'Masked ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`list_id`),
  UNIQUE KEY `CATALOG_COMPARE_LIST_CUSTOMER_ID` (`customer_id`),
  KEY `CATALOG_COMPARE_LIST_LIST_ID_MASK` (`list_id_mask`),
  CONSTRAINT `CATALOG_COMPARE_LIST_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Compare List with hash Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `is_pagebuilder_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is PageBuilder Enabled',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `CATALOG_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `CAT_PRD_BNDL_OPT_VAL_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2468 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_PRICE_IDX_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `position` int unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_OPT_ID_CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1194 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DCF37523AA05D770A70AA4ED7C2616E4` FOREIGN KEY (`selection_id`) REFERENCES `catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) NOT NULL COMMENT 'SKU',
  `has_options` smallint NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=826 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DTIME_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=48117 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CAT_PRD_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_DEC_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32323 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_GLR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID_STORE_ID_VALUE` (`attribute_id`,`store_id`,`value`),
  CONSTRAINT `CAT_PRD_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_INT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19533 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2429 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Media Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  PRIMARY KEY (`record_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_VAL_ID_STORE_ID` (`entity_id`,`value_id`,`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_VAL_ID_CAT_PRD_ENTT_MDA_GLR_VAL_ID` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7367 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Media Gallery Attribute Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_to_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int unsigned NOT NULL COMMENT 'Product Entity ID',
  PRIMARY KEY (`value_id`,`entity_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` (`entity_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_A6C6C8FAA386736921D3A7C4B50B1185` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Link Media value to Product entity table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_media_gallery_value_video` (
  `value_id` int unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  PRIMARY KEY (`value_id`,`store_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_6FDF205946906B0E653E60AA769899F8` FOREIGN KEY (`value_id`) REFERENCES `catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Video Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` mediumtext COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TEXT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22276 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_entity_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_tier_price` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `all_groups` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Applicable To All Customer Groups',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'QTY',
  `value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Value',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `percentage_value` decimal(5,2) DEFAULT NULL COMMENT 'Percentage value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `UNQ_E8AB433B9ACB00343ABB312AD2FAB087` (`entity_id`,`all_groups`,`customer_group_id`,`qty`,`website_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TIER_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_ENTT_TIER_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_TIER_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Tier Price Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_product_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_ENTT_VCHR_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=96898 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_frontend_action`
--

DROP TABLE IF EXISTS `catalog_product_frontend_action`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_frontend_action` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Action ID',
  `type_id` varchar(64) NOT NULL COMMENT 'Type of product action',
  `visitor_id` int unsigned DEFAULT NULL COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `added_at` bigint NOT NULL COMMENT 'Added At',
  PRIMARY KEY (`action_id`),
  UNIQUE KEY `CATALOG_PRODUCT_FRONTEND_ACTION_VISITOR_ID_PRODUCT_ID_TYPE_ID` (`visitor_id`,`product_id`,`type_id`),
  UNIQUE KEY `CATALOG_PRODUCT_FRONTEND_ACTION_CUSTOMER_ID_PRODUCT_ID_TYPE_ID` (`customer_id`,`product_id`,`type_id`),
  KEY `CAT_PRD_FRONTEND_ACTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_FRONTEND_ACTION_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_FRONTEND_ACTION_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Frontend Action Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav`
--

DROP TABLE IF EXISTS `catalog_product_index_eav`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_decimal`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_decimal_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_decimal_replica`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal_replica` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_decimal_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_decimal_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_decimal_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` decimal(12,4) NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_DECIMAL_TMP_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Decimal Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_IDX_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_replica`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_replica` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_eav_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_eav_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_eav_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` int unsigned NOT NULL COMMENT 'Value',
  `source_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Original entity ID for attribute value',
  PRIMARY KEY (`entity_id`,`attribute_id`,`store_id`,`value`,`source_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_INDEX_EAV_TMP_VALUE` (`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product EAV Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price`
--

DROP TABLE IF EXISTS `catalog_product_index_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE` (`min_price`),
  KEY `CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE` (`website_id`,`customer_group_id`,`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_bundle_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price_type` smallint unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(20,6) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(20,6) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Opt Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_bundle_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_opt_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `alt_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `alt_tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Alt Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Opt Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `selection_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Selection ID',
  `group_type` smallint unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Sel Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_bundle_sel_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_sel_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_sel_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `selection_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Selection ID',
  `group_type` smallint unsigned DEFAULT '0' COMMENT 'Group Type',
  `is_required` smallint unsigned DEFAULT '0' COMMENT 'Is Required',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`,`selection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Sel Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_bundle_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_bundle_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_bundle_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price_type` smallint unsigned NOT NULL COMMENT 'Price Type',
  `special_price` decimal(20,6) DEFAULT NULL COMMENT 'Special Price',
  `tier_percent` decimal(20,6) DEFAULT NULL COMMENT 'Tier Percent',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Orig Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Index Price Bundle Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_idx` (
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Aggregate Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_agr_tmp` (
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int unsigned NOT NULL COMMENT 'Child ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`parent_id`,`child_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Aggregate Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_cfg_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_cfg_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_cfg_opt_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Config Option Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_downlod_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_downlod_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Minimum price',
  `max_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Indexer Table for price of downloadable products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_downlod_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_downlod_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_downlod_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int NOT NULL,
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Minimum price',
  `max_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Maximum price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Temporary Indexer Table for price of downloadable products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_final_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_final_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Final Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_final_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_final_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_final_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `orig_price` decimal(20,6) DEFAULT NULL COMMENT 'Original Price',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `base_tier` decimal(20,6) DEFAULT NULL COMMENT 'Base Tier',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Final Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_IDX_MIN_PRICE` (`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_opt_agr_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_agr_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Aggregate Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_opt_agr_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_agr_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_agr_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Aggregate Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_opt_idx`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_idx` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_opt_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_opt_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_opt_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Option Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_replica`
--

DROP TABLE IF EXISTS `catalog_product_index_price_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_replica` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_PRICE_MIN_PRICE` (`min_price`),
  KEY `CAT_PRD_IDX_PRICE_WS_ID_CSTR_GROUP_ID_MIN_PRICE` (`website_id`,`customer_group_id`,`min_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_price_tmp`
--

DROP TABLE IF EXISTS `catalog_product_index_price_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_price_tmp` (
  `entity_id` int unsigned NOT NULL COMMENT 'Product ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `tax_class_id` smallint unsigned DEFAULT '0' COMMENT 'Tax Class ID',
  `price` decimal(20,6) DEFAULT NULL COMMENT 'Price',
  `final_price` decimal(20,6) DEFAULT NULL COMMENT 'Final Price',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) DEFAULT NULL COMMENT 'Max Price',
  `tier_price` decimal(20,6) DEFAULT NULL COMMENT 'Tier Price',
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Price Indexer Temp Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_tier_price`
--

DROP TABLE IF EXISTS `catalog_product_index_tier_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_tier_price` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `min_price` decimal(20,6) DEFAULT NULL COMMENT 'Min Price',
  PRIMARY KEY (`entity_id`,`customer_group_id`,`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_TIER_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOG_PRODUCT_INDEX_TIER_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_IDX_TIER_PRICE_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_IDX_TIER_PRICE_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_IDX_TIER_PRICE_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Tier Price Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_index_website`
--

DROP TABLE IF EXISTS `catalog_product_index_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_index_website` (
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `default_store_id` smallint unsigned NOT NULL COMMENT 'Default store ID for website',
  `website_date` date DEFAULT NULL COMMENT 'Website Date',
  `rate` float DEFAULT '1' COMMENT 'Rate',
  PRIMARY KEY (`website_id`),
  KEY `CATALOG_PRODUCT_INDEX_WEBSITE_WEBSITE_DATE` (`website_date`),
  CONSTRAINT `CAT_PRD_IDX_WS_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Website Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_link`
--

DROP TABLE IF EXISTS `catalog_product_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `linked_product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Linked Product ID',
  `link_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `CATALOG_PRODUCT_LINK_LINK_TYPE_ID_PRODUCT_ID_LINKED_PRODUCT_ID` (`link_type_id`,`product_id`,`linked_product_id`),
  KEY `CATALOG_PRODUCT_LINK_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_PRODUCT_LINK_LINKED_PRODUCT_ID` (`linked_product_id`),
  CONSTRAINT `CAT_PRD_LNK_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_LNK_LNKED_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`linked_product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_LINK_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2760 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Product Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_link_attribute`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute` (
  `product_link_attribute_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Link Attribute ID',
  `link_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Link Type ID',
  `product_link_attribute_code` varchar(32) DEFAULT NULL COMMENT 'Product Link Attribute Code',
  `data_type` varchar(32) DEFAULT NULL COMMENT 'Data Type',
  PRIMARY KEY (`product_link_attribute_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_LINK_TYPE_ID` (`link_type_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_LNK_TYPE_ID_CAT_PRD_LNK_TYPE_LNK_TYPE_ID` FOREIGN KEY (`link_type_id`) REFERENCES `catalog_product_link_type` (`link_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_link_attribute_decimal`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute_decimal` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int unsigned NOT NULL COMMENT 'Link ID',
  `value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_DEC_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_DECIMAL_LINK_ID` (`link_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_DEC_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_AB2EFA9A14F7BCF1D5400056203D14B6` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Decimal Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_link_attribute_int`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute_int` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint unsigned DEFAULT NULL COMMENT 'Product Link Attribute ID',
  `link_id` int unsigned NOT NULL COMMENT 'Link ID',
  `value` int NOT NULL DEFAULT '0' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_INT_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_INT_LINK_ID` (`link_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_INT_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_D6D878F8BA2A4282F8DDED7E6E3DE35C` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3237 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Integer Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_link_attribute_varchar`
--

DROP TABLE IF EXISTS `catalog_product_link_attribute_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_attribute_varchar` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_link_attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Product Link Attribute ID',
  `link_id` int unsigned NOT NULL COMMENT 'Link ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_LNK_ATTR_VCHR_PRD_LNK_ATTR_ID_LNK_ID` (`product_link_attribute_id`,`link_id`),
  KEY `CATALOG_PRODUCT_LINK_ATTRIBUTE_VARCHAR_LINK_ID` (`link_id`),
  CONSTRAINT `CAT_PRD_LNK_ATTR_VCHR_LNK_ID_CAT_PRD_LNK_LNK_ID` FOREIGN KEY (`link_id`) REFERENCES `catalog_product_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_DEE9C4DA61CFCC01DFCF50F0D79CEA51` FOREIGN KEY (`product_link_attribute_id`) REFERENCES `catalog_product_link_attribute` (`product_link_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Varchar Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_link_type`
--

DROP TABLE IF EXISTS `catalog_product_link_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_link_type` (
  `link_type_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link Type ID',
  `code` varchar(32) DEFAULT NULL COMMENT 'Code',
  PRIMARY KEY (`link_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Link Type Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_option`
--

DROP TABLE IF EXISTS `catalog_product_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `type` varchar(50) DEFAULT NULL COMMENT 'Type',
  `is_require` smallint NOT NULL DEFAULT '1' COMMENT 'Is Required',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `max_characters` int unsigned DEFAULT NULL COMMENT 'Max Characters',
  `file_extension` varchar(50) DEFAULT NULL COMMENT 'File Extension',
  `image_size_x` smallint unsigned DEFAULT NULL COMMENT 'Image Size X',
  `image_size_y` smallint unsigned DEFAULT NULL COMMENT 'Image Size Y',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `CAT_PRD_OPT_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_option_price`
--

DROP TABLE IF EXISTS `catalog_product_option_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_price` (
  `option_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Price ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_price_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_PRICE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_OPT_PRICE_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_OPTION_PRICE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_option_title`
--

DROP TABLE IF EXISTS `catalog_product_option_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_title` (
  `option_title_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Title ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`option_title_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TITLE_OPTION_ID_STORE_ID` (`option_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `CAT_PRD_OPT_TTL_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_OPTION_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_option_type_price`
--

DROP TABLE IF EXISTS `catalog_product_option_type_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_type_price` (
  `option_type_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Price ID',
  `option_type_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Price',
  `price_type` varchar(7) NOT NULL DEFAULT 'fixed' COMMENT 'Price Type',
  PRIMARY KEY (`option_type_price_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_OPTION_TYPE_PRICE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_B523E3378E8602F376CC415825576B7F` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Type Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_option_type_title`
--

DROP TABLE IF EXISTS `catalog_product_option_type_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_type_title` (
  `option_type_title_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type Title ID',
  `option_type_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option Type ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`option_type_title_id`),
  UNIQUE KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_OPTION_TYPE_ID_STORE_ID` (`option_type_id`,`store_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_OPTION_TYPE_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_C085B9CF2C2A302E8043FDEA1937D6A2` FOREIGN KEY (`option_type_id`) REFERENCES `catalog_product_option_type_value` (`option_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Type Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_option_type_value`
--

DROP TABLE IF EXISTS `catalog_product_option_type_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_option_type_value` (
  `option_type_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Type ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_type_id`),
  KEY `CATALOG_PRODUCT_OPTION_TYPE_VALUE_OPTION_ID` (`option_id`),
  CONSTRAINT `CAT_PRD_OPT_TYPE_VAL_OPT_ID_CAT_PRD_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `catalog_product_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Option Type Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_relation`
--

DROP TABLE IF EXISTS `catalog_product_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_relation` (
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `child_id` int unsigned NOT NULL COMMENT 'Child ID',
  PRIMARY KEY (`parent_id`,`child_id`),
  KEY `CATALOG_PRODUCT_RELATION_CHILD_ID` (`child_id`),
  CONSTRAINT `CAT_PRD_RELATION_CHILD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`child_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_RELATION_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Relation Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_super_attribute`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_super_attribute` (
  `product_super_attribute_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product Super Attribute ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `position` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`product_super_attribute_id`),
  UNIQUE KEY `CATALOG_PRODUCT_SUPER_ATTRIBUTE_PRODUCT_ID_ATTRIBUTE_ID` (`product_id`,`attribute_id`),
  CONSTRAINT `CAT_PRD_SPR_ATTR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Super Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_super_attribute_label`
--

DROP TABLE IF EXISTS `catalog_product_super_attribute_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_super_attribute_label` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `product_super_attribute_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product Super Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `use_default` smallint unsigned DEFAULT '0' COMMENT 'Use Default Value',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_SPR_ATTR_LBL_PRD_SPR_ATTR_ID_STORE_ID` (`product_super_attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID` (`store_id`),
  CONSTRAINT `CATALOG_PRODUCT_SUPER_ATTRIBUTE_LABEL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_309442281DF7784210ED82B2CC51E5D5` FOREIGN KEY (`product_super_attribute_id`) REFERENCES `catalog_product_super_attribute` (`product_super_attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Super Attribute Label Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_super_link`
--

DROP TABLE IF EXISTS `catalog_product_super_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_super_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent ID',
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `CATALOG_PRODUCT_SUPER_LINK_PRODUCT_ID_PARENT_ID` (`product_id`,`parent_id`),
  KEY `CATALOG_PRODUCT_SUPER_LINK_PARENT_ID` (`parent_id`),
  CONSTRAINT `CAT_PRD_SPR_LNK_PARENT_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_PRD_SPR_LNK_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product Super Link Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_product_website`
--

DROP TABLE IF EXISTS `catalog_product_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_product_website` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CAT_PRD_WS_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOG_PRODUCT_WEBSITE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Product To Website Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalog_url_rewrite_product_category`
--

DROP TABLE IF EXISTS `catalog_url_rewrite_product_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalog_url_rewrite_product_category` (
  `url_rewrite_id` int unsigned NOT NULL COMMENT 'url_rewrite_id',
  `category_id` int unsigned NOT NULL COMMENT 'category_id',
  `product_id` int unsigned NOT NULL COMMENT 'product_id',
  PRIMARY KEY (`url_rewrite_id`),
  KEY `CAT_URL_REWRITE_PRD_CTGR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` (`product_id`),
  KEY `CATALOG_URL_REWRITE_PRODUCT_CATEGORY_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  CONSTRAINT `CAT_URL_REWRITE_PRD_CTGR_CTGR_ID_CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CAT_URL_REWRITE_PRD_CTGR_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_BB79E64705D7F17FE181F23144528FC8` FOREIGN KEY (`url_rewrite_id`) REFERENCES `url_rewrite` (`url_rewrite_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='url_rewrite_relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cataloginventory_stock`
--

DROP TABLE IF EXISTS `cataloginventory_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock` (
  `stock_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Stock ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_name` varchar(255) DEFAULT NULL COMMENT 'Stock Name',
  PRIMARY KEY (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cataloginventory_stock_item`
--

DROP TABLE IF EXISTS `cataloginventory_stock_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_item` (
  `item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `stock_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Stock ID',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `min_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Min Qty',
  `use_config_min_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Qty',
  `is_qty_decimal` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Qty Decimal',
  `backorders` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Backorders',
  `use_config_backorders` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Backorders',
  `min_sale_qty` decimal(12,4) NOT NULL DEFAULT '1.0000' COMMENT 'Min Sale Qty',
  `use_config_min_sale_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Min Sale Qty',
  `max_sale_qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Max Sale Qty',
  `use_config_max_sale_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Max Sale Qty',
  `is_in_stock` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is In Stock',
  `low_stock_date` timestamp NULL DEFAULT NULL COMMENT 'Low Stock Date',
  `notify_stock_qty` decimal(12,4) DEFAULT NULL COMMENT 'Notify Stock Qty',
  `use_config_notify_stock_qty` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Notify Stock Qty',
  `manage_stock` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Manage Stock',
  `use_config_manage_stock` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Manage Stock',
  `stock_status_changed_auto` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Stock Status Changed Automatically',
  `use_config_qty_increments` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Qty Increments',
  `qty_increments` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Increments',
  `use_config_enable_qty_inc` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Use Config Enable Qty Increments',
  `enable_qty_increments` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Enable Qty Increments',
  `is_decimal_divided` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Divided into Multiple Boxes for Shipping',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`item_id`),
  UNIQUE KEY `CATALOGINVENTORY_STOCK_ITEM_PRODUCT_ID_STOCK_ID` (`product_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_WEBSITE_ID_PRODUCT_ID` (`website_id`,`product_id`),
  KEY `CATALOGINVENTORY_STOCK_ITEM_STOCK_ID` (`stock_id`),
  CONSTRAINT `CATINV_STOCK_ITEM_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `CATINV_STOCK_ITEM_STOCK_ID_CATINV_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `cataloginventory_stock` (`stock_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=826 DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cataloginventory_stock_status`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_STATUS` (`stock_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cataloginventory_stock_status_idx`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_idx`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status_idx` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_IDX_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_IDX_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status Indexer Idx';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cataloginventory_stock_status_replica`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status_replica` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_WEBSITE_ID` (`website_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_STOCK_STATUS` (`stock_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cataloginventory_stock_status_tmp`
--

DROP TABLE IF EXISTS `cataloginventory_stock_status_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cataloginventory_stock_status_tmp` (
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint unsigned NOT NULL COMMENT 'Stock ID',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `stock_status` smallint unsigned NOT NULL COMMENT 'Stock Status',
  PRIMARY KEY (`product_id`,`website_id`,`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_TMP_STOCK_ID` (`stock_id`),
  KEY `CATALOGINVENTORY_STOCK_STATUS_TMP_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Cataloginventory Stock Status Indexer Tmp';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule`
--

DROP TABLE IF EXISTS `catalogrule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `from_date` date DEFAULT NULL COMMENT 'From',
  `to_date` date DEFAULT NULL COMMENT 'To',
  `is_active` smallint NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `conditions_serialized` mediumtext COMMENT 'Conditions Serialized',
  `actions_serialized` mediumtext COMMENT 'Actions Serialized',
  `stop_rules_processing` smallint NOT NULL DEFAULT '1' COMMENT 'Stop Rules Processing',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Discount Amount',
  PRIMARY KEY (`rule_id`),
  KEY `CATALOGRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE` (`is_active`,`sort_order`,`to_date`,`from_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_customer_group`
--

DROP TABLE IF EXISTS `catalogrule_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_customer_group` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`),
  KEY `CATALOGRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `CATALOGRULE_CUSTOMER_GROUP_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `CATRULE_CSTR_GROUP_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Rules To Customer Groups Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_group_website`
--

DROP TABLE IF EXISTS `catalogrule_group_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_group_website` (
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Group Website';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_group_website_replica`
--

DROP TABLE IF EXISTS `catalogrule_group_website_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_group_website_replica` (
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`,`website_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_GROUP_WEBSITE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Group Website';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_product`
--

DROP TABLE IF EXISTS `catalogrule_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product` (
  `rule_product_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product ID',
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `from_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'From Time',
  `to_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'To time',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `action_operator` varchar(10) DEFAULT 'to_fixed' COMMENT 'Action Operator',
  `action_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Action Amount',
  `action_stop` smallint NOT NULL DEFAULT '0' COMMENT 'Action Stop',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `UNQ_EAA51B56FF092A0DCB795D1CEF812B7B` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_FROM_TIME` (`from_time`),
  KEY `CATALOGRULE_PRODUCT_TO_TIME` (`to_time`),
  KEY `CATALOGRULE_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_product_price`
--

DROP TABLE IF EXISTS `catalogrule_product_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product_price` (
  `rule_product_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product PriceId',
  `rule_date` date NOT NULL COMMENT 'Rule Date',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `rule_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Rule Price',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `latest_start_date` date DEFAULT NULL COMMENT 'Latest StartDate',
  `earliest_end_date` date DEFAULT NULL COMMENT 'Earliest EndDate',
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_product_price_replica`
--

DROP TABLE IF EXISTS `catalogrule_product_price_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product_price_replica` (
  `rule_product_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product PriceId',
  `rule_date` date NOT NULL COMMENT 'Rule Date',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `rule_price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Rule Price',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `latest_start_date` date DEFAULT NULL COMMENT 'Latest StartDate',
  `earliest_end_date` date DEFAULT NULL COMMENT 'Earliest EndDate',
  PRIMARY KEY (`rule_product_price_id`),
  UNIQUE KEY `CATRULE_PRD_PRICE_RULE_DATE_WS_ID_CSTR_GROUP_ID_PRD_ID` (`rule_date`,`website_id`,`customer_group_id`,`product_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_PRICE_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_product_replica`
--

DROP TABLE IF EXISTS `catalogrule_product_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_product_replica` (
  `rule_product_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Product ID',
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `from_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'From Time',
  `to_time` int unsigned NOT NULL DEFAULT '0' COMMENT 'To time',
  `customer_group_id` int DEFAULT NULL,
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `action_operator` varchar(10) DEFAULT 'to_fixed' COMMENT 'Action Operator',
  `action_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Action Amount',
  `action_stop` smallint NOT NULL DEFAULT '0' COMMENT 'Action Stop',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_product_id`),
  UNIQUE KEY `UNQ_EAA51B56FF092A0DCB795D1CEF812B7B` (`rule_id`,`from_time`,`to_time`,`website_id`,`customer_group_id`,`product_id`,`sort_order`),
  KEY `CATALOGRULE_PRODUCT_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `CATALOGRULE_PRODUCT_WEBSITE_ID` (`website_id`),
  KEY `CATALOGRULE_PRODUCT_FROM_TIME` (`from_time`),
  KEY `CATALOGRULE_PRODUCT_TO_TIME` (`to_time`),
  KEY `CATALOGRULE_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CatalogRule Product';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogrule_website`
--

DROP TABLE IF EXISTS `catalogrule_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogrule_website` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`website_id`),
  KEY `CATALOGRULE_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CATALOGRULE_WEBSITE_RULE_ID_CATALOGRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `catalogrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOGRULE_WEBSITE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Catalog Rules To Websites Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `catalogsearch_recommendations`
--

DROP TABLE IF EXISTS `catalogsearch_recommendations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `catalogsearch_recommendations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `query_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Query ID',
  `relation_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Relation ID',
  PRIMARY KEY (`id`),
  KEY `CATALOGSEARCH_RECOMMENDATIONS_QUERY_ID_SEARCH_QUERY_QUERY_ID` (`query_id`),
  KEY `CATALOGSEARCH_RECOMMENDATIONS_RELATION_ID_SEARCH_QUERY_QUERY_ID` (`relation_id`),
  CONSTRAINT `CATALOGSEARCH_RECOMMENDATIONS_QUERY_ID_SEARCH_QUERY_QUERY_ID` FOREIGN KEY (`query_id`) REFERENCES `search_query` (`query_id`) ON DELETE CASCADE,
  CONSTRAINT `CATALOGSEARCH_RECOMMENDATIONS_RELATION_ID_SEARCH_QUERY_QUERY_ID` FOREIGN KEY (`relation_id`) REFERENCES `search_query` (`query_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Advanced Search Recommendations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checkout_agreement`
--

DROP TABLE IF EXISTS `checkout_agreement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_agreement` (
  `agreement_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Agreement ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `content` text COMMENT 'Content',
  `content_height` varchar(25) DEFAULT NULL COMMENT 'Content Height',
  `checkbox_text` text COMMENT 'Checkbox Text',
  `is_active` smallint NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `is_html` smallint NOT NULL DEFAULT '0' COMMENT 'Is Html',
  `mode` smallint NOT NULL DEFAULT '0' COMMENT 'Applied mode',
  PRIMARY KEY (`agreement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Checkout Agreement';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `checkout_agreement_store`
--

DROP TABLE IF EXISTS `checkout_agreement_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_agreement_store` (
  `agreement_id` int unsigned NOT NULL COMMENT 'Agreement ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`agreement_id`,`store_id`),
  KEY `CHECKOUT_AGREEMENT_STORE_STORE_ID_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CHECKOUT_AGREEMENT_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `CHKT_AGRT_STORE_AGRT_ID_CHKT_AGRT_AGRT_ID` FOREIGN KEY (`agreement_id`) REFERENCES `checkout_agreement` (`agreement_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Checkout Agreement Store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cms_block`
--

DROP TABLE IF EXISTS `cms_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_block` (
  `block_id` smallint NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `title` varchar(255) NOT NULL COMMENT 'Block Title',
  `identifier` varchar(255) NOT NULL COMMENT 'Block String Identifier',
  `content` mediumtext COMMENT 'Block Content',
  `creation_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Block Creation Time',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Block Modification Time',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'Is Block Active',
  PRIMARY KEY (`block_id`),
  KEY `CMS_BLOCK_IDENTIFIER` (`identifier`),
  FULLTEXT KEY `CMS_BLOCK_TITLE_IDENTIFIER_CONTENT` (`title`,`identifier`,`content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CMS Block Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cms_block_store`
--

DROP TABLE IF EXISTS `cms_block_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_block_store` (
  `block_id` smallint NOT NULL,
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`block_id`,`store_id`),
  KEY `CMS_BLOCK_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CMS_BLOCK_STORE_BLOCK_ID_CMS_BLOCK_BLOCK_ID` FOREIGN KEY (`block_id`) REFERENCES `cms_block` (`block_id`) ON DELETE CASCADE,
  CONSTRAINT `CMS_BLOCK_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CMS Block To Store Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cms_page`
--

DROP TABLE IF EXISTS `cms_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_page` (
  `page_id` smallint NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Page Title',
  `page_layout` varchar(255) DEFAULT NULL COMMENT 'Page Layout',
  `meta_keywords` text COMMENT 'Page Meta Keywords',
  `meta_description` text COMMENT 'Page Meta Description',
  `identifier` varchar(100) DEFAULT NULL COMMENT 'Page String Identifier',
  `content_heading` varchar(255) DEFAULT NULL COMMENT 'Page Content Heading',
  `content` mediumtext COMMENT 'Page Content',
  `creation_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Page Creation Time',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Page Modification Time',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'Is Page Active',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Page Sort Order',
  `layout_update_xml` text COMMENT 'Page Layout Update Content',
  `custom_theme` varchar(100) DEFAULT NULL COMMENT 'Page Custom Theme',
  `custom_root_template` varchar(255) DEFAULT NULL COMMENT 'Page Custom Template',
  `custom_layout_update_xml` text COMMENT 'Page Custom Layout Update Content',
  `layout_update_selected` varchar(128) DEFAULT NULL COMMENT 'Page Custom Layout File',
  `custom_theme_from` date DEFAULT NULL COMMENT 'Page Custom Theme Active From Date',
  `custom_theme_to` date DEFAULT NULL COMMENT 'Page Custom Theme Active To Date',
  `meta_title` varchar(255) DEFAULT NULL COMMENT 'Page Meta Title',
  PRIMARY KEY (`page_id`),
  KEY `CMS_PAGE_IDENTIFIER` (`identifier`),
  FULLTEXT KEY `CMS_PAGE_TITLE_META_KEYWORDS_META_DESCRIPTION_IDENTIFIER_CONTENT` (`title`,`meta_keywords`,`meta_description`,`identifier`,`content`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='CMS Page Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cms_page_store`
--

DROP TABLE IF EXISTS `cms_page_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_page_store` (
  `page_id` smallint NOT NULL COMMENT 'Entity ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`page_id`,`store_id`),
  KEY `CMS_PAGE_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `CMS_PAGE_STORE_PAGE_ID_CMS_PAGE_PAGE_ID` FOREIGN KEY (`page_id`) REFERENCES `cms_page` (`page_id`) ON DELETE CASCADE,
  CONSTRAINT `CMS_PAGE_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='CMS Page To Store Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `core_config_data`
--

DROP TABLE IF EXISTS `core_config_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `core_config_data` (
  `config_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Config ID',
  `scope` varchar(8) NOT NULL DEFAULT 'default' COMMENT 'Config Scope',
  `scope_id` int NOT NULL DEFAULT '0' COMMENT 'Config Scope ID',
  `path` varchar(255) NOT NULL DEFAULT 'general' COMMENT 'Config Path',
  `value` text COMMENT 'Config Value',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `CORE_CONFIG_DATA_SCOPE_SCOPE_ID_PATH` (`scope`,`scope_id`,`path`)
) ENGINE=InnoDB AUTO_INCREMENT=1954 DEFAULT CHARSET=utf8mb3 COMMENT='Config Data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cron_schedule`
--

DROP TABLE IF EXISTS `cron_schedule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cron_schedule` (
  `schedule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Schedule ID',
  `job_code` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Job Code',
  `status` varchar(7) NOT NULL DEFAULT 'pending' COMMENT 'Status',
  `messages` text COMMENT 'Messages',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `scheduled_at` timestamp NULL DEFAULT NULL COMMENT 'Scheduled At',
  `executed_at` timestamp NULL DEFAULT NULL COMMENT 'Executed At',
  `finished_at` timestamp NULL DEFAULT NULL COMMENT 'Finished At',
  PRIMARY KEY (`schedule_id`),
  KEY `CRON_SCHEDULE_JOB_CODE_STATUS_SCHEDULED_AT` (`job_code`,`status`,`scheduled_at`)
) ENGINE=InnoDB AUTO_INCREMENT=12771199 DEFAULT CHARSET=utf8mb3 COMMENT='Cron Schedule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_address_entity`
--

DROP TABLE IF EXISTS `customer_address_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_address_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `parent_id` int unsigned DEFAULT NULL COMMENT 'Parent ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `is_active` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Active',
  `city` varchar(255) NOT NULL COMMENT 'City',
  `company` varchar(255) DEFAULT NULL COMMENT 'Company',
  `country_id` varchar(255) NOT NULL COMMENT 'Country',
  `fax` varchar(255) DEFAULT NULL COMMENT 'Fax',
  `firstname` varchar(255) NOT NULL COMMENT 'First Name',
  `lastname` varchar(255) NOT NULL COMMENT 'Last Name',
  `middlename` varchar(255) DEFAULT NULL COMMENT 'Middle Name',
  `postcode` varchar(255) DEFAULT NULL COMMENT 'Zip/Postal Code',
  `prefix` varchar(40) DEFAULT NULL COMMENT 'Name Prefix',
  `region` varchar(255) DEFAULT NULL COMMENT 'State/Province',
  `region_id` int unsigned DEFAULT NULL COMMENT 'State/Province',
  `street` text NOT NULL COMMENT 'Street Address',
  `suffix` varchar(40) DEFAULT NULL COMMENT 'Name Suffix',
  `telephone` varchar(255) NOT NULL COMMENT 'Phone Number',
  `vat_id` varchar(255) DEFAULT NULL COMMENT 'VAT number',
  `vat_is_valid` int unsigned DEFAULT NULL COMMENT 'VAT number validity',
  `vat_request_date` varchar(255) DEFAULT NULL COMMENT 'VAT number validation request date',
  `vat_request_id` varchar(255) DEFAULT NULL COMMENT 'VAT number validation request ID',
  `vat_request_success` int unsigned DEFAULT NULL COMMENT 'VAT number validation request success',
  PRIMARY KEY (`entity_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_PARENT_ID` (`parent_id`),
  CONSTRAINT `CUSTOMER_ADDRESS_ENTITY_PARENT_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Address Entity';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_address_entity_datetime`
--

DROP TABLE IF EXISTS `customer_address_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_address_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ADDRESS_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CSTR_ADDR_ENTT_DTIME_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CSTR_ADDR_ENTT_DTIME_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_address_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Address Entity Datetime';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_address_entity_decimal`
--

DROP TABLE IF EXISTS `customer_address_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_address_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ADDRESS_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CSTR_ADDR_ENTT_DEC_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CSTR_ADDR_ENTT_DEC_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_address_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Address Entity Decimal';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_address_entity_int`
--

DROP TABLE IF EXISTS `customer_address_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_address_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int NOT NULL DEFAULT '0' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ADDRESS_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CSTR_ADDR_ENTT_INT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CSTR_ADDR_ENTT_INT_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_address_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Address Entity Int';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_address_entity_text`
--

DROP TABLE IF EXISTS `customer_address_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_address_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text NOT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ADDRESS_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CSTR_ADDR_ENTT_TEXT_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CSTR_ADDR_ENTT_TEXT_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_address_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Address Entity Text';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_address_entity_varchar`
--

DROP TABLE IF EXISTS `customer_address_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_address_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ADDRESS_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ADDRESS_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CSTR_ADDR_ENTT_VCHR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CSTR_ADDR_ENTT_VCHR_ENTT_ID_CSTR_ADDR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_address_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Address Entity Varchar';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_eav_attribute`
--

DROP TABLE IF EXISTS `customer_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_eav_attribute` (
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `is_visible` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `input_filter` varchar(255) DEFAULT NULL COMMENT 'Input Filter',
  `multiline_count` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Multiline Count',
  `validate_rules` text COMMENT 'Validate Rules',
  `is_system` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is System',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `data_model` varchar(255) DEFAULT NULL COMMENT 'Data Model',
  `is_used_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `is_searchable_in_grid` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable in Grid',
  `grid_filter_condition_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Grid Filter Condition Type',
  PRIMARY KEY (`attribute_id`),
  KEY `CUSTOMER_EAV_ATTRIBUTE_SORT_ORDER` (`sort_order`),
  CONSTRAINT `CUSTOMER_EAV_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Eav Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_eav_attribute_website`
--

DROP TABLE IF EXISTS `customer_eav_attribute_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_eav_attribute_website` (
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `is_visible` smallint unsigned DEFAULT NULL COMMENT 'Is Visible',
  `is_required` smallint unsigned DEFAULT NULL COMMENT 'Is Required',
  `default_value` text COMMENT 'Default Value',
  `multiline_count` smallint unsigned DEFAULT NULL COMMENT 'Multiline Count',
  PRIMARY KEY (`attribute_id`,`website_id`),
  KEY `CUSTOMER_EAV_ATTRIBUTE_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `CSTR_EAV_ATTR_WS_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CSTR_EAV_ATTR_WS_WS_ID_STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Eav Attribute Website';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_entity`
--

DROP TABLE IF EXISTS `customer_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `website_id` smallint unsigned DEFAULT NULL COMMENT 'Website ID',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `group_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Group ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `store_id` smallint unsigned DEFAULT '0' COMMENT 'Store ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_active` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Active',
  `disable_auto_group_change` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Disable automatic group change based on VAT ID',
  `created_in` varchar(255) DEFAULT NULL COMMENT 'Created From',
  `prefix` varchar(40) DEFAULT NULL COMMENT 'Name Prefix',
  `firstname` varchar(255) DEFAULT NULL COMMENT 'First Name',
  `middlename` varchar(255) DEFAULT NULL COMMENT 'Middle Name/Initial',
  `lastname` varchar(255) DEFAULT NULL COMMENT 'Last Name',
  `suffix` varchar(40) DEFAULT NULL COMMENT 'Name Suffix',
  `dob` date DEFAULT NULL COMMENT 'Date of Birth',
  `password_hash` varchar(128) DEFAULT NULL COMMENT 'Password_hash',
  `rp_token` varchar(128) DEFAULT NULL COMMENT 'Reset password token',
  `rp_token_created_at` datetime DEFAULT NULL COMMENT 'Reset password token creation time',
  `default_billing` int unsigned DEFAULT NULL COMMENT 'Default Billing Address',
  `default_shipping` int unsigned DEFAULT NULL COMMENT 'Default Shipping Address',
  `taxvat` varchar(50) DEFAULT NULL COMMENT 'Tax/VAT Number',
  `confirmation` varchar(64) DEFAULT NULL COMMENT 'Is Confirmed',
  `gender` smallint unsigned DEFAULT NULL COMMENT 'Gender',
  `failures_num` smallint DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Lock Expiration Date',
  `session_cutoff` timestamp NULL DEFAULT NULL COMMENT 'Session Cutoff Time',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `CUSTOMER_ENTITY_EMAIL_WEBSITE_ID` (`email`,`website_id`),
  KEY `CUSTOMER_ENTITY_STORE_ID` (`store_id`),
  KEY `CUSTOMER_ENTITY_WEBSITE_ID` (`website_id`),
  KEY `CUSTOMER_ENTITY_FIRSTNAME` (`firstname`),
  KEY `CUSTOMER_ENTITY_LASTNAME` (`lastname`),
  CONSTRAINT `CUSTOMER_ENTITY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL,
  CONSTRAINT `CUSTOMER_ENTITY_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Entity';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_entity_datetime`
--

DROP TABLE IF EXISTS `customer_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CUSTOMER_ENTITY_DATETIME_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CUSTOMER_ENTITY_DATETIME_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Entity Datetime';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_entity_decimal`
--

DROP TABLE IF EXISTS `customer_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CUSTOMER_ENTITY_DECIMAL_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CUSTOMER_ENTITY_DECIMAL_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Entity Decimal';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_entity_int`
--

DROP TABLE IF EXISTS `customer_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int NOT NULL DEFAULT '0' COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CUSTOMER_ENTITY_INT_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CUSTOMER_ENTITY_INT_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Entity Int';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_entity_text`
--

DROP TABLE IF EXISTS `customer_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text NOT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CUSTOMER_ENTITY_TEXT_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CUSTOMER_ENTITY_TEXT_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Entity Text';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_entity_varchar`
--

DROP TABLE IF EXISTS `customer_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CUSTOMER_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID` (`entity_id`,`attribute_id`),
  KEY `CUSTOMER_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CUSTOMER_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_VALUE` (`entity_id`,`attribute_id`,`value`),
  CONSTRAINT `CUSTOMER_ENTITY_VARCHAR_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `CUSTOMER_ENTITY_VARCHAR_ENTITY_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Entity Varchar';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_form_attribute`
--

DROP TABLE IF EXISTS `customer_form_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_form_attribute` (
  `form_code` varchar(32) NOT NULL COMMENT 'Form Code',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  PRIMARY KEY (`form_code`,`attribute_id`),
  KEY `CUSTOMER_FORM_ATTRIBUTE_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `CUSTOMER_FORM_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Customer Form Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_grid_flat`
--

DROP TABLE IF EXISTS `customer_grid_flat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_grid_flat` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `name` text COMMENT 'Name',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `group_id` int DEFAULT NULL COMMENT 'Group_id',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created_at',
  `website_id` int DEFAULT NULL COMMENT 'Website_id',
  `confirmation` varchar(255) DEFAULT NULL COMMENT 'Confirmation',
  `created_in` text COMMENT 'Created_in',
  `dob` date DEFAULT NULL COMMENT 'Dob',
  `gender` int DEFAULT NULL COMMENT 'Gender',
  `taxvat` varchar(255) DEFAULT NULL COMMENT 'Taxvat',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Lock_expires',
  `tj_exemption_type` varchar(255) DEFAULT NULL COMMENT 'Tj_exemption_type',
  `shipping_full` text COMMENT 'Shipping_full',
  `billing_full` text COMMENT 'Billing_full',
  `billing_firstname` varchar(255) DEFAULT NULL COMMENT 'Billing_firstname',
  `billing_lastname` varchar(255) DEFAULT NULL COMMENT 'Billing_lastname',
  `billing_telephone` varchar(255) DEFAULT NULL COMMENT 'Billing_telephone',
  `billing_postcode` varchar(255) DEFAULT NULL COMMENT 'Billing_postcode',
  `billing_country_id` varchar(255) DEFAULT NULL COMMENT 'Billing_country_id',
  `billing_region` varchar(255) DEFAULT NULL COMMENT 'Billing_region',
  `billing_region_id` int DEFAULT NULL COMMENT 'Billing_region_id',
  `billing_street` varchar(255) DEFAULT NULL COMMENT 'Billing_street',
  `billing_city` varchar(255) DEFAULT NULL COMMENT 'Billing_city',
  `billing_fax` varchar(255) DEFAULT NULL COMMENT 'Billing_fax',
  `billing_vat_id` varchar(255) DEFAULT NULL COMMENT 'Billing_vat_id',
  `billing_company` varchar(255) DEFAULT NULL COMMENT 'Billing_company',
  PRIMARY KEY (`entity_id`),
  KEY `CUSTOMER_GRID_FLAT_GROUP_ID` (`group_id`),
  KEY `CUSTOMER_GRID_FLAT_CREATED_AT` (`created_at`),
  KEY `CUSTOMER_GRID_FLAT_WEBSITE_ID` (`website_id`),
  KEY `CUSTOMER_GRID_FLAT_CONFIRMATION` (`confirmation`),
  KEY `CUSTOMER_GRID_FLAT_DOB` (`dob`),
  KEY `CUSTOMER_GRID_FLAT_GENDER` (`gender`),
  KEY `CUSTOMER_GRID_FLAT_TJ_EXEMPTION_TYPE` (`tj_exemption_type`),
  KEY `CUSTOMER_GRID_FLAT_BILLING_COUNTRY_ID` (`billing_country_id`),
  FULLTEXT KEY `FTI_8746F705702DD5F6D45B8C7CE7FE9F2F` (`name`,`email`,`created_in`,`taxvat`,`shipping_full`,`billing_full`,`billing_firstname`,`billing_lastname`,`billing_telephone`,`billing_postcode`,`billing_region`,`billing_city`,`billing_fax`,`billing_company`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='customer_grid_flat';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_group`
--

DROP TABLE IF EXISTS `customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_group` (
  `customer_group_id` int unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_code` varchar(32) NOT NULL COMMENT 'Customer Group Code',
  `tax_class_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Tax Class ID',
  PRIMARY KEY (`customer_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='Customer Group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_group_excluded_website`
--

DROP TABLE IF EXISTS `customer_group_excluded_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_group_excluded_website` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Excluded Website ID from Customer Group',
  PRIMARY KEY (`entity_id`),
  KEY `CUSTOMER_GROUP_EXCLUDED_WEBSITE_CUSTOMER_GROUP_ID_WEBSITE_ID` (`customer_group_id`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Excluded Websites From Customer Group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_log`
--

DROP TABLE IF EXISTS `customer_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_log` (
  `log_id` int NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `customer_id` int NOT NULL COMMENT 'Customer ID',
  `last_login_at` timestamp NULL DEFAULT NULL COMMENT 'Last Login Time',
  `last_logout_at` timestamp NULL DEFAULT NULL COMMENT 'Last Logout Time',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `CUSTOMER_LOG_CUSTOMER_ID` (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34025 DEFAULT CHARSET=utf8mb3 COMMENT='Customer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `customer_visitor`
--

DROP TABLE IF EXISTS `customer_visitor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_visitor` (
  `visitor_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Visitor ID',
  `customer_id` int DEFAULT NULL COMMENT 'Customer ID',
  `session_id` varchar(1) DEFAULT NULL COMMENT 'Deprecated: Session ID value no longer used',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `last_visit_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last Visit Time',
  PRIMARY KEY (`visitor_id`),
  KEY `CUSTOMER_VISITOR_CUSTOMER_ID` (`customer_id`),
  KEY `CUSTOMER_VISITOR_LAST_VISIT_AT` (`last_visit_at`)
) ENGINE=InnoDB AUTO_INCREMENT=17781 DEFAULT CHARSET=utf8mb3 COMMENT='Visitor Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `data_exporter_uuid`
--

DROP TABLE IF EXISTS `data_exporter_uuid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `data_exporter_uuid` (
  `uuid` varchar(36) NOT NULL COMMENT 'Entity UUID',
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `type` varchar(36) NOT NULL COMMENT 'Entity type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`uuid`),
  UNIQUE KEY `DATA_EXPORTER_UUID_ENTITY_ID_TYPE` (`entity_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Data Export Items UUID References Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `design_change`
--

DROP TABLE IF EXISTS `design_change`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `design_change` (
  `design_change_id` int NOT NULL AUTO_INCREMENT COMMENT 'Design Change ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `design` varchar(255) DEFAULT NULL COMMENT 'Design',
  `date_from` date DEFAULT NULL COMMENT 'First Date of Design Activity',
  `date_to` date DEFAULT NULL COMMENT 'Last Date of Design Activity',
  PRIMARY KEY (`design_change_id`),
  KEY `DESIGN_CHANGE_STORE_ID` (`store_id`),
  CONSTRAINT `DESIGN_CHANGE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Design Changes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `design_config_grid_flat`
--

DROP TABLE IF EXISTS `design_config_grid_flat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `design_config_grid_flat` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `store_website_id` int DEFAULT NULL COMMENT 'Store_website_id',
  `store_group_id` int DEFAULT NULL COMMENT 'Store_group_id',
  `store_id` int DEFAULT NULL COMMENT 'Store_id',
  `theme_theme_id` varchar(255) DEFAULT NULL COMMENT 'Theme_theme_id',
  PRIMARY KEY (`entity_id`),
  KEY `DESIGN_CONFIG_GRID_FLAT_STORE_WEBSITE_ID` (`store_website_id`),
  KEY `DESIGN_CONFIG_GRID_FLAT_STORE_GROUP_ID` (`store_group_id`),
  KEY `DESIGN_CONFIG_GRID_FLAT_STORE_ID` (`store_id`),
  FULLTEXT KEY `DESIGN_CONFIG_GRID_FLAT_THEME_THEME_ID` (`theme_theme_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='design_config_grid_flat';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `directory_country`
--

DROP TABLE IF EXISTS `directory_country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `directory_country` (
  `country_id` varchar(2) NOT NULL COMMENT 'Country ID in ISO-2',
  `iso2_code` varchar(2) DEFAULT NULL COMMENT 'Country ISO-2 format',
  `iso3_code` varchar(3) DEFAULT NULL COMMENT 'Country ISO-3',
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Directory Country';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `directory_country_format`
--

DROP TABLE IF EXISTS `directory_country_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `directory_country_format` (
  `country_format_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Country Format ID',
  `country_id` varchar(2) DEFAULT NULL COMMENT 'Country ID in ISO-2',
  `type` varchar(30) DEFAULT NULL COMMENT 'Country Format Type',
  `format` text NOT NULL COMMENT 'Country Format',
  PRIMARY KEY (`country_format_id`),
  UNIQUE KEY `DIRECTORY_COUNTRY_FORMAT_COUNTRY_ID_TYPE` (`country_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Directory Country Format';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `directory_country_region`
--

DROP TABLE IF EXISTS `directory_country_region`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `directory_country_region` (
  `region_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Region ID',
  `country_id` varchar(4) NOT NULL DEFAULT '0' COMMENT 'Country ID in ISO-2',
  `code` varchar(32) DEFAULT NULL COMMENT 'Region code',
  `default_name` varchar(255) DEFAULT NULL COMMENT 'Region Name',
  PRIMARY KEY (`region_id`),
  KEY `DIRECTORY_COUNTRY_REGION_COUNTRY_ID` (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1157 DEFAULT CHARSET=utf8mb3 COMMENT='Directory Country Region';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `directory_country_region_name`
--

DROP TABLE IF EXISTS `directory_country_region_name`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `directory_country_region_name` (
  `locale` varchar(16) NOT NULL COMMENT 'Locale',
  `region_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Region ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Region Name',
  PRIMARY KEY (`locale`,`region_id`),
  KEY `DIRECTORY_COUNTRY_REGION_NAME_REGION_ID` (`region_id`),
  CONSTRAINT `DIR_COUNTRY_REGION_NAME_REGION_ID_DIR_COUNTRY_REGION_REGION_ID` FOREIGN KEY (`region_id`) REFERENCES `directory_country_region` (`region_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Directory Country Region Name';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `directory_currency_rate`
--

DROP TABLE IF EXISTS `directory_currency_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `directory_currency_rate` (
  `currency_from` varchar(3) NOT NULL COMMENT 'Currency Code Convert From',
  `currency_to` varchar(3) NOT NULL COMMENT 'Currency Code Convert To',
  `rate` decimal(24,12) NOT NULL DEFAULT '0.000000000000' COMMENT 'Currency Conversion Rate',
  PRIMARY KEY (`currency_from`,`currency_to`),
  KEY `DIRECTORY_CURRENCY_RATE_CURRENCY_TO` (`currency_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Directory Currency Rate';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_link`
--

DROP TABLE IF EXISTS `downloadable_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort order',
  `number_of_downloads` int DEFAULT NULL COMMENT 'Number of downloads',
  `is_shareable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Shareable flag',
  `link_url` varchar(255) DEFAULT NULL COMMENT 'Link Url',
  `link_file` varchar(255) DEFAULT NULL COMMENT 'Link File',
  `link_type` varchar(20) DEFAULT NULL COMMENT 'Link Type',
  `sample_url` varchar(255) DEFAULT NULL COMMENT 'Sample Url',
  `sample_file` varchar(255) DEFAULT NULL COMMENT 'Sample File',
  `sample_type` varchar(20) DEFAULT NULL COMMENT 'Sample Type',
  PRIMARY KEY (`link_id`),
  KEY `DOWNLOADABLE_LINK_PRODUCT_ID_SORT_ORDER` (`product_id`,`sort_order`),
  CONSTRAINT `DOWNLOADABLE_LINK_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Downloadable Link Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_link_price`
--

DROP TABLE IF EXISTS `downloadable_link_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_link_price` (
  `price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Price ID',
  `link_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Link ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Price',
  PRIMARY KEY (`price_id`),
  KEY `DOWNLOADABLE_LINK_PRICE_LINK_ID` (`link_id`),
  KEY `DOWNLOADABLE_LINK_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `DOWNLOADABLE_LINK_PRICE_LINK_ID_DOWNLOADABLE_LINK_LINK_ID` FOREIGN KEY (`link_id`) REFERENCES `downloadable_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `DOWNLOADABLE_LINK_PRICE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Downloadable Link Price Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_link_purchased`
--

DROP TABLE IF EXISTS `downloadable_link_purchased`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_link_purchased` (
  `purchased_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Purchased ID',
  `order_id` int unsigned DEFAULT '0' COMMENT 'Order ID',
  `order_increment_id` varchar(50) DEFAULT NULL COMMENT 'Order Increment ID',
  `order_item_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Order Item ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Date of creation',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of modification',
  `customer_id` int unsigned DEFAULT '0' COMMENT 'Customer ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product name',
  `product_sku` varchar(255) DEFAULT NULL COMMENT 'Product sku',
  `link_section_title` varchar(255) DEFAULT NULL COMMENT 'Link_section_title',
  PRIMARY KEY (`purchased_id`),
  KEY `DOWNLOADABLE_LINK_PURCHASED_ORDER_ID` (`order_id`),
  KEY `DOWNLOADABLE_LINK_PURCHASED_ORDER_ITEM_ID` (`order_item_id`),
  KEY `DOWNLOADABLE_LINK_PURCHASED_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `DL_LNK_PURCHASED_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE SET NULL,
  CONSTRAINT `DOWNLOADABLE_LINK_PURCHASED_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Downloadable Link Purchased Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_link_purchased_item`
--

DROP TABLE IF EXISTS `downloadable_link_purchased_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_link_purchased_item` (
  `item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item ID',
  `purchased_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Purchased ID',
  `order_item_id` int unsigned DEFAULT '0' COMMENT 'Order Item ID',
  `product_id` int unsigned DEFAULT '0' COMMENT 'Product ID',
  `link_hash` varchar(255) DEFAULT NULL COMMENT 'Link hash',
  `number_of_downloads_bought` int unsigned NOT NULL DEFAULT '0' COMMENT 'Number of downloads bought',
  `number_of_downloads_used` int unsigned NOT NULL DEFAULT '0' COMMENT 'Number of downloads used',
  `link_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Link ID',
  `link_title` varchar(255) DEFAULT NULL COMMENT 'Link Title',
  `is_shareable` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Shareable Flag',
  `link_url` varchar(255) DEFAULT NULL COMMENT 'Link Url',
  `link_file` varchar(255) DEFAULT NULL COMMENT 'Link File',
  `link_type` varchar(255) DEFAULT NULL COMMENT 'Link Type',
  `status` varchar(50) DEFAULT NULL COMMENT 'Status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`item_id`),
  KEY `DOWNLOADABLE_LINK_PURCHASED_ITEM_LINK_HASH` (`link_hash`),
  KEY `DOWNLOADABLE_LINK_PURCHASED_ITEM_ORDER_ITEM_ID` (`order_item_id`),
  KEY `DOWNLOADABLE_LINK_PURCHASED_ITEM_PURCHASED_ID` (`purchased_id`),
  CONSTRAINT `DL_LNK_PURCHASED_ITEM_ORDER_ITEM_ID_SALES_ORDER_ITEM_ITEM_ID` FOREIGN KEY (`order_item_id`) REFERENCES `sales_order_item` (`item_id`) ON DELETE SET NULL,
  CONSTRAINT `DL_LNK_PURCHASED_ITEM_PURCHASED_ID_DL_LNK_PURCHASED_PURCHASED_ID` FOREIGN KEY (`purchased_id`) REFERENCES `downloadable_link_purchased` (`purchased_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Downloadable Link Purchased Item Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_link_title`
--

DROP TABLE IF EXISTS `downloadable_link_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_link_title` (
  `title_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Title ID',
  `link_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Link ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`title_id`),
  UNIQUE KEY `DOWNLOADABLE_LINK_TITLE_LINK_ID_STORE_ID` (`link_id`,`store_id`),
  KEY `DOWNLOADABLE_LINK_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `DOWNLOADABLE_LINK_TITLE_LINK_ID_DOWNLOADABLE_LINK_LINK_ID` FOREIGN KEY (`link_id`) REFERENCES `downloadable_link` (`link_id`) ON DELETE CASCADE,
  CONSTRAINT `DOWNLOADABLE_LINK_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Link Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_sample`
--

DROP TABLE IF EXISTS `downloadable_sample`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_sample` (
  `sample_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sample ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `sample_url` varchar(255) DEFAULT NULL COMMENT 'Sample URL',
  `sample_file` varchar(255) DEFAULT NULL COMMENT 'Sample file',
  `sample_type` varchar(20) DEFAULT NULL COMMENT 'Sample Type',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`sample_id`),
  KEY `DOWNLOADABLE_SAMPLE_PRODUCT_ID` (`product_id`),
  CONSTRAINT `DOWNLOADABLE_SAMPLE_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Downloadable Sample Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `downloadable_sample_title`
--

DROP TABLE IF EXISTS `downloadable_sample_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `downloadable_sample_title` (
  `title_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Title ID',
  `sample_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sample ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`title_id`),
  UNIQUE KEY `DOWNLOADABLE_SAMPLE_TITLE_SAMPLE_ID_STORE_ID` (`sample_id`,`store_id`),
  KEY `DOWNLOADABLE_SAMPLE_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `DL_SAMPLE_TTL_SAMPLE_ID_DL_SAMPLE_SAMPLE_ID` FOREIGN KEY (`sample_id`) REFERENCES `downloadable_sample` (`sample_id`) ON DELETE CASCADE,
  CONSTRAINT `DOWNLOADABLE_SAMPLE_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Downloadable Sample Title Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute`
--

DROP TABLE IF EXISTS `eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute` (
  `attribute_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_code` varchar(255) NOT NULL COMMENT 'Attribute Code',
  `attribute_model` varchar(255) DEFAULT NULL COMMENT 'Attribute Model',
  `backend_model` varchar(255) DEFAULT NULL COMMENT 'Backend Model',
  `backend_type` varchar(8) NOT NULL DEFAULT 'static' COMMENT 'Backend Type',
  `backend_table` varchar(255) DEFAULT NULL COMMENT 'Backend Table',
  `frontend_model` varchar(255) DEFAULT NULL COMMENT 'Frontend Model',
  `frontend_input` varchar(50) DEFAULT NULL COMMENT 'Frontend Input',
  `frontend_label` varchar(255) DEFAULT NULL COMMENT 'Frontend Label',
  `frontend_class` varchar(255) DEFAULT NULL COMMENT 'Frontend Class',
  `source_model` varchar(255) DEFAULT NULL COMMENT 'Source Model',
  `is_required` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Defines Is Required',
  `is_user_defined` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Defines Is User Defined',
  `default_value` text COMMENT 'Default Value',
  `is_unique` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Defines Is Unique',
  `note` varchar(255) DEFAULT NULL COMMENT 'Note',
  PRIMARY KEY (`attribute_id`),
  UNIQUE KEY `EAV_ATTRIBUTE_ENTITY_TYPE_ID_ATTRIBUTE_CODE` (`entity_type_id`,`attribute_code`),
  KEY `EAV_ATTRIBUTE_FRONTEND_INPUT_ENTITY_TYPE_ID_IS_USER_DEFINED` (`frontend_input`,`entity_type_id`,`is_user_defined`),
  CONSTRAINT `EAV_ATTRIBUTE_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=392 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute_group`
--

DROP TABLE IF EXISTS `eav_attribute_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute_group` (
  `attribute_group_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute Group ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `attribute_group_name` varchar(255) DEFAULT NULL COMMENT 'Attribute Group Name',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `default_id` smallint unsigned DEFAULT '0' COMMENT 'Default ID',
  `attribute_group_code` varchar(255) NOT NULL COMMENT 'Attribute Group Code',
  `tab_group_code` varchar(255) DEFAULT NULL COMMENT 'Tab Group Code',
  PRIMARY KEY (`attribute_group_id`),
  UNIQUE KEY `EAV_ATTRIBUTE_GROUP_ATTRIBUTE_SET_ID_ATTRIBUTE_GROUP_CODE` (`attribute_set_id`,`attribute_group_code`),
  UNIQUE KEY `EAV_ATTRIBUTE_GROUP_ATTRIBUTE_SET_ID_ATTRIBUTE_GROUP_NAME` (`attribute_set_id`,`attribute_group_name`),
  KEY `EAV_ATTRIBUTE_GROUP_ATTRIBUTE_SET_ID_SORT_ORDER` (`attribute_set_id`,`sort_order`),
  CONSTRAINT `EAV_ATTR_GROUP_ATTR_SET_ID_EAV_ATTR_SET_ATTR_SET_ID` FOREIGN KEY (`attribute_set_id`) REFERENCES `eav_attribute_set` (`attribute_set_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=337 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Attribute Group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute_label`
--

DROP TABLE IF EXISTS `eav_attribute_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute_label` (
  `attribute_label_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute Label ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`attribute_label_id`),
  KEY `EAV_ATTRIBUTE_LABEL_STORE_ID` (`store_id`),
  KEY `EAV_ATTRIBUTE_LABEL_ATTRIBUTE_ID_STORE_ID` (`attribute_id`,`store_id`),
  CONSTRAINT `EAV_ATTRIBUTE_LABEL_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ATTRIBUTE_LABEL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Attribute Label';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute_option`
--

DROP TABLE IF EXISTS `eav_attribute_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`option_id`),
  KEY `EAV_ATTRIBUTE_OPTION_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `EAV_ATTRIBUTE_OPTION_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Attribute Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute_option_swatch`
--

DROP TABLE IF EXISTS `eav_attribute_option_swatch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute_option_swatch` (
  `swatch_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Swatch ID',
  `option_id` int unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `type` smallint unsigned NOT NULL COMMENT 'Swatch type: 0 - text, 1 - visual color, 2 - visual image',
  `value` varchar(255) DEFAULT NULL COMMENT 'Swatch Value',
  PRIMARY KEY (`swatch_id`),
  UNIQUE KEY `EAV_ATTRIBUTE_OPTION_SWATCH_STORE_ID_OPTION_ID` (`store_id`,`option_id`),
  KEY `EAV_ATTR_OPT_SWATCH_OPT_ID_EAV_ATTR_OPT_OPT_ID` (`option_id`),
  KEY `EAV_ATTRIBUTE_OPTION_SWATCH_SWATCH_ID` (`swatch_id`),
  CONSTRAINT `EAV_ATTR_OPT_SWATCH_OPT_ID_EAV_ATTR_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `eav_attribute_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ATTRIBUTE_OPTION_SWATCH_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Magento Swatches table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute_option_value`
--

DROP TABLE IF EXISTS `eav_attribute_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute_option_value` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  KEY `EAV_ATTRIBUTE_OPTION_VALUE_OPTION_ID` (`option_id`),
  KEY `EAV_ATTRIBUTE_OPTION_VALUE_STORE_ID` (`store_id`),
  CONSTRAINT `EAV_ATTR_OPT_VAL_OPT_ID_EAV_ATTR_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `eav_attribute_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ATTRIBUTE_OPTION_VALUE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Attribute Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_attribute_set`
--

DROP TABLE IF EXISTS `eav_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_attribute_set` (
  `attribute_set_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Attribute Set ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_set_name` varchar(255) DEFAULT NULL COMMENT 'Attribute Set Name',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`attribute_set_id`),
  UNIQUE KEY `EAV_ATTRIBUTE_SET_ENTITY_TYPE_ID_ATTRIBUTE_SET_NAME` (`entity_type_id`,`attribute_set_name`),
  KEY `EAV_ATTRIBUTE_SET_ENTITY_TYPE_ID_SORT_ORDER` (`entity_type_id`,`sort_order`),
  CONSTRAINT `EAV_ATTRIBUTE_SET_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Attribute Set';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity`
--

DROP TABLE IF EXISTS `eav_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `parent_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Parent ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `is_active` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Defines Is Entity Active',
  PRIMARY KEY (`entity_id`),
  KEY `EAV_ENTITY_ENTITY_TYPE_ID` (`entity_type_id`),
  KEY `EAV_ENTITY_STORE_ID` (`store_id`),
  CONSTRAINT `EAV_ENTITY_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_attribute`
--

DROP TABLE IF EXISTS `eav_entity_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_attribute` (
  `entity_attribute_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity Attribute ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `attribute_group_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Group ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`entity_attribute_id`),
  UNIQUE KEY `EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_SET_ID_ATTRIBUTE_ID` (`attribute_set_id`,`attribute_id`),
  UNIQUE KEY `EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_GROUP_ID_ATTRIBUTE_ID` (`attribute_group_id`,`attribute_id`),
  KEY `EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_SET_ID_SORT_ORDER` (`attribute_set_id`,`sort_order`),
  KEY `EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `EAV_ENTITY_ATTRIBUTE_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTT_ATTR_ATTR_GROUP_ID_EAV_ATTR_GROUP_ATTR_GROUP_ID` FOREIGN KEY (`attribute_group_id`) REFERENCES `eav_attribute_group` (`attribute_group_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3711 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Attributes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_datetime`
--

DROP TABLE IF EXISTS `eav_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_datetime` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Attribute Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `EAV_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `EAV_ENTITY_DATETIME_STORE_ID` (`store_id`),
  KEY `EAV_ENTITY_DATETIME_ATTRIBUTE_ID_VALUE` (`attribute_id`,`value`),
  KEY `EAV_ENTITY_DATETIME_ENTITY_TYPE_ID_VALUE` (`entity_type_id`,`value`),
  CONSTRAINT `EAV_ENTITY_DATETIME_ENTITY_ID_EAV_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `eav_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_DATETIME_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTT_DTIME_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Value Prefix';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_decimal`
--

DROP TABLE IF EXISTS `eav_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_decimal` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Attribute Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `EAV_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `EAV_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `EAV_ENTITY_DECIMAL_ATTRIBUTE_ID_VALUE` (`attribute_id`,`value`),
  KEY `EAV_ENTITY_DECIMAL_ENTITY_TYPE_ID_VALUE` (`entity_type_id`,`value`),
  CONSTRAINT `EAV_ENTITY_DECIMAL_ENTITY_ID_EAV_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `eav_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_DECIMAL_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_DECIMAL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Value Prefix';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_int`
--

DROP TABLE IF EXISTS `eav_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_int` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int NOT NULL DEFAULT '0' COMMENT 'Attribute Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `EAV_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `EAV_ENTITY_INT_STORE_ID` (`store_id`),
  KEY `EAV_ENTITY_INT_ATTRIBUTE_ID_VALUE` (`attribute_id`,`value`),
  KEY `EAV_ENTITY_INT_ENTITY_TYPE_ID_VALUE` (`entity_type_id`,`value`),
  CONSTRAINT `EAV_ENTITY_INT_ENTITY_ID_EAV_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `eav_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_INT_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_INT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Value Prefix';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_store`
--

DROP TABLE IF EXISTS `eav_entity_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_store` (
  `entity_store_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity Store ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `increment_prefix` varchar(20) DEFAULT NULL COMMENT 'Increment Prefix',
  `increment_last_id` varchar(50) DEFAULT NULL COMMENT 'Last Incremented ID',
  PRIMARY KEY (`entity_store_id`),
  KEY `EAV_ENTITY_STORE_ENTITY_TYPE_ID` (`entity_type_id`),
  KEY `EAV_ENTITY_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `EAV_ENTITY_STORE_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_text`
--

DROP TABLE IF EXISTS `eav_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_text` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text NOT NULL COMMENT 'Attribute Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `EAV_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `EAV_ENTITY_TEXT_ENTITY_TYPE_ID` (`entity_type_id`),
  KEY `EAV_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `EAV_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `EAV_ENTITY_TEXT_ENTITY_ID_EAV_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `eav_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_TEXT_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_TEXT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Value Prefix';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_type`
--

DROP TABLE IF EXISTS `eav_entity_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_type` (
  `entity_type_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity Type ID',
  `entity_type_code` varchar(50) NOT NULL COMMENT 'Entity Type Code',
  `entity_model` varchar(255) NOT NULL COMMENT 'Entity Model',
  `attribute_model` varchar(255) DEFAULT NULL COMMENT 'Attribute Model',
  `entity_table` varchar(255) DEFAULT NULL COMMENT 'Entity Table',
  `value_table_prefix` varchar(255) DEFAULT NULL COMMENT 'Value Table Prefix',
  `entity_id_field` varchar(255) DEFAULT NULL COMMENT 'Entity ID Field',
  `is_data_sharing` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Defines Is Data Sharing',
  `data_sharing_key` varchar(100) DEFAULT 'default' COMMENT 'Data Sharing Key',
  `default_attribute_set_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Default Attribute Set ID',
  `increment_model` varchar(255) DEFAULT NULL COMMENT 'Increment Model',
  `increment_per_store` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Increment Per Store',
  `increment_pad_length` smallint unsigned NOT NULL DEFAULT '8' COMMENT 'Increment Pad Length',
  `increment_pad_char` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Increment Pad Char',
  `additional_attribute_table` varchar(255) DEFAULT NULL COMMENT 'Additional Attribute Table',
  `entity_attribute_collection` varchar(255) DEFAULT NULL COMMENT 'Entity Attribute Collection',
  PRIMARY KEY (`entity_type_id`),
  KEY `EAV_ENTITY_TYPE_ENTITY_TYPE_CODE` (`entity_type_code`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Type';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_entity_varchar`
--

DROP TABLE IF EXISTS `eav_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_entity_varchar` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `entity_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity Type ID',
  `attribute_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Attribute Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `EAV_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `EAV_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  KEY `EAV_ENTITY_VARCHAR_ATTRIBUTE_ID_VALUE` (`attribute_id`,`value`),
  KEY `EAV_ENTITY_VARCHAR_ENTITY_TYPE_ID_VALUE` (`entity_type_id`,`value`),
  CONSTRAINT `EAV_ENTITY_VARCHAR_ENTITY_ID_EAV_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `eav_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_VARCHAR_ENTITY_TYPE_ID_EAV_ENTITY_TYPE_ENTITY_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_ENTITY_VARCHAR_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Entity Value Prefix';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_form_element`
--

DROP TABLE IF EXISTS `eav_form_element`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_form_element` (
  `element_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Element ID',
  `type_id` smallint unsigned NOT NULL COMMENT 'Type ID',
  `fieldset_id` smallint unsigned DEFAULT NULL COMMENT 'Fieldset ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  `sort_order` int NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`element_id`),
  UNIQUE KEY `EAV_FORM_ELEMENT_TYPE_ID_ATTRIBUTE_ID` (`type_id`,`attribute_id`),
  KEY `EAV_FORM_ELEMENT_FIELDSET_ID` (`fieldset_id`),
  KEY `EAV_FORM_ELEMENT_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `EAV_FORM_ELEMENT_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_FORM_ELEMENT_FIELDSET_ID_EAV_FORM_FIELDSET_FIELDSET_ID` FOREIGN KEY (`fieldset_id`) REFERENCES `eav_form_fieldset` (`fieldset_id`) ON DELETE SET NULL,
  CONSTRAINT `EAV_FORM_ELEMENT_TYPE_ID_EAV_FORM_TYPE_TYPE_ID` FOREIGN KEY (`type_id`) REFERENCES `eav_form_type` (`type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Form Element';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_form_fieldset`
--

DROP TABLE IF EXISTS `eav_form_fieldset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_form_fieldset` (
  `fieldset_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Fieldset ID',
  `type_id` smallint unsigned NOT NULL COMMENT 'Type ID',
  `code` varchar(64) NOT NULL COMMENT 'Code',
  `sort_order` int NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  PRIMARY KEY (`fieldset_id`),
  UNIQUE KEY `EAV_FORM_FIELDSET_TYPE_ID_CODE` (`type_id`,`code`),
  CONSTRAINT `EAV_FORM_FIELDSET_TYPE_ID_EAV_FORM_TYPE_TYPE_ID` FOREIGN KEY (`type_id`) REFERENCES `eav_form_type` (`type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Form Fieldset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_form_fieldset_label`
--

DROP TABLE IF EXISTS `eav_form_fieldset_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_form_fieldset_label` (
  `fieldset_id` smallint unsigned NOT NULL COMMENT 'Fieldset ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `label` varchar(255) NOT NULL COMMENT 'Label',
  PRIMARY KEY (`fieldset_id`,`store_id`),
  KEY `EAV_FORM_FIELDSET_LABEL_STORE_ID` (`store_id`),
  CONSTRAINT `EAV_FORM_FIELDSET_LABEL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_FORM_FSET_LBL_FSET_ID_EAV_FORM_FSET_FSET_ID` FOREIGN KEY (`fieldset_id`) REFERENCES `eav_form_fieldset` (`fieldset_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Form Fieldset Label';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_form_type`
--

DROP TABLE IF EXISTS `eav_form_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_form_type` (
  `type_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Type ID',
  `code` varchar(64) NOT NULL COMMENT 'Code',
  `label` varchar(255) NOT NULL COMMENT 'Label',
  `is_system` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is System',
  `theme` varchar(64) DEFAULT NULL COMMENT 'Theme',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`type_id`),
  UNIQUE KEY `EAV_FORM_TYPE_CODE_THEME_STORE_ID` (`code`,`theme`,`store_id`),
  KEY `EAV_FORM_TYPE_STORE_ID` (`store_id`),
  CONSTRAINT `EAV_FORM_TYPE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='Eav Form Type';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `eav_form_type_entity`
--

DROP TABLE IF EXISTS `eav_form_type_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eav_form_type_entity` (
  `type_id` smallint unsigned NOT NULL COMMENT 'Type ID',
  `entity_type_id` smallint unsigned NOT NULL COMMENT 'Entity Type ID',
  PRIMARY KEY (`type_id`,`entity_type_id`),
  KEY `EAV_FORM_TYPE_ENTITY_ENTITY_TYPE_ID` (`entity_type_id`),
  CONSTRAINT `EAV_FORM_TYPE_ENTITY_TYPE_ID_EAV_FORM_TYPE_TYPE_ID` FOREIGN KEY (`type_id`) REFERENCES `eav_form_type` (`type_id`) ON DELETE CASCADE,
  CONSTRAINT `EAV_FORM_TYPE_ENTT_ENTT_TYPE_ID_EAV_ENTT_TYPE_ENTT_TYPE_ID` FOREIGN KEY (`entity_type_id`) REFERENCES `eav_entity_type` (`entity_type_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Eav Form Type Entity';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `email_template`
--

DROP TABLE IF EXISTS `email_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_template` (
  `template_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Template ID',
  `template_code` varchar(150) NOT NULL COMMENT 'Template Name',
  `template_text` text NOT NULL COMMENT 'Template Content',
  `template_styles` text COMMENT 'Templste Styles',
  `template_type` int unsigned DEFAULT NULL COMMENT 'Template Type',
  `template_subject` varchar(200) NOT NULL COMMENT 'Template Subject',
  `template_sender_name` varchar(200) DEFAULT NULL COMMENT 'Template Sender Name',
  `template_sender_email` varchar(200) DEFAULT NULL COMMENT 'Template Sender Email',
  `added_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Date of Template Creation',
  `modified_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of Template Modification',
  `orig_template_code` varchar(200) DEFAULT NULL COMMENT 'Original Template Code',
  `orig_template_variables` text COMMENT 'Original Template Variables',
  `is_legacy` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Should the template render in legacy mode',
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `EMAIL_TEMPLATE_TEMPLATE_CODE` (`template_code`),
  KEY `EMAIL_TEMPLATE_ADDED_AT` (`added_at`),
  KEY `EMAIL_TEMPLATE_MODIFIED_AT` (`modified_at`)
) ENGINE=InnoDB AUTO_INCREMENT=237 DEFAULT CHARSET=utf8mb3 COMMENT='Email Templates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `etsy_customers`
--

DROP TABLE IF EXISTS `etsy_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etsy_customers` (
  `id` bigint NOT NULL,
  `username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `avatar_url` varchar(999) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `etsy_customers_email_IDX` (`email`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `etsy_listing_mapping`
--

DROP TABLE IF EXISTS `etsy_listing_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etsy_listing_mapping` (
  `id` int NOT NULL AUTO_INCREMENT,
  `listing_id` bigint NOT NULL,
  `magento_sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `magento_product_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `etsy_listing_mapping_unique` (`listing_id`),
  KEY `etsy_listing_mapping_magento_product_id_IDX` (`magento_product_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `etsy_order_customer`
--

DROP TABLE IF EXISTS `etsy_order_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etsy_order_customer` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `order_id` bigint NOT NULL,
  `customer_id` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `etsy_order_customer_order_id_IDX` (`order_id`) USING BTREE,
  KEY `etsy_order_customer_customer_id_IDX` (`customer_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=262 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `etsy_orders`
--

DROP TABLE IF EXISTS `etsy_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etsy_orders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sale_date` date DEFAULT NULL,
  `item_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `buyer` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `price` double DEFAULT NULL,
  `coupon_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `coupon_details` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `discount_amount` double DEFAULT NULL,
  `shipping_discount` double DEFAULT NULL,
  `shipping` double DEFAULT NULL,
  `sales_tax` double DEFAULT NULL,
  `item_total` double DEFAULT NULL,
  `currency` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `transaction_id` bigint DEFAULT NULL,
  `listing_id` bigint DEFAULT NULL,
  `date_paid` date DEFAULT NULL,
  `date_shipped` date DEFAULT NULL,
  `ship_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ship_address1` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ship_address2` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ship_city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ship_state` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ship_zipcode` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ship_country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `order_id` bigint DEFAULT NULL,
  `variations` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `order_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `listings_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `inperson_discount` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `inperson_location` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `vat_paid_by_buyer` double DEFAULT NULL,
  `sku` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `order_shipping` double DEFAULT NULL,
  `order_sales_tax` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1783 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `etsy_reviews`
--

DROP TABLE IF EXISTS `etsy_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `etsy_reviews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reviewer` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `date_reviewed` timestamp NULL DEFAULT NULL,
  `star_rating` int DEFAULT NULL,
  `message` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `order_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=326 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fera_orders`
--

DROP TABLE IF EXISTS `fera_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fera_orders` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `order_id` int unsigned NOT NULL COMMENT 'Magento Order ID',
  `fera_id` varchar(64) NOT NULL COMMENT 'Fera Order ID',
  `exported_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Exported At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `FERA_ORDERS_ORDER_ID` (`order_id`),
  KEY `FERA_ORDERS_FERA_ID` (`fera_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9975 DEFAULT CHARSET=utf8mb3 COMMENT='Fera Exported Orders';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fera_products`
--

DROP TABLE IF EXISTS `fera_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fera_products` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `product_id` int unsigned NOT NULL COMMENT 'Magento Product ID',
  `fera_id` varchar(64) NOT NULL COMMENT 'Fera Product ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `exported_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Exported At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `FERA_PRODUCTS_PRODUCT_ID_STORE_ID` (`product_id`,`store_id`),
  KEY `FERA_PRODUCTS_STORE_ID_STORE_STORE_ID` (`store_id`),
  KEY `FERA_PRODUCTS_FERA_ID` (`fera_id`),
  CONSTRAINT `FERA_PRODUCTS_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=utf8mb3 COMMENT='Fera Exported Products';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `flag`
--

DROP TABLE IF EXISTS `flag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `flag` (
  `flag_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Flag Id',
  `flag_code` varchar(255) NOT NULL COMMENT 'Flag Code',
  `state` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Flag State',
  `flag_data` mediumtext COMMENT 'Flag Data',
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of Last Flag Update',
  PRIMARY KEY (`flag_id`),
  KEY `FLAG_LAST_UPDATE` (`last_update`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3 COMMENT='Flag';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gift_message`
--

DROP TABLE IF EXISTS `gift_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gift_message` (
  `gift_message_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'GiftMessage ID',
  `customer_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer ID',
  `sender` varchar(255) DEFAULT NULL COMMENT 'Sender',
  `recipient` varchar(255) DEFAULT NULL COMMENT 'Registrant',
  `message` text COMMENT 'Message',
  PRIMARY KEY (`gift_message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Gift Message';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `google_reviews`
--

DROP TABLE IF EXISTS `google_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `google_reviews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `author` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `rating` int DEFAULT NULL,
  `review` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `NewTable_author_IDX` (`author`,`date`) USING BTREE,
  KEY `NewTable_rating_IDX` (`rating`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `googleoptimizer_code`
--

DROP TABLE IF EXISTS `googleoptimizer_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `googleoptimizer_code` (
  `code_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Google experiment code ID',
  `entity_id` int unsigned NOT NULL COMMENT 'Optimized entity ID product ID or catalog ID',
  `entity_type` varchar(50) DEFAULT NULL COMMENT 'Optimized entity type',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `experiment_script` text COMMENT 'Google experiment script',
  PRIMARY KEY (`code_id`),
  UNIQUE KEY `GOOGLEOPTIMIZER_CODE_STORE_ID_ENTITY_ID_ENTITY_TYPE` (`store_id`,`entity_id`,`entity_type`),
  CONSTRAINT `GOOGLEOPTIMIZER_CODE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Google Experiment code';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `import_history`
--

DROP TABLE IF EXISTS `import_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `import_history` (
  `history_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'History record ID',
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Started at',
  `user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `imported_file` varchar(255) DEFAULT NULL COMMENT 'Imported file',
  `execution_time` varchar(255) DEFAULT NULL COMMENT 'Execution time',
  `summary` varchar(255) DEFAULT NULL COMMENT 'Summary',
  `error_file` varchar(255) NOT NULL COMMENT 'Imported file with errors',
  PRIMARY KEY (`history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Import history table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `importexport_importdata`
--

DROP TABLE IF EXISTS `importexport_importdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `importexport_importdata` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `entity` varchar(50) NOT NULL COMMENT 'Entity',
  `behavior` varchar(10) NOT NULL DEFAULT 'append' COMMENT 'Behavior',
  `data` longtext COMMENT 'Data',
  `is_processed` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Is Row Processed',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'timestamp of last update',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Import Data Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `indexer_state`
--

DROP TABLE IF EXISTS `indexer_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `indexer_state` (
  `state_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Indexer State ID',
  `indexer_id` varchar(255) DEFAULT NULL COMMENT 'Indexer ID',
  `status` varchar(16) DEFAULT 'invalid' COMMENT 'Indexer Status',
  `updated` datetime DEFAULT NULL COMMENT 'Indexer Status',
  `hash_config` varchar(32) NOT NULL COMMENT 'Hash of indexer config',
  PRIMARY KEY (`state_id`),
  KEY `INDEXER_STATE_INDEXER_ID` (`indexer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COMMENT='Indexer State';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `integration`
--

DROP TABLE IF EXISTS `integration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `integration` (
  `integration_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Integration ID',
  `name` varchar(255) NOT NULL COMMENT 'Integration name is displayed in the admin interface',
  `email` varchar(255) NOT NULL COMMENT 'Email address of the contact person',
  `endpoint` varchar(255) DEFAULT NULL COMMENT 'Endpoint for posting consumer credentials',
  `status` smallint unsigned NOT NULL COMMENT 'Integration status',
  `consumer_id` int unsigned DEFAULT NULL COMMENT 'Oauth consumer',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `setup_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Integration type - manual or config file',
  `identity_link_url` varchar(255) DEFAULT NULL COMMENT 'Identity linking Url',
  PRIMARY KEY (`integration_id`),
  UNIQUE KEY `INTEGRATION_NAME` (`name`),
  UNIQUE KEY `INTEGRATION_CONSUMER_ID` (`consumer_id`),
  CONSTRAINT `INTEGRATION_CONSUMER_ID_OAUTH_CONSUMER_ENTITY_ID` FOREIGN KEY (`consumer_id`) REFERENCES `oauth_consumer` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COMMENT='integration';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_geoname`
--

DROP TABLE IF EXISTS `inventory_geoname`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_geoname` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'entity id',
  `country_code` varchar(64) NOT NULL,
  `postcode` varchar(64) NOT NULL,
  `city` varchar(180) NOT NULL,
  `region` varchar(100) NOT NULL,
  `province` varchar(64) NOT NULL,
  `latitude` double NOT NULL,
  `longitude` double NOT NULL,
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_low_stock_notification_configuration`
--

DROP TABLE IF EXISTS `inventory_low_stock_notification_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_low_stock_notification_configuration` (
  `source_code` varchar(255) NOT NULL,
  `sku` varchar(64) NOT NULL,
  `notify_stock_qty` decimal(12,4) DEFAULT NULL,
  PRIMARY KEY (`source_code`,`sku`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_order_notification`
--

DROP TABLE IF EXISTS `inventory_order_notification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_order_notification` (
  `order_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Order ID',
  `notification_sent` smallint NOT NULL COMMENT 'Has Notification Been Sent For Order',
  `send_notification` smallint NOT NULL COMMENT 'Should Notification Be Send For Order',
  PRIMARY KEY (`order_id`),
  CONSTRAINT `INVENTORY_ORDER_NOTIFICATION_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_pickup_location_order`
--

DROP TABLE IF EXISTS `inventory_pickup_location_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_pickup_location_order` (
  `order_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Order ID',
  `pickup_location_code` varchar(255) NOT NULL COMMENT 'Pickup Location Code',
  PRIMARY KEY (`order_id`),
  CONSTRAINT `INVENTORY_PICKUP_LOCATION_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_pickup_location_quote_address`
--

DROP TABLE IF EXISTS `inventory_pickup_location_quote_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_pickup_location_quote_address` (
  `address_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Quote Address ID',
  `pickup_location_code` varchar(255) NOT NULL COMMENT 'Pickup Location Code',
  PRIMARY KEY (`address_id`),
  CONSTRAINT `INV_PICKUP_LOCATION_QUOTE_ADDR_ADDR_ID_QUOTE_ADDR_ADDR_ID` FOREIGN KEY (`address_id`) REFERENCES `quote_address` (`address_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_reservation`
--

DROP TABLE IF EXISTS `inventory_reservation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_reservation` (
  `reservation_id` int unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` int unsigned NOT NULL,
  `sku` varchar(64) NOT NULL,
  `quantity` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `metadata` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`reservation_id`),
  KEY `INVENTORY_RESERVATION_STOCK_ID_SKU_QUANTITY` (`stock_id`,`sku`,`quantity`)
) ENGINE=InnoDB AUTO_INCREMENT=5269 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_shipment_source`
--

DROP TABLE IF EXISTS `inventory_shipment_source`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_shipment_source` (
  `shipment_id` int unsigned NOT NULL,
  `source_code` varchar(255) NOT NULL,
  PRIMARY KEY (`shipment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_source`
--

DROP TABLE IF EXISTS `inventory_source`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_source` (
  `source_code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `enabled` smallint unsigned NOT NULL DEFAULT '1',
  `description` text,
  `latitude` decimal(8,6) DEFAULT NULL,
  `longitude` decimal(9,6) DEFAULT NULL,
  `country_id` varchar(2) NOT NULL,
  `region_id` int unsigned DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `street` varchar(255) DEFAULT NULL,
  `postcode` varchar(255) NOT NULL,
  `contact_name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `use_default_carrier_config` smallint unsigned NOT NULL DEFAULT '1',
  `is_pickup_location_active` tinyint(1) NOT NULL DEFAULT '0',
  `frontend_name` varchar(255) DEFAULT '',
  `frontend_description` text,
  PRIMARY KEY (`source_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_source_carrier_link`
--

DROP TABLE IF EXISTS `inventory_source_carrier_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_source_carrier_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT,
  `source_code` varchar(255) NOT NULL,
  `carrier_code` varchar(255) NOT NULL,
  `position` smallint unsigned DEFAULT NULL,
  PRIMARY KEY (`link_id`),
  KEY `INV_SOURCE_CARRIER_LNK_SOURCE_CODE_INV_SOURCE_SOURCE_CODE` (`source_code`),
  CONSTRAINT `INV_SOURCE_CARRIER_LNK_SOURCE_CODE_INV_SOURCE_SOURCE_CODE` FOREIGN KEY (`source_code`) REFERENCES `inventory_source` (`source_code`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_source_item`
--

DROP TABLE IF EXISTS `inventory_source_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_source_item` (
  `source_item_id` int unsigned NOT NULL AUTO_INCREMENT,
  `source_code` varchar(255) NOT NULL,
  `sku` varchar(64) NOT NULL,
  `quantity` decimal(12,4) NOT NULL DEFAULT '0.0000',
  `status` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`source_item_id`),
  UNIQUE KEY `INVENTORY_SOURCE_ITEM_SOURCE_CODE_SKU` (`source_code`,`sku`),
  KEY `INVENTORY_SOURCE_ITEM_SKU_SOURCE_CODE_QUANTITY` (`sku`,`source_code`,`quantity`),
  CONSTRAINT `INVENTORY_SOURCE_ITEM_SOURCE_CODE_INVENTORY_SOURCE_SOURCE_CODE` FOREIGN KEY (`source_code`) REFERENCES `inventory_source` (`source_code`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1130 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_source_stock_link`
--

DROP TABLE IF EXISTS `inventory_source_stock_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_source_stock_link` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` int unsigned NOT NULL,
  `source_code` varchar(255) NOT NULL,
  `priority` smallint unsigned NOT NULL,
  PRIMARY KEY (`link_id`),
  UNIQUE KEY `INVENTORY_SOURCE_STOCK_LINK_STOCK_ID_SOURCE_CODE` (`stock_id`,`source_code`),
  KEY `INV_SOURCE_STOCK_LNK_SOURCE_CODE_INV_SOURCE_SOURCE_CODE` (`source_code`),
  KEY `INVENTORY_SOURCE_STOCK_LINK_STOCK_ID_PRIORITY` (`stock_id`,`priority`),
  CONSTRAINT `INV_SOURCE_STOCK_LNK_SOURCE_CODE_INV_SOURCE_SOURCE_CODE` FOREIGN KEY (`source_code`) REFERENCES `inventory_source` (`source_code`) ON DELETE CASCADE,
  CONSTRAINT `INVENTORY_SOURCE_STOCK_LINK_STOCK_ID_INVENTORY_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `inventory_stock` (`stock_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `inventory_stock`
--

DROP TABLE IF EXISTS `inventory_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_stock` (
  `stock_id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Temporary view structure for view `inventory_stock_1`
--

DROP TABLE IF EXISTS `inventory_stock_1`;
/*!50001 DROP VIEW IF EXISTS `inventory_stock_1`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `inventory_stock_1` AS SELECT 
 1 AS `product_id`,
 1 AS `website_id`,
 1 AS `stock_id`,
 1 AS `quantity`,
 1 AS `is_salable`,
 1 AS `sku`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `inventory_stock_sales_channel`
--

DROP TABLE IF EXISTS `inventory_stock_sales_channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_stock_sales_channel` (
  `type` varchar(64) NOT NULL,
  `code` varchar(64) NOT NULL,
  `stock_id` int unsigned NOT NULL,
  PRIMARY KEY (`type`,`code`),
  KEY `INVENTORY_STOCK_SALES_CHANNEL_STOCK_ID_INVENTORY_STOCK_STOCK_ID` (`stock_id`),
  CONSTRAINT `INVENTORY_STOCK_SALES_CHANNEL_STOCK_ID_INVENTORY_STOCK_STOCK_ID` FOREIGN KEY (`stock_id`) REFERENCES `inventory_stock` (`stock_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `jwt_auth_revoked`
--

DROP TABLE IF EXISTS `jwt_auth_revoked`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jwt_auth_revoked` (
  `user_type_id` int unsigned NOT NULL COMMENT 'User Type ID',
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `revoke_before` bigint unsigned NOT NULL COMMENT 'Not accepting tokens issued before this timestamp',
  PRIMARY KEY (`user_type_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Holds revoked JWT authentication data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kl_events`
--

DROP TABLE IF EXISTS `kl_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kl_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `status` varchar(30) DEFAULT NULL COMMENT 'Status of row (NEW, MOVED)',
  `event` varchar(255) DEFAULT NULL COMMENT 'Klaviyo Event name',
  `user_properties` text COMMENT 'User properties',
  `payload` text COMMENT 'Event payload',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation time',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update time',
  PRIMARY KEY (`id`),
  KEY `KL_EVENTS_STATUS` (`status`),
  KEY `KL_EVENTS_CREATED_AT` (`created_at`),
  KEY `KL_EVENTS_UPDATED_AT` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Klaviyo Events topic table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kl_products`
--

DROP TABLE IF EXISTS `kl_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kl_products` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `payload` text COMMENT 'Event payload',
  `status` varchar(30) NOT NULL COMMENT 'Status of row (NEW, MOVED)',
  `topic` varchar(255) NOT NULL COMMENT 'Klaviyo webhook topic',
  `klaviyo_id` text COMMENT 'Klaviyo ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation time',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update time',
  PRIMARY KEY (`id`),
  KEY `KL_PRODUCTS_STATUS` (`status`),
  KEY `KL_PRODUCTS_TOPIC` (`topic`),
  KEY `KL_PRODUCTS_CREATED_AT` (`created_at`),
  KEY `KL_PRODUCTS_UPDATED_AT` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Klaviyo Products topic table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `kl_sync`
--

DROP TABLE IF EXISTS `kl_sync`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kl_sync` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `user_properties` text COMMENT 'User Properties',
  `payload` text COMMENT 'Event payload',
  `status` varchar(30) NOT NULL COMMENT 'Status of row (NEW, SYNCED, RETRY, FAILED)',
  `topic` varchar(255) NOT NULL COMMENT 'Klaviyo Topic name',
  `klaviyo_id` text COMMENT 'Klaviyo ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation time',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update time',
  PRIMARY KEY (`id`),
  KEY `KL_SYNC_STATUS` (`status`),
  KEY `KL_SYNC_TOPIC` (`topic`),
  KEY `KL_SYNC_CREATED_AT` (`created_at`),
  KEY `KL_SYNC_UPDATED_AT` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Klaviyo Sync table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `layout_link`
--

DROP TABLE IF EXISTS `layout_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `layout_link` (
  `layout_link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Link ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `theme_id` int unsigned NOT NULL COMMENT 'Theme ID',
  `layout_update_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Layout Update ID',
  `is_temporary` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Defines whether Layout Update is Temporary',
  PRIMARY KEY (`layout_link_id`),
  KEY `LAYOUT_LINK_THEME_ID_THEME_THEME_ID` (`theme_id`),
  KEY `LAYOUT_LINK_LAYOUT_UPDATE_ID` (`layout_update_id`),
  KEY `LAYOUT_LINK_STORE_ID_THEME_ID_LAYOUT_UPDATE_ID_IS_TEMPORARY` (`store_id`,`theme_id`,`layout_update_id`,`is_temporary`),
  CONSTRAINT `LAYOUT_LINK_LAYOUT_UPDATE_ID_LAYOUT_UPDATE_LAYOUT_UPDATE_ID` FOREIGN KEY (`layout_update_id`) REFERENCES `layout_update` (`layout_update_id`) ON DELETE CASCADE,
  CONSTRAINT `LAYOUT_LINK_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `LAYOUT_LINK_THEME_ID_THEME_THEME_ID` FOREIGN KEY (`theme_id`) REFERENCES `theme` (`theme_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Layout Link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `layout_update`
--

DROP TABLE IF EXISTS `layout_update`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `layout_update` (
  `layout_update_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Layout Update ID',
  `handle` varchar(255) DEFAULT NULL COMMENT 'Handle',
  `xml` text COMMENT 'Xml',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `updated_at` timestamp NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT 'Last Update Timestamp',
  PRIMARY KEY (`layout_update_id`),
  KEY `LAYOUT_UPDATE_HANDLE` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Layout Updates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `login_as_customer`
--

DROP TABLE IF EXISTS `login_as_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `login_as_customer` (
  `secret` varchar(64) NOT NULL COMMENT 'Login Secret',
  `customer_id` int NOT NULL COMMENT 'Customer ID',
  `admin_id` int NOT NULL COMMENT 'Admin ID',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Creation Time',
  PRIMARY KEY (`secret`),
  KEY `LOGIN_AS_CUSTOMER_CREATED_AT` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Magento Login as Customer Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `login_as_customer_assistance_allowed`
--

DROP TABLE IF EXISTS `login_as_customer_assistance_allowed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `login_as_customer_assistance_allowed` (
  `customer_id` int unsigned NOT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`customer_id`),
  CONSTRAINT `LOGIN_AS_CSTR_ASSISTANCE_ALLOWED_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Magento Login as Customer Assistance Allowed Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `magento_acknowledged_bulk`
--

DROP TABLE IF EXISTS `magento_acknowledged_bulk`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `magento_acknowledged_bulk` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Internal ID',
  `bulk_uuid` varbinary(39) DEFAULT NULL COMMENT 'Related Bulk UUID',
  PRIMARY KEY (`id`),
  UNIQUE KEY `MAGENTO_ACKNOWLEDGED_BULK_BULK_UUID` (`bulk_uuid`),
  CONSTRAINT `MAGENTO_ACKNOWLEDGED_BULK_BULK_UUID_MAGENTO_BULK_UUID` FOREIGN KEY (`bulk_uuid`) REFERENCES `magento_bulk` (`uuid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Bulk that was viewed by user from notification area';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `magento_bulk`
--

DROP TABLE IF EXISTS `magento_bulk`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `magento_bulk` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Bulk Internal ID (must not be exposed)',
  `uuid` varbinary(39) DEFAULT NULL COMMENT 'Bulk UUID (can be exposed to reference bulk entity)',
  `user_id` int unsigned DEFAULT NULL COMMENT 'ID of the WebAPI user that performed an action',
  `user_type` int DEFAULT NULL COMMENT 'Which type of user',
  `description` varchar(255) DEFAULT NULL COMMENT 'Bulk Description',
  `operation_count` int unsigned NOT NULL COMMENT 'Total number of operations scheduled within this bulk',
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Bulk start time',
  PRIMARY KEY (`id`),
  UNIQUE KEY `MAGENTO_BULK_UUID` (`uuid`),
  KEY `MAGENTO_BULK_USER_ID` (`user_id`),
  KEY `MAGENTO_BULK_START_TIME` (`start_time`)
) ENGINE=InnoDB AUTO_INCREMENT=45277 DEFAULT CHARSET=utf8mb3 COMMENT='Bulk entity that represents set of related asynchronous operations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `magento_login_as_customer_log`
--

DROP TABLE IF EXISTS `magento_login_as_customer_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `magento_login_as_customer_log` (
  `log_id` int NOT NULL AUTO_INCREMENT COMMENT 'Log Id',
  `time` timestamp NULL DEFAULT NULL COMMENT 'Event Date',
  `user_id` int unsigned DEFAULT NULL COMMENT 'User Id',
  `user_name` varchar(40) DEFAULT NULL COMMENT 'User Name',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer Id',
  `customer_email` varchar(40) DEFAULT NULL COMMENT 'Customer email',
  PRIMARY KEY (`log_id`),
  KEY `MAGENTO_LOGIN_AS_CUSTOMER_LOG_USER_ID` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Login as Customer Logging';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `magento_operation`
--

DROP TABLE IF EXISTS `magento_operation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `magento_operation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Operation ID',
  `operation_key` int unsigned DEFAULT NULL COMMENT 'Operation Key',
  `bulk_uuid` varbinary(39) DEFAULT NULL COMMENT 'Related Bulk UUID',
  `topic_name` varchar(255) DEFAULT NULL COMMENT 'Name of the related message queue topic',
  `serialized_data` blob COMMENT 'Data (serialized) required to perform an operation',
  `result_serialized_data` blob COMMENT 'Result data (serialized) after perform an operation',
  `status` smallint DEFAULT '0' COMMENT 'Operation status (OPEN | COMPLETE | RETRIABLY_FAILED | NOT_RETRIABLY_FAILED)',
  `error_code` smallint DEFAULT NULL COMMENT 'Code of the error that appeared during operation execution (used to aggregate related failed operations)',
  `result_message` varchar(255) DEFAULT NULL COMMENT 'Operation result message',
  `started_at` timestamp NULL DEFAULT NULL COMMENT 'Datetime the operation started processing',
  PRIMARY KEY (`id`),
  KEY `MAGENTO_OPERATION_BULK_UUID_ERROR_CODE` (`bulk_uuid`,`error_code`),
  KEY `MAGENTO_OPERATION_STATUS_STARTED_AT` (`status`,`started_at`),
  CONSTRAINT `MAGENTO_OPERATION_BULK_UUID_MAGENTO_BULK_UUID` FOREIGN KEY (`bulk_uuid`) REFERENCES `magento_bulk` (`uuid`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=45300 DEFAULT CHARSET=utf8mb3 COMMENT='Operation entity';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mageplaza_productfeed_defaulttemplate`
--

DROP TABLE IF EXISTS `mageplaza_productfeed_defaulttemplate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mageplaza_productfeed_defaulttemplate` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Template Id',
  `name` varchar(255) NOT NULL COMMENT 'Template Name',
  `title` varchar(255) NOT NULL COMMENT 'Template Title',
  `file_type` varchar(64) NOT NULL COMMENT 'Type',
  `template_html` mediumtext COMMENT 'Template Html',
  `field_separate` varchar(64) DEFAULT NULL COMMENT 'Field Separate',
  `field_around` varchar(64) DEFAULT NULL COMMENT 'Field Around',
  `include_header` int DEFAULT NULL COMMENT 'Include Field Header',
  `fields_map` mediumtext COMMENT 'Field Map',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COMMENT='Default Template Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mageplaza_productfeed_feed`
--

DROP TABLE IF EXISTS `mageplaza_productfeed_feed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mageplaza_productfeed_feed` (
  `feed_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Feed Id',
  `name` varchar(255) NOT NULL COMMENT 'Name',
  `status` int NOT NULL COMMENT 'Feed Status',
  `store_id` varchar(64) NOT NULL COMMENT 'Store',
  `file_name` varchar(255) NOT NULL COMMENT 'File Name',
  `default_template` varchar(255) NOT NULL COMMENT 'Feed Template',
  `file_type` varchar(64) NOT NULL COMMENT 'Feed Type',
  `template_html` mediumtext COMMENT 'Template Html',
  `field_separate` varchar(64) DEFAULT NULL COMMENT 'Field Separate',
  `field_around` varchar(64) DEFAULT NULL COMMENT 'Field Around',
  `include_header` int DEFAULT NULL COMMENT 'Include Field Header',
  `fields_map` mediumtext COMMENT 'Field Map',
  `conditions_serialized` mediumtext COMMENT 'Product Filter',
  `category_map` mediumtext COMMENT 'Category Map',
  `execution_mode` varchar(64) DEFAULT NULL COMMENT 'Execution Mode',
  `frequency` varchar(64) DEFAULT NULL COMMENT 'Frequency',
  `cron_run_day_of_week` varchar(64) DEFAULT NULL COMMENT 'Day of Week',
  `cron_run_day_of_month` varchar(64) DEFAULT NULL COMMENT 'Day of Month',
  `cron_run_time` varchar(64) DEFAULT NULL COMMENT 'Cron Run Time',
  `last_cron` timestamp NULL DEFAULT NULL COMMENT 'Last Generated',
  `delivery_enable` int DEFAULT NULL COMMENT 'Delivery Enable',
  `protocol` varchar(64) DEFAULT NULL COMMENT 'Delivery Config: Protocol',
  `passive_mode` varchar(64) DEFAULT NULL COMMENT 'Delivery Config: Passive Mode',
  `host_name` varchar(255) DEFAULT NULL COMMENT 'Delivery Config: Host Name',
  `user_name` varchar(255) DEFAULT NULL COMMENT 'Delivery Config: User Name',
  `password` varchar(255) DEFAULT NULL COMMENT 'Delivery Config: Password',
  `directory_path` varchar(255) DEFAULT NULL COMMENT 'Delivery Config: Directory Path',
  `campaign_source` varchar(255) DEFAULT NULL COMMENT 'Google Analytics: Campaign Source',
  `campaign_medium` varchar(255) DEFAULT NULL COMMENT 'Google Analytics: Campaign Medium',
  `campaign_name` varchar(255) DEFAULT NULL COMMENT 'Google Analytics: Campaign Name',
  `campaign_term` varchar(255) DEFAULT NULL COMMENT 'Google Analytics: Campaign Term',
  `campaign_content` varchar(255) DEFAULT NULL COMMENT 'Google Analytics: Campaign Content',
  `last_generated` timestamp NULL DEFAULT NULL COMMENT 'Last Generated',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Update At',
  `compress_file` text COMMENT 'Compress File',
  `private_key_path` text COMMENT 'Private Key File',
  `mapping` text COMMENT 'Mapping',
  `preview_limit` text COMMENT 'Preview Limit',
  `click` int unsigned NOT NULL DEFAULT '0' COMMENT 'Click',
  `impression` int unsigned NOT NULL DEFAULT '0' COMMENT 'Impression',
  `ctr` int unsigned NOT NULL DEFAULT '0' COMMENT 'CTR',
  `request_url` text COMMENT 'Request Url',
  `headers` text COMMENT 'Headers',
  `generate_variants` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Generate variants for custom products',
  PRIMARY KEY (`feed_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='Product Feed Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mageplaza_productfeed_history`
--

DROP TABLE IF EXISTS `mageplaza_productfeed_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mageplaza_productfeed_history` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log Id',
  `feed_id` int unsigned NOT NULL COMMENT 'Feed Id',
  `feed_name` varchar(255) DEFAULT NULL COMMENT 'Feed Name',
  `status` varchar(64) DEFAULT NULL COMMENT 'Log Status',
  `delivery` varchar(64) DEFAULT NULL COMMENT 'Delivery Status',
  `type` varchar(64) NOT NULL COMMENT 'Execution Type',
  `file` varchar(255) DEFAULT NULL COMMENT 'File',
  `product_count` int DEFAULT NULL COMMENT 'Product Count',
  `success_message` varchar(255) DEFAULT NULL COMMENT 'Success Message',
  `error_message` varchar(255) DEFAULT NULL COMMENT 'Error Message',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`id`),
  KEY `MAGEPLAZA_PRODUCTFEED_HISTORY_FEED_ID` (`feed_id`),
  CONSTRAINT `MAGEPLAZA_PRDFEED_HISTORY_FEED_ID_MAGEPLAZA_PRDFEED_FEED_FEED_ID` FOREIGN KEY (`feed_id`) REFERENCES `mageplaza_productfeed_feed` (`feed_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=296 DEFAULT CHARSET=utf8mb3 COMMENT='Product Feed Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mageplaza_productfeed_reports`
--

DROP TABLE IF EXISTS `mageplaza_productfeed_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mageplaza_productfeed_reports` (
  `report_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Report Id',
  `feed_id` int unsigned NOT NULL COMMENT 'Feed Id',
  `order_id` int unsigned DEFAULT NULL COMMENT 'Order ID',
  `ordered_quantity` decimal(12,4) DEFAULT NULL COMMENT 'Ordered Quantity',
  `revenue` decimal(20,4) DEFAULT NULL COMMENT 'Revenue',
  `refunded` decimal(20,4) DEFAULT NULL COMMENT 'Refunded',
  `discount` decimal(20,4) DEFAULT NULL COMMENT 'Discount',
  `tax` decimal(20,4) DEFAULT NULL COMMENT 'Tax',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`report_id`),
  KEY `MAGEPLAZA_PRDFEED_REPORTS_FEED_ID_MAGEPLAZA_PRDFEED_FEED_FEED_ID` (`feed_id`),
  KEY `MAGEPLAZA_PRODUCTFEED_REPORTS_ORDER_ID_SALES_ORDER_ENTITY_ID` (`order_id`),
  CONSTRAINT `MAGEPLAZA_PRDFEED_REPORTS_FEED_ID_MAGEPLAZA_PRDFEED_FEED_FEED_ID` FOREIGN KEY (`feed_id`) REFERENCES `mageplaza_productfeed_feed` (`feed_id`) ON DELETE CASCADE,
  CONSTRAINT `MAGEPLAZA_PRODUCTFEED_REPORTS_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COMMENT='ProductFeed Reports';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_errors`
--

DROP TABLE IF EXISTS `mailchimp_errors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_errors` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Table Id',
  `mailchimp_store_id` varchar(50) DEFAULT NULL COMMENT 'Mailchimp Store Id',
  `type` text NOT NULL COMMENT 'type',
  `title` varchar(128) DEFAULT NULL COMMENT 'title',
  `status` int NOT NULL COMMENT 'status',
  `errors` text NOT NULL COMMENT 'errors',
  `regtype` varchar(3) DEFAULT NULL COMMENT 'regtype',
  `original_id` int NOT NULL COMMENT 'Associated object ID',
  `batch_id` varchar(64) DEFAULT NULL COMMENT 'Mailchimp Batch ID',
  `store_id` int NOT NULL COMMENT 'Magento Store Id',
  `added_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Added at date',
  PRIMARY KEY (`id`),
  KEY `MAILCHIMP_ERRORS_STORE_ID_REGTYPE_ORIGINAL_ID` (`store_id`,`regtype`,`original_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_interest_group`
--

DROP TABLE IF EXISTS `mailchimp_interest_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_interest_group` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Table Id',
  `subscriber_id` int NOT NULL COMMENT 'subscriber id',
  `store_id` smallint NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `groupdata` text NOT NULL COMMENT 'data',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_stores`
--

DROP TABLE IF EXISTS `mailchimp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_stores` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Table Id',
  `apikey` varchar(128) DEFAULT NULL COMMENT 'API Key',
  `storeid` varchar(50) DEFAULT NULL COMMENT 'Store Id',
  `list_id` varchar(50) DEFAULT NULL COMMENT 'List Id',
  `name` varchar(128) DEFAULT NULL COMMENT 'Name',
  `platform` varchar(50) DEFAULT NULL COMMENT 'Platform',
  `is_sync` tinyint(1) NOT NULL COMMENT 'if the store is synced or not ',
  `email_address` varchar(128) DEFAULT NULL COMMENT 'email associated to store',
  `currency_code` varchar(3) DEFAULT NULL COMMENT 'store currency code',
  `money_format` varchar(10) DEFAULT NULL COMMENT 'symbol of currency',
  `primary_locale` varchar(5) DEFAULT NULL COMMENT 'store locale',
  `timezone` varchar(32) DEFAULT NULL COMMENT 'store timezone',
  `phone` varchar(50) DEFAULT NULL COMMENT 'store phone',
  `address_address_one` varchar(255) DEFAULT NULL COMMENT 'first street address',
  `address_address_two` varchar(255) DEFAULT NULL COMMENT 'second street address',
  `address_city` varchar(50) DEFAULT NULL COMMENT 'store city',
  `address_province` varchar(50) DEFAULT NULL COMMENT 'store province',
  `address_province_code` varchar(2) DEFAULT NULL COMMENT 'store province code',
  `address_postal_code` varchar(50) DEFAULT NULL COMMENT 'store postal code',
  `address_country` varchar(50) DEFAULT NULL COMMENT 'store country',
  `address_country_code` varchar(2) DEFAULT NULL COMMENT 'store country code',
  `domain` text NOT NULL COMMENT 'Domain',
  `mc_account_name` text NOT NULL COMMENT 'MC account name',
  `list_name` text NOT NULL COMMENT ' List Name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_survey`
--

DROP TABLE IF EXISTS `mailchimp_survey`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_survey` (
  `id` int NOT NULL AUTO_INCREMENT,
  `created_at` datetime DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rating` tinyint DEFAULT NULL,
  `review` varchar(9000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `store_id` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mailchimp_survey_store_id_IDX` (`store_id`,`email`,`created_at`,`rating`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=838 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_sync_batches`
--

DROP TABLE IF EXISTS `mailchimp_sync_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_sync_batches` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Table Id',
  `store_id` varchar(50) DEFAULT NULL COMMENT 'Store Id',
  `mailchimp_store_id` varchar(50) DEFAULT NULL COMMENT 'Mailchimp Store Id',
  `batch_id` varchar(24) DEFAULT NULL COMMENT 'Batch Id',
  `status` varchar(10) DEFAULT NULL COMMENT 'Status',
  `modified_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Sync Delta',
  `carts_new_count` smallint DEFAULT NULL COMMENT 'Carts New Count',
  `customers_new_count` smallint DEFAULT NULL COMMENT 'Customers New Count',
  `orders_new_count` smallint DEFAULT NULL COMMENT 'Orders New Count',
  `products_new_count` smallint DEFAULT NULL COMMENT 'Products New Count',
  `subscribers_new_count` smallint DEFAULT NULL COMMENT 'Subscribers New Count',
  `carts_modified_count` smallint DEFAULT NULL COMMENT 'Carts Modified Count',
  `customers_modified_count` smallint DEFAULT NULL COMMENT 'Customers Modified Count',
  `orders_modified_count` smallint DEFAULT NULL COMMENT 'Orders Modified Count',
  `products_modified_count` smallint DEFAULT NULL COMMENT 'Products Modified Count',
  `subscribers_modified_count` smallint DEFAULT NULL COMMENT 'Subscribers Modified Count',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_sync_ecommerce`
--

DROP TABLE IF EXISTS `mailchimp_sync_ecommerce`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_sync_ecommerce` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Table Id',
  `mailchimp_store_id` varchar(50) DEFAULT NULL COMMENT 'Store Id',
  `type` varchar(24) DEFAULT NULL COMMENT 'Type of register',
  `related_id` int unsigned NOT NULL COMMENT 'Id of the related entity',
  `mailchimp_sync_modified` tinyint(1) NOT NULL COMMENT 'If the entity was modified',
  `mailchimp_sync_delta` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Sync Delta',
  `mailchimp_sync_error` varchar(128) DEFAULT NULL COMMENT 'Error on synchronization',
  `mailchimp_sync_deleted` tinyint(1) NOT NULL COMMENT 'If the object was deleted in mailchimp',
  `mailchimp_token` varchar(32) DEFAULT NULL COMMENT 'Quote token',
  `batch_id` varchar(64) DEFAULT NULL COMMENT 'Batch id',
  `deleted_related_id` int unsigned NOT NULL COMMENT 'Id related to delete item',
  `mailchimp_sent` smallint NOT NULL DEFAULT '0' COMMENT 'Sent to Mailchimp',
  PRIMARY KEY (`id`),
  KEY `MAILCHIMP_SYNC_ECOMMERCE_RELATED_ID` (`related_id`),
  KEY `MAILCHIMP_SYNC_ECOMMERCE_TYPE` (`type`),
  KEY `MAILCHIMP_SYNC_ECOMMERCE_BATCH_ID` (`batch_id`),
  KEY `MAILCHIMP_SYNC_ECOMMERCE_MAILCHIMP_STORE_ID` (`mailchimp_store_id`),
  KEY `MAILCHIMP_SYNC_ECOMMERCE_MAILCHIMP_SYNC_DELTA` (`mailchimp_sync_delta`),
  KEY `MAILCHIMP_SYNC_ECOMMERCE_MAILCHIMP_SYNC_MODIFIED` (`mailchimp_sync_modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mailchimp_webhook_request`
--

DROP TABLE IF EXISTS `mailchimp_webhook_request`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mailchimp_webhook_request` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'Table Id',
  `type` varchar(50) DEFAULT NULL COMMENT 'request type',
  `fired_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'date of the request',
  `data_request` text NOT NULL COMMENT 'data of the request',
  `processed` tinyint(1) NOT NULL COMMENT 'Already processed',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `media_content_asset`
--

DROP TABLE IF EXISTS `media_content_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_content_asset` (
  `asset_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `entity_type` varchar(255) NOT NULL COMMENT 'Content type',
  `entity_id` varchar(255) NOT NULL COMMENT 'Content entity id',
  `field` varchar(255) NOT NULL COMMENT 'Content field',
  PRIMARY KEY (`entity_type`,`entity_id`,`field`,`asset_id`),
  KEY `MEDIA_CONTENT_ASSET_ASSET_ID` (`asset_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Relation between media content and media asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `media_gallery_asset`
--

DROP TABLE IF EXISTS `media_gallery_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_gallery_asset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `path` text COMMENT 'Path',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `source` varchar(255) DEFAULT NULL COMMENT 'Source',
  `hash` varchar(255) DEFAULT NULL COMMENT 'File hash',
  `content_type` varchar(255) DEFAULT NULL COMMENT 'Content Type',
  `width` int unsigned NOT NULL DEFAULT '0' COMMENT 'Width',
  `height` int unsigned NOT NULL DEFAULT '0' COMMENT 'Height',
  `size` int unsigned NOT NULL COMMENT 'Asset file size in bytes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`id`),
  KEY `MEDIA_GALLERY_ASSET_ID` (`id`),
  FULLTEXT KEY `MEDIA_GALLERY_ASSET_TITLE` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Media Gallery Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `media_gallery_asset_keyword`
--

DROP TABLE IF EXISTS `media_gallery_asset_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_gallery_asset_keyword` (
  `keyword_id` int unsigned NOT NULL COMMENT 'Keyword Id',
  `asset_id` int unsigned NOT NULL COMMENT 'Asset ID',
  PRIMARY KEY (`keyword_id`,`asset_id`),
  KEY `MEDIA_GALLERY_ASSET_KEYWORD_ASSET_ID` (`asset_id`),
  KEY `MEDIA_GALLERY_ASSET_KEYWORD_KEYWORD_ID` (`keyword_id`),
  CONSTRAINT `MEDIA_GALLERY_ASSET_KEYWORD_ASSET_ID_MEDIA_GALLERY_ASSET_ID` FOREIGN KEY (`asset_id`) REFERENCES `media_gallery_asset` (`id`) ON DELETE CASCADE,
  CONSTRAINT `MEDIA_GALLERY_ASSET_KEYWORD_KEYWORD_ID_MEDIA_GALLERY_KEYWORD_ID` FOREIGN KEY (`keyword_id`) REFERENCES `media_gallery_keyword` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Media Gallery Asset Keyword';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `media_gallery_keyword`
--

DROP TABLE IF EXISTS `media_gallery_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_gallery_keyword` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Keyword ID',
  `keyword` varchar(255) NOT NULL COMMENT 'Keyword',
  PRIMARY KEY (`id`),
  UNIQUE KEY `MEDIA_GALLERY_KEYWORD_KEYWORD` (`keyword`),
  KEY `MEDIA_GALLERY_KEYWORD_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Media Gallery Keyword';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mview_state`
--

DROP TABLE IF EXISTS `mview_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mview_state` (
  `state_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'View State ID',
  `view_id` varchar(255) DEFAULT NULL COMMENT 'View ID',
  `mode` varchar(16) DEFAULT 'disabled' COMMENT 'View Mode',
  `status` varchar(16) DEFAULT 'idle' COMMENT 'View Status',
  `updated` datetime DEFAULT NULL COMMENT 'View updated time',
  `version_id` int unsigned DEFAULT NULL COMMENT 'View Version ID',
  PRIMARY KEY (`state_id`),
  KEY `MVIEW_STATE_VIEW_ID` (`view_id`),
  KEY `MVIEW_STATE_MODE` (`mode`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3 COMMENT='View State';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `newsletter_problem`
--

DROP TABLE IF EXISTS `newsletter_problem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletter_problem` (
  `problem_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Problem ID',
  `subscriber_id` int unsigned DEFAULT NULL COMMENT 'Subscriber ID',
  `queue_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Queue ID',
  `problem_error_code` int unsigned DEFAULT '0' COMMENT 'Problem Error Code',
  `problem_error_text` varchar(200) DEFAULT NULL COMMENT 'Problem Error Text',
  PRIMARY KEY (`problem_id`),
  KEY `NEWSLETTER_PROBLEM_SUBSCRIBER_ID` (`subscriber_id`),
  KEY `NEWSLETTER_PROBLEM_QUEUE_ID` (`queue_id`),
  CONSTRAINT `NEWSLETTER_PROBLEM_QUEUE_ID_NEWSLETTER_QUEUE_QUEUE_ID` FOREIGN KEY (`queue_id`) REFERENCES `newsletter_queue` (`queue_id`) ON DELETE CASCADE,
  CONSTRAINT `NLTTR_PROBLEM_SUBSCRIBER_ID_NLTTR_SUBSCRIBER_SUBSCRIBER_ID` FOREIGN KEY (`subscriber_id`) REFERENCES `newsletter_subscriber` (`subscriber_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Newsletter Problems';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `newsletter_queue`
--

DROP TABLE IF EXISTS `newsletter_queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletter_queue` (
  `queue_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Queue ID',
  `template_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Template ID',
  `newsletter_type` int DEFAULT NULL COMMENT 'Newsletter Type',
  `newsletter_text` text COMMENT 'Newsletter Text',
  `newsletter_styles` text COMMENT 'Newsletter Styles',
  `newsletter_subject` varchar(200) DEFAULT NULL COMMENT 'Newsletter Subject',
  `newsletter_sender_name` varchar(200) DEFAULT NULL COMMENT 'Newsletter Sender Name',
  `newsletter_sender_email` varchar(200) DEFAULT NULL COMMENT 'Newsletter Sender Email',
  `queue_status` int unsigned NOT NULL DEFAULT '0' COMMENT 'Queue Status',
  `queue_start_at` timestamp NULL DEFAULT NULL COMMENT 'Queue Start At',
  `queue_finish_at` timestamp NULL DEFAULT NULL COMMENT 'Queue Finish At',
  PRIMARY KEY (`queue_id`),
  KEY `NEWSLETTER_QUEUE_TEMPLATE_ID` (`template_id`),
  CONSTRAINT `NEWSLETTER_QUEUE_TEMPLATE_ID_NEWSLETTER_TEMPLATE_TEMPLATE_ID` FOREIGN KEY (`template_id`) REFERENCES `newsletter_template` (`template_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Newsletter Queue';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `newsletter_queue_link`
--

DROP TABLE IF EXISTS `newsletter_queue_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletter_queue_link` (
  `queue_link_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Queue Link ID',
  `queue_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Queue ID',
  `subscriber_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Subscriber ID',
  `letter_sent_at` timestamp NULL DEFAULT NULL COMMENT 'Letter Sent At',
  PRIMARY KEY (`queue_link_id`),
  KEY `NEWSLETTER_QUEUE_LINK_SUBSCRIBER_ID` (`subscriber_id`),
  KEY `NEWSLETTER_QUEUE_LINK_QUEUE_ID_LETTER_SENT_AT` (`queue_id`,`letter_sent_at`),
  CONSTRAINT `NEWSLETTER_QUEUE_LINK_QUEUE_ID_NEWSLETTER_QUEUE_QUEUE_ID` FOREIGN KEY (`queue_id`) REFERENCES `newsletter_queue` (`queue_id`) ON DELETE CASCADE,
  CONSTRAINT `NLTTR_QUEUE_LNK_SUBSCRIBER_ID_NLTTR_SUBSCRIBER_SUBSCRIBER_ID` FOREIGN KEY (`subscriber_id`) REFERENCES `newsletter_subscriber` (`subscriber_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Newsletter Queue Link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `newsletter_queue_store_link`
--

DROP TABLE IF EXISTS `newsletter_queue_store_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletter_queue_store_link` (
  `queue_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Queue ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  PRIMARY KEY (`queue_id`,`store_id`),
  KEY `NEWSLETTER_QUEUE_STORE_LINK_STORE_ID` (`store_id`),
  CONSTRAINT `NEWSLETTER_QUEUE_STORE_LINK_QUEUE_ID_NEWSLETTER_QUEUE_QUEUE_ID` FOREIGN KEY (`queue_id`) REFERENCES `newsletter_queue` (`queue_id`) ON DELETE CASCADE,
  CONSTRAINT `NEWSLETTER_QUEUE_STORE_LINK_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Newsletter Queue Store Link';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `newsletter_subscriber`
--

DROP TABLE IF EXISTS `newsletter_subscriber`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletter_subscriber` (
  `subscriber_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Subscriber ID',
  `store_id` smallint unsigned DEFAULT '0' COMMENT 'Store ID',
  `change_status_at` timestamp NULL DEFAULT NULL COMMENT 'Change Status At',
  `customer_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer ID',
  `subscriber_email` varchar(150) DEFAULT NULL COMMENT 'Subscriber Email',
  `subscriber_status` int NOT NULL DEFAULT '0' COMMENT 'Subscriber Status',
  `subscriber_confirm_code` varchar(32) DEFAULT 'NULL' COMMENT 'Subscriber Confirm Code',
  PRIMARY KEY (`subscriber_id`),
  KEY `NEWSLETTER_SUBSCRIBER_CUSTOMER_ID` (`customer_id`),
  KEY `NEWSLETTER_SUBSCRIBER_STORE_ID` (`store_id`),
  KEY `NEWSLETTER_SUBSCRIBER_SUBSCRIBER_EMAIL` (`subscriber_email`),
  CONSTRAINT `NEWSLETTER_SUBSCRIBER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Newsletter Subscriber';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `newsletter_template`
--

DROP TABLE IF EXISTS `newsletter_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletter_template` (
  `template_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Template ID',
  `template_code` varchar(150) DEFAULT NULL COMMENT 'Template Code',
  `template_text` text COMMENT 'Template Text',
  `template_styles` text COMMENT 'Template Styles',
  `template_type` int unsigned DEFAULT NULL COMMENT 'Template Type',
  `template_subject` varchar(200) DEFAULT NULL COMMENT 'Template Subject',
  `template_sender_name` varchar(200) DEFAULT NULL COMMENT 'Template Sender Name',
  `template_sender_email` varchar(200) DEFAULT NULL COMMENT 'Template Sender Email',
  `template_actual` smallint unsigned DEFAULT '1' COMMENT 'Template Actual',
  `added_at` timestamp NULL DEFAULT NULL COMMENT 'Added At',
  `modified_at` timestamp NULL DEFAULT NULL COMMENT 'Modified At',
  `is_legacy` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Should the template render in legacy mode',
  PRIMARY KEY (`template_id`),
  KEY `NEWSLETTER_TEMPLATE_TEMPLATE_ACTUAL` (`template_actual`),
  KEY `NEWSLETTER_TEMPLATE_ADDED_AT` (`added_at`),
  KEY `NEWSLETTER_TEMPLATE_MODIFIED_AT` (`modified_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Newsletter Template';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_consumer`
--

DROP TABLE IF EXISTS `oauth_consumer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_consumer` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `name` varchar(255) NOT NULL COMMENT 'Name of consumer',
  `key` varchar(32) NOT NULL COMMENT 'Key code',
  `secret` varchar(128) NOT NULL COMMENT 'Secret code',
  `callback_url` text COMMENT 'Callback URL',
  `rejected_callback_url` text NOT NULL COMMENT 'Rejected callback URL',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `OAUTH_CONSUMER_KEY` (`key`),
  UNIQUE KEY `OAUTH_CONSUMER_SECRET` (`secret`),
  KEY `OAUTH_CONSUMER_CREATED_AT` (`created_at`),
  KEY `OAUTH_CONSUMER_UPDATED_AT` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COMMENT='OAuth Consumers';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_nonce`
--

DROP TABLE IF EXISTS `oauth_nonce`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_nonce` (
  `nonce` varchar(32) NOT NULL COMMENT 'Nonce String',
  `timestamp` int unsigned NOT NULL COMMENT 'Nonce Timestamp',
  `consumer_id` int unsigned NOT NULL COMMENT 'Consumer ID',
  PRIMARY KEY (`nonce`,`consumer_id`),
  KEY `OAUTH_NONCE_CONSUMER_ID_OAUTH_CONSUMER_ENTITY_ID` (`consumer_id`),
  KEY `OAUTH_NONCE_TIMESTAMP` (`timestamp`),
  CONSTRAINT `OAUTH_NONCE_CONSUMER_ID_OAUTH_CONSUMER_ENTITY_ID` FOREIGN KEY (`consumer_id`) REFERENCES `oauth_consumer` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='OAuth Nonce';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_token`
--

DROP TABLE IF EXISTS `oauth_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_token` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `consumer_id` int unsigned DEFAULT NULL COMMENT 'Oauth Consumer ID',
  `admin_id` int unsigned DEFAULT NULL COMMENT 'Admin user ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer user ID',
  `type` varchar(16) NOT NULL COMMENT 'Token Type',
  `token` varchar(32) NOT NULL COMMENT 'Token',
  `secret` varchar(128) NOT NULL COMMENT 'Token Secret',
  `verifier` varchar(32) DEFAULT NULL COMMENT 'Token Verifier',
  `callback_url` text NOT NULL COMMENT 'Token Callback URL',
  `revoked` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Token revoked',
  `authorized` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Token authorized',
  `user_type` int DEFAULT NULL COMMENT 'User type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Token creation timestamp',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `OAUTH_TOKEN_TOKEN` (`token`),
  KEY `OAUTH_TOKEN_ADMIN_ID_ADMIN_USER_USER_ID` (`admin_id`),
  KEY `OAUTH_TOKEN_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` (`customer_id`),
  KEY `OAUTH_TOKEN_CONSUMER_ID` (`consumer_id`),
  KEY `OAUTH_TOKEN_CREATED_AT` (`created_at`),
  CONSTRAINT `OAUTH_TOKEN_ADMIN_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`admin_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE,
  CONSTRAINT `OAUTH_TOKEN_CONSUMER_ID_OAUTH_CONSUMER_ENTITY_ID` FOREIGN KEY (`consumer_id`) REFERENCES `oauth_consumer` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `OAUTH_TOKEN_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COMMENT='OAuth Tokens';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `oauth_token_request_log`
--

DROP TABLE IF EXISTS `oauth_token_request_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_token_request_log` (
  `log_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `user_name` varchar(255) NOT NULL COMMENT 'Customer email or admin login',
  `user_type` smallint unsigned NOT NULL COMMENT 'User type (admin or customer)',
  `failures_count` smallint unsigned DEFAULT '0' COMMENT 'Number of failed authentication attempts in a row',
  `lock_expires_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Lock expiration time',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `OAUTH_TOKEN_REQUEST_LOG_USER_NAME_USER_TYPE` (`user_name`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Log of token request authentication failures.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `otp_token`
--

DROP TABLE IF EXISTS `otp_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `otp_token` (
  `token_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Token ID',
  `token` varchar(128) DEFAULT NULL COMMENT 'Token',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `website_id` smallint unsigned DEFAULT NULL COMMENT 'Website ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `expires_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Expires At',
  `customer_id` int unsigned NOT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `OTP_TOKEN_EMAIL_WEBSITE_ID` (`email`,`website_id`),
  KEY `OTP_TOKEN_STORE_ID_STORE_STORE_ID` (`store_id`),
  KEY `OTP_TOKEN_WEBSITE_ID` (`website_id`),
  CONSTRAINT `OTP_TOKEN_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `OTP_TOKEN_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35467 DEFAULT CHARSET=utf8mb3 COMMENT='Login token storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `pagebuilder_template`
--

DROP TABLE IF EXISTS `pagebuilder_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pagebuilder_template` (
  `template_id` int NOT NULL AUTO_INCREMENT COMMENT 'Template ID Auto Increment',
  `name` varchar(1024) NOT NULL COMMENT 'Template Name',
  `preview_image` varchar(1024) DEFAULT NULL COMMENT 'Template Preview Image',
  `template` longtext NOT NULL COMMENT 'Master Format HTML',
  `created_for` varchar(255) DEFAULT NULL COMMENT 'Created For',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`template_id`),
  FULLTEXT KEY `PAGEBUILDER_TEMPLATE_NAME` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Page Builder Templates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `password_reset_request_event`
--

DROP TABLE IF EXISTS `password_reset_request_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_request_event` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `request_type` smallint unsigned NOT NULL COMMENT 'Type of the event under a security control',
  `account_reference` varchar(255) DEFAULT NULL COMMENT 'An identifier for existing account or another target',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp when the event occurs',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `PASSWORD_RESET_REQUEST_EVENT_ACCOUNT_REFERENCE` (`account_reference`),
  KEY `PASSWORD_RESET_REQUEST_EVENT_CREATED_AT` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Password Reset Request Event under a security control';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `patch_list`
--

DROP TABLE IF EXISTS `patch_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `patch_list` (
  `patch_id` int NOT NULL AUTO_INCREMENT COMMENT 'Patch Auto Increment',
  `patch_name` varchar(1024) NOT NULL COMMENT 'Patch Class Name',
  PRIMARY KEY (`patch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8mb3 COMMENT='List of data/schema patches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_order_data_production_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_order_data_production_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_order_data_production_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Order identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Order Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_order_data_sandbox_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_order_data_sandbox_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_order_data_sandbox_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Order identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Order Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_order_status_data_prod_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_order_status_data_prod_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_order_status_data_prod_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Order Status identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Order Status Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_order_status_data_production_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_order_status_data_production_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_order_status_data_production_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Order Status identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Order Status Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_order_status_data_sandbox_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_order_status_data_sandbox_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_order_status_data_sandbox_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Order Status identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Order Status Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_store_data_production_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_store_data_production_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_store_data_production_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Store identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Store Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `payment_services_store_data_sandbox_submitted_hash`
--

DROP TABLE IF EXISTS `payment_services_store_data_sandbox_submitted_hash`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_services_store_data_sandbox_submitted_hash` (
  `identifier` varchar(64) NOT NULL COMMENT 'Store identifier',
  `feed_hash` varchar(64) NOT NULL COMMENT 'feed_hash',
  `submitted_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Submitted At',
  PRIMARY KEY (`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Payment Services Store Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paypal_billing_agreement`
--

DROP TABLE IF EXISTS `paypal_billing_agreement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_billing_agreement` (
  `agreement_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Agreement ID',
  `customer_id` int unsigned NOT NULL COMMENT 'Customer ID',
  `method_code` varchar(32) NOT NULL COMMENT 'Method Code',
  `reference_id` varchar(32) NOT NULL COMMENT 'Reference ID',
  `status` varchar(20) NOT NULL COMMENT 'Status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `agreement_label` varchar(255) DEFAULT NULL COMMENT 'Agreement Label',
  PRIMARY KEY (`agreement_id`),
  KEY `PAYPAL_BILLING_AGREEMENT_CUSTOMER_ID` (`customer_id`),
  KEY `PAYPAL_BILLING_AGREEMENT_STORE_ID` (`store_id`),
  CONSTRAINT `PAYPAL_BILLING_AGREEMENT_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PAYPAL_BILLING_AGREEMENT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Billing Agreement';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paypal_billing_agreement_order`
--

DROP TABLE IF EXISTS `paypal_billing_agreement_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_billing_agreement_order` (
  `agreement_id` int unsigned NOT NULL COMMENT 'Agreement ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  PRIMARY KEY (`agreement_id`,`order_id`),
  KEY `PAYPAL_BILLING_AGREEMENT_ORDER_ORDER_ID` (`order_id`),
  CONSTRAINT `PAYPAL_BILLING_AGREEMENT_ORDER_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PAYPAL_BILLING_AGRT_ORDER_AGRT_ID_PAYPAL_BILLING_AGRT_AGRT_ID` FOREIGN KEY (`agreement_id`) REFERENCES `paypal_billing_agreement` (`agreement_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Billing Agreement Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paypal_cert`
--

DROP TABLE IF EXISTS `paypal_cert`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_cert` (
  `cert_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Cert ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `content` text COMMENT 'Content',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  PRIMARY KEY (`cert_id`),
  KEY `PAYPAL_CERT_WEBSITE_ID` (`website_id`),
  CONSTRAINT `PAYPAL_CERT_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Paypal Certificate Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paypal_payment_transaction`
--

DROP TABLE IF EXISTS `paypal_payment_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_payment_transaction` (
  `transaction_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `txn_id` varchar(100) DEFAULT NULL COMMENT 'Txn ID',
  `additional_information` blob COMMENT 'Additional Information',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  PRIMARY KEY (`transaction_id`),
  UNIQUE KEY `PAYPAL_PAYMENT_TRANSACTION_TXN_ID` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='PayPal Payflow Link Payment Transaction';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paypal_settlement_report`
--

DROP TABLE IF EXISTS `paypal_settlement_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_settlement_report` (
  `report_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Report ID',
  `report_date` date DEFAULT NULL COMMENT 'Report Date',
  `account_id` varchar(64) DEFAULT NULL COMMENT 'Account ID',
  `filename` varchar(24) DEFAULT NULL COMMENT 'Filename',
  `last_modified` timestamp NULL DEFAULT NULL COMMENT 'Last Modified',
  PRIMARY KEY (`report_id`),
  UNIQUE KEY `PAYPAL_SETTLEMENT_REPORT_REPORT_DATE_ACCOUNT_ID` (`report_date`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Paypal Settlement Report Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `paypal_settlement_report_row`
--

DROP TABLE IF EXISTS `paypal_settlement_report_row`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `paypal_settlement_report_row` (
  `row_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Row ID',
  `report_id` int unsigned NOT NULL COMMENT 'Report ID',
  `transaction_id` varchar(19) DEFAULT NULL COMMENT 'Transaction ID',
  `invoice_id` varchar(127) DEFAULT NULL COMMENT 'Invoice ID',
  `paypal_reference_id` varchar(19) DEFAULT NULL COMMENT 'Paypal Reference ID',
  `paypal_reference_id_type` varchar(3) DEFAULT NULL COMMENT 'Paypal Reference ID Type',
  `transaction_event_code` varchar(5) DEFAULT NULL COMMENT 'Transaction Event Code',
  `transaction_initiation_date` timestamp NULL DEFAULT NULL COMMENT 'Transaction Initiation Date',
  `transaction_completion_date` timestamp NULL DEFAULT NULL COMMENT 'Transaction Completion Date',
  `transaction_debit_or_credit` varchar(2) NOT NULL DEFAULT 'CR' COMMENT 'Transaction Debit Or Credit',
  `gross_transaction_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Gross Transaction Amount',
  `gross_transaction_currency` varchar(3) DEFAULT NULL COMMENT 'Gross Transaction Currency',
  `fee_debit_or_credit` varchar(2) DEFAULT NULL COMMENT 'Fee Debit Or Credit',
  `fee_amount` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Fee Amount',
  `fee_currency` varchar(3) DEFAULT NULL COMMENT 'Fee Currency',
  `custom_field` varchar(255) DEFAULT NULL COMMENT 'Custom Field',
  `consumer_id` varchar(127) DEFAULT NULL COMMENT 'Consumer ID',
  `payment_tracking_id` varchar(255) DEFAULT NULL COMMENT 'Payment Tracking ID',
  `store_id` varchar(50) DEFAULT NULL COMMENT 'Store ID',
  PRIMARY KEY (`row_id`),
  KEY `PAYPAL_SETTLEMENT_REPORT_ROW_REPORT_ID` (`report_id`),
  CONSTRAINT `FK_E183E488F593E0DE10C6EBFFEBAC9B55` FOREIGN KEY (`report_id`) REFERENCES `paypal_settlement_report` (`report_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Paypal Settlement Report Row Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `persistent_session`
--

DROP TABLE IF EXISTS `persistent_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `persistent_session` (
  `persistent_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Session ID',
  `key` varchar(50) NOT NULL COMMENT 'Unique cookie key',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `info` text COMMENT 'Session Data',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`persistent_id`),
  UNIQUE KEY `PERSISTENT_SESSION_KEY` (`key`),
  UNIQUE KEY `PERSISTENT_SESSION_CUSTOMER_ID` (`customer_id`),
  KEY `PERSISTENT_SESSION_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` (`website_id`),
  KEY `PERSISTENT_SESSION_UPDATED_AT` (`updated_at`),
  CONSTRAINT `PERSISTENT_SESSION_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PERSISTENT_SESSION_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Persistent Session';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `product_alert_price`
--

DROP TABLE IF EXISTS `product_alert_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_alert_price` (
  `alert_price_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product alert price ID',
  `customer_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `price` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Price amount',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `store_id` smallint unsigned DEFAULT '0' COMMENT 'Store ID',
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Product alert add date',
  `last_send_date` timestamp NULL DEFAULT NULL COMMENT 'Product alert last send date',
  `send_count` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Product alert send count',
  `status` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Product alert status',
  PRIMARY KEY (`alert_price_id`),
  KEY `PRODUCT_ALERT_PRICE_CUSTOMER_ID` (`customer_id`),
  KEY `PRODUCT_ALERT_PRICE_PRODUCT_ID` (`product_id`),
  KEY `PRODUCT_ALERT_PRICE_WEBSITE_ID` (`website_id`),
  KEY `PRODUCT_ALERT_PRICE_STORE_ID` (`store_id`),
  CONSTRAINT `PRODUCT_ALERT_PRICE_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PRODUCT_ALERT_PRICE_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PRODUCT_ALERT_PRICE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `PRODUCT_ALERT_PRICE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Product Alert Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `product_alert_stock`
--

DROP TABLE IF EXISTS `product_alert_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_alert_stock` (
  `alert_stock_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Product alert stock ID',
  `customer_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `store_id` smallint unsigned DEFAULT '0' COMMENT 'Store ID',
  `add_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Product alert add date',
  `send_date` timestamp NULL DEFAULT NULL COMMENT 'Product alert send date',
  `send_count` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Send Count',
  `status` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Product alert status',
  PRIMARY KEY (`alert_stock_id`),
  KEY `PRODUCT_ALERT_STOCK_CUSTOMER_ID` (`customer_id`),
  KEY `PRODUCT_ALERT_STOCK_PRODUCT_ID` (`product_id`),
  KEY `PRODUCT_ALERT_STOCK_WEBSITE_ID` (`website_id`),
  KEY `PRODUCT_ALERT_STOCK_STORE_ID` (`store_id`),
  CONSTRAINT `PRODUCT_ALERT_STOCK_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PRODUCT_ALERT_STOCK_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `PRODUCT_ALERT_STOCK_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `PRODUCT_ALERT_STOCK_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Product Alert Stock';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Queue ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Queue name',
  PRIMARY KEY (`id`),
  UNIQUE KEY `QUEUE_NAME` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3 COMMENT='Table storing unique queues';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_lock`
--

DROP TABLE IF EXISTS `queue_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue_lock` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Message ID',
  `message_code` varchar(255) NOT NULL DEFAULT '' COMMENT 'Message Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`id`),
  UNIQUE KEY `QUEUE_LOCK_MESSAGE_CODE` (`message_code`)
) ENGINE=InnoDB AUTO_INCREMENT=283328 DEFAULT CHARSET=utf8mb3 COMMENT='Messages that were processed are inserted here to be locked.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_message`
--

DROP TABLE IF EXISTS `queue_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue_message` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Message ID',
  `topic_name` varchar(255) DEFAULT NULL COMMENT 'Message topic',
  `body` longtext COMMENT 'Message body',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=664236 DEFAULT CHARSET=utf8mb3 COMMENT='Queue messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_message_status`
--

DROP TABLE IF EXISTS `queue_message_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue_message_status` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Relation ID',
  `queue_id` int unsigned NOT NULL COMMENT 'Queue ID',
  `message_id` bigint unsigned NOT NULL COMMENT 'Message ID',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `status` smallint unsigned NOT NULL COMMENT 'Message status in particular queue',
  `number_of_trials` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Number of trials to processed failed message processing',
  PRIMARY KEY (`id`),
  UNIQUE KEY `QUEUE_MESSAGE_STATUS_QUEUE_ID_MESSAGE_ID` (`queue_id`,`message_id`),
  KEY `QUEUE_MESSAGE_STATUS_MESSAGE_ID_QUEUE_MESSAGE_ID` (`message_id`),
  KEY `QUEUE_MESSAGE_STATUS_STATUS_UPDATED_AT` (`status`,`updated_at`),
  CONSTRAINT `QUEUE_MESSAGE_STATUS_MESSAGE_ID_QUEUE_MESSAGE_ID` FOREIGN KEY (`message_id`) REFERENCES `queue_message` (`id`) ON DELETE CASCADE,
  CONSTRAINT `QUEUE_MESSAGE_STATUS_QUEUE_ID_QUEUE_ID` FOREIGN KEY (`queue_id`) REFERENCES `queue` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=664236 DEFAULT CHARSET=utf8mb3 COMMENT='Relation table to keep associations between queues and messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_poison_pill`
--

DROP TABLE IF EXISTS `queue_poison_pill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue_poison_pill` (
  `version` varchar(255) NOT NULL COMMENT 'Poison Pill version.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sequence table for poison pill versions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote`
--

DROP TABLE IF EXISTS `quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `converted_at` timestamp NULL DEFAULT NULL COMMENT 'Converted At',
  `is_active` smallint unsigned DEFAULT '1' COMMENT 'Is Active',
  `is_virtual` smallint unsigned DEFAULT '0' COMMENT 'Is Virtual',
  `is_multi_shipping` smallint unsigned DEFAULT '0' COMMENT 'Is Multi Shipping',
  `items_count` int unsigned DEFAULT '0' COMMENT 'Items Count',
  `items_qty` decimal(12,4) DEFAULT '0.0000' COMMENT 'Items Qty',
  `orig_order_id` int unsigned DEFAULT '0' COMMENT 'Orig Order ID',
  `store_to_base_rate` decimal(12,4) DEFAULT '0.0000' COMMENT 'Store To Base Rate',
  `store_to_quote_rate` decimal(12,4) DEFAULT '0.0000' COMMENT 'Store To Quote Rate',
  `base_currency_code` varchar(255) DEFAULT NULL COMMENT 'Base Currency Code',
  `store_currency_code` varchar(255) DEFAULT NULL COMMENT 'Store Currency Code',
  `quote_currency_code` varchar(255) DEFAULT NULL COMMENT 'Quote Currency Code',
  `grand_total` decimal(20,4) DEFAULT '0.0000' COMMENT 'Grand Total',
  `base_grand_total` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Grand Total',
  `checkout_method` varchar(255) DEFAULT NULL COMMENT 'Checkout Method',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `customer_tax_class_id` int unsigned DEFAULT NULL COMMENT 'Customer Tax Class ID',
  `customer_group_id` int unsigned DEFAULT '0' COMMENT 'Customer Group ID',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  `customer_prefix` varchar(40) DEFAULT NULL COMMENT 'Customer Prefix',
  `customer_firstname` varchar(255) DEFAULT NULL COMMENT 'Customer Firstname',
  `customer_middlename` varchar(40) DEFAULT NULL COMMENT 'Customer Middlename',
  `customer_lastname` varchar(255) DEFAULT NULL COMMENT 'Customer Lastname',
  `customer_suffix` varchar(40) DEFAULT NULL COMMENT 'Customer Suffix',
  `customer_dob` datetime DEFAULT NULL COMMENT 'Customer Dob',
  `customer_note` text COMMENT 'Customer Note',
  `customer_note_notify` smallint unsigned DEFAULT '1' COMMENT 'Customer Note Notify',
  `customer_is_guest` smallint unsigned DEFAULT '0' COMMENT 'Customer Is Guest',
  `remote_ip` varchar(45) DEFAULT NULL COMMENT 'Remote Ip',
  `applied_rule_ids` varchar(255) DEFAULT NULL COMMENT 'Applied Rule Ids',
  `reserved_order_id` varchar(64) DEFAULT NULL COMMENT 'Reserved Order ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `coupon_code` varchar(255) DEFAULT NULL COMMENT 'Coupon Code',
  `global_currency_code` varchar(255) DEFAULT NULL COMMENT 'Global Currency Code',
  `base_to_global_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Global Rate',
  `base_to_quote_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Quote Rate',
  `customer_taxvat` varchar(255) DEFAULT NULL COMMENT 'Customer Taxvat',
  `customer_gender` varchar(255) DEFAULT NULL COMMENT 'Customer Gender',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `base_subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal',
  `subtotal_with_discount` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal With Discount',
  `base_subtotal_with_discount` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal With Discount',
  `is_changed` int unsigned DEFAULT NULL COMMENT 'Is Changed',
  `trigger_recollect` smallint NOT NULL DEFAULT '0' COMMENT 'Trigger Recollect',
  `ext_shipping_info` text COMMENT 'Ext Shipping Info',
  `gift_message_id` int DEFAULT NULL COMMENT 'Gift Message ID',
  `is_persistent` smallint unsigned DEFAULT '0' COMMENT 'Is Quote Persistent',
  `mailchimp_abandonedcart_flag` tinyint(1) NOT NULL COMMENT 'Retrieved from Mailchimp',
  `mailchimp_campaign_id` varchar(16) DEFAULT NULL COMMENT 'Campaign',
  `mailchimp_landing_page` text NOT NULL COMMENT 'Landing Page',
  `kl_sms_consent` text COMMENT 'SMS Consent',
  `kl_email_consent` text COMMENT 'Email Consent',
  PRIMARY KEY (`entity_id`),
  KEY `QUOTE_CUSTOMER_ID_STORE_ID_IS_ACTIVE` (`customer_id`,`store_id`,`is_active`),
  KEY `QUOTE_STORE_ID_UPDATED_AT` (`store_id`,`updated_at`),
  CONSTRAINT `QUOTE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_address`
--

DROP TABLE IF EXISTS `quote_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_address` (
  `address_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Address ID',
  `quote_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Quote ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `save_in_address_book` smallint DEFAULT '0' COMMENT 'Save In Address Book',
  `customer_address_id` int unsigned DEFAULT NULL COMMENT 'Customer Address ID',
  `address_type` varchar(10) DEFAULT NULL COMMENT 'Address Type',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `prefix` varchar(40) DEFAULT NULL COMMENT 'Prefix',
  `firstname` varchar(255) DEFAULT NULL,
  `middlename` varchar(40) DEFAULT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `suffix` varchar(40) DEFAULT NULL COMMENT 'Suffix',
  `company` varchar(255) DEFAULT NULL COMMENT 'Company',
  `street` varchar(255) DEFAULT NULL COMMENT 'Street',
  `city` varchar(255) DEFAULT NULL,
  `region` varchar(255) DEFAULT NULL,
  `region_id` int unsigned DEFAULT NULL COMMENT 'Region ID',
  `postcode` varchar(20) DEFAULT NULL COMMENT 'Postcode',
  `country_id` varchar(30) DEFAULT NULL COMMENT 'Country ID',
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `same_as_billing` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Same As Billing',
  `collect_shipping_rates` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Collect Shipping Rates',
  `shipping_method` varchar(120) DEFAULT NULL,
  `shipping_description` varchar(255) DEFAULT NULL COMMENT 'Shipping Description',
  `weight` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Weight',
  `subtotal` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal',
  `base_subtotal` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Subtotal',
  `subtotal_with_discount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal With Discount',
  `base_subtotal_with_discount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Subtotal With Discount',
  `tax_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Tax Amount',
  `base_tax_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Tax Amount',
  `shipping_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Shipping Amount',
  `base_shipping_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Shipping Amount',
  `shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Tax Amount',
  `base_shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Tax Amount',
  `discount_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `base_discount_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Discount Amount',
  `grand_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Grand Total',
  `base_grand_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Grand Total',
  `customer_notes` text COMMENT 'Customer Notes',
  `applied_taxes` text COMMENT 'Applied Taxes',
  `discount_description` varchar(255) DEFAULT NULL COMMENT 'Discount Description',
  `shipping_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Discount Amount',
  `base_shipping_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Discount Amount',
  `subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Incl Tax',
  `base_subtotal_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Total Incl Tax',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `shipping_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Discount Tax Compensation Amount',
  `base_shipping_discount_tax_compensation_amnt` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Discount Tax Compensation Amount',
  `shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Incl Tax',
  `base_shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Incl Tax',
  `vat_id` text COMMENT 'Vat ID',
  `vat_is_valid` smallint DEFAULT NULL COMMENT 'Vat Is Valid',
  `vat_request_id` text COMMENT 'Vat Request ID',
  `vat_request_date` text COMMENT 'Vat Request Date',
  `vat_request_success` smallint DEFAULT NULL COMMENT 'Vat Request Success',
  `validated_country_code` text COMMENT 'Validated Country Code',
  `validated_vat_number` text COMMENT 'Validated Vat Number',
  `gift_message_id` int DEFAULT NULL COMMENT 'Gift Message ID',
  `free_shipping` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Free Shipping',
  PRIMARY KEY (`address_id`),
  KEY `QUOTE_ADDRESS_QUOTE_ID` (`quote_id`),
  CONSTRAINT `QUOTE_ADDRESS_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote Address';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_address_item`
--

DROP TABLE IF EXISTS `quote_address_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_address_item` (
  `address_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Address Item ID',
  `parent_item_id` int unsigned DEFAULT NULL COMMENT 'Parent Item ID',
  `quote_address_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Quote Address ID',
  `quote_item_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Quote Item ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `applied_rule_ids` text COMMENT 'Applied Rule Ids',
  `additional_data` text COMMENT 'Additional Data',
  `weight` decimal(12,4) DEFAULT '0.0000' COMMENT 'Weight',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `discount_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Discount Amount',
  `tax_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Tax Amount',
  `row_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Row Total',
  `base_row_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Row Total',
  `row_total_with_discount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Row Total With Discount',
  `base_discount_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Discount Amount',
  `base_tax_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Tax Amount',
  `row_weight` decimal(12,4) DEFAULT '0.0000' COMMENT 'Row Weight',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `super_product_id` int unsigned DEFAULT NULL COMMENT 'Super Product ID',
  `parent_product_id` int unsigned DEFAULT NULL COMMENT 'Parent Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `sku` varchar(255) DEFAULT NULL COMMENT 'Sku',
  `image` varchar(255) DEFAULT NULL COMMENT 'Image',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `is_qty_decimal` int unsigned DEFAULT NULL COMMENT 'Is Qty Decimal',
  `price` decimal(12,4) DEFAULT NULL COMMENT 'Price',
  `discount_percent` decimal(12,4) DEFAULT NULL COMMENT 'Discount Percent',
  `no_discount` int unsigned DEFAULT NULL COMMENT 'No Discount',
  `tax_percent` decimal(12,4) DEFAULT NULL COMMENT 'Tax Percent',
  `base_price` decimal(20,4) DEFAULT NULL COMMENT 'Base Price',
  `base_cost` decimal(20,4) DEFAULT NULL COMMENT 'Base Cost',
  `price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Price Incl Tax',
  `base_price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Price Incl Tax',
  `row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Row Total Incl Tax',
  `base_row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total Incl Tax',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `gift_message_id` int DEFAULT NULL COMMENT 'Gift Message ID',
  `free_shipping` int unsigned DEFAULT NULL COMMENT 'Free Shipping',
  PRIMARY KEY (`address_item_id`),
  KEY `QUOTE_ADDRESS_ITEM_QUOTE_ADDRESS_ID` (`quote_address_id`),
  KEY `QUOTE_ADDRESS_ITEM_PARENT_ITEM_ID` (`parent_item_id`),
  KEY `QUOTE_ADDRESS_ITEM_QUOTE_ITEM_ID` (`quote_item_id`),
  KEY `QUOTE_ADDRESS_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `QUOTE_ADDR_ITEM_PARENT_ITEM_ID_QUOTE_ADDR_ITEM_ADDR_ITEM_ID` FOREIGN KEY (`parent_item_id`) REFERENCES `quote_address_item` (`address_item_id`) ON DELETE CASCADE,
  CONSTRAINT `QUOTE_ADDRESS_ITEM_QUOTE_ADDRESS_ID_QUOTE_ADDRESS_ADDRESS_ID` FOREIGN KEY (`quote_address_id`) REFERENCES `quote_address` (`address_id`) ON DELETE CASCADE,
  CONSTRAINT `QUOTE_ADDRESS_ITEM_QUOTE_ITEM_ID_QUOTE_ITEM_ITEM_ID` FOREIGN KEY (`quote_item_id`) REFERENCES `quote_item` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote Address Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_id_mask`
--

DROP TABLE IF EXISTS `quote_id_mask`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_id_mask` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `quote_id` int unsigned NOT NULL COMMENT 'Quote ID',
  `masked_id` varchar(32) DEFAULT NULL COMMENT 'Masked ID',
  PRIMARY KEY (`entity_id`,`quote_id`),
  KEY `QUOTE_ID_MASK_QUOTE_ID` (`quote_id`),
  KEY `QUOTE_ID_MASK_MASKED_ID` (`masked_id`),
  CONSTRAINT `QUOTE_ID_MASK_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=190182 DEFAULT CHARSET=utf8mb3 COMMENT='Quote ID and masked ID mapping';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_item`
--

DROP TABLE IF EXISTS `quote_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_item` (
  `item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item ID',
  `quote_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Quote ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `parent_item_id` int unsigned DEFAULT NULL COMMENT 'Parent Item ID',
  `is_virtual` smallint unsigned DEFAULT NULL COMMENT 'Is Virtual',
  `sku` varchar(255) DEFAULT NULL COMMENT 'Sku',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `applied_rule_ids` text COMMENT 'Applied Rule Ids',
  `additional_data` text COMMENT 'Additional Data',
  `is_qty_decimal` smallint unsigned DEFAULT NULL COMMENT 'Is Qty Decimal',
  `no_discount` smallint unsigned DEFAULT '0' COMMENT 'No Discount',
  `weight` decimal(12,4) DEFAULT '0.0000' COMMENT 'Weight',
  `qty` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty',
  `price` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `base_price` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Price',
  `custom_price` decimal(20,4) DEFAULT NULL COMMENT 'Custom Price',
  `discount_percent` decimal(12,4) DEFAULT '0.0000' COMMENT 'Discount Percent',
  `discount_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Discount Amount',
  `base_discount_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Discount Amount',
  `tax_percent` decimal(12,4) DEFAULT '0.0000' COMMENT 'Tax Percent',
  `tax_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Tax Amount',
  `base_tax_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Tax Amount',
  `row_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Row Total',
  `base_row_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Row Total',
  `row_total_with_discount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Row Total With Discount',
  `row_weight` decimal(12,4) DEFAULT '0.0000' COMMENT 'Row Weight',
  `product_type` varchar(255) DEFAULT NULL COMMENT 'Product Type',
  `base_tax_before_discount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Before Discount',
  `tax_before_discount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Before Discount',
  `original_custom_price` decimal(20,4) DEFAULT NULL COMMENT 'Original Custom Price',
  `redirect_url` varchar(255) DEFAULT NULL COMMENT 'Redirect Url',
  `base_cost` decimal(12,4) DEFAULT NULL COMMENT 'Base Cost',
  `price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Price Incl Tax',
  `base_price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Price Incl Tax',
  `row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Row Total Incl Tax',
  `base_row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total Incl Tax',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `gift_message_id` int DEFAULT NULL COMMENT 'Gift Message ID',
  `free_shipping` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Free Shipping',
  `weee_tax_applied` text COMMENT 'Weee Tax Applied',
  `weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Amount',
  `weee_tax_applied_row_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Row Amount',
  `weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Disposition',
  `weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Row Disposition',
  `base_weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Amount',
  `base_weee_tax_applied_row_amnt` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Row Amnt',
  `base_weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Disposition',
  `base_weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Row Disposition',
  PRIMARY KEY (`item_id`),
  KEY `QUOTE_ITEM_PARENT_ITEM_ID` (`parent_item_id`),
  KEY `QUOTE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `QUOTE_ITEM_QUOTE_ID` (`quote_id`),
  KEY `QUOTE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `QUOTE_ITEM_PARENT_ITEM_ID_QUOTE_ITEM_ITEM_ID` FOREIGN KEY (`parent_item_id`) REFERENCES `quote_item` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `QUOTE_ITEM_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `QUOTE_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_item_option`
--

DROP TABLE IF EXISTS `quote_item_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_item_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `item_id` int unsigned NOT NULL COMMENT 'Item ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT 'Value',
  PRIMARY KEY (`option_id`),
  KEY `QUOTE_ITEM_OPTION_ITEM_ID` (`item_id`),
  CONSTRAINT `QUOTE_ITEM_OPTION_ITEM_ID_QUOTE_ITEM_ITEM_ID` FOREIGN KEY (`item_id`) REFERENCES `quote_item` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote Item Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_payment`
--

DROP TABLE IF EXISTS `quote_payment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_payment` (
  `payment_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Payment ID',
  `quote_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Quote ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `method` varchar(255) DEFAULT NULL COMMENT 'Method',
  `cc_type` varchar(255) DEFAULT NULL COMMENT 'Cc Type',
  `cc_number_enc` varchar(255) DEFAULT NULL COMMENT 'Cc Number Enc',
  `cc_last_4` varchar(255) DEFAULT NULL COMMENT 'Cc Last 4',
  `cc_cid_enc` varchar(255) DEFAULT NULL COMMENT 'Cc Cid Enc',
  `cc_owner` varchar(255) DEFAULT NULL COMMENT 'Cc Owner',
  `cc_exp_month` varchar(255) DEFAULT NULL COMMENT 'Cc Exp Month',
  `cc_exp_year` smallint unsigned DEFAULT '0' COMMENT 'Cc Exp Year',
  `cc_ss_owner` varchar(255) DEFAULT NULL COMMENT 'Cc Ss Owner',
  `cc_ss_start_month` smallint unsigned DEFAULT '0' COMMENT 'Cc Ss Start Month',
  `cc_ss_start_year` smallint unsigned DEFAULT '0' COMMENT 'Cc Ss Start Year',
  `po_number` varchar(255) DEFAULT NULL COMMENT 'Po Number',
  `additional_data` text COMMENT 'Additional Data',
  `cc_ss_issue` varchar(255) DEFAULT NULL COMMENT 'Cc Ss Issue',
  `additional_information` text COMMENT 'Additional Information',
  `paypal_payer_id` varchar(255) DEFAULT NULL COMMENT 'Paypal Payer ID',
  `paypal_payer_status` varchar(255) DEFAULT NULL COMMENT 'Paypal Payer Status',
  `paypal_correlation_id` varchar(255) DEFAULT NULL COMMENT 'Paypal Correlation ID',
  PRIMARY KEY (`payment_id`),
  KEY `QUOTE_PAYMENT_QUOTE_ID` (`quote_id`),
  CONSTRAINT `QUOTE_PAYMENT_QUOTE_ID_QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote Payment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `quote_shipping_rate`
--

DROP TABLE IF EXISTS `quote_shipping_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `quote_shipping_rate` (
  `rate_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rate ID',
  `address_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Address ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `carrier` varchar(255) DEFAULT NULL COMMENT 'Carrier',
  `carrier_title` varchar(255) DEFAULT NULL COMMENT 'Carrier Title',
  `code` varchar(255) DEFAULT NULL COMMENT 'Code',
  `method` varchar(255) DEFAULT NULL COMMENT 'Method',
  `method_description` text COMMENT 'Method Description',
  `price` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `error_message` text COMMENT 'Error Message',
  `method_title` text COMMENT 'Method Title',
  PRIMARY KEY (`rate_id`),
  KEY `QUOTE_SHIPPING_RATE_ADDRESS_ID` (`address_id`),
  CONSTRAINT `QUOTE_SHIPPING_RATE_ADDRESS_ID_QUOTE_ADDRESS_ADDRESS_ID` FOREIGN KEY (`address_id`) REFERENCES `quote_address` (`address_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Quote Shipping Rate';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating`
--

DROP TABLE IF EXISTS `rating`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating` (
  `rating_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rating ID',
  `entity_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `rating_code` varchar(64) NOT NULL COMMENT 'Rating Code',
  `position` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Position On Storefront',
  `is_active` smallint NOT NULL DEFAULT '1' COMMENT 'Rating is active.',
  PRIMARY KEY (`rating_id`),
  UNIQUE KEY `RATING_RATING_CODE` (`rating_code`),
  KEY `RATING_ENTITY_ID` (`entity_id`),
  CONSTRAINT `RATING_ENTITY_ID_RATING_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `rating_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Ratings';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating_entity`
--

DROP TABLE IF EXISTS `rating_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating_entity` (
  `entity_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `entity_code` varchar(64) NOT NULL COMMENT 'Entity Code',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `RATING_ENTITY_ENTITY_CODE` (`entity_code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Rating entities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating_option`
--

DROP TABLE IF EXISTS `rating_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rating Option ID',
  `rating_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating ID',
  `code` varchar(32) NOT NULL COMMENT 'Rating Option Code',
  `value` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Option Value',
  `position` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Ration option position on Storefront',
  PRIMARY KEY (`option_id`),
  KEY `RATING_OPTION_RATING_ID` (`rating_id`),
  CONSTRAINT `RATING_OPTION_RATING_ID_RATING_RATING_ID` FOREIGN KEY (`rating_id`) REFERENCES `rating` (`rating_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COMMENT='Rating options';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating_option_vote`
--

DROP TABLE IF EXISTS `rating_option_vote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating_option_vote` (
  `vote_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Vote ID',
  `option_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Vote option ID',
  `remote_ip` varchar(16) NOT NULL COMMENT 'Customer IP',
  `remote_ip_long` bigint NOT NULL DEFAULT '0' COMMENT 'Customer IP converted to long integer format',
  `customer_id` int unsigned DEFAULT '0' COMMENT 'Customer ID',
  `entity_pk_value` bigint unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `rating_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating ID',
  `review_id` bigint unsigned DEFAULT NULL COMMENT 'Review ID',
  `percent` smallint NOT NULL DEFAULT '0' COMMENT 'Percent amount',
  `value` smallint NOT NULL DEFAULT '0' COMMENT 'Vote option value',
  PRIMARY KEY (`vote_id`),
  KEY `RATING_OPTION_VOTE_REVIEW_ID_REVIEW_REVIEW_ID` (`review_id`),
  KEY `RATING_OPTION_VOTE_OPTION_ID` (`option_id`),
  CONSTRAINT `RATING_OPTION_VOTE_OPTION_ID_RATING_OPTION_OPTION_ID` FOREIGN KEY (`option_id`) REFERENCES `rating_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `RATING_OPTION_VOTE_REVIEW_ID_REVIEW_REVIEW_ID` FOREIGN KEY (`review_id`) REFERENCES `review` (`review_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Rating option values';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating_option_vote_aggregated`
--

DROP TABLE IF EXISTS `rating_option_vote_aggregated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating_option_vote_aggregated` (
  `primary_id` int NOT NULL AUTO_INCREMENT COMMENT 'Vote aggregation ID',
  `rating_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating ID',
  `entity_pk_value` bigint unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `vote_count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Vote dty',
  `vote_value_sum` int unsigned NOT NULL DEFAULT '0' COMMENT 'General vote sum',
  `percent` smallint NOT NULL DEFAULT '0' COMMENT 'Vote percent',
  `percent_approved` smallint DEFAULT '0' COMMENT 'Vote percent approved by admin',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  PRIMARY KEY (`primary_id`),
  KEY `RATING_OPTION_VOTE_AGGREGATED_RATING_ID` (`rating_id`),
  KEY `RATING_OPTION_VOTE_AGGREGATED_STORE_ID` (`store_id`),
  CONSTRAINT `RATING_OPTION_VOTE_AGGREGATED_RATING_ID_RATING_RATING_ID` FOREIGN KEY (`rating_id`) REFERENCES `rating` (`rating_id`) ON DELETE CASCADE,
  CONSTRAINT `RATING_OPTION_VOTE_AGGREGATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Rating vote aggregated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating_store`
--

DROP TABLE IF EXISTS `rating_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating_store` (
  `rating_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  PRIMARY KEY (`rating_id`,`store_id`),
  KEY `RATING_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `RATING_STORE_RATING_ID_RATING_RATING_ID` FOREIGN KEY (`rating_id`) REFERENCES `rating` (`rating_id`) ON DELETE CASCADE,
  CONSTRAINT `RATING_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Rating Store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rating_title`
--

DROP TABLE IF EXISTS `rating_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `rating_title` (
  `rating_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `value` varchar(255) NOT NULL COMMENT 'Rating Label',
  PRIMARY KEY (`rating_id`,`store_id`),
  KEY `RATING_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `RATING_TITLE_RATING_ID_RATING_RATING_ID` FOREIGN KEY (`rating_id`) REFERENCES `rating` (`rating_id`) ON DELETE CASCADE,
  CONSTRAINT `RATING_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Rating Title';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `release_notification_viewer_log`
--

DROP TABLE IF EXISTS `release_notification_viewer_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `release_notification_viewer_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `viewer_id` int unsigned NOT NULL COMMENT 'Viewer admin user ID',
  `last_view_version` varchar(16) NOT NULL COMMENT 'Viewer last view on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `RELEASE_NOTIFICATION_VIEWER_LOG_VIEWER_ID` (`viewer_id`),
  CONSTRAINT `RELEASE_NOTIFICATION_VIEWER_LOG_VIEWER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`viewer_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Release Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_compared_product_index`
--

DROP TABLE IF EXISTS `report_compared_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_compared_product_index` (
  `index_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Index ID',
  `visitor_id` int unsigned DEFAULT NULL COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `added_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Added At',
  PRIMARY KEY (`index_id`),
  UNIQUE KEY `REPORT_COMPARED_PRODUCT_INDEX_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  UNIQUE KEY `REPORT_COMPARED_PRODUCT_INDEX_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `REPORT_COMPARED_PRODUCT_INDEX_STORE_ID` (`store_id`),
  KEY `REPORT_COMPARED_PRODUCT_INDEX_ADDED_AT` (`added_at`),
  KEY `REPORT_COMPARED_PRODUCT_INDEX_PRODUCT_ID` (`product_id`),
  CONSTRAINT `REPORT_CMPD_PRD_IDX_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_CMPD_PRD_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_COMPARED_PRODUCT_INDEX_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Reports Compared Product Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_event`
--

DROP TABLE IF EXISTS `report_event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_event` (
  `event_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Event ID',
  `logged_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Logged At',
  `event_type_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Event Type ID',
  `object_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Object ID',
  `subject_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Subject ID',
  `subtype` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Subtype',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`event_id`),
  KEY `REPORT_EVENT_EVENT_TYPE_ID` (`event_type_id`),
  KEY `REPORT_EVENT_SUBJECT_ID` (`subject_id`),
  KEY `REPORT_EVENT_OBJECT_ID` (`object_id`),
  KEY `REPORT_EVENT_SUBTYPE` (`subtype`),
  KEY `REPORT_EVENT_STORE_ID` (`store_id`),
  CONSTRAINT `REPORT_EVENT_EVENT_TYPE_ID_REPORT_EVENT_TYPES_EVENT_TYPE_ID` FOREIGN KEY (`event_type_id`) REFERENCES `report_event_types` (`event_type_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_EVENT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Reports Event Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_event_types`
--

DROP TABLE IF EXISTS `report_event_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_event_types` (
  `event_type_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Event Type ID',
  `event_name` varchar(64) NOT NULL COMMENT 'Event Name',
  `customer_login` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Customer Login',
  PRIMARY KEY (`event_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COMMENT='Reports Event Type Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_products_by_website`
--

DROP TABLE IF EXISTS `report_products_by_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_products_by_website` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `website_id` int unsigned NOT NULL COMMENT 'Website ID',
  `product_name` varchar(255) NOT NULL COMMENT 'Product Name',
  `order_date` date NOT NULL COMMENT 'Order Date',
  `amount_invoiced` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Amount Invoiced',
  `amount_refunded` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Amount Refunded',
  `order_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Order Amount',
  PRIMARY KEY (`id`),
  KEY `idx_order_date` (`order_date`),
  KEY `idx_website_id` (`website_id`)
) ENGINE=InnoDB AUTO_INCREMENT=824547 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Orders Data Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_products_by_website_1`
--

DROP TABLE IF EXISTS `report_products_by_website_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_products_by_website_1` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `website_id` int unsigned NOT NULL COMMENT 'Website ID',
  `product_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT 'Product Name',
  `order_date` date NOT NULL COMMENT 'Order Date',
  `amount_invoiced` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Amount Invoiced',
  `amount_refunded` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Amount Refunded',
  `order_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Order Amount',
  PRIMARY KEY (`id`),
  KEY `idx_order_date` (`order_date`) USING BTREE,
  KEY `idx_website_id` (`website_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=236976 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Orders Data Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_viewed_product_aggregated_daily`
--

DROP TABLE IF EXISTS `report_viewed_product_aggregated_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_viewed_product_aggregated_daily` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product Name',
  `product_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Product Price',
  `views_num` int NOT NULL DEFAULT '0' COMMENT 'Number of Views',
  `rating_pos` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Pos',
  PRIMARY KEY (`id`),
  UNIQUE KEY `REPORT_VIEWED_PRD_AGGRED_DAILY_PERIOD_STORE_ID_PRD_ID` (`period`,`store_id`,`product_id`),
  KEY `REPORT_VIEWED_PRODUCT_AGGREGATED_DAILY_STORE_ID` (`store_id`),
  KEY `REPORT_VIEWED_PRODUCT_AGGREGATED_DAILY_PRODUCT_ID` (`product_id`),
  CONSTRAINT `REPORT_VIEWED_PRD_AGGRED_DAILY_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_VIEWED_PRODUCT_AGGREGATED_DAILY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26373 DEFAULT CHARSET=utf8mb3 COMMENT='Most Viewed Products Aggregated Daily';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_viewed_product_aggregated_monthly`
--

DROP TABLE IF EXISTS `report_viewed_product_aggregated_monthly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_viewed_product_aggregated_monthly` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product Name',
  `product_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Product Price',
  `views_num` int NOT NULL DEFAULT '0' COMMENT 'Number of Views',
  `rating_pos` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Pos',
  PRIMARY KEY (`id`),
  UNIQUE KEY `REPORT_VIEWED_PRD_AGGRED_MONTHLY_PERIOD_STORE_ID_PRD_ID` (`period`,`store_id`,`product_id`),
  KEY `REPORT_VIEWED_PRODUCT_AGGREGATED_MONTHLY_STORE_ID` (`store_id`),
  KEY `REPORT_VIEWED_PRODUCT_AGGREGATED_MONTHLY_PRODUCT_ID` (`product_id`),
  CONSTRAINT `REPORT_VIEWED_PRD_AGGRED_MONTHLY_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_VIEWED_PRODUCT_AGGREGATED_MONTHLY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1408 DEFAULT CHARSET=utf8mb3 COMMENT='Most Viewed Products Aggregated Monthly';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_viewed_product_aggregated_yearly`
--

DROP TABLE IF EXISTS `report_viewed_product_aggregated_yearly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_viewed_product_aggregated_yearly` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product Name',
  `product_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Product Price',
  `views_num` int NOT NULL DEFAULT '0' COMMENT 'Number of Views',
  `rating_pos` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Pos',
  PRIMARY KEY (`id`),
  UNIQUE KEY `REPORT_VIEWED_PRD_AGGRED_YEARLY_PERIOD_STORE_ID_PRD_ID` (`period`,`store_id`,`product_id`),
  KEY `REPORT_VIEWED_PRODUCT_AGGREGATED_YEARLY_STORE_ID` (`store_id`),
  KEY `REPORT_VIEWED_PRODUCT_AGGREGATED_YEARLY_PRODUCT_ID` (`product_id`),
  CONSTRAINT `REPORT_VIEWED_PRD_AGGRED_YEARLY_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_VIEWED_PRODUCT_AGGREGATED_YEARLY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=624 DEFAULT CHARSET=utf8mb3 COMMENT='Most Viewed Products Aggregated Yearly';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `report_viewed_product_index`
--

DROP TABLE IF EXISTS `report_viewed_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_viewed_product_index` (
  `index_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Index ID',
  `visitor_id` int unsigned DEFAULT NULL COMMENT 'Visitor ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `added_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Added At',
  PRIMARY KEY (`index_id`),
  UNIQUE KEY `REPORT_VIEWED_PRODUCT_INDEX_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  UNIQUE KEY `REPORT_VIEWED_PRODUCT_INDEX_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `REPORT_VIEWED_PRODUCT_INDEX_STORE_ID` (`store_id`),
  KEY `REPORT_VIEWED_PRODUCT_INDEX_ADDED_AT` (`added_at`),
  KEY `REPORT_VIEWED_PRODUCT_INDEX_PRODUCT_ID` (`product_id`),
  CONSTRAINT `REPORT_VIEWED_PRD_IDX_CSTR_ID_CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_VIEWED_PRD_IDX_PRD_ID_CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REPORT_VIEWED_PRODUCT_INDEX_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=27585 DEFAULT CHARSET=utf8mb3 COMMENT='Reports Viewed Product Index Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reporting_counts`
--

DROP TABLE IF EXISTS `reporting_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reporting_counts` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `type` varchar(255) DEFAULT NULL COMMENT 'Item Reported',
  `count` int unsigned DEFAULT NULL COMMENT 'Count Value',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Reporting for all count related events generated via the cron job';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reporting_module_status`
--

DROP TABLE IF EXISTS `reporting_module_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reporting_module_status` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Module ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Module Name',
  `active` varchar(255) DEFAULT NULL COMMENT 'Module Active Status',
  `setup_version` varchar(255) DEFAULT NULL COMMENT 'Module Version',
  `state` varchar(255) DEFAULT NULL COMMENT 'Module State',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Module Status Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reporting_orders`
--

DROP TABLE IF EXISTS `reporting_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reporting_orders` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `total` decimal(20,4) unsigned DEFAULT NULL,
  `total_base` decimal(20,4) unsigned DEFAULT NULL,
  `item_count` int unsigned NOT NULL COMMENT 'Line Item Count',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Reporting for all orders';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reporting_system_updates`
--

DROP TABLE IF EXISTS `reporting_system_updates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reporting_system_updates` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `type` varchar(255) DEFAULT NULL COMMENT 'Update Type',
  `action` varchar(255) DEFAULT NULL COMMENT 'Action Performed',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Reporting for system updates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `reporting_users`
--

DROP TABLE IF EXISTS `reporting_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reporting_users` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `type` varchar(255) DEFAULT NULL COMMENT 'User Type',
  `action` varchar(255) DEFAULT NULL COMMENT 'Action Performed',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Reporting for user actions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `review`
--

DROP TABLE IF EXISTS `review`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `review` (
  `review_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Review ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Review create date',
  `entity_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `entity_pk_value` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `status_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Status code',
  PRIMARY KEY (`review_id`),
  KEY `REVIEW_ENTITY_ID` (`entity_id`),
  KEY `REVIEW_STATUS_ID` (`status_id`),
  KEY `REVIEW_ENTITY_PK_VALUE` (`entity_pk_value`),
  CONSTRAINT `REVIEW_ENTITY_ID_REVIEW_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `review_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `REVIEW_STATUS_ID_REVIEW_STATUS_STATUS_ID` FOREIGN KEY (`status_id`) REFERENCES `review_status` (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COMMENT='Review base information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `review_detail`
--

DROP TABLE IF EXISTS `review_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `review_detail` (
  `detail_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Review detail ID',
  `review_id` bigint unsigned NOT NULL DEFAULT '0' COMMENT 'Review ID',
  `store_id` smallint unsigned DEFAULT '0' COMMENT 'Store ID',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `detail` text NOT NULL COMMENT 'Detail description',
  `nickname` varchar(128) NOT NULL COMMENT 'User nickname',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  PRIMARY KEY (`detail_id`),
  KEY `REVIEW_DETAIL_REVIEW_ID` (`review_id`),
  KEY `REVIEW_DETAIL_STORE_ID` (`store_id`),
  KEY `REVIEW_DETAIL_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `REVIEW_DETAIL_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE SET NULL,
  CONSTRAINT `REVIEW_DETAIL_REVIEW_ID_REVIEW_REVIEW_ID` FOREIGN KEY (`review_id`) REFERENCES `review` (`review_id`) ON DELETE CASCADE,
  CONSTRAINT `REVIEW_DETAIL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COMMENT='Review detail information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `review_entity`
--

DROP TABLE IF EXISTS `review_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `review_entity` (
  `entity_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Review entity ID',
  `entity_code` varchar(32) NOT NULL COMMENT 'Review entity code',
  PRIMARY KEY (`entity_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Review entities';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `review_entity_summary`
--

DROP TABLE IF EXISTS `review_entity_summary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `review_entity_summary` (
  `primary_id` bigint NOT NULL AUTO_INCREMENT COMMENT 'Summary review entity ID',
  `entity_pk_value` bigint NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `entity_type` smallint NOT NULL DEFAULT '0' COMMENT 'Entity type ID',
  `reviews_count` smallint NOT NULL DEFAULT '0' COMMENT 'Qty of reviews',
  `rating_summary` smallint NOT NULL DEFAULT '0' COMMENT 'Summarized rating',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  PRIMARY KEY (`primary_id`),
  UNIQUE KEY `REVIEW_ENTITY_SUMMARY_ENTITY_PK_VALUE_STORE_ID_ENTITY_TYPE` (`entity_pk_value`,`store_id`,`entity_type`),
  KEY `REVIEW_ENTITY_SUMMARY_STORE_ID` (`store_id`),
  CONSTRAINT `REVIEW_ENTITY_SUMMARY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Review aggregates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `review_status`
--

DROP TABLE IF EXISTS `review_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `review_status` (
  `status_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Status ID',
  `status_code` varchar(32) NOT NULL COMMENT 'Status code',
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='Review statuses';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `review_store`
--

DROP TABLE IF EXISTS `review_store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `review_store` (
  `review_id` bigint unsigned NOT NULL COMMENT 'Review ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  PRIMARY KEY (`review_id`,`store_id`),
  KEY `REVIEW_STORE_STORE_ID` (`store_id`),
  CONSTRAINT `REVIEW_STORE_REVIEW_ID_REVIEW_REVIEW_ID` FOREIGN KEY (`review_id`) REFERENCES `review` (`review_id`) ON DELETE CASCADE,
  CONSTRAINT `REVIEW_STORE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Review Store';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_bestsellers_aggregated_daily`
--

DROP TABLE IF EXISTS `sales_bestsellers_aggregated_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_bestsellers_aggregated_daily` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product Name',
  `product_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Product Price',
  `qty_ordered` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Ordered',
  `rating_pos` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Pos',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_BESTSELLERS_AGGREGATED_DAILY_PERIOD_STORE_ID_PRODUCT_ID` (`period`,`store_id`,`product_id`),
  KEY `SALES_BESTSELLERS_AGGREGATED_DAILY_STORE_ID` (`store_id`),
  KEY `SALES_BESTSELLERS_AGGREGATED_DAILY_PRODUCT_ID` (`product_id`),
  CONSTRAINT `SALES_BESTSELLERS_AGGREGATED_DAILY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Bestsellers Aggregated Daily';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_bestsellers_aggregated_monthly`
--

DROP TABLE IF EXISTS `sales_bestsellers_aggregated_monthly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_bestsellers_aggregated_monthly` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product Name',
  `product_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Product Price',
  `qty_ordered` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Ordered',
  `rating_pos` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Pos',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_BESTSELLERS_AGGREGATED_MONTHLY_PERIOD_STORE_ID_PRODUCT_ID` (`period`,`store_id`,`product_id`),
  KEY `SALES_BESTSELLERS_AGGREGATED_MONTHLY_STORE_ID` (`store_id`),
  KEY `SALES_BESTSELLERS_AGGREGATED_MONTHLY_PRODUCT_ID` (`product_id`),
  CONSTRAINT `SALES_BESTSELLERS_AGGREGATED_MONTHLY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=54050 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Bestsellers Aggregated Monthly';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_bestsellers_aggregated_yearly`
--

DROP TABLE IF EXISTS `sales_bestsellers_aggregated_yearly`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_bestsellers_aggregated_yearly` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_name` varchar(255) DEFAULT NULL COMMENT 'Product Name',
  `product_price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Product Price',
  `qty_ordered` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Qty Ordered',
  `rating_pos` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Rating Pos',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_BESTSELLERS_AGGREGATED_YEARLY_PERIOD_STORE_ID_PRODUCT_ID` (`period`,`store_id`,`product_id`),
  KEY `SALES_BESTSELLERS_AGGREGATED_YEARLY_STORE_ID` (`store_id`),
  KEY `SALES_BESTSELLERS_AGGREGATED_YEARLY_PRODUCT_ID` (`product_id`),
  CONSTRAINT `SALES_BESTSELLERS_AGGREGATED_YEARLY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13631 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Bestsellers Aggregated Yearly';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_creditmemo`
--

DROP TABLE IF EXISTS `sales_creditmemo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_creditmemo` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `adjustment_positive` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment Positive',
  `base_shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Tax Amount',
  `store_to_order_rate` decimal(20,4) DEFAULT NULL COMMENT 'Store To Order Rate',
  `base_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Amount',
  `base_to_order_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Order Rate',
  `grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Grand Total',
  `base_adjustment_negative` decimal(20,4) DEFAULT NULL COMMENT 'Base Adjustment Negative',
  `base_subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Incl Tax',
  `shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Amount',
  `subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Incl Tax',
  `adjustment_negative` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment Negative',
  `base_shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Amount',
  `store_to_base_rate` decimal(20,4) DEFAULT NULL COMMENT 'Store To Base Rate',
  `base_to_global_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Global Rate',
  `base_adjustment` decimal(20,4) DEFAULT NULL COMMENT 'Base Adjustment',
  `base_subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal',
  `discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Amount',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `adjustment` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment',
  `base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Grand Total',
  `base_adjustment_positive` decimal(20,4) DEFAULT NULL COMMENT 'Base Adjustment Positive',
  `base_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Amount',
  `shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Tax Amount',
  `tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Amount',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `email_sent` smallint unsigned DEFAULT NULL COMMENT 'Email Sent',
  `send_email` smallint unsigned DEFAULT NULL COMMENT 'Send Email',
  `creditmemo_status` int DEFAULT NULL COMMENT 'Creditmemo Status',
  `state` int DEFAULT NULL COMMENT 'State',
  `shipping_address_id` int DEFAULT NULL COMMENT 'Shipping Address ID',
  `billing_address_id` int DEFAULT NULL COMMENT 'Billing Address ID',
  `invoice_id` int DEFAULT NULL COMMENT 'Invoice ID',
  `store_currency_code` varchar(3) DEFAULT NULL COMMENT 'Store Currency Code',
  `order_currency_code` varchar(3) DEFAULT NULL COMMENT 'Order Currency Code',
  `base_currency_code` varchar(3) DEFAULT NULL COMMENT 'Base Currency Code',
  `global_currency_code` varchar(3) DEFAULT NULL COMMENT 'Global Currency Code',
  `transaction_id` varchar(255) DEFAULT NULL COMMENT 'Transaction ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `shipping_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Discount Tax Compensation Amount',
  `base_shipping_discount_tax_compensation_amnt` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Discount Tax Compensation Amount',
  `shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Incl Tax',
  `base_shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Incl Tax',
  `discount_description` varchar(255) DEFAULT NULL COMMENT 'Discount Description',
  `customer_note` text COMMENT 'Customer Note',
  `customer_note_notify` smallint unsigned DEFAULT NULL COMMENT 'Customer Note Notify',
  `tj_salestax_sync_date` timestamp NULL DEFAULT NULL COMMENT 'Refund sync date for TaxJar',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_CREDITMEMO_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_CREDITMEMO_STORE_ID` (`store_id`),
  KEY `SALES_CREDITMEMO_ORDER_ID` (`order_id`),
  KEY `SALES_CREDITMEMO_CREDITMEMO_STATUS` (`creditmemo_status`),
  KEY `SALES_CREDITMEMO_STATE` (`state`),
  KEY `SALES_CREDITMEMO_CREATED_AT` (`created_at`),
  KEY `SALES_CREDITMEMO_UPDATED_AT` (`updated_at`),
  KEY `SALES_CREDITMEMO_SEND_EMAIL` (`send_email`),
  KEY `SALES_CREDITMEMO_EMAIL_SENT` (`email_sent`),
  CONSTRAINT `SALES_CREDITMEMO_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_CREDITMEMO_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=15513 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Creditmemo';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_creditmemo_comment`
--

DROP TABLE IF EXISTS `sales_creditmemo_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_creditmemo_comment` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `is_customer_notified` int DEFAULT NULL COMMENT 'Is Customer Notified',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `comment` text COMMENT 'Comment',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_CREDITMEMO_COMMENT_CREATED_AT` (`created_at`),
  KEY `SALES_CREDITMEMO_COMMENT_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_CREDITMEMO_COMMENT_PARENT_ID_SALES_CREDITMEMO_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_creditmemo` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8645 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Creditmemo Comment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_creditmemo_grid`
--

DROP TABLE IF EXISTS `sales_creditmemo_grid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_creditmemo_grid` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `order_increment_id` varchar(50) DEFAULT NULL COMMENT 'Order Increment ID',
  `order_created_at` timestamp NULL DEFAULT NULL COMMENT 'Order Created At',
  `billing_name` varchar(255) DEFAULT NULL COMMENT 'Billing Name',
  `state` int DEFAULT NULL COMMENT 'Status',
  `base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Grand Total',
  `order_status` varchar(32) DEFAULT NULL COMMENT 'Order Status',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `billing_address` varchar(255) DEFAULT NULL COMMENT 'Billing Address',
  `shipping_address` varchar(255) DEFAULT NULL COMMENT 'Shipping Address',
  `customer_name` varchar(128) NOT NULL COMMENT 'Customer Name',
  `customer_email` varchar(128) DEFAULT NULL COMMENT 'Customer Email',
  `customer_group_id` smallint DEFAULT NULL COMMENT 'Customer Group ID',
  `payment_method` varchar(32) DEFAULT NULL COMMENT 'Payment Method',
  `shipping_information` varchar(255) DEFAULT NULL COMMENT 'Shipping Method Name',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `shipping_and_handling` decimal(20,4) DEFAULT NULL COMMENT 'Shipping and handling amount',
  `adjustment_positive` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment Positive',
  `adjustment_negative` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment Negative',
  `order_base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Order Grand Total',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_CREDITMEMO_GRID_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_CREDITMEMO_GRID_ORDER_INCREMENT_ID` (`order_increment_id`),
  KEY `SALES_CREDITMEMO_GRID_CREATED_AT` (`created_at`),
  KEY `SALES_CREDITMEMO_GRID_UPDATED_AT` (`updated_at`),
  KEY `SALES_CREDITMEMO_GRID_ORDER_CREATED_AT` (`order_created_at`),
  KEY `SALES_CREDITMEMO_GRID_STATE` (`state`),
  KEY `SALES_CREDITMEMO_GRID_BILLING_NAME` (`billing_name`),
  KEY `SALES_CREDITMEMO_GRID_ORDER_STATUS` (`order_status`),
  KEY `SALES_CREDITMEMO_GRID_BASE_GRAND_TOTAL` (`base_grand_total`),
  KEY `SALES_CREDITMEMO_GRID_STORE_ID` (`store_id`),
  KEY `SALES_CREDITMEMO_GRID_ORDER_BASE_GRAND_TOTAL` (`order_base_grand_total`),
  KEY `SALES_CREDITMEMO_GRID_ORDER_ID` (`order_id`),
  FULLTEXT KEY `FTI_32B7BA885941A8254EE84AE650ABDC86` (`increment_id`,`order_increment_id`,`billing_name`,`billing_address`,`shipping_address`,`customer_name`,`customer_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Creditmemo Grid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_creditmemo_item`
--

DROP TABLE IF EXISTS `sales_creditmemo_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_creditmemo_item` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `base_price` decimal(20,4) DEFAULT NULL COMMENT 'Base Price',
  `tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Amount',
  `base_row_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total',
  `discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Amount',
  `row_total` decimal(20,4) DEFAULT NULL COMMENT 'Row Total',
  `base_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Amount',
  `price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Price Incl Tax',
  `base_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Amount',
  `base_price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Price Incl Tax',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `base_cost` decimal(20,4) DEFAULT NULL COMMENT 'Base Cost',
  `price` decimal(20,4) DEFAULT NULL COMMENT 'Price',
  `base_row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total Incl Tax',
  `row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Row Total Incl Tax',
  `product_id` int DEFAULT NULL COMMENT 'Product ID',
  `order_item_id` int DEFAULT NULL COMMENT 'Order Item ID',
  `additional_data` text COMMENT 'Additional Data',
  `description` text COMMENT 'Description',
  `sku` varchar(255) DEFAULT NULL COMMENT 'Sku',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `tax_ratio` text COMMENT 'Ratio of tax in the creditmemo item over tax of the order item',
  `weee_tax_applied` text COMMENT 'Weee Tax Applied',
  `weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Amount',
  `weee_tax_applied_row_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Row Amount',
  `weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Disposition',
  `weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Row Disposition',
  `base_weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Amount',
  `base_weee_tax_applied_row_amnt` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Row Amnt',
  `base_weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Disposition',
  `base_weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Row Disposition',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_CREDITMEMO_ITEM_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_CREDITMEMO_ITEM_PARENT_ID_SALES_CREDITMEMO_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_creditmemo` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33647 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Creditmemo Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_data_exporter_order_statuses`
--

DROP TABLE IF EXISTS `sales_data_exporter_order_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_data_exporter_order_statuses` (
  `status` varchar(255) NOT NULL COMMENT 'status',
  `feed_data` mediumtext NOT NULL COMMENT 'Feed Data',
  `modified_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Modified At',
  PRIMARY KEY (`status`),
  KEY `SALES_DATA_EXPORTER_ORDER_STATUSES_MODIFIED_AT` (`modified_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Statuses Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_data_exporter_order_statuses_index_batches`
--

DROP TABLE IF EXISTS `sales_data_exporter_order_statuses_index_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_data_exporter_order_statuses_index_batches` (
  `batch_number` int NOT NULL COMMENT 'Batch Number',
  `status` varchar(32) NOT NULL COMMENT 'Status',
  PRIMARY KEY (`batch_number`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sales_data_exporter_order_statuses_index_batches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_data_exporter_order_statuses_index_sequence`
--

DROP TABLE IF EXISTS `sales_data_exporter_order_statuses_index_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_data_exporter_order_statuses_index_sequence` (
  `i` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Auto Increment ID',
  PRIMARY KEY (`i`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='sales_data_exporter_order_statuses_index_sequence';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_data_exporter_orders`
--

DROP TABLE IF EXISTS `sales_data_exporter_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_data_exporter_orders` (
  `id` int unsigned NOT NULL COMMENT 'ID',
  `mode` varchar(255) NOT NULL COMMENT 'Order Payment Mode',
  `feed_data` mediumtext NOT NULL COMMENT 'Feed Data',
  `modified_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Modified At',
  PRIMARY KEY (`id`),
  KEY `SALES_DATA_EXPORTER_ORDERS_MODIFIED_AT` (`modified_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Orders Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_data_exporter_orders_index_batches`
--

DROP TABLE IF EXISTS `sales_data_exporter_orders_index_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_data_exporter_orders_index_batches` (
  `batch_number` int NOT NULL COMMENT 'Batch Number',
  `entity_id` int unsigned NOT NULL COMMENT 'Entity Id',
  PRIMARY KEY (`batch_number`,`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sales_data_exporter_orders_index_batches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_data_exporter_orders_index_sequence`
--

DROP TABLE IF EXISTS `sales_data_exporter_orders_index_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_data_exporter_orders_index_sequence` (
  `i` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Auto Increment ID',
  PRIMARY KEY (`i`)
) ENGINE=InnoDB AUTO_INCREMENT=2275 DEFAULT CHARSET=utf8mb3 COMMENT='sales_data_exporter_orders_index_sequence';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_invoice`
--

DROP TABLE IF EXISTS `sales_invoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_invoice` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Grand Total',
  `shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Tax Amount',
  `tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Amount',
  `base_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Amount',
  `store_to_order_rate` decimal(20,4) DEFAULT NULL COMMENT 'Store To Order Rate',
  `base_shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Tax Amount',
  `base_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Amount',
  `base_to_order_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Order Rate',
  `grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Grand Total',
  `shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Amount',
  `subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Incl Tax',
  `base_subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Incl Tax',
  `store_to_base_rate` decimal(20,4) DEFAULT NULL COMMENT 'Store To Base Rate',
  `base_shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Amount',
  `total_qty` decimal(12,4) DEFAULT NULL COMMENT 'Total Qty',
  `base_to_global_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Global Rate',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `base_subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal',
  `discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Amount',
  `billing_address_id` int DEFAULT NULL COMMENT 'Billing Address ID',
  `is_used_for_refund` smallint unsigned DEFAULT NULL COMMENT 'Is Used For Refund',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `email_sent` smallint unsigned DEFAULT NULL COMMENT 'Email Sent',
  `send_email` smallint unsigned DEFAULT NULL COMMENT 'Send Email',
  `can_void_flag` smallint unsigned DEFAULT NULL COMMENT 'Can Void Flag',
  `state` int DEFAULT NULL COMMENT 'State',
  `shipping_address_id` int DEFAULT NULL COMMENT 'Shipping Address ID',
  `store_currency_code` varchar(3) DEFAULT NULL COMMENT 'Store Currency Code',
  `transaction_id` varchar(255) DEFAULT NULL COMMENT 'Transaction ID',
  `order_currency_code` varchar(3) DEFAULT NULL COMMENT 'Order Currency Code',
  `base_currency_code` varchar(3) DEFAULT NULL COMMENT 'Base Currency Code',
  `global_currency_code` varchar(3) DEFAULT NULL COMMENT 'Global Currency Code',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `shipping_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Discount Tax Compensation Amount',
  `base_shipping_discount_tax_compensation_amnt` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Discount Tax Compensation Amount',
  `shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Incl Tax',
  `base_shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Incl Tax',
  `base_total_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Refunded',
  `discount_description` varchar(255) DEFAULT NULL COMMENT 'Discount Description',
  `customer_note` text COMMENT 'Customer Note',
  `customer_note_notify` smallint unsigned DEFAULT NULL COMMENT 'Customer Note Notify',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_INVOICE_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_INVOICE_STORE_ID` (`store_id`),
  KEY `SALES_INVOICE_GRAND_TOTAL` (`grand_total`),
  KEY `SALES_INVOICE_ORDER_ID` (`order_id`),
  KEY `SALES_INVOICE_STATE` (`state`),
  KEY `SALES_INVOICE_CREATED_AT` (`created_at`),
  KEY `SALES_INVOICE_UPDATED_AT` (`updated_at`),
  KEY `SALES_INVOICE_SEND_EMAIL` (`send_email`),
  KEY `SALES_INVOICE_EMAIL_SENT` (`email_sent`),
  CONSTRAINT `SALES_INVOICE_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_INVOICE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Invoice';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_invoice_comment`
--

DROP TABLE IF EXISTS `sales_invoice_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_invoice_comment` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `is_customer_notified` smallint unsigned DEFAULT NULL COMMENT 'Is Customer Notified',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `comment` text COMMENT 'Comment',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_INVOICE_COMMENT_CREATED_AT` (`created_at`),
  KEY `SALES_INVOICE_COMMENT_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_INVOICE_COMMENT_PARENT_ID_SALES_INVOICE_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_invoice` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=700 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Invoice Comment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_invoice_grid`
--

DROP TABLE IF EXISTS `sales_invoice_grid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_invoice_grid` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `state` int DEFAULT NULL COMMENT 'State',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `store_name` varchar(255) DEFAULT NULL COMMENT 'Store Name',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `order_increment_id` varchar(50) DEFAULT NULL COMMENT 'Order Increment ID',
  `order_created_at` timestamp NULL DEFAULT NULL COMMENT 'Order Created At',
  `customer_name` varchar(255) DEFAULT NULL COMMENT 'Customer Name',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  `customer_group_id` int DEFAULT NULL,
  `payment_method` varchar(128) DEFAULT NULL COMMENT 'Payment Method',
  `store_currency_code` varchar(3) DEFAULT NULL COMMENT 'Store Currency Code',
  `order_currency_code` varchar(3) DEFAULT NULL COMMENT 'Order Currency Code',
  `base_currency_code` varchar(3) DEFAULT NULL COMMENT 'Base Currency Code',
  `global_currency_code` varchar(3) DEFAULT NULL COMMENT 'Global Currency Code',
  `billing_name` varchar(255) DEFAULT NULL COMMENT 'Billing Name',
  `billing_address` varchar(255) DEFAULT NULL COMMENT 'Billing Address',
  `shipping_address` varchar(255) DEFAULT NULL COMMENT 'Shipping Address',
  `shipping_information` varchar(255) DEFAULT NULL COMMENT 'Shipping Method Name',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `shipping_and_handling` decimal(20,4) DEFAULT NULL COMMENT 'Shipping and handling amount',
  `grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Grand Total',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Grand Total',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_INVOICE_GRID_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_INVOICE_GRID_STORE_ID` (`store_id`),
  KEY `SALES_INVOICE_GRID_GRAND_TOTAL` (`grand_total`),
  KEY `SALES_INVOICE_GRID_ORDER_ID` (`order_id`),
  KEY `SALES_INVOICE_GRID_STATE` (`state`),
  KEY `SALES_INVOICE_GRID_ORDER_INCREMENT_ID` (`order_increment_id`),
  KEY `SALES_INVOICE_GRID_CREATED_AT` (`created_at`),
  KEY `SALES_INVOICE_GRID_UPDATED_AT` (`updated_at`),
  KEY `SALES_INVOICE_GRID_ORDER_CREATED_AT` (`order_created_at`),
  KEY `SALES_INVOICE_GRID_BILLING_NAME` (`billing_name`),
  KEY `SALES_INVOICE_GRID_BASE_GRAND_TOTAL` (`base_grand_total`),
  FULLTEXT KEY `FTI_95D9C924DD6A8734EB8B5D01D60F90DE` (`increment_id`,`order_increment_id`,`billing_name`,`billing_address`,`shipping_address`,`customer_name`,`customer_email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Invoice Grid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_invoice_item`
--

DROP TABLE IF EXISTS `sales_invoice_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_invoice_item` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `base_price` decimal(20,4) DEFAULT NULL COMMENT 'Base Price',
  `tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Amount',
  `base_row_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total',
  `discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Amount',
  `row_total` decimal(20,4) DEFAULT NULL COMMENT 'Row Total',
  `base_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Amount',
  `price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Price Incl Tax',
  `base_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Amount',
  `base_price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Price Incl Tax',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `base_cost` decimal(20,4) DEFAULT NULL COMMENT 'Base Cost',
  `price` decimal(20,4) DEFAULT NULL COMMENT 'Price',
  `base_row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total Incl Tax',
  `row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Row Total Incl Tax',
  `product_id` int DEFAULT NULL COMMENT 'Product ID',
  `order_item_id` int DEFAULT NULL COMMENT 'Order Item ID',
  `additional_data` text COMMENT 'Additional Data',
  `description` text COMMENT 'Description',
  `sku` varchar(255) DEFAULT NULL COMMENT 'Sku',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `tax_ratio` text COMMENT 'Ratio of tax invoiced over tax of the order item',
  `weee_tax_applied` text COMMENT 'Weee Tax Applied',
  `weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Amount',
  `weee_tax_applied_row_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Row Amount',
  `weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Disposition',
  `weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Row Disposition',
  `base_weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Amount',
  `base_weee_tax_applied_row_amnt` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Row Amnt',
  `base_weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Disposition',
  `base_weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Row Disposition',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_INVOICE_ITEM_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_INVOICE_ITEM_PARENT_ID_SALES_INVOICE_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_invoice` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Invoice Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_invoiced_aggregated`
--

DROP TABLE IF EXISTS `sales_invoiced_aggregated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_invoiced_aggregated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `orders_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Orders Invoiced',
  `invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Invoiced',
  `invoiced_captured` decimal(20,4) DEFAULT NULL COMMENT 'Invoiced Captured',
  `invoiced_not_captured` decimal(20,4) DEFAULT NULL COMMENT 'Invoiced Not Captured',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_INVOICED_AGGREGATED_PERIOD_STORE_ID_ORDER_STATUS` (`period`,`store_id`,`order_status`),
  KEY `SALES_INVOICED_AGGREGATED_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_INVOICED_AGGREGATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5637535 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Invoiced Aggregated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_invoiced_aggregated_order`
--

DROP TABLE IF EXISTS `sales_invoiced_aggregated_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_invoiced_aggregated_order` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) NOT NULL COMMENT 'Order Status',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `orders_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Orders Invoiced',
  `invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Invoiced',
  `invoiced_captured` decimal(20,4) DEFAULT NULL COMMENT 'Invoiced Captured',
  `invoiced_not_captured` decimal(20,4) DEFAULT NULL COMMENT 'Invoiced Not Captured',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_INVOICED_AGGREGATED_ORDER_PERIOD_STORE_ID_ORDER_STATUS` (`period`,`store_id`,`order_status`),
  KEY `SALES_INVOICED_AGGREGATED_ORDER_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_INVOICED_AGGREGATED_ORDER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5355197 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Invoiced Aggregated Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order`
--

DROP TABLE IF EXISTS `sales_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `state` varchar(32) DEFAULT NULL COMMENT 'State',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `coupon_code` varchar(255) DEFAULT NULL COMMENT 'Coupon Code',
  `protect_code` varchar(255) DEFAULT NULL COMMENT 'Protect Code',
  `shipping_description` varchar(255) DEFAULT NULL COMMENT 'Shipping Description',
  `is_virtual` smallint unsigned DEFAULT NULL COMMENT 'Is Virtual',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `base_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Amount',
  `base_discount_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Canceled',
  `base_discount_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Invoiced',
  `base_discount_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Refunded',
  `base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Grand Total',
  `base_shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Amount',
  `base_shipping_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Canceled',
  `base_shipping_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Invoiced',
  `base_shipping_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Refunded',
  `base_shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Tax Amount',
  `base_shipping_tax_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Tax Refunded',
  `base_subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal',
  `base_subtotal_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Canceled',
  `base_subtotal_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Invoiced',
  `base_subtotal_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Refunded',
  `base_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Amount',
  `base_tax_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Canceled',
  `base_tax_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Invoiced',
  `base_tax_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Refunded',
  `base_to_global_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Global Rate',
  `base_to_order_rate` decimal(20,4) DEFAULT NULL COMMENT 'Base To Order Rate',
  `base_total_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Canceled',
  `base_total_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Invoiced',
  `base_total_invoiced_cost` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Invoiced Cost',
  `base_total_offline_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Offline Refunded',
  `base_total_online_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Online Refunded',
  `base_total_paid` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Paid',
  `base_total_qty_ordered` decimal(12,4) DEFAULT NULL COMMENT 'Base Total Qty Ordered',
  `base_total_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Refunded',
  `discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Amount',
  `discount_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Discount Canceled',
  `discount_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Discount Invoiced',
  `discount_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Discount Refunded',
  `grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Grand Total',
  `shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Amount',
  `shipping_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Canceled',
  `shipping_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Invoiced',
  `shipping_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Refunded',
  `shipping_tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Tax Amount',
  `shipping_tax_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Tax Refunded',
  `store_to_base_rate` decimal(12,4) DEFAULT NULL COMMENT 'Store To Base Rate',
  `store_to_order_rate` decimal(12,4) DEFAULT NULL COMMENT 'Store To Order Rate',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `subtotal_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Canceled',
  `subtotal_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Invoiced',
  `subtotal_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Refunded',
  `tax_amount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Amount',
  `tax_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Tax Canceled',
  `tax_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Tax Invoiced',
  `tax_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Tax Refunded',
  `total_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Total Canceled',
  `total_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Total Invoiced',
  `total_offline_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Total Offline Refunded',
  `total_online_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Total Online Refunded',
  `total_paid` decimal(20,4) DEFAULT NULL COMMENT 'Total Paid',
  `total_qty_ordered` decimal(12,4) DEFAULT NULL COMMENT 'Total Qty Ordered',
  `total_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Total Refunded',
  `can_ship_partially` smallint unsigned DEFAULT NULL COMMENT 'Can Ship Partially',
  `can_ship_partially_item` smallint unsigned DEFAULT NULL COMMENT 'Can Ship Partially Item',
  `customer_is_guest` smallint unsigned DEFAULT NULL COMMENT 'Customer Is Guest',
  `customer_note_notify` smallint unsigned DEFAULT NULL COMMENT 'Customer Note Notify',
  `billing_address_id` int DEFAULT NULL COMMENT 'Billing Address ID',
  `customer_group_id` int DEFAULT NULL,
  `edit_increment` int DEFAULT NULL COMMENT 'Edit Increment',
  `email_sent` smallint unsigned DEFAULT NULL COMMENT 'Email Sent',
  `send_email` smallint unsigned DEFAULT NULL COMMENT 'Send Email',
  `forced_shipment_with_invoice` smallint unsigned DEFAULT NULL COMMENT 'Forced Do Shipment With Invoice',
  `payment_auth_expiration` int DEFAULT NULL COMMENT 'Payment Authorization Expiration',
  `quote_address_id` int DEFAULT NULL COMMENT 'Quote Address ID',
  `quote_id` int DEFAULT NULL COMMENT 'Quote ID',
  `shipping_address_id` int DEFAULT NULL COMMENT 'Shipping Address ID',
  `adjustment_negative` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment Negative',
  `adjustment_positive` decimal(20,4) DEFAULT NULL COMMENT 'Adjustment Positive',
  `base_adjustment_negative` decimal(20,4) DEFAULT NULL COMMENT 'Base Adjustment Negative',
  `base_adjustment_positive` decimal(20,4) DEFAULT NULL COMMENT 'Base Adjustment Positive',
  `base_shipping_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Discount Amount',
  `base_subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Subtotal Incl Tax',
  `base_total_due` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Due',
  `payment_authorization_amount` decimal(20,4) DEFAULT NULL COMMENT 'Payment Authorization Amount',
  `shipping_discount_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Discount Amount',
  `subtotal_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal Incl Tax',
  `total_due` decimal(20,4) DEFAULT NULL COMMENT 'Total Due',
  `weight` decimal(12,4) DEFAULT NULL COMMENT 'Weight',
  `customer_dob` datetime DEFAULT NULL COMMENT 'Customer Dob',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `applied_rule_ids` varchar(128) DEFAULT NULL COMMENT 'Applied Rule Ids',
  `base_currency_code` varchar(3) DEFAULT NULL COMMENT 'Base Currency Code',
  `customer_email` varchar(128) DEFAULT NULL COMMENT 'Customer Email',
  `customer_firstname` varchar(128) DEFAULT NULL COMMENT 'Customer Firstname',
  `customer_lastname` varchar(128) DEFAULT NULL COMMENT 'Customer Lastname',
  `customer_middlename` varchar(128) DEFAULT NULL COMMENT 'Customer Middlename',
  `customer_prefix` varchar(32) DEFAULT NULL COMMENT 'Customer Prefix',
  `customer_suffix` varchar(32) DEFAULT NULL COMMENT 'Customer Suffix',
  `customer_taxvat` varchar(32) DEFAULT NULL COMMENT 'Customer Taxvat',
  `discount_description` varchar(255) DEFAULT NULL COMMENT 'Discount Description',
  `ext_customer_id` varchar(32) DEFAULT NULL COMMENT 'Ext Customer ID',
  `ext_order_id` varchar(32) DEFAULT NULL COMMENT 'Ext Order ID',
  `global_currency_code` varchar(3) DEFAULT NULL COMMENT 'Global Currency Code',
  `hold_before_state` varchar(32) DEFAULT NULL COMMENT 'Hold Before State',
  `hold_before_status` varchar(32) DEFAULT NULL COMMENT 'Hold Before Status',
  `order_currency_code` varchar(3) DEFAULT NULL COMMENT 'Order Currency Code',
  `original_increment_id` varchar(50) DEFAULT NULL COMMENT 'Original Increment ID',
  `relation_child_id` varchar(32) DEFAULT NULL COMMENT 'Relation Child ID',
  `relation_child_real_id` varchar(32) DEFAULT NULL COMMENT 'Relation Child Real ID',
  `relation_parent_id` varchar(32) DEFAULT NULL COMMENT 'Relation Parent ID',
  `relation_parent_real_id` varchar(32) DEFAULT NULL COMMENT 'Relation Parent Real ID',
  `remote_ip` varchar(45) DEFAULT NULL COMMENT 'Remote Ip',
  `shipping_method` varchar(120) DEFAULT NULL,
  `store_currency_code` varchar(3) DEFAULT NULL COMMENT 'Store Currency Code',
  `store_name` varchar(255) DEFAULT NULL COMMENT 'Store Name',
  `x_forwarded_for` varchar(255) DEFAULT NULL COMMENT 'X Forwarded For',
  `customer_note` text COMMENT 'Customer Note',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `total_item_count` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Total Item Count',
  `customer_gender` int DEFAULT NULL COMMENT 'Customer Gender',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `shipping_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Discount Tax Compensation Amount',
  `base_shipping_discount_tax_compensation_amnt` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Discount Tax Compensation Amount',
  `discount_tax_compensation_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Invoiced',
  `base_discount_tax_compensation_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Invoiced',
  `discount_tax_compensation_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Refunded',
  `base_discount_tax_compensation_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Refunded',
  `shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Incl Tax',
  `base_shipping_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Incl Tax',
  `coupon_rule_name` varchar(255) DEFAULT NULL COMMENT 'Coupon Sales Rule Name',
  `gift_message_id` int DEFAULT NULL COMMENT 'Gift Message ID',
  `paypal_ipn_customer_notified` int DEFAULT '0' COMMENT 'Paypal Ipn Customer Notified',
  `mailchimp_abandonedcart_flag` tinyint(1) NOT NULL COMMENT 'Retrieved from Mailchimp',
  `mailchimp_campaign_id` varchar(16) DEFAULT NULL COMMENT 'Campaign',
  `mailchimp_landing_page` text NOT NULL COMMENT 'Landing Page',
  `mailchimp_flag` tinyint(1) NOT NULL COMMENT 'Retrieved from Mailchimp',
  `dispute_status` varchar(45) DEFAULT NULL COMMENT 'Braintree Dispute Status',
  `tj_salestax_sync_date` timestamp NULL DEFAULT NULL COMMENT 'Order sync date for TaxJar',
  `kl_sms_consent` text COMMENT 'SMS Consent',
  `kl_email_consent` text COMMENT 'Email Consent',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_ORDER_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_ORDER_STATUS` (`status`),
  KEY `SALES_ORDER_STATE` (`state`),
  KEY `SALES_ORDER_STORE_ID` (`store_id`),
  KEY `SALES_ORDER_CREATED_AT` (`created_at`),
  KEY `SALES_ORDER_CUSTOMER_ID` (`customer_id`),
  KEY `SALES_ORDER_EXT_ORDER_ID` (`ext_order_id`),
  KEY `SALES_ORDER_QUOTE_ID` (`quote_id`),
  KEY `SALES_ORDER_UPDATED_AT` (`updated_at`),
  KEY `SALES_ORDER_SEND_EMAIL` (`send_email`),
  KEY `SALES_ORDER_EMAIL_SENT` (`email_sent`),
  KEY `SALES_ORDER_STORE_ID_STATE_CREATED_AT` (`store_id`,`state`,`created_at`),
  CONSTRAINT `SALES_ORDER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE SET NULL,
  CONSTRAINT `SALES_ORDER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_address`
--

DROP TABLE IF EXISTS `sales_order_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_address` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned DEFAULT NULL COMMENT 'Parent ID',
  `customer_address_id` int DEFAULT NULL COMMENT 'Customer Address ID',
  `quote_address_id` int DEFAULT NULL COMMENT 'Quote Address ID',
  `region_id` int DEFAULT NULL COMMENT 'Region ID',
  `customer_id` int DEFAULT NULL COMMENT 'Customer ID',
  `fax` varchar(255) DEFAULT NULL COMMENT 'Fax',
  `region` varchar(255) DEFAULT NULL COMMENT 'Region',
  `postcode` varchar(255) DEFAULT NULL COMMENT 'Postcode',
  `lastname` varchar(255) DEFAULT NULL COMMENT 'Lastname',
  `street` varchar(255) DEFAULT NULL COMMENT 'Street',
  `city` varchar(255) DEFAULT NULL COMMENT 'City',
  `email` varchar(255) DEFAULT NULL COMMENT 'Email',
  `telephone` varchar(255) DEFAULT NULL COMMENT 'Phone Number',
  `country_id` varchar(2) DEFAULT NULL COMMENT 'Country ID',
  `firstname` varchar(255) DEFAULT NULL COMMENT 'Firstname',
  `address_type` varchar(255) DEFAULT NULL COMMENT 'Address Type',
  `prefix` varchar(255) DEFAULT NULL COMMENT 'Prefix',
  `middlename` varchar(255) DEFAULT NULL COMMENT 'Middlename',
  `suffix` varchar(255) DEFAULT NULL COMMENT 'Suffix',
  `company` varchar(255) DEFAULT NULL COMMENT 'Company',
  `vat_id` text COMMENT 'Vat ID',
  `vat_is_valid` smallint DEFAULT NULL COMMENT 'Vat Is Valid',
  `vat_request_id` text COMMENT 'Vat Request ID',
  `vat_request_date` text COMMENT 'Vat Request Date',
  `vat_request_success` smallint DEFAULT NULL COMMENT 'Vat Request Success',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_ORDER_ADDRESS_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_ORDER_ADDRESS_PARENT_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Order Address';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_aggregated_created`
--

DROP TABLE IF EXISTS `sales_order_aggregated_created`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_aggregated_created` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) NOT NULL COMMENT 'Order Status',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `total_qty_ordered` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Qty Ordered',
  `total_qty_invoiced` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Qty Invoiced',
  `total_income_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Income Amount',
  `total_revenue_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Revenue Amount',
  `total_profit_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Profit Amount',
  `total_invoiced_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Invoiced Amount',
  `total_canceled_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Canceled Amount',
  `total_paid_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Paid Amount',
  `total_refunded_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Refunded Amount',
  `total_tax_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Tax Amount',
  `total_tax_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Tax Amount Actual',
  `total_shipping_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Shipping Amount',
  `total_shipping_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Shipping Amount Actual',
  `total_discount_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Discount Amount',
  `total_discount_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Discount Amount Actual',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_ORDER_AGGREGATED_CREATED_PERIOD_STORE_ID_ORDER_STATUS` (`period`,`store_id`,`order_status`),
  KEY `SALES_ORDER_AGGREGATED_CREATED_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_ORDER_AGGREGATED_CREATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4738943 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Aggregated Created';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_aggregated_updated`
--

DROP TABLE IF EXISTS `sales_order_aggregated_updated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_aggregated_updated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) NOT NULL COMMENT 'Order Status',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `total_qty_ordered` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Qty Ordered',
  `total_qty_invoiced` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Qty Invoiced',
  `total_income_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Income Amount',
  `total_revenue_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Revenue Amount',
  `total_profit_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Profit Amount',
  `total_invoiced_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Invoiced Amount',
  `total_canceled_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Canceled Amount',
  `total_paid_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Paid Amount',
  `total_refunded_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Refunded Amount',
  `total_tax_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Tax Amount',
  `total_tax_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Tax Amount Actual',
  `total_shipping_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Shipping Amount',
  `total_shipping_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Shipping Amount Actual',
  `total_discount_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Discount Amount',
  `total_discount_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Discount Amount Actual',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_ORDER_AGGREGATED_UPDATED_PERIOD_STORE_ID_ORDER_STATUS` (`period`,`store_id`,`order_status`),
  KEY `SALES_ORDER_AGGREGATED_UPDATED_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_ORDER_AGGREGATED_UPDATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Aggregated Updated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_grid`
--

DROP TABLE IF EXISTS `sales_order_grid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_grid` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `store_name` varchar(255) DEFAULT NULL COMMENT 'Store Name',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `base_grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Base Grand Total',
  `base_total_paid` decimal(20,4) DEFAULT NULL COMMENT 'Base Total Paid',
  `grand_total` decimal(20,4) DEFAULT NULL COMMENT 'Grand Total',
  `total_paid` decimal(20,4) DEFAULT NULL COMMENT 'Total Paid',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `base_currency_code` varchar(3) DEFAULT NULL COMMENT 'Base Currency Code',
  `order_currency_code` varchar(255) DEFAULT NULL COMMENT 'Order Currency Code',
  `shipping_name` varchar(255) DEFAULT NULL COMMENT 'Shipping Name',
  `billing_name` varchar(255) DEFAULT NULL COMMENT 'Billing Name',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  `billing_address` varchar(255) DEFAULT NULL COMMENT 'Billing Address',
  `shipping_address` varchar(255) DEFAULT NULL COMMENT 'Shipping Address',
  `shipping_information` varchar(255) DEFAULT NULL COMMENT 'Shipping Method Name',
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Customer Email',
  `customer_group` varchar(255) DEFAULT NULL COMMENT 'Customer Group',
  `subtotal` decimal(20,4) DEFAULT NULL COMMENT 'Subtotal',
  `shipping_and_handling` decimal(20,4) DEFAULT NULL COMMENT 'Shipping and handling amount',
  `customer_name` varchar(255) DEFAULT NULL COMMENT 'Customer Name',
  `payment_method` varchar(255) DEFAULT NULL COMMENT 'Payment Method',
  `total_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Total Refunded',
  `pickup_location_code` varchar(255) DEFAULT NULL COMMENT 'Pickup Location Code',
  `mailchimp_flag` tinyint(1) NOT NULL COMMENT 'Retrieved from Mailchimp',
  `dispute_status` varchar(45) DEFAULT NULL COMMENT 'Braintree Dispute Status',
  `plushie_ids` varchar(1024) DEFAULT NULL COMMENT 'Plushie IDs',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_ORDER_GRID_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_ORDER_GRID_STATUS` (`status`),
  KEY `SALES_ORDER_GRID_STORE_ID` (`store_id`),
  KEY `SALES_ORDER_GRID_BASE_GRAND_TOTAL` (`base_grand_total`),
  KEY `SALES_ORDER_GRID_BASE_TOTAL_PAID` (`base_total_paid`),
  KEY `SALES_ORDER_GRID_GRAND_TOTAL` (`grand_total`),
  KEY `SALES_ORDER_GRID_TOTAL_PAID` (`total_paid`),
  KEY `SALES_ORDER_GRID_SHIPPING_NAME` (`shipping_name`),
  KEY `SALES_ORDER_GRID_BILLING_NAME` (`billing_name`),
  KEY `SALES_ORDER_GRID_CREATED_AT` (`created_at`),
  KEY `SALES_ORDER_GRID_CUSTOMER_ID` (`customer_id`),
  KEY `SALES_ORDER_GRID_UPDATED_AT` (`updated_at`),
  KEY `SALES_ORDER_GRID_PICKUP_LOCATION_CODE` (`pickup_location_code`),
  FULLTEXT KEY `FTI_65840A58AD5F34614DF48B6E20CDB413` (`increment_id`,`billing_name`,`shipping_name`,`shipping_address`,`billing_address`,`customer_name`,`customer_email`,`plushie_ids`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Grid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_item`
--

DROP TABLE IF EXISTS `sales_order_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_item` (
  `item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Item ID',
  `order_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Order ID',
  `parent_item_id` int unsigned DEFAULT NULL COMMENT 'Parent Item ID',
  `quote_item_id` int unsigned DEFAULT NULL COMMENT 'Quote Item ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `product_id` int unsigned DEFAULT NULL COMMENT 'Product ID',
  `product_type` varchar(255) DEFAULT NULL COMMENT 'Product Type',
  `product_options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci COMMENT 'Product Options',
  `weight` decimal(12,4) DEFAULT '0.0000' COMMENT 'Weight',
  `is_virtual` smallint unsigned DEFAULT NULL COMMENT 'Is Virtual',
  `sku` varchar(255) DEFAULT NULL COMMENT 'Sku',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `applied_rule_ids` text COMMENT 'Applied Rule Ids',
  `additional_data` text COMMENT 'Additional Data',
  `is_qty_decimal` smallint unsigned DEFAULT NULL COMMENT 'Is Qty Decimal',
  `no_discount` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'No Discount',
  `qty_backordered` decimal(12,4) DEFAULT '0.0000' COMMENT 'Qty Backordered',
  `qty_canceled` decimal(12,4) DEFAULT '0.0000' COMMENT 'Qty Canceled',
  `qty_invoiced` decimal(12,4) DEFAULT '0.0000' COMMENT 'Qty Invoiced',
  `qty_ordered` decimal(12,4) DEFAULT '0.0000' COMMENT 'Qty Ordered',
  `qty_refunded` decimal(12,4) DEFAULT '0.0000' COMMENT 'Qty Refunded',
  `qty_shipped` decimal(12,4) DEFAULT '0.0000' COMMENT 'Qty Shipped',
  `base_cost` decimal(12,4) DEFAULT '0.0000' COMMENT 'Base Cost',
  `price` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `base_price` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Price',
  `original_price` decimal(20,4) DEFAULT NULL COMMENT 'Original Price',
  `base_original_price` decimal(20,4) DEFAULT NULL COMMENT 'Base Original Price',
  `tax_percent` decimal(12,4) DEFAULT '0.0000' COMMENT 'Tax Percent',
  `tax_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Tax Amount',
  `base_tax_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Tax Amount',
  `tax_invoiced` decimal(20,4) DEFAULT '0.0000' COMMENT 'Tax Invoiced',
  `base_tax_invoiced` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Tax Invoiced',
  `discount_percent` decimal(12,4) DEFAULT '0.0000' COMMENT 'Discount Percent',
  `discount_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Discount Amount',
  `base_discount_amount` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Discount Amount',
  `discount_invoiced` decimal(20,4) DEFAULT '0.0000' COMMENT 'Discount Invoiced',
  `base_discount_invoiced` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Discount Invoiced',
  `amount_refunded` decimal(20,4) DEFAULT '0.0000' COMMENT 'Amount Refunded',
  `base_amount_refunded` decimal(20,4) DEFAULT '0.0000' COMMENT 'Base Amount Refunded',
  `row_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Row Total',
  `base_row_total` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Row Total',
  `row_invoiced` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Row Invoiced',
  `base_row_invoiced` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Base Row Invoiced',
  `row_weight` decimal(12,4) DEFAULT '0.0000' COMMENT 'Row Weight',
  `base_tax_before_discount` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Before Discount',
  `tax_before_discount` decimal(20,4) DEFAULT NULL COMMENT 'Tax Before Discount',
  `ext_order_item_id` varchar(255) DEFAULT NULL COMMENT 'Ext Order Item ID',
  `locked_do_invoice` smallint unsigned DEFAULT NULL COMMENT 'Locked Do Invoice',
  `locked_do_ship` smallint unsigned DEFAULT NULL COMMENT 'Locked Do Ship',
  `price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Price Incl Tax',
  `base_price_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Price Incl Tax',
  `row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Row Total Incl Tax',
  `base_row_total_incl_tax` decimal(20,4) DEFAULT NULL COMMENT 'Base Row Total Incl Tax',
  `discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Amount',
  `base_discount_tax_compensation_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Amount',
  `discount_tax_compensation_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Invoiced',
  `base_discount_tax_compensation_invoiced` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Invoiced',
  `discount_tax_compensation_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Refunded',
  `base_discount_tax_compensation_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Tax Compensation Refunded',
  `tax_canceled` decimal(12,4) DEFAULT NULL COMMENT 'Tax Canceled',
  `discount_tax_compensation_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Discount Tax Compensation Canceled',
  `tax_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Tax Refunded',
  `base_tax_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Tax Refunded',
  `discount_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Discount Refunded',
  `base_discount_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Discount Refunded',
  `gift_message_id` int DEFAULT NULL COMMENT 'Gift Message ID',
  `gift_message_available` int DEFAULT NULL COMMENT 'Gift Message Available',
  `free_shipping` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Free Shipping',
  `weee_tax_applied` text COMMENT 'Weee Tax Applied',
  `weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Amount',
  `weee_tax_applied_row_amount` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Applied Row Amount',
  `weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Disposition',
  `weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Weee Tax Row Disposition',
  `base_weee_tax_applied_amount` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Amount',
  `base_weee_tax_applied_row_amnt` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Applied Row Amnt',
  `base_weee_tax_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Disposition',
  `base_weee_tax_row_disposition` decimal(12,4) DEFAULT NULL COMMENT 'Base Weee Tax Row Disposition',
  `tj_ptc` varchar(32) DEFAULT NULL COMMENT 'TaxJar Product Tax Code',
  `mp_productfeed_key` text COMMENT 'Mp Productfeed Key',
  PRIMARY KEY (`item_id`),
  KEY `SALES_ORDER_ITEM_ORDER_ID` (`order_id`),
  KEY `SALES_ORDER_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_ORDER_ITEM_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_ORDER_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Order Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_payment`
--

DROP TABLE IF EXISTS `sales_order_payment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_payment` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `base_shipping_captured` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Captured',
  `shipping_captured` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Captured',
  `amount_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Amount Refunded',
  `base_amount_paid` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Paid',
  `amount_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Amount Canceled',
  `base_amount_authorized` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Authorized',
  `base_amount_paid_online` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Paid Online',
  `base_amount_refunded_online` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Refunded Online',
  `base_shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Amount',
  `shipping_amount` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Amount',
  `amount_paid` decimal(20,4) DEFAULT NULL COMMENT 'Amount Paid',
  `amount_authorized` decimal(20,4) DEFAULT NULL COMMENT 'Amount Authorized',
  `base_amount_ordered` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Ordered',
  `base_shipping_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Shipping Refunded',
  `shipping_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Shipping Refunded',
  `base_amount_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Refunded',
  `amount_ordered` decimal(20,4) DEFAULT NULL COMMENT 'Amount Ordered',
  `base_amount_canceled` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount Canceled',
  `quote_payment_id` int DEFAULT NULL COMMENT 'Quote Payment ID',
  `additional_data` text COMMENT 'Additional Data',
  `cc_exp_month` varchar(12) DEFAULT NULL COMMENT 'Cc Exp Month',
  `cc_ss_start_year` varchar(12) DEFAULT NULL COMMENT 'Cc Ss Start Year',
  `echeck_bank_name` varchar(128) DEFAULT NULL COMMENT 'Echeck Bank Name',
  `method` varchar(128) DEFAULT NULL COMMENT 'Method',
  `cc_debug_request_body` varchar(32) DEFAULT NULL COMMENT 'Cc Debug Request Body',
  `cc_secure_verify` varchar(32) DEFAULT NULL COMMENT 'Cc Secure Verify',
  `protection_eligibility` varchar(32) DEFAULT NULL COMMENT 'Protection Eligibility',
  `cc_approval` varchar(32) DEFAULT NULL COMMENT 'Cc Approval',
  `cc_last_4` varchar(100) DEFAULT NULL COMMENT 'Cc Last 4',
  `cc_status_description` varchar(32) DEFAULT NULL COMMENT 'Cc Status Description',
  `echeck_type` varchar(32) DEFAULT NULL COMMENT 'Echeck Type',
  `cc_debug_response_serialized` varchar(32) DEFAULT NULL COMMENT 'Cc Debug Response Serialized',
  `cc_ss_start_month` varchar(128) DEFAULT NULL COMMENT 'Cc Ss Start Month',
  `echeck_account_type` varchar(255) DEFAULT NULL COMMENT 'Echeck Account Type',
  `last_trans_id` varchar(255) DEFAULT NULL COMMENT 'Last Trans ID',
  `cc_cid_status` varchar(32) DEFAULT NULL COMMENT 'Cc Cid Status',
  `cc_owner` varchar(128) DEFAULT NULL COMMENT 'Cc Owner',
  `cc_type` varchar(32) DEFAULT NULL COMMENT 'Cc Type',
  `po_number` varchar(32) DEFAULT NULL COMMENT 'Po Number',
  `cc_exp_year` varchar(4) DEFAULT NULL COMMENT 'Cc Exp Year',
  `cc_status` varchar(4) DEFAULT NULL COMMENT 'Cc Status',
  `echeck_routing_number` varchar(32) DEFAULT NULL COMMENT 'Echeck Routing Number',
  `account_status` varchar(32) DEFAULT NULL COMMENT 'Account Status',
  `anet_trans_method` varchar(32) DEFAULT NULL COMMENT 'Anet Trans Method',
  `cc_debug_response_body` varchar(32) DEFAULT NULL COMMENT 'Cc Debug Response Body',
  `cc_ss_issue` varchar(32) DEFAULT NULL COMMENT 'Cc Ss Issue',
  `echeck_account_name` varchar(32) DEFAULT NULL COMMENT 'Echeck Account Name',
  `cc_avs_status` varchar(32) DEFAULT NULL COMMENT 'Cc Avs Status',
  `cc_number_enc` varchar(128) DEFAULT NULL,
  `cc_trans_id` varchar(32) DEFAULT NULL COMMENT 'Cc Trans ID',
  `address_status` varchar(32) DEFAULT NULL COMMENT 'Address Status',
  `additional_information` text COMMENT 'Additional Information',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_ORDER_PAYMENT_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_ORDER_PAYMENT_PARENT_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Order Payment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_status`
--

DROP TABLE IF EXISTS `sales_order_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_status` (
  `status` varchar(32) NOT NULL COMMENT 'Status',
  `label` varchar(128) NOT NULL COMMENT 'Label',
  PRIMARY KEY (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Status Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_status_history`
--

DROP TABLE IF EXISTS `sales_order_status_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_status_history` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `is_customer_notified` int DEFAULT NULL COMMENT 'Is Customer Notified',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `comment` text COMMENT 'Comment',
  `status` varchar(32) DEFAULT NULL COMMENT 'Status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `entity_name` varchar(32) DEFAULT NULL COMMENT 'Shows what entity history is bind to.',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_ORDER_STATUS_HISTORY_PARENT_ID` (`parent_id`),
  KEY `SALES_ORDER_STATUS_HISTORY_CREATED_AT` (`created_at`),
  CONSTRAINT `SALES_ORDER_STATUS_HISTORY_PARENT_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Order Status History';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_status_label`
--

DROP TABLE IF EXISTS `sales_order_status_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_status_label` (
  `status` varchar(32) NOT NULL COMMENT 'Status',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `label` varchar(128) NOT NULL COMMENT 'Label',
  PRIMARY KEY (`status`,`store_id`),
  KEY `SALES_ORDER_STATUS_LABEL_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_ORDER_STATUS_LABEL_STATUS_SALES_ORDER_STATUS_STATUS` FOREIGN KEY (`status`) REFERENCES `sales_order_status` (`status`) ON DELETE CASCADE,
  CONSTRAINT `SALES_ORDER_STATUS_LABEL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Status Label Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_status_state`
--

DROP TABLE IF EXISTS `sales_order_status_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_status_state` (
  `status` varchar(32) NOT NULL COMMENT 'Status',
  `state` varchar(32) NOT NULL COMMENT 'Label',
  `is_default` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Visible on front',
  PRIMARY KEY (`status`,`state`),
  CONSTRAINT `SALES_ORDER_STATUS_STATE_STATUS_SALES_ORDER_STATUS_STATUS` FOREIGN KEY (`status`) REFERENCES `sales_order_status` (`status`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Status Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_tax`
--

DROP TABLE IF EXISTS `sales_order_tax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_tax` (
  `tax_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Tax ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `code` varchar(255) DEFAULT NULL COMMENT 'Code',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `percent` decimal(12,4) DEFAULT NULL COMMENT 'Percent',
  `amount` decimal(20,4) DEFAULT NULL COMMENT 'Amount',
  `priority` int NOT NULL COMMENT 'Priority',
  `position` int NOT NULL COMMENT 'Position',
  `base_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Amount',
  `process` smallint NOT NULL COMMENT 'Process',
  `base_real_amount` decimal(20,4) DEFAULT NULL COMMENT 'Base Real Amount',
  PRIMARY KEY (`tax_id`),
  KEY `SALES_ORDER_TAX_ORDER_ID_PRIORITY_POSITION` (`order_id`,`priority`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Tax Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_order_tax_item`
--

DROP TABLE IF EXISTS `sales_order_tax_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_order_tax_item` (
  `tax_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Tax Item ID',
  `tax_id` int unsigned NOT NULL COMMENT 'Tax ID',
  `item_id` int unsigned DEFAULT NULL COMMENT 'Item ID',
  `tax_percent` decimal(12,4) NOT NULL COMMENT 'Real Tax Percent For Item',
  `amount` decimal(20,4) NOT NULL COMMENT 'Tax amount for the item and tax rate',
  `base_amount` decimal(20,4) NOT NULL COMMENT 'Base tax amount for the item and tax rate',
  `real_amount` decimal(20,4) NOT NULL COMMENT 'Real tax amount for the item and tax rate',
  `real_base_amount` decimal(20,4) NOT NULL COMMENT 'Real base tax amount for the item and tax rate',
  `associated_item_id` int unsigned DEFAULT NULL COMMENT 'Id of the associated item',
  `taxable_item_type` varchar(32) NOT NULL COMMENT 'Type of the taxable item',
  PRIMARY KEY (`tax_item_id`),
  UNIQUE KEY `SALES_ORDER_TAX_ITEM_TAX_ID_ITEM_ID` (`tax_id`,`item_id`),
  KEY `SALES_ORDER_TAX_ITEM_ASSOCIATED_ITEM_ID_SALES_ORDER_ITEM_ITEM_ID` (`associated_item_id`),
  KEY `SALES_ORDER_TAX_ITEM_ITEM_ID` (`item_id`),
  CONSTRAINT `SALES_ORDER_TAX_ITEM_ASSOCIATED_ITEM_ID_SALES_ORDER_ITEM_ITEM_ID` FOREIGN KEY (`associated_item_id`) REFERENCES `sales_order_item` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_ORDER_TAX_ITEM_ITEM_ID_SALES_ORDER_ITEM_ITEM_ID` FOREIGN KEY (`item_id`) REFERENCES `sales_order_item` (`item_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_ORDER_TAX_ITEM_TAX_ID_SALES_ORDER_TAX_TAX_ID` FOREIGN KEY (`tax_id`) REFERENCES `sales_order_tax` (`tax_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=73741 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Order Tax Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_payment_transaction`
--

DROP TABLE IF EXISTS `sales_payment_transaction`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payment_transaction` (
  `transaction_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Transaction ID',
  `parent_id` int unsigned DEFAULT NULL COMMENT 'Parent ID',
  `order_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Order ID',
  `payment_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Payment ID',
  `txn_id` varchar(100) DEFAULT NULL COMMENT 'Txn ID',
  `parent_txn_id` varchar(100) DEFAULT NULL COMMENT 'Parent Txn ID',
  `txn_type` varchar(15) DEFAULT NULL COMMENT 'Txn Type',
  `is_closed` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Closed',
  `additional_information` blob COMMENT 'Additional Information',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`transaction_id`),
  UNIQUE KEY `SALES_PAYMENT_TRANSACTION_ORDER_ID_PAYMENT_ID_TXN_ID` (`order_id`,`payment_id`,`txn_id`),
  KEY `SALES_PAYMENT_TRANSACTION_PARENT_ID` (`parent_id`),
  KEY `SALES_PAYMENT_TRANSACTION_PAYMENT_ID` (`payment_id`),
  CONSTRAINT `FK_B99FF1A06402D725EBDB0F3A7ECD47A2` FOREIGN KEY (`parent_id`) REFERENCES `sales_payment_transaction` (`transaction_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_PAYMENT_TRANSACTION_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_PAYMENT_TRANSACTION_PAYMENT_ID_SALES_ORDER_PAYMENT_ENTT_ID` FOREIGN KEY (`payment_id`) REFERENCES `sales_order_payment` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Payment Transaction';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_refunded_aggregated`
--

DROP TABLE IF EXISTS `sales_refunded_aggregated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_refunded_aggregated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) NOT NULL COMMENT 'Order Status',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `refunded` decimal(20,4) DEFAULT NULL COMMENT 'Refunded',
  `online_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Online Refunded',
  `offline_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Offline Refunded',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_REFUNDED_AGGREGATED_PERIOD_STORE_ID_ORDER_STATUS` (`period`,`store_id`,`order_status`),
  KEY `SALES_REFUNDED_AGGREGATED_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_REFUNDED_AGGREGATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=163541 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Refunded Aggregated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_refunded_aggregated_order`
--

DROP TABLE IF EXISTS `sales_refunded_aggregated_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_refunded_aggregated_order` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `refunded` decimal(20,4) DEFAULT NULL COMMENT 'Refunded',
  `online_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Online Refunded',
  `offline_refunded` decimal(20,4) DEFAULT NULL COMMENT 'Offline Refunded',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_REFUNDED_AGGREGATED_ORDER_PERIOD_STORE_ID_ORDER_STATUS` (`period`,`store_id`,`order_status`),
  KEY `SALES_REFUNDED_AGGREGATED_ORDER_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_REFUNDED_AGGREGATED_ORDER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=1120353 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Refunded Aggregated Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_sequence_meta`
--

DROP TABLE IF EXISTS `sales_sequence_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_sequence_meta` (
  `meta_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `entity_type` varchar(32) NOT NULL COMMENT 'Prefix',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `sequence_table` varchar(64) NOT NULL COMMENT 'table for sequence',
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `SALES_SEQUENCE_META_ENTITY_TYPE_STORE_ID` (`entity_type`,`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb3 COMMENT='sales_sequence_meta';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_sequence_profile`
--

DROP TABLE IF EXISTS `sales_sequence_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_sequence_profile` (
  `profile_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `meta_id` int unsigned NOT NULL COMMENT 'Meta_id',
  `prefix` varchar(32) DEFAULT NULL COMMENT 'Prefix',
  `suffix` varchar(32) DEFAULT NULL COMMENT 'Suffix',
  `start_value` int unsigned NOT NULL DEFAULT '1' COMMENT 'Start value for sequence',
  `step` int unsigned NOT NULL DEFAULT '1' COMMENT 'Step for sequence',
  `max_value` int unsigned NOT NULL COMMENT 'MaxValue for sequence',
  `warning_value` int unsigned NOT NULL COMMENT 'WarningValue for sequence',
  `is_active` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'isActive flag',
  PRIMARY KEY (`profile_id`),
  UNIQUE KEY `SALES_SEQUENCE_PROFILE_META_ID_PREFIX_SUFFIX` (`meta_id`,`prefix`,`suffix`),
  CONSTRAINT `SALES_SEQUENCE_PROFILE_META_ID_SALES_SEQUENCE_META_META_ID` FOREIGN KEY (`meta_id`) REFERENCES `sales_sequence_meta` (`meta_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb3 COMMENT='sales_sequence_profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipment`
--

DROP TABLE IF EXISTS `sales_shipment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipment` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `total_weight` decimal(12,4) DEFAULT NULL COMMENT 'Total Weight',
  `total_qty` decimal(12,4) DEFAULT NULL COMMENT 'Total Qty',
  `email_sent` smallint unsigned DEFAULT NULL COMMENT 'Email Sent',
  `send_email` smallint unsigned DEFAULT NULL COMMENT 'Send Email',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `customer_id` int DEFAULT NULL COMMENT 'Customer ID',
  `shipping_address_id` int DEFAULT NULL COMMENT 'Shipping Address ID',
  `billing_address_id` int DEFAULT NULL COMMENT 'Billing Address ID',
  `shipment_status` int DEFAULT NULL COMMENT 'Shipment Status',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `packages` text COMMENT 'Packed Products in Packages',
  `shipping_label` mediumblob COMMENT 'Shipping Label Content',
  `customer_note` text COMMENT 'Customer Note',
  `customer_note_notify` smallint unsigned DEFAULT NULL COMMENT 'Customer Note Notify',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_SHIPMENT_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_SHIPMENT_STORE_ID` (`store_id`),
  KEY `SALES_SHIPMENT_TOTAL_QTY` (`total_qty`),
  KEY `SALES_SHIPMENT_ORDER_ID` (`order_id`),
  KEY `SALES_SHIPMENT_CREATED_AT` (`created_at`),
  KEY `SALES_SHIPMENT_UPDATED_AT` (`updated_at`),
  KEY `SALES_SHIPMENT_SEND_EMAIL` (`send_email`),
  KEY `SALES_SHIPMENT_EMAIL_SENT` (`email_sent`),
  CONSTRAINT `SALES_SHIPMENT_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `SALES_SHIPMENT_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Shipment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipment_comment`
--

DROP TABLE IF EXISTS `sales_shipment_comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipment_comment` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `is_customer_notified` int DEFAULT NULL COMMENT 'Is Customer Notified',
  `is_visible_on_front` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `comment` text COMMENT 'Comment',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_SHIPMENT_COMMENT_CREATED_AT` (`created_at`),
  KEY `SALES_SHIPMENT_COMMENT_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_SHIPMENT_COMMENT_PARENT_ID_SALES_SHIPMENT_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_shipment` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Shipment Comment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipment_grid`
--

DROP TABLE IF EXISTS `sales_shipment_grid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipment_grid` (
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `increment_id` varchar(50) DEFAULT NULL COMMENT 'Increment ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_increment_id` varchar(32) NOT NULL COMMENT 'Order Increment ID',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `order_created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Order Increment ID',
  `customer_name` varchar(128) NOT NULL COMMENT 'Customer Name',
  `total_qty` decimal(12,4) DEFAULT NULL COMMENT 'Total Qty',
  `shipment_status` int DEFAULT NULL COMMENT 'Shipment Status',
  `order_status` varchar(32) DEFAULT NULL COMMENT 'Order',
  `billing_address` varchar(255) DEFAULT NULL COMMENT 'Billing Address',
  `shipping_address` varchar(255) DEFAULT NULL COMMENT 'Shipping Address',
  `billing_name` varchar(128) DEFAULT NULL COMMENT 'Billing Name',
  `shipping_name` varchar(128) DEFAULT NULL COMMENT 'Shipping Name',
  `customer_email` varchar(128) DEFAULT NULL COMMENT 'Customer Email',
  `customer_group_id` int DEFAULT NULL,
  `payment_method` varchar(32) DEFAULT NULL COMMENT 'Payment Method',
  `shipping_information` varchar(255) DEFAULT NULL COMMENT 'Shipping Method Name',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Created At',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `SALES_SHIPMENT_GRID_INCREMENT_ID_STORE_ID` (`increment_id`,`store_id`),
  KEY `SALES_SHIPMENT_GRID_STORE_ID` (`store_id`),
  KEY `SALES_SHIPMENT_GRID_TOTAL_QTY` (`total_qty`),
  KEY `SALES_SHIPMENT_GRID_ORDER_INCREMENT_ID` (`order_increment_id`),
  KEY `SALES_SHIPMENT_GRID_SHIPMENT_STATUS` (`shipment_status`),
  KEY `SALES_SHIPMENT_GRID_ORDER_STATUS` (`order_status`),
  KEY `SALES_SHIPMENT_GRID_CREATED_AT` (`created_at`),
  KEY `SALES_SHIPMENT_GRID_UPDATED_AT` (`updated_at`),
  KEY `SALES_SHIPMENT_GRID_ORDER_CREATED_AT` (`order_created_at`),
  KEY `SALES_SHIPMENT_GRID_SHIPPING_NAME` (`shipping_name`),
  KEY `SALES_SHIPMENT_GRID_BILLING_NAME` (`billing_name`),
  KEY `SALES_SHIPMENT_GRID_ORDER_ID` (`order_id`),
  FULLTEXT KEY `FTI_086B40C8955F167B8EA76653437879B4` (`increment_id`,`order_increment_id`,`shipping_name`,`customer_name`,`customer_email`,`billing_address`,`shipping_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Shipment Grid';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipment_item`
--

DROP TABLE IF EXISTS `sales_shipment_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipment_item` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `row_total` decimal(20,4) DEFAULT NULL COMMENT 'Row Total',
  `price` decimal(20,4) DEFAULT NULL COMMENT 'Price',
  `weight` decimal(12,4) DEFAULT NULL COMMENT 'Weight',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `product_id` int DEFAULT NULL COMMENT 'Product ID',
  `order_item_id` int DEFAULT NULL COMMENT 'Order Item ID',
  `additional_data` text COMMENT 'Additional Data',
  `description` text COMMENT 'Description',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `sku` varchar(255) DEFAULT NULL COMMENT 'Sku',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_SHIPMENT_ITEM_PARENT_ID` (`parent_id`),
  CONSTRAINT `SALES_SHIPMENT_ITEM_PARENT_ID_SALES_SHIPMENT_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_shipment` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Shipment Item';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipment_track`
--

DROP TABLE IF EXISTS `sales_shipment_track`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipment_track` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `parent_id` int unsigned NOT NULL COMMENT 'Parent ID',
  `weight` decimal(12,4) DEFAULT NULL COMMENT 'Weight',
  `qty` decimal(12,4) DEFAULT NULL COMMENT 'Qty',
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `track_number` text COMMENT 'Number',
  `description` text COMMENT 'Description',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `carrier_code` varchar(32) DEFAULT NULL COMMENT 'Carrier Code',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  PRIMARY KEY (`entity_id`),
  KEY `SALES_SHIPMENT_TRACK_PARENT_ID` (`parent_id`),
  KEY `SALES_SHIPMENT_TRACK_ORDER_ID` (`order_id`),
  KEY `SALES_SHIPMENT_TRACK_CREATED_AT` (`created_at`),
  CONSTRAINT `SALES_SHIPMENT_TRACK_PARENT_ID_SALES_SHIPMENT_ENTITY_ID` FOREIGN KEY (`parent_id`) REFERENCES `sales_shipment` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Flat Shipment Track';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipping_aggregated`
--

DROP TABLE IF EXISTS `sales_shipping_aggregated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipping_aggregated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `shipping_description` varchar(255) DEFAULT NULL COMMENT 'Shipping Description',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `total_shipping` decimal(20,4) DEFAULT NULL COMMENT 'Total Shipping',
  `total_shipping_actual` decimal(20,4) DEFAULT NULL COMMENT 'Total Shipping Actual',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALES_SHPP_AGGRED_PERIOD_STORE_ID_ORDER_STS_SHPP_DESCRIPTION` (`period`,`store_id`,`order_status`,`shipping_description`),
  KEY `SALES_SHIPPING_AGGREGATED_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_SHIPPING_AGGREGATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6601636 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Shipping Aggregated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sales_shipping_aggregated_order`
--

DROP TABLE IF EXISTS `sales_shipping_aggregated_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_shipping_aggregated_order` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `shipping_description` varchar(255) DEFAULT NULL COMMENT 'Shipping Description',
  `orders_count` int NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `total_shipping` decimal(20,4) DEFAULT NULL COMMENT 'Total Shipping',
  `total_shipping_actual` decimal(20,4) DEFAULT NULL COMMENT 'Total Shipping Actual',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_C05FAE47282EEA68654D0924E946761F` (`period`,`store_id`,`order_status`,`shipping_description`),
  KEY `SALES_SHIPPING_AGGREGATED_ORDER_STORE_ID` (`store_id`),
  CONSTRAINT `SALES_SHIPPING_AGGREGATED_ORDER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6440269 DEFAULT CHARSET=utf8mb3 COMMENT='Sales Shipping Aggregated Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule`
--

DROP TABLE IF EXISTS `salesrule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule` (
  `rule_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  `description` text COMMENT 'Description',
  `from_date` date DEFAULT NULL COMMENT 'From',
  `to_date` date DEFAULT NULL COMMENT 'To',
  `uses_per_customer` int NOT NULL DEFAULT '0' COMMENT 'Uses Per Customer',
  `is_active` smallint NOT NULL DEFAULT '0' COMMENT 'Is Active',
  `conditions_serialized` mediumtext COMMENT 'Conditions Serialized',
  `actions_serialized` mediumtext COMMENT 'Actions Serialized',
  `stop_rules_processing` smallint NOT NULL DEFAULT '1' COMMENT 'Stop Rules Processing',
  `is_advanced` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Is Advanced',
  `product_ids` text COMMENT 'Product Ids',
  `sort_order` int unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `simple_action` varchar(32) DEFAULT NULL COMMENT 'Simple Action',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `discount_qty` decimal(12,4) DEFAULT NULL COMMENT 'Discount Qty',
  `discount_step` int unsigned NOT NULL DEFAULT '0' COMMENT 'Discount Step',
  `apply_to_shipping` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Apply To Shipping',
  `times_used` int unsigned NOT NULL DEFAULT '0' COMMENT 'Times Used',
  `is_rss` smallint NOT NULL DEFAULT '0' COMMENT 'Is Rss',
  `coupon_type` smallint unsigned NOT NULL DEFAULT '1' COMMENT 'Coupon Type',
  `use_auto_generation` smallint NOT NULL DEFAULT '0' COMMENT 'Use Auto Generation',
  `uses_per_coupon` int NOT NULL DEFAULT '0' COMMENT 'User Per Coupon',
  `simple_free_shipping` smallint unsigned DEFAULT NULL COMMENT 'Simple Free Shipping',
  PRIMARY KEY (`rule_id`),
  KEY `SALESRULE_IS_ACTIVE_SORT_ORDER_TO_DATE_FROM_DATE` (`is_active`,`sort_order`,`to_date`,`from_date`)
) ENGINE=InnoDB AUTO_INCREMENT=1673910 DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_correction_factor`
--

DROP TABLE IF EXISTS `salesrule_correction_factor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_correction_factor` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Coupon Correction Factor ID',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `correction_factor` float NOT NULL DEFAULT '0' COMMENT 'Correction Factor Percent',
  PRIMARY KEY (`id`),
  KEY `SALESRULE_CORRECTION_FACTOR_RULE_ID_SALESRULE_RULE_ID` (`rule_id`),
  CONSTRAINT `SALESRULE_CORRECTION_FACTOR_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COMMENT='salesrule_correction_factor';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_coupon`
--

DROP TABLE IF EXISTS `salesrule_coupon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_coupon` (
  `coupon_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Coupon ID',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `code` varchar(255) DEFAULT NULL COMMENT 'Code',
  `usage_limit` int unsigned DEFAULT NULL COMMENT 'Usage Limit',
  `usage_per_customer` int unsigned DEFAULT NULL COMMENT 'Usage Per Customer',
  `times_used` int unsigned NOT NULL DEFAULT '0' COMMENT 'Times Used',
  `expiration_date` datetime DEFAULT NULL COMMENT 'Expiration Date',
  `is_primary` smallint unsigned DEFAULT NULL COMMENT 'Is Primary',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Coupon Code Creation Date',
  `type` smallint DEFAULT '0' COMMENT 'Coupon Code Type',
  PRIMARY KEY (`coupon_id`),
  UNIQUE KEY `SALESRULE_COUPON_CODE` (`code`),
  UNIQUE KEY `SALESRULE_COUPON_RULE_ID_IS_PRIMARY` (`rule_id`,`is_primary`),
  KEY `SALESRULE_COUPON_RULE_ID` (`rule_id`),
  CONSTRAINT `SALESRULE_COUPON_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1685527 DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule Coupon';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_coupon_aggregated`
--

DROP TABLE IF EXISTS `salesrule_coupon_aggregated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_coupon_aggregated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date NOT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `coupon_code` varchar(50) DEFAULT NULL COMMENT 'Coupon Code',
  `coupon_uses` int NOT NULL DEFAULT '0' COMMENT 'Coupon Uses',
  `subtotal_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal Amount',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `total_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Amount',
  `subtotal_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal Amount Actual',
  `discount_amount_actual` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount Actual',
  `total_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Amount Actual',
  `rule_name` varchar(255) DEFAULT NULL COMMENT 'Rule Name',
  PRIMARY KEY (`id`),
  UNIQUE KEY `SALESRULE_COUPON_AGGRED_PERIOD_STORE_ID_ORDER_STS_COUPON_CODE` (`period`,`store_id`,`order_status`,`coupon_code`),
  KEY `SALESRULE_COUPON_AGGREGATED_STORE_ID` (`store_id`),
  KEY `SALESRULE_COUPON_AGGREGATED_RULE_NAME` (`rule_name`),
  CONSTRAINT `SALESRULE_COUPON_AGGREGATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Coupon Aggregated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_coupon_aggregated_order`
--

DROP TABLE IF EXISTS `salesrule_coupon_aggregated_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_coupon_aggregated_order` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date NOT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `coupon_code` varchar(50) DEFAULT NULL COMMENT 'Coupon Code',
  `coupon_uses` int NOT NULL DEFAULT '0' COMMENT 'Coupon Uses',
  `subtotal_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal Amount',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `total_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Amount',
  `rule_name` varchar(255) DEFAULT NULL COMMENT 'Rule Name',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_1094D1FBBCBB11704A29DEF3ACC37D2B` (`period`,`store_id`,`order_status`,`coupon_code`),
  KEY `SALESRULE_COUPON_AGGREGATED_ORDER_STORE_ID` (`store_id`),
  KEY `SALESRULE_COUPON_AGGREGATED_ORDER_RULE_NAME` (`rule_name`),
  CONSTRAINT `SALESRULE_COUPON_AGGREGATED_ORDER_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Coupon Aggregated Order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_coupon_aggregated_updated`
--

DROP TABLE IF EXISTS `salesrule_coupon_aggregated_updated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_coupon_aggregated_updated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date NOT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `order_status` varchar(50) DEFAULT NULL COMMENT 'Order Status',
  `coupon_code` varchar(50) DEFAULT NULL COMMENT 'Coupon Code',
  `coupon_uses` int NOT NULL DEFAULT '0' COMMENT 'Coupon Uses',
  `subtotal_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal Amount',
  `discount_amount` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount',
  `total_amount` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Amount',
  `subtotal_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Subtotal Amount Actual',
  `discount_amount_actual` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Discount Amount Actual',
  `total_amount_actual` decimal(20,4) NOT NULL DEFAULT '0.0000' COMMENT 'Total Amount Actual',
  `rule_name` varchar(255) DEFAULT NULL COMMENT 'Rule Name',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_7196FA120A4F0F84E1B66605E87E213E` (`period`,`store_id`,`order_status`,`coupon_code`),
  KEY `SALESRULE_COUPON_AGGREGATED_UPDATED_STORE_ID` (`store_id`),
  KEY `SALESRULE_COUPON_AGGREGATED_UPDATED_RULE_NAME` (`rule_name`),
  CONSTRAINT `SALESRULE_COUPON_AGGREGATED_UPDATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule Coupon Aggregated Updated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_coupon_usage`
--

DROP TABLE IF EXISTS `salesrule_coupon_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_coupon_usage` (
  `coupon_id` int unsigned NOT NULL COMMENT 'Coupon ID',
  `customer_id` int unsigned NOT NULL COMMENT 'Customer ID',
  `times_used` int unsigned NOT NULL DEFAULT '0' COMMENT 'Times Used',
  PRIMARY KEY (`coupon_id`,`customer_id`),
  KEY `SALESRULE_COUPON_USAGE_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `SALESRULE_COUPON_USAGE_COUPON_ID_SALESRULE_COUPON_COUPON_ID` FOREIGN KEY (`coupon_id`) REFERENCES `salesrule_coupon` (`coupon_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_COUPON_USAGE_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule Coupon Usage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_customer`
--

DROP TABLE IF EXISTS `salesrule_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_customer` (
  `rule_customer_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule Customer ID',
  `rule_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Rule ID',
  `customer_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer ID',
  `times_used` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Times Used',
  PRIMARY KEY (`rule_customer_id`),
  KEY `SALESRULE_CUSTOMER_RULE_ID_CUSTOMER_ID` (`rule_id`,`customer_id`),
  KEY `SALESRULE_CUSTOMER_CUSTOMER_ID_RULE_ID` (`customer_id`,`rule_id`),
  CONSTRAINT `SALESRULE_CUSTOMER_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_CUSTOMER_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23877 DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule Customer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_customer_group`
--

DROP TABLE IF EXISTS `salesrule_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_customer_group` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  PRIMARY KEY (`rule_id`,`customer_group_id`),
  KEY `SALESRULE_CUSTOMER_GROUP_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `SALESRULE_CSTR_GROUP_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_CUSTOMER_GROUP_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Rules To Customer Groups Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_label`
--

DROP TABLE IF EXISTS `salesrule_label`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_label` (
  `label_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Label ID',
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  PRIMARY KEY (`label_id`),
  UNIQUE KEY `SALESRULE_LABEL_RULE_ID_STORE_ID` (`rule_id`,`store_id`),
  KEY `SALESRULE_LABEL_STORE_ID` (`store_id`),
  CONSTRAINT `SALESRULE_LABEL_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_LABEL_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1372126 DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule Label';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_product_attribute`
--

DROP TABLE IF EXISTS `salesrule_product_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_product_attribute` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int unsigned NOT NULL COMMENT 'Customer Group ID',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  PRIMARY KEY (`rule_id`,`website_id`,`customer_group_id`,`attribute_id`),
  KEY `SALESRULE_PRODUCT_ATTRIBUTE_WEBSITE_ID` (`website_id`),
  KEY `SALESRULE_PRODUCT_ATTRIBUTE_CUSTOMER_GROUP_ID` (`customer_group_id`),
  KEY `SALESRULE_PRODUCT_ATTRIBUTE_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `SALESRULE_PRD_ATTR_ATTR_ID_EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_PRD_ATTR_CSTR_GROUP_ID_CSTR_GROUP_CSTR_GROUP_ID` FOREIGN KEY (`customer_group_id`) REFERENCES `customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_PRODUCT_ATTRIBUTE_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_PRODUCT_ATTRIBUTE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Salesrule Product Attribute';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `salesrule_website`
--

DROP TABLE IF EXISTS `salesrule_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `salesrule_website` (
  `rule_id` int unsigned NOT NULL COMMENT 'Rule ID',
  `website_id` smallint unsigned NOT NULL COMMENT 'Website ID',
  PRIMARY KEY (`rule_id`,`website_id`),
  KEY `SALESRULE_WEBSITE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `SALESRULE_WEBSITE_RULE_ID_SALESRULE_RULE_ID` FOREIGN KEY (`rule_id`) REFERENCES `salesrule` (`rule_id`) ON DELETE CASCADE,
  CONSTRAINT `SALESRULE_WEBSITE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Sales Rules To Websites Relations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `search_query`
--

DROP TABLE IF EXISTS `search_query`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `search_query` (
  `query_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Query ID',
  `query_text` varchar(255) DEFAULT NULL COMMENT 'Query text',
  `num_results` int unsigned NOT NULL DEFAULT '0' COMMENT 'Num results',
  `popularity` int unsigned NOT NULL DEFAULT '0' COMMENT 'Popularity',
  `redirect` varchar(255) DEFAULT NULL COMMENT 'Redirect',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `display_in_terms` smallint NOT NULL DEFAULT '1' COMMENT 'Display in terms',
  `is_active` smallint DEFAULT '1' COMMENT 'Active status',
  `is_processed` smallint DEFAULT '0' COMMENT 'Processed status',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated at',
  PRIMARY KEY (`query_id`),
  UNIQUE KEY `SEARCH_QUERY_QUERY_TEXT_STORE_ID` (`query_text`,`store_id`),
  KEY `SEARCH_QUERY_QUERY_TEXT_STORE_ID_POPULARITY` (`query_text`,`store_id`,`popularity`),
  KEY `SEARCH_QUERY_IS_PROCESSED` (`is_processed`),
  KEY `SEARCH_QUERY_STORE_ID_NUM_RESULTS_POPULARITY` (`store_id`,`num_results`,`popularity`),
  CONSTRAINT `SEARCH_QUERY_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6534 DEFAULT CHARSET=utf8mb3 COMMENT='Search query table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `search_synonyms`
--

DROP TABLE IF EXISTS `search_synonyms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `search_synonyms` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Synonyms Group ID',
  `synonyms` text NOT NULL COMMENT 'list of synonyms making up this group',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID - identifies the store view these synonyms belong to',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID - identifies the website ID these synonyms belong to',
  PRIMARY KEY (`group_id`),
  KEY `SEARCH_SYNONYMS_STORE_ID` (`store_id`),
  KEY `SEARCH_SYNONYMS_WEBSITE_ID` (`website_id`),
  FULLTEXT KEY `SEARCH_SYNONYMS_SYNONYMS` (`synonyms`),
  CONSTRAINT `SEARCH_SYNONYMS_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `SEARCH_SYNONYMS_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='table storing various synonyms groups';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sendfriend_log`
--

DROP TABLE IF EXISTS `sendfriend_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sendfriend_log` (
  `log_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `ip` bigint unsigned NOT NULL DEFAULT '0' COMMENT 'Customer IP address',
  `time` int unsigned NOT NULL DEFAULT '0' COMMENT 'Log time',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  PRIMARY KEY (`log_id`),
  KEY `SENDFRIEND_LOG_IP` (`ip`),
  KEY `SENDFRIEND_LOG_TIME` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Send to friend function log storage table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_0`
--

DROP TABLE IF EXISTS `sequence_creditmemo_0`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_0` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_0';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_1`
--

DROP TABLE IF EXISTS `sequence_creditmemo_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_1` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=8817 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_10`
--

DROP TABLE IF EXISTS `sequence_creditmemo_10`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_10` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_11`
--

DROP TABLE IF EXISTS `sequence_creditmemo_11`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_11` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_12`
--

DROP TABLE IF EXISTS `sequence_creditmemo_12`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_12` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_13`
--

DROP TABLE IF EXISTS `sequence_creditmemo_13`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_13` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_14`
--

DROP TABLE IF EXISTS `sequence_creditmemo_14`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_14` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_2`
--

DROP TABLE IF EXISTS `sequence_creditmemo_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_2` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_3`
--

DROP TABLE IF EXISTS `sequence_creditmemo_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_3` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=5971 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_3';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_4`
--

DROP TABLE IF EXISTS `sequence_creditmemo_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_4` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_4';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_5`
--

DROP TABLE IF EXISTS `sequence_creditmemo_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_5` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=555 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_6`
--

DROP TABLE IF EXISTS `sequence_creditmemo_6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_6` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_7`
--

DROP TABLE IF EXISTS `sequence_creditmemo_7`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_7` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_7';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_8`
--

DROP TABLE IF EXISTS `sequence_creditmemo_8`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_8` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_8';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_creditmemo_9`
--

DROP TABLE IF EXISTS `sequence_creditmemo_9`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_creditmemo_9` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_creditmemo_9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_0`
--

DROP TABLE IF EXISTS `sequence_invoice_0`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_0` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_0';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_1`
--

DROP TABLE IF EXISTS `sequence_invoice_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_1` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=115151 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_10`
--

DROP TABLE IF EXISTS `sequence_invoice_10`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_10` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_11`
--

DROP TABLE IF EXISTS `sequence_invoice_11`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_11` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_12`
--

DROP TABLE IF EXISTS `sequence_invoice_12`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_12` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_13`
--

DROP TABLE IF EXISTS `sequence_invoice_13`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_13` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_14`
--

DROP TABLE IF EXISTS `sequence_invoice_14`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_14` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_2`
--

DROP TABLE IF EXISTS `sequence_invoice_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_2` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=615 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_3`
--

DROP TABLE IF EXISTS `sequence_invoice_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_3` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=124048 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_3';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_4`
--

DROP TABLE IF EXISTS `sequence_invoice_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_4` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=749 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_4';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_5`
--

DROP TABLE IF EXISTS `sequence_invoice_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_5` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=3447 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_6`
--

DROP TABLE IF EXISTS `sequence_invoice_6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_6` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_7`
--

DROP TABLE IF EXISTS `sequence_invoice_7`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_7` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_7';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_8`
--

DROP TABLE IF EXISTS `sequence_invoice_8`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_8` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_8';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_invoice_9`
--

DROP TABLE IF EXISTS `sequence_invoice_9`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_invoice_9` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_invoice_9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_0`
--

DROP TABLE IF EXISTS `sequence_order_0`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_0` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_0';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_1`
--

DROP TABLE IF EXISTS `sequence_order_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_1` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=126486 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_10`
--

DROP TABLE IF EXISTS `sequence_order_10`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_10` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_11`
--

DROP TABLE IF EXISTS `sequence_order_11`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_11` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_12`
--

DROP TABLE IF EXISTS `sequence_order_12`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_12` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_13`
--

DROP TABLE IF EXISTS `sequence_order_13`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_13` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_14`
--

DROP TABLE IF EXISTS `sequence_order_14`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_14` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_2`
--

DROP TABLE IF EXISTS `sequence_order_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_2` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=689 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_3`
--

DROP TABLE IF EXISTS `sequence_order_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_3` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=137680 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_3';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_4`
--

DROP TABLE IF EXISTS `sequence_order_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_4` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=820 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_4';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_5`
--

DROP TABLE IF EXISTS `sequence_order_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_5` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=3839 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_6`
--

DROP TABLE IF EXISTS `sequence_order_6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_6` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_7`
--

DROP TABLE IF EXISTS `sequence_order_7`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_7` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_7';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_8`
--

DROP TABLE IF EXISTS `sequence_order_8`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_8` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_8';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_order_9`
--

DROP TABLE IF EXISTS `sequence_order_9`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_order_9` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_order_9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_0`
--

DROP TABLE IF EXISTS `sequence_rma_item_0`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_0` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_0';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_1`
--

DROP TABLE IF EXISTS `sequence_rma_item_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_1` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_2`
--

DROP TABLE IF EXISTS `sequence_rma_item_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_2` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_3`
--

DROP TABLE IF EXISTS `sequence_rma_item_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_3` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_3';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_4`
--

DROP TABLE IF EXISTS `sequence_rma_item_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_4` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_4';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_5`
--

DROP TABLE IF EXISTS `sequence_rma_item_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_5` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_6`
--

DROP TABLE IF EXISTS `sequence_rma_item_6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_6` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_7`
--

DROP TABLE IF EXISTS `sequence_rma_item_7`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_7` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_7';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_8`
--

DROP TABLE IF EXISTS `sequence_rma_item_8`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_8` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_8';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_rma_item_9`
--

DROP TABLE IF EXISTS `sequence_rma_item_9`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_rma_item_9` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_rma_item_9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_0`
--

DROP TABLE IF EXISTS `sequence_shipment_0`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_0` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_0';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_1`
--

DROP TABLE IF EXISTS `sequence_shipment_1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_1` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=105393 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_10`
--

DROP TABLE IF EXISTS `sequence_shipment_10`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_10` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_11`
--

DROP TABLE IF EXISTS `sequence_shipment_11`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_11` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_12`
--

DROP TABLE IF EXISTS `sequence_shipment_12`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_12` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_13`
--

DROP TABLE IF EXISTS `sequence_shipment_13`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_13` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_14`
--

DROP TABLE IF EXISTS `sequence_shipment_14`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_14` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_2`
--

DROP TABLE IF EXISTS `sequence_shipment_2`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_2` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=594 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_2';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_3`
--

DROP TABLE IF EXISTS `sequence_shipment_3`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_3` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=125263 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_3';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_4`
--

DROP TABLE IF EXISTS `sequence_shipment_4`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_4` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_4';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_5`
--

DROP TABLE IF EXISTS `sequence_shipment_5`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_5` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=2290 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_5';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_6`
--

DROP TABLE IF EXISTS `sequence_shipment_6`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_6` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_6';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_7`
--

DROP TABLE IF EXISTS `sequence_shipment_7`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_7` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_7';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_8`
--

DROP TABLE IF EXISTS `sequence_shipment_8`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_8` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_8';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequence_shipment_9`
--

DROP TABLE IF EXISTS `sequence_shipment_9`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequence_shipment_9` (
  `sequence_value` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sequence_value',
  PRIMARY KEY (`sequence_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='sequence_shipment_9';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `session`
--

DROP TABLE IF EXISTS `session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `session` (
  `session_id` varchar(255) NOT NULL COMMENT 'Session Id',
  `session_expires` int unsigned NOT NULL DEFAULT '0' COMMENT 'Date of Session Expiration',
  `session_data` mediumblob NOT NULL COMMENT 'Session Data',
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Database Sessions Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `setup_module`
--

DROP TABLE IF EXISTS `setup_module`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `setup_module` (
  `module` varchar(50) NOT NULL COMMENT 'Module',
  `schema_version` varchar(50) DEFAULT NULL COMMENT 'Schema Version',
  `data_version` varchar(50) DEFAULT NULL COMMENT 'Data Version',
  PRIMARY KEY (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Module versions registry';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shipping_tablerate`
--

DROP TABLE IF EXISTS `shipping_tablerate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shipping_tablerate` (
  `pk` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `website_id` int NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `dest_country_id` varchar(4) NOT NULL DEFAULT '0' COMMENT 'Destination coutry ISO/2 or ISO/3 code',
  `dest_region_id` int NOT NULL DEFAULT '0' COMMENT 'Destination Region ID',
  `dest_zip` varchar(10) NOT NULL DEFAULT '*' COMMENT 'Destination Post Code (Zip)',
  `condition_name` varchar(30) NOT NULL COMMENT 'Rate Condition name',
  `condition_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Rate condition value',
  `price` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Price',
  `cost` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Cost',
  PRIMARY KEY (`pk`),
  UNIQUE KEY `UNQ_D60821CDB2AFACEE1566CFC02D0D4CAA` (`website_id`,`dest_country_id`,`dest_region_id`,`dest_zip`,`condition_name`,`condition_value`)
) ENGINE=InnoDB AUTO_INCREMENT=19769 DEFAULT CHARSET=utf8mb3 COMMENT='Shipping Tablerate';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitemap`
--

DROP TABLE IF EXISTS `sitemap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitemap` (
  `sitemap_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Sitemap ID',
  `sitemap_type` varchar(32) DEFAULT NULL COMMENT 'Sitemap Type',
  `sitemap_filename` varchar(32) DEFAULT NULL COMMENT 'Sitemap Filename',
  `sitemap_path` varchar(255) DEFAULT NULL COMMENT 'Sitemap Path',
  `sitemap_time` timestamp NULL DEFAULT NULL COMMENT 'Sitemap Time',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  PRIMARY KEY (`sitemap_id`),
  KEY `SITEMAP_STORE_ID` (`store_id`),
  CONSTRAINT `SITEMAP_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COMMENT='XML Sitemap';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `store`
--

DROP TABLE IF EXISTS `store`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `store` (
  `store_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Store ID',
  `code` varchar(32) DEFAULT NULL COMMENT 'Code',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `group_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Group ID',
  `name` varchar(255) NOT NULL COMMENT 'Store Name',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Sort Order',
  `is_active` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store Activity',
  PRIMARY KEY (`store_id`),
  UNIQUE KEY `STORE_CODE` (`code`),
  KEY `STORE_WEBSITE_ID` (`website_id`),
  KEY `STORE_IS_ACTIVE_SORT_ORDER` (`is_active`,`sort_order`),
  KEY `STORE_GROUP_ID` (`group_id`),
  CONSTRAINT `STORE_GROUP_ID_STORE_GROUP_GROUP_ID` FOREIGN KEY (`group_id`) REFERENCES `store_group` (`group_id`) ON DELETE CASCADE,
  CONSTRAINT `STORE_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COMMENT='Stores';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `store_group`
--

DROP TABLE IF EXISTS `store_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `store_group` (
  `group_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Group ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `name` varchar(255) NOT NULL COMMENT 'Store Group Name',
  `root_category_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Root Category ID',
  `default_store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Default Store ID',
  `code` varchar(32) DEFAULT NULL COMMENT 'Store group unique code',
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `STORE_GROUP_CODE` (`code`),
  KEY `STORE_GROUP_WEBSITE_ID` (`website_id`),
  KEY `STORE_GROUP_DEFAULT_STORE_ID` (`default_store_id`),
  CONSTRAINT `STORE_GROUP_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COMMENT='Store Groups';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `store_website`
--

DROP TABLE IF EXISTS `store_website`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `store_website` (
  `website_id` smallint unsigned NOT NULL AUTO_INCREMENT COMMENT 'Website ID',
  `code` varchar(32) DEFAULT NULL COMMENT 'Code',
  `name` varchar(64) DEFAULT NULL COMMENT 'Website Name',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `default_group_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Default Group ID',
  `is_default` smallint unsigned DEFAULT '0' COMMENT 'Defines Is Website Default',
  PRIMARY KEY (`website_id`),
  UNIQUE KEY `STORE_WEBSITE_CODE` (`code`),
  KEY `STORE_WEBSITE_SORT_ORDER` (`sort_order`),
  KEY `STORE_WEBSITE_DEFAULT_GROUP_ID` (`default_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COMMENT='Websites';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stores_data_exporter`
--

DROP TABLE IF EXISTS `stores_data_exporter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stores_data_exporter` (
  `id` int unsigned NOT NULL COMMENT 'ID',
  `feed_data` mediumtext NOT NULL COMMENT 'Feed Data',
  `modified_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Modified At',
  PRIMARY KEY (`id`),
  KEY `STORES_DATA_EXPORTER_MODIFIED_AT` (`modified_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Stores Feed Storage';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stores_data_exporter_index_batches`
--

DROP TABLE IF EXISTS `stores_data_exporter_index_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stores_data_exporter_index_batches` (
  `batch_number` int NOT NULL COMMENT 'Batch Number',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website Id',
  PRIMARY KEY (`batch_number`,`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='stores_data_exporter_index_batches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `stores_data_exporter_index_sequence`
--

DROP TABLE IF EXISTS `stores_data_exporter_index_sequence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stores_data_exporter_index_sequence` (
  `i` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Auto Increment ID',
  PRIMARY KEY (`i`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COMMENT='stores_data_exporter_index_sequence';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_calculation`
--

DROP TABLE IF EXISTS `tax_calculation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_calculation` (
  `tax_calculation_id` int NOT NULL AUTO_INCREMENT COMMENT 'Tax Calculation ID',
  `tax_calculation_rate_id` int NOT NULL COMMENT 'Tax Calculation Rate ID',
  `tax_calculation_rule_id` int NOT NULL COMMENT 'Tax Calculation Rule ID',
  `customer_tax_class_id` smallint NOT NULL COMMENT 'Customer Tax Class ID',
  `product_tax_class_id` smallint NOT NULL COMMENT 'Product Tax Class ID',
  PRIMARY KEY (`tax_calculation_id`),
  KEY `TAX_CALCULATION_TAX_CALCULATION_RULE_ID` (`tax_calculation_rule_id`),
  KEY `TAX_CALCULATION_CUSTOMER_TAX_CLASS_ID` (`customer_tax_class_id`),
  KEY `TAX_CALCULATION_PRODUCT_TAX_CLASS_ID` (`product_tax_class_id`),
  KEY `TAX_CALC_TAX_CALC_RATE_ID_CSTR_TAX_CLASS_ID_PRD_TAX_CLASS_ID` (`tax_calculation_rate_id`,`customer_tax_class_id`,`product_tax_class_id`),
  CONSTRAINT `TAX_CALC_TAX_CALC_RATE_ID_TAX_CALC_RATE_TAX_CALC_RATE_ID` FOREIGN KEY (`tax_calculation_rate_id`) REFERENCES `tax_calculation_rate` (`tax_calculation_rate_id`) ON DELETE CASCADE,
  CONSTRAINT `TAX_CALC_TAX_CALC_RULE_ID_TAX_CALC_RULE_TAX_CALC_RULE_ID` FOREIGN KEY (`tax_calculation_rule_id`) REFERENCES `tax_calculation_rule` (`tax_calculation_rule_id`) ON DELETE CASCADE,
  CONSTRAINT `TAX_CALCULATION_CUSTOMER_TAX_CLASS_ID_TAX_CLASS_CLASS_ID` FOREIGN KEY (`customer_tax_class_id`) REFERENCES `tax_class` (`class_id`) ON DELETE CASCADE,
  CONSTRAINT `TAX_CALCULATION_PRODUCT_TAX_CLASS_ID_TAX_CLASS_CLASS_ID` FOREIGN KEY (`product_tax_class_id`) REFERENCES `tax_class` (`class_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1138628 DEFAULT CHARSET=utf8mb3 COMMENT='Tax Calculation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_calculation_rate`
--

DROP TABLE IF EXISTS `tax_calculation_rate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_calculation_rate` (
  `tax_calculation_rate_id` int NOT NULL AUTO_INCREMENT COMMENT 'Tax Calculation Rate ID',
  `tax_country_id` varchar(2) NOT NULL COMMENT 'Tax Country ID',
  `tax_region_id` int NOT NULL COMMENT 'Tax Region ID',
  `tax_postcode` varchar(21) DEFAULT NULL COMMENT 'Tax Postcode',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `rate` decimal(12,4) NOT NULL COMMENT 'Rate',
  `zip_is_range` smallint DEFAULT NULL COMMENT 'Zip Is Range',
  `zip_from` int unsigned DEFAULT NULL COMMENT 'Zip From',
  `zip_to` int unsigned DEFAULT NULL COMMENT 'Zip To',
  PRIMARY KEY (`tax_calculation_rate_id`),
  KEY `TAX_CALCULATION_RATE_TAX_COUNTRY_ID_TAX_REGION_ID_TAX_POSTCODE` (`tax_country_id`,`tax_region_id`,`tax_postcode`),
  KEY `TAX_CALCULATION_RATE_CODE` (`code`),
  KEY `IDX_CA799F1E2CB843495F601E56C84A626D` (`tax_calculation_rate_id`,`tax_country_id`,`tax_region_id`,`zip_is_range`,`tax_postcode`)
) ENGINE=InnoDB AUTO_INCREMENT=706485 DEFAULT CHARSET=utf8mb3 COMMENT='Tax Calculation Rate';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_calculation_rate_title`
--

DROP TABLE IF EXISTS `tax_calculation_rate_title`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_calculation_rate_title` (
  `tax_calculation_rate_title_id` int NOT NULL AUTO_INCREMENT COMMENT 'Tax Calculation Rate Title ID',
  `tax_calculation_rate_id` int NOT NULL COMMENT 'Tax Calculation Rate ID',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  PRIMARY KEY (`tax_calculation_rate_title_id`),
  KEY `TAX_CALCULATION_RATE_TITLE_TAX_CALCULATION_RATE_ID_STORE_ID` (`tax_calculation_rate_id`,`store_id`),
  KEY `TAX_CALCULATION_RATE_TITLE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_37FB965F786AD5897BB3AE90470C42AB` FOREIGN KEY (`tax_calculation_rate_id`) REFERENCES `tax_calculation_rate` (`tax_calculation_rate_id`) ON DELETE CASCADE,
  CONSTRAINT `TAX_CALCULATION_RATE_TITLE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Tax Calculation Rate Title';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_calculation_rule`
--

DROP TABLE IF EXISTS `tax_calculation_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_calculation_rule` (
  `tax_calculation_rule_id` int NOT NULL AUTO_INCREMENT COMMENT 'Tax Calculation Rule ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `priority` int NOT NULL COMMENT 'Priority',
  `position` int NOT NULL COMMENT 'Position',
  `calculate_subtotal` int NOT NULL COMMENT 'Calculate off subtotal option',
  PRIMARY KEY (`tax_calculation_rule_id`),
  KEY `TAX_CALCULATION_RULE_PRIORITY_POSITION` (`priority`,`position`),
  KEY `TAX_CALCULATION_RULE_CODE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb3 COMMENT='Tax Calculation Rule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_nexus`
--

DROP TABLE IF EXISTS `tax_nexus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_nexus` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `api_id` int unsigned DEFAULT NULL COMMENT 'API ID',
  `street` varchar(255) DEFAULT NULL COMMENT 'Street',
  `city` varchar(255) DEFAULT NULL COMMENT 'City',
  `country_id` varchar(2) DEFAULT NULL COMMENT 'Country Id',
  `region` varchar(255) DEFAULT NULL COMMENT 'Region',
  `region_id` int DEFAULT NULL COMMENT 'Region Id',
  `region_code` varchar(255) DEFAULT NULL COMMENT 'Region Code',
  `postcode` varchar(255) DEFAULT NULL COMMENT 'Postcode',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  PRIMARY KEY (`id`),
  KEY `TAX_NEXUS_COUNTRY_ID` (`country_id`),
  KEY `TAX_NEXUS_REGION_ID` (`region_id`),
  KEY `TAX_NEXUS_REGION_CODE` (`region_code`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb3 COMMENT='TaxJar Nexus Address';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_order_aggregated_created`
--

DROP TABLE IF EXISTS `tax_order_aggregated_created`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_order_aggregated_created` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `order_status` varchar(50) NOT NULL COMMENT 'Order Status',
  `percent` float DEFAULT NULL COMMENT 'Percent',
  `orders_count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `tax_base_amount_sum` float DEFAULT NULL COMMENT 'Tax Base Amount Sum',
  `shipping_amount_sum` float NOT NULL DEFAULT '0' COMMENT 'Shipping amount',
  `orders_subtotal_sum` float NOT NULL DEFAULT '0' COMMENT 'Orders subtotal',
  `orders_grand_total_sum` float NOT NULL DEFAULT '0' COMMENT 'Orders Grand total',
  PRIMARY KEY (`id`),
  UNIQUE KEY `TAX_ORDER_AGGRED_CREATED_PERIOD_STORE_ID_CODE_PERCENT_ORDER_STS` (`period`,`store_id`,`code`,`percent`,`order_status`),
  KEY `TAX_ORDER_AGGREGATED_CREATED_STORE_ID` (`store_id`),
  CONSTRAINT `TAX_ORDER_AGGREGATED_CREATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Tax Order Aggregation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tax_order_aggregated_updated`
--

DROP TABLE IF EXISTS `tax_order_aggregated_updated`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_order_aggregated_updated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `period` date DEFAULT NULL COMMENT 'Period',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `order_status` varchar(50) NOT NULL COMMENT 'Order Status',
  `percent` float DEFAULT NULL COMMENT 'Percent',
  `orders_count` int unsigned NOT NULL DEFAULT '0' COMMENT 'Orders Count',
  `tax_base_amount_sum` float DEFAULT NULL COMMENT 'Tax Base Amount Sum',
  `shipping_amount_sum` float NOT NULL DEFAULT '0' COMMENT 'Shipping amount',
  `orders_subtotal_sum` float NOT NULL DEFAULT '0' COMMENT 'Orders subtotal',
  `orders_grand_total_sum` float NOT NULL DEFAULT '0' COMMENT 'Orders Grand total',
  PRIMARY KEY (`id`),
  UNIQUE KEY `TAX_ORDER_AGGRED_UPDATED_PERIOD_STORE_ID_CODE_PERCENT_ORDER_STS` (`period`,`store_id`,`code`,`percent`,`order_status`),
  KEY `TAX_ORDER_AGGREGATED_UPDATED_STORE_ID` (`store_id`),
  CONSTRAINT `TAX_ORDER_AGGREGATED_UPDATED_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Tax Order Aggregated Updated';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `theme`
--

DROP TABLE IF EXISTS `theme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `theme` (
  `theme_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Theme identifier',
  `parent_id` int DEFAULT NULL COMMENT 'Parent ID',
  `theme_path` varchar(255) DEFAULT NULL COMMENT 'Theme Path',
  `theme_title` varchar(255) NOT NULL COMMENT 'Theme Title',
  `preview_image` varchar(255) DEFAULT NULL COMMENT 'Preview Image',
  `is_featured` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Theme Featured',
  `area` varchar(255) NOT NULL COMMENT 'Theme Area',
  `type` smallint NOT NULL COMMENT 'Theme type: 0:physical, 1:virtual, 2:staging',
  `code` text COMMENT 'Full theme code, including package',
  PRIMARY KEY (`theme_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COMMENT='Core theme';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `theme_file`
--

DROP TABLE IF EXISTS `theme_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `theme_file` (
  `theme_files_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Theme files identifier',
  `theme_id` int unsigned NOT NULL COMMENT 'Theme ID',
  `file_path` varchar(255) DEFAULT NULL COMMENT 'Relative path to file',
  `file_type` varchar(32) NOT NULL COMMENT 'File Type',
  `content` longtext NOT NULL COMMENT 'File Content',
  `sort_order` smallint NOT NULL DEFAULT '0' COMMENT 'Sort Order',
  `is_temporary` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is Temporary File',
  PRIMARY KEY (`theme_files_id`),
  KEY `THEME_FILE_THEME_ID_THEME_THEME_ID` (`theme_id`),
  CONSTRAINT `THEME_FILE_THEME_ID_THEME_THEME_ID` FOREIGN KEY (`theme_id`) REFERENCES `theme` (`theme_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Core theme files';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tj_product_tax_categories`
--

DROP TABLE IF EXISTS `tj_product_tax_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tj_product_tax_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `product_tax_code` varchar(32) NOT NULL DEFAULT '' COMMENT 'Product Tax Code',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT 'Description',
  PRIMARY KEY (`id`),
  KEY `TJ_PRODUCT_TAX_CATEGORIES_PRODUCT_TAX_CODE` (`product_tax_code`)
) ENGINE=InnoDB AUTO_INCREMENT=850 DEFAULT CHARSET=utf8mb3 COMMENT='TaxJar Product Tax Codes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tj_sales_order_metadata`
--

DROP TABLE IF EXISTS `tj_sales_order_metadata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tj_sales_order_metadata` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `order_id` int unsigned NOT NULL COMMENT 'Order_id',
  `tax_calculation_status` text NOT NULL COMMENT 'Tax_calculation_status',
  `tax_calculation_message` text NOT NULL COMMENT 'Tax_calculation_message',
  `prevent_tax_sync` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Prevent Tax Sync',
  PRIMARY KEY (`entity_id`),
  KEY `TJ_SALES_ORDER_METADATA_ORDER_ID` (`order_id`),
  CONSTRAINT `TJ_SALES_ORDER_METADATA_ORDER_ID_SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16763 DEFAULT CHARSET=utf8mb3 COMMENT='TaxJar Sales Order Metadata';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `translation`
--

DROP TABLE IF EXISTS `translation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `translation` (
  `key_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Key ID of Translation',
  `string` varchar(255) NOT NULL DEFAULT 'Translate String' COMMENT 'Translation String',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `translate` varchar(255) DEFAULT NULL COMMENT 'Translate',
  `locale` varchar(20) NOT NULL DEFAULT 'en_US' COMMENT 'Locale',
  `crc_string` bigint NOT NULL DEFAULT '1591228201' COMMENT 'Translation String CRC32 Hash',
  PRIMARY KEY (`key_id`),
  UNIQUE KEY `TRANSLATION_STORE_ID_LOCALE_CRC_STRING_STRING` (`store_id`,`locale`,`crc_string`,`string`),
  CONSTRAINT `TRANSLATION_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Translations';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `trustpilot_store_reviews`
--

DROP TABLE IF EXISTS `trustpilot_store_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `trustpilot_store_reviews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `review_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `rating` tinyint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `review` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `customer_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reference_number` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reply_date` datetime DEFAULT NULL,
  `reply_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `store_id` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mailchimp_survey_store_id_IDX` (`store_id`,`email`,`created_at`,`rating`) USING BTREE,
  KEY `mailchimp_survey_store_id_reference_number_rating_IDX` (`store_id`,`reference_number`,`rating`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ui_bookmark`
--

DROP TABLE IF EXISTS `ui_bookmark`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ui_bookmark` (
  `bookmark_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Bookmark identifier',
  `user_id` int unsigned NOT NULL COMMENT 'User ID',
  `namespace` varchar(255) NOT NULL COMMENT 'Bookmark namespace',
  `identifier` varchar(255) NOT NULL COMMENT 'Bookmark Identifier',
  `current` smallint NOT NULL COMMENT 'Mark current bookmark per user and identifier',
  `title` varchar(255) DEFAULT NULL COMMENT 'Bookmark title',
  `config` longtext COMMENT 'Bookmark config',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Bookmark created at',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Bookmark updated at',
  PRIMARY KEY (`bookmark_id`),
  KEY `UI_BOOKMARK_USER_ID_NAMESPACE_IDENTIFIER` (`user_id`,`namespace`,`identifier`),
  CONSTRAINT `UI_BOOKMARK_USER_ID_ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=412 DEFAULT CHARSET=utf8mb3 COMMENT='Bookmark';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `url_rewrite`
--

DROP TABLE IF EXISTS `url_rewrite`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `url_rewrite` (
  `url_rewrite_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rewrite ID',
  `entity_type` varchar(32) NOT NULL COMMENT 'Entity type code',
  `entity_id` int unsigned NOT NULL COMMENT 'Entity ID',
  `request_path` varchar(255) DEFAULT NULL COMMENT 'Request Path',
  `target_path` varchar(255) DEFAULT NULL COMMENT 'Target Path',
  `redirect_type` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Redirect Type',
  `store_id` smallint unsigned NOT NULL COMMENT 'Store ID',
  `description` varchar(255) DEFAULT NULL COMMENT 'Description',
  `is_autogenerated` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Is rewrite generated automatically flag',
  `metadata` varchar(255) DEFAULT NULL COMMENT 'Meta data for url rewrite',
  PRIMARY KEY (`url_rewrite_id`),
  UNIQUE KEY `URL_REWRITE_REQUEST_PATH_STORE_ID` (`request_path`,`store_id`),
  KEY `URL_REWRITE_TARGET_PATH` (`target_path`),
  KEY `URL_REWRITE_STORE_ID_ENTITY_ID` (`store_id`,`entity_id`),
  KEY `URL_REWRITE_ENTITY_ID` (`entity_id`),
  KEY `URL_REWRITE_IS_AUTOGENERATED_METADATA` (`is_autogenerated`,`metadata`)
) ENGINE=InnoDB AUTO_INCREMENT=108217 DEFAULT CHARSET=utf8mb3 COMMENT='Url Rewrites';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `variable`
--

DROP TABLE IF EXISTS `variable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variable` (
  `variable_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Variable ID',
  `code` varchar(255) DEFAULT NULL COMMENT 'Variable Code',
  `name` varchar(255) DEFAULT NULL COMMENT 'Variable Name',
  PRIMARY KEY (`variable_id`),
  UNIQUE KEY `VARIABLE_CODE` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Variables';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `variable_value`
--

DROP TABLE IF EXISTS `variable_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `variable_value` (
  `value_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Variable Value ID',
  `variable_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Variable ID',
  `store_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `plain_value` text COMMENT 'Plain Text Value',
  `html_value` text COMMENT 'Html Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `VARIABLE_VALUE_VARIABLE_ID_STORE_ID` (`variable_id`,`store_id`),
  KEY `VARIABLE_VALUE_STORE_ID` (`store_id`),
  CONSTRAINT `VARIABLE_VALUE_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `VARIABLE_VALUE_VARIABLE_ID_VARIABLE_VARIABLE_ID` FOREIGN KEY (`variable_id`) REFERENCES `variable` (`variable_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COMMENT='Variable Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vault_payment_token`
--

DROP TABLE IF EXISTS `vault_payment_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vault_payment_token` (
  `entity_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `customer_id` int unsigned DEFAULT NULL COMMENT 'Customer ID',
  `website_id` int unsigned DEFAULT NULL COMMENT 'Website ID',
  `public_hash` varchar(128) NOT NULL COMMENT 'Hash code for using on frontend',
  `payment_method_code` varchar(128) NOT NULL COMMENT 'Payment method code',
  `type` varchar(128) NOT NULL COMMENT 'Type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `expires_at` timestamp NULL DEFAULT NULL COMMENT 'Expires At',
  `gateway_token` varchar(255) NOT NULL COMMENT 'Gateway Token',
  `details` text COMMENT 'Details',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `VAULT_PAYMENT_TOKEN_PUBLIC_HASH` (`public_hash`),
  UNIQUE KEY `VAULT_PAYMENT_TOKEN_PAYMENT_METHOD_CODE_CSTR_ID_GATEWAY_TOKEN` (`payment_method_code`,`customer_id`,`gateway_token`),
  KEY `VAULT_PAYMENT_TOKEN_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` (`customer_id`),
  CONSTRAINT `VAULT_PAYMENT_TOKEN_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Vault tokens of payment';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `vault_payment_token_order_payment_link`
--

DROP TABLE IF EXISTS `vault_payment_token_order_payment_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `vault_payment_token_order_payment_link` (
  `order_payment_id` int unsigned NOT NULL COMMENT 'Order payment ID',
  `payment_token_id` int unsigned NOT NULL COMMENT 'Payment token ID',
  PRIMARY KEY (`order_payment_id`,`payment_token_id`),
  KEY `FK_4ED894655446D385894580BECA993862` (`payment_token_id`),
  CONSTRAINT `FK_4ED894655446D385894580BECA993862` FOREIGN KEY (`payment_token_id`) REFERENCES `vault_payment_token` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_CF37B9D854256534BE23C818F6291CA2` FOREIGN KEY (`order_payment_id`) REFERENCES `sales_order_payment` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Order payments to vault token';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `weee_tax`
--

DROP TABLE IF EXISTS `weee_tax`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `weee_tax` (
  `value_id` int NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `website_id` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Website ID',
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `country` varchar(2) DEFAULT NULL COMMENT 'Country',
  `value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Value',
  `state` int NOT NULL DEFAULT '0' COMMENT 'State',
  `attribute_id` smallint unsigned NOT NULL COMMENT 'Attribute ID',
  PRIMARY KEY (`value_id`),
  KEY `WEEE_TAX_WEBSITE_ID` (`website_id`),
  KEY `WEEE_TAX_ENTITY_ID` (`entity_id`),
  KEY `WEEE_TAX_COUNTRY` (`country`),
  KEY `WEEE_TAX_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `WEEE_TAX_ATTRIBUTE_ID_EAV_ATTRIBUTE_ATTRIBUTE_ID` FOREIGN KEY (`attribute_id`) REFERENCES `eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `WEEE_TAX_COUNTRY_DIRECTORY_COUNTRY_COUNTRY_ID` FOREIGN KEY (`country`) REFERENCES `directory_country` (`country_id`) ON DELETE CASCADE,
  CONSTRAINT `WEEE_TAX_ENTITY_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`entity_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `WEEE_TAX_WEBSITE_ID_STORE_WEBSITE_WEBSITE_ID` FOREIGN KEY (`website_id`) REFERENCES `store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Weee Tax';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widget`
--

DROP TABLE IF EXISTS `widget`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widget` (
  `widget_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Widget ID',
  `widget_code` varchar(255) DEFAULT NULL COMMENT 'Widget code for template directive',
  `widget_type` varchar(255) DEFAULT NULL COMMENT 'Widget Type',
  `parameters` text COMMENT 'Parameters',
  PRIMARY KEY (`widget_id`),
  KEY `WIDGET_WIDGET_CODE` (`widget_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Preconfigured Widgets';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widget_instance`
--

DROP TABLE IF EXISTS `widget_instance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widget_instance` (
  `instance_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Instance ID',
  `instance_type` varchar(255) DEFAULT NULL COMMENT 'Instance Type',
  `theme_id` int unsigned NOT NULL COMMENT 'Theme ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Widget Title',
  `store_ids` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Store ids',
  `widget_parameters` text COMMENT 'Widget parameters',
  `sort_order` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Sort order',
  PRIMARY KEY (`instance_id`),
  KEY `WIDGET_INSTANCE_THEME_ID_THEME_THEME_ID` (`theme_id`),
  CONSTRAINT `WIDGET_INSTANCE_THEME_ID_THEME_THEME_ID` FOREIGN KEY (`theme_id`) REFERENCES `theme` (`theme_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Instances of Widget for Package Theme';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widget_instance_page`
--

DROP TABLE IF EXISTS `widget_instance_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widget_instance_page` (
  `page_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Page ID',
  `instance_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Instance ID',
  `page_group` varchar(25) DEFAULT NULL COMMENT 'Block Group Type',
  `layout_handle` varchar(255) DEFAULT NULL COMMENT 'Layout Handle',
  `block_reference` varchar(255) DEFAULT NULL COMMENT 'Container',
  `page_for` varchar(25) DEFAULT NULL COMMENT 'For instance entities',
  `entities` text COMMENT 'Catalog entities (comma separated)',
  `page_template` varchar(255) DEFAULT NULL COMMENT 'Path to widget template',
  PRIMARY KEY (`page_id`),
  KEY `WIDGET_INSTANCE_PAGE_INSTANCE_ID` (`instance_id`),
  CONSTRAINT `WIDGET_INSTANCE_PAGE_INSTANCE_ID_WIDGET_INSTANCE_INSTANCE_ID` FOREIGN KEY (`instance_id`) REFERENCES `widget_instance` (`instance_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Instance of Widget on Page';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widget_instance_page_layout`
--

DROP TABLE IF EXISTS `widget_instance_page_layout`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widget_instance_page_layout` (
  `page_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Page ID',
  `layout_update_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Layout Update ID',
  PRIMARY KEY (`layout_update_id`,`page_id`),
  KEY `WIDGET_INSTANCE_PAGE_LAYOUT_PAGE_ID` (`page_id`),
  CONSTRAINT `WIDGET_INSTANCE_PAGE_LAYOUT_PAGE_ID_WIDGET_INSTANCE_PAGE_PAGE_ID` FOREIGN KEY (`page_id`) REFERENCES `widget_instance_page` (`page_id`) ON DELETE CASCADE,
  CONSTRAINT `WIDGET_INSTANCE_PAGE_LYT_LYT_UPDATE_ID_LYT_UPDATE_LYT_UPDATE_ID` FOREIGN KEY (`layout_update_id`) REFERENCES `layout_update` (`layout_update_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Layout updates';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wishlist`
--

DROP TABLE IF EXISTS `wishlist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wishlist` (
  `wishlist_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Wishlist ID',
  `customer_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Customer ID',
  `shared` smallint unsigned NOT NULL DEFAULT '0' COMMENT 'Sharing flag (0 or 1)',
  `sharing_code` varchar(32) DEFAULT NULL COMMENT 'Sharing encrypted code',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Last updated date',
  PRIMARY KEY (`wishlist_id`),
  UNIQUE KEY `WISHLIST_CUSTOMER_ID` (`customer_id`),
  KEY `WISHLIST_SHARED` (`shared`),
  CONSTRAINT `WISHLIST_CUSTOMER_ID_CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5669 DEFAULT CHARSET=utf8mb3 COMMENT='Wishlist main Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wishlist_item`
--

DROP TABLE IF EXISTS `wishlist_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wishlist_item` (
  `wishlist_item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Wishlist item ID',
  `wishlist_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Wishlist ID',
  `product_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint unsigned DEFAULT NULL COMMENT 'Store ID',
  `added_at` timestamp NULL DEFAULT NULL COMMENT 'Add date and time',
  `description` text COMMENT 'Short description of wish list item',
  `qty` decimal(12,4) NOT NULL COMMENT 'Qty',
  PRIMARY KEY (`wishlist_item_id`),
  KEY `WISHLIST_ITEM_WISHLIST_ID` (`wishlist_id`),
  KEY `WISHLIST_ITEM_PRODUCT_ID` (`product_id`),
  KEY `WISHLIST_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `WISHLIST_ITEM_PRODUCT_ID_CATALOG_PRODUCT_ENTITY_ENTITY_ID` FOREIGN KEY (`product_id`) REFERENCES `catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `WISHLIST_ITEM_STORE_ID_STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `store` (`store_id`) ON DELETE SET NULL,
  CONSTRAINT `WISHLIST_ITEM_WISHLIST_ID_WISHLIST_WISHLIST_ID` FOREIGN KEY (`wishlist_id`) REFERENCES `wishlist` (`wishlist_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Wishlist items';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `wishlist_item_option`
--

DROP TABLE IF EXISTS `wishlist_item_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `wishlist_item_option` (
  `option_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `wishlist_item_id` int unsigned NOT NULL COMMENT 'Wishlist Item ID',
  `product_id` int unsigned NOT NULL COMMENT 'Product ID',
  `code` varchar(255) NOT NULL COMMENT 'Code',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`option_id`),
  KEY `FK_A014B30B04B72DD0EAB3EECD779728D6` (`wishlist_item_id`),
  CONSTRAINT `FK_A014B30B04B72DD0EAB3EECD779728D6` FOREIGN KEY (`wishlist_item_id`) REFERENCES `wishlist_item` (`wishlist_item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='Wishlist Item Option Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'budsies_staging'
--
/*!50003 DROP PROCEDURE IF EXISTS `update_auto_increment` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_0900_ai_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE DEFINER=CURRENT_USER PROCEDURE `update_auto_increment`(_table VARCHAR(128), _fieldname VARCHAR(128), _cnt VARCHAR(128))
BEGIN
        DECLARE _max_stmt VARCHAR(1024);
        DECLARE _stmt VARCHAR(1024);    
        SET @inc := 0;

        SET @MAX_SQL := CONCAT('SELECT IFNULL(MAX(',_fieldname,'), 0) + ',_cnt,' INTO @inc FROM ', _table);
        PREPARE _max_stmt FROM @MAX_SQL;
        EXECUTE _max_stmt;
        DEALLOCATE PREPARE _max_stmt;

        SET @SQL := CONCAT('ALTER TABLE ', _table, ' AUTO_INCREMENT =  ', @inc);
        PREPARE _stmt FROM @SQL;
        EXECUTE _stmt;
        DEALLOCATE PREPARE _stmt;
    END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Final view structure for view `inventory_stock_1`
--

/*!50001 DROP VIEW IF EXISTS `inventory_stock_1`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb3 */;
/*!50001 SET character_set_results     = utf8mb3 */;
/*!50001 SET collation_connection      = utf8mb3_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=CURRENT_USER SQL SECURITY INVOKER */
/*!50001 VIEW `inventory_stock_1` AS select distinct `legacy_stock_status`.`product_id` AS `product_id`,`legacy_stock_status`.`website_id` AS `website_id`,`legacy_stock_status`.`stock_id` AS `stock_id`,`legacy_stock_status`.`qty` AS `quantity`,`legacy_stock_status`.`stock_status` AS `is_salable`,`product`.`sku` AS `sku` from (`cataloginventory_stock_status` `legacy_stock_status` join `catalog_product_entity` `product` on((`legacy_stock_status`.`product_id` = `product`.`entity_id`))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-06  1:39:39
SET autocommit=0;
-- MySQL dump 10.13  Distrib 8.0.36, for Linux (x86_64)
--
-- Host: server    Database: budsies_staging
-- ------------------------------------------------------
-- Server version	8.0.36

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `admin_adobe_ims_webapi`
--


--
-- Dumping data for table `admin_analytics_usage_version_log`
--

INSERT INTO `admin_analytics_usage_version_log` VALUES (1,'2.4.7');

--
-- Dumping data for table `admin_passwords`
--

INSERT INTO `admin_passwords` VALUES (1,1,'1c91fabb780f1c6477b8635c4a035a42a48761d78e3d76c82c7cab21e8cf2fa1:gLpWEZ82mq423Z8K88b4xmealP55e9l1:3_32_2_67108864',0,1726683854),(2,1,'e851b5e91ef27ae3d448dec3571729cd77d2d07a38df9ea8abd336ffd22f9313:de5vsGz8ZPQKFQljToAsXqhVf5Ds5PFN:3_32_2_67108864',0,1737993252),(3,2,'6e72d4f05568984f8986200208f851419197e481058c6b142af868fd538957a5:rODdvCPvq9ZjZHcYvqOltXIR0NQGrTzl:3_32_2_67108864',0,1738592250),(4,3,'9257b0273541a36309904b2de9819441ec73c6c1ae0608586188e92938910493:68ETEBejeb9G4AUdgaZMCR2gM4bWmjuI:3_32_2_67108864',0,1738592761),(5,2,'d5d684f24378b6569fb7c19d0a4f7262551b04e312dc850b00d990b4ac9b4594:4GVYcQ3Xm93QYADLtTrE58rNUqwJFnNF:3_32_2_67108864',0,1738593057),(6,4,'58654b6713ff8f8992d83d824f9b4b24f70d049ac11a5feea277ee770767a51b:1LVaTH2yzPunNhKDHHKMWHXpvYVOfxAP:3_32_2_67108864',0,1738593135),(7,5,'533c3ab7a4386c7a916b9287552f7fc38015fb3640073abce71c253b2d240b52:0x4ceu93Ahng74DR0jwjaIeOR21cLdNH:3_32_2_67108864',0,1738593297),(8,6,'e6809f165653ffaff873f1985d1e92bb5e0e9f45fdb2fd6ac076b8c4b90e1651:FdLRO8GCIydScFkJi4K32onaPBP36NHl:3_32_2_67108864',0,1738593339),(9,7,'f51369fc854542a947b20d51a6a5ee04429f75fc5b25bbfb377f1fad666819a3:p3Nd4wXD3JUmj5dLvJFVz97Tqi6ZTQQQ:3_32_2_67108864',0,1738594264),(10,8,'17545ac5bc855adfd41911cd8f07bd9b15e1ecfef73c646e8e188f317c54c31d:0TPSUKlNXBRLrPn5b6t2rZx10Zle2A9z:3_32_2_67108864',0,1738594301),(11,9,'d70bdb58ae0ac28736951cd505ef228c9facd06458e3cf754da4be48b8d17f2b:08X17SDviKXyrRfD4Kd7cDWgXREg6On0:3_32_2_67108864',0,1738594333),(12,10,'9a550d483c2d13c22575b7fc278d0fcc684b158eafb99c5364ec73d14d795182:PTzWvbkNJ6UZ7Yd6tbbW0xkL59lJDPhg:3_32_2_67108864',0,1738594365),(13,11,'a5c9244fa1e4c5b6478116406ce19027ec92a1e2d44a3ce262a32a6ae092c427:QhiyZnETFxZH4mMoSlSzHa2D4qpwrXp2:3_32_2_67108864',0,1738594403),(14,12,'a1b430a266e3e26e9a4612b72815c4c8446b4b19d6174398e6a2fcfd46865703:PS5gbGKKNPxxxuvohOA73AyEW7OvLl9J:3_32_2_67108864',0,1738594438),(15,13,'7e33c56109262566a6aa88f80f76dc579991e713c2ce6ad5b3de1f3328c08983:cWVwWCSBTrawHQKzkqlbc2wJ6N5lnyNs:3_32_2_67108864',0,1738594481),(16,14,'e52bb067f52987bb53d1627a89d499054113b6702876dd44d1c618660dc3cb47:RM12ug428yMj1qfqre7ZBU7qq4KZFP3Y:3_32_2_67108864',0,1738594516),(17,15,'61da9897f9bc6556da2e1a3f33fc470c63f3726f3e81e9dcb19f4c02b0054d8f:iW6SRIJoxc9lkCmPn5VJILhryVYlmm89:3_32_2_67108864',0,1738594548),(18,16,'345d2e5a6bb8aee61efcc5e3c0f6f1983172077690f43ec283bba74d0013f1e1:Q8SPEIkoLeXdvO6h8MeShDo4QOMvKMMO:3_32_2_67108864',0,1738594580),(19,17,'36e31b0c2c071b046d074bb52900c8a75b1305010260dfb36897a5fd8860ee39:MWRCXLaoxHq53piaWIFPYwf2s6xfqLrQ:3_32_2_67108864',0,1738594621),(20,18,'20c623c75fb9351bb5f3c3392f00a87230fa2219f71502f0cabf469221a489c2:VXNnpM6c0PvDs9tUZEIJbVXxacN0Ltj3:3_32_2_67108864',0,1738594654),(21,19,'96a5b9dd95395b84222db5263710f3b551683565dd4bff1a9285cc4c439c6731:3RKOPc56f8z7uV4N4Y1JVYVyJSUyQuYc:3_32_2_67108864',0,1738594684),(22,20,'1eafdb064e2d13d13cfaaea058a5bdb9009ada41e80ea20adf7cf75d7a78e101:KhbCMfHj0VrjkE51ny3oqEdJziEjZOn5:3_32_2_67108864',0,1738594715),(23,21,'3860085452cc7ca76742113bbce35fc1a75a049a5694e40fac5006e93c418517:sR6uddd3YBq33b6A1dk9340Hi9Pava7X:3_32_2_67108864',0,1738594745),(24,22,'c77985e5853c13a5dab5266457b4309f4c70c47bd28d4ef20d199ec655043988:2CndsjjTWlG6gi9AhVcEw1bpyiyREK6Q:3_32_2_67108864',0,1738594775),(25,23,'15f894e9fa2d45cca943a2825157f7d16c87e172b8644627a7b8502eca7dd97e:2dD6qHEHSqV6VHd5MWFUZ47Y8sygxFDr:3_32_2_67108864',0,1738594937),(26,11,'4c27663e5e9f53ffe878a4c0201c4b9b0b89a9a58022df0bae614f57fc854577:2ff7imBxVrM9C73jkK8jArloTD5xjXKW:3_32_2_67108864',0,1738674060),(27,10,'ea1aa323199e09f6ab325c326a108aeb7176866d3add937e16d8188a69242029:wnZm5byGHtHOhBIHOnIeK300DleeQzXQ:3_32_2_67108864',0,1738674546),(28,19,'c06d35cafba6e7aa935dcfb8db953b32567282ad3d2a13c4efe761524ba5fed1:x3jw5ez213dK0ShCXTcRCbHHp9IHiDQH:3_32_2_67108864',0,1738674713),(29,5,'8545d87a4384255e3eaa59aa4955dc426390323bbece559d2a0e05427cd33bda:RTMFt8TgIE2emBJGZZIBzZAdNchFmVCF:3_32_2_67108864',0,1738675543),(30,22,'79a89cef5b335e25d6f1413b27ec7120308ec60569c0bb20df47aad9a092b184:ozyLudW9OlgDW5hUDmKAKGq99ACVBGrV:3_32_2_67108864',0,1738675647),(31,24,'a26fb2d7e138f7815e371f2502b4cbee081e47b57dbf64126f7b815ee08e87f3:wnVDR46Z7QZ41CbANMsKYyPQWfJRgL9H:3_32_2_67108864',0,1738675690),(32,24,'d6fd228076a453fdc21f4d5c9acfaab5577268666a237200e10443342bbd9e4a:AVAWAXV6EUiWEPZWPm1Xndd4AexLecPC:3_32_2_67108864',0,1738675788),(33,8,'fe5a151255a748170f9b94a8e8ad8433272b0b2cb845d0ec89c71a52ee008e7c:caIfXBuXG3okeLyDK5GOtjx76l3pKEWD:3_32_2_67108864',0,1738675897),(34,16,'ac26d44b3e09dad7eb68c47756180d72f77aae43e12b5e1dc6f75ec7fe233f22:OW896lXErH8nFmTaVXLLQuV4Evz2wf1t:3_32_2_67108864',0,1738677190),(35,3,'dca69ec65eddadee71128085b1472b0bcfc165195409f93d1386f352082ad8cd:Z0aIb7hToMcozQgATGScNp9zflwXQyyh:3_32_2_67108864',0,1738677585),(36,9,'c9aa13f0bf3b0e38259a6b6cc7ab5464bc6d9d6a34bfe03ea5ab026bcf286f01:w7NliFeMxibehB9aa1oOO9jB1VitQH7i:3_32_2_67108864',0,1738680473),(37,21,'fb13abdca93659ec16e4711ae83a1b8507ef6a67f9acea430cb037c38beb573a:6bVuzNxo7738KtrEpNuEk5x8sBoHKmyu:3_32_2_67108864',0,1738680878),(38,15,'5602d2855b74952ab85b22b60430433632e97a1079ec5a1733aab373a0f88f16:HpoHKqc1pqXIBW26UOSYyborhUE6P2jG:3_32_2_67108864',0,1738681188),(39,4,'749272a53fbdb266dd83047e9657cef8c541fb476588de1dd56b8d21f56a7155:da1ysIgEiN9UYKwrTu8q8muk9hnIIQnB:3_32_2_67108864',0,1738689970),(40,7,'5852cdb1f0db7cf28d1b0dde38f8318aacceb784b5b89cef87d6e3ea85a66be9:sChn56tP7MxO4nVYHTnO6EOusrB3LdmK:3_32_2_67108864',0,1738689980),(41,13,'9207dc2087f3a278e8472604cae927ad0f48cc1324c47c9c7adc265754037628:R53oVi6elmtQtFSiLuODZ23ozXQsQ0Q4:3_32_2_67108864',0,1738693584),(42,6,'3e5de46a8c599d402d51e7fbc329094a0d9b61d27cf78f36b2853aaa2b3a73bc:FyNKsWIaeUd5AMqPEnKTZAur7pLtqL4O:3_32_2_67108864',0,1738936703),(43,15,'ee9383c7f4623009e4fe75415015fcf3ae3c6bda7881b554002eee1f2d81d4b3:7VtjIaGBjlp0nvTEDk8jGho8wFd5HwTC:3_32_2_67108864',0,1738950240),(44,25,'482fe306f02da0f9b183bf7e027a49c7fdea2add36a5b792d5409bfe6925c1bf:PqgaVr7fW3CIRsuBlLLWMYCn4L1dMDfU:3_32_2_67108864',0,1739809657),(45,17,'1b5441fc45d82a2b62a592b50739a4e7a0591720c3789337948bdef4ce7ae382:veyyLV7Fym5wzNmeYJjKqdnfEeNLLNP9:3_32_2_67108864',0,1739901640),(46,26,'132b263a0656ab597031edb08ae9295d27cc50dc09681f8ccf674c208de18b3a:CL5wcZl820xSJZt9xJfXXaHCbBkVxjs7:3_32_2_67108864',0,1740587983),(47,27,'431bd8bdb393cf0d0ef29c8bf46b0231fac4523464072e80fb0c9edc1238e308:FXM1AlGb187XkSJwFk4ciu27FIyYOmQZ:3_32_2_67108864',0,1740671695),(48,20,'dd841a72e50ce6ac5fed0625563a7cd2726754eb3bf14b644c26dff956dd78f2:iCf9PouuGQsuIk9eAYf0nVhgGRd1rw2d:3_32_2_67108864',0,1741014474),(49,27,'3d8b34f180ebb8b43076f1be1c9e908f994c8875961fe6de84e375ee5d2a6819:JxozVUUvdFnkftKsbUzsoRt9C0XxZ0C2:3_32_2_67108864',0,1741264336),(50,18,'9317c5724be382bf5496fe2049383115f790b08a9db82bd46bcd5b90087ebc87:gaOh24zIBmGKKWnEgKyjjVuHw9ZTHV90:3_32_2_67108864',0,1743176414),(51,18,'37622298febead0402ca0d11d2c085a870337f36c8ad05a375b027a4e62e30ec:hbhqoFEGk3cromcAdO3CA0s2H3GJszHT:3_32_2_67108864',0,1743178625),(52,28,'0470db84bdb958c10bf69f7b66bf3520a220bba036383521fe424f6166bf8cc9:Zm6eO5NHPdEswVnysUnApXb4xZcp968T:3_32_2_67108864',0,1746036766),(53,5,'bdaa90ec17836976c30a36d8f1ba1845524553e05cf3060be6cc6bafba5a963c:GDehrDQnQOU636gUkfYlTFQJ2GX4LLdn:3_32_2_67108864',0,1747052792),(54,24,'cc91b3c4af9f067f6efe1181a52ce66c7d16100d785bd9e939cebfb0b6dfe896:36JFZxJP42Apaq9pMtpWHcfb1efeYa7f:3_32_2_67108864',0,1747074448),(55,8,'45389a4ab4be4669e918ee8417654fbbf5e592438c119eb30f920eae697e5db1:uBmhIJGgH6QaoAvaww6WyR5sq2b4iEJz:3_32_2_67108864',0,1747136152),(56,13,'4f9ab4a339dc516ab0a795de4ff1749dbbc97a3f4ece332d0ef9a209c9f3fc6b:F0eZoIO9DjfyA14HhGCA9HRamy2ehvl7:3_32_2_67108864',0,1748718064),(57,26,'3cf5e744ee6b5f6ee7934e5d6a7bf6b6453f451153a0cc9a56098f72f87c9163:uuihrGP1BrqtGiV0X43JXYOVpNQWy69x:3_32_2_67108864',0,1748958514),(58,20,'f4fbf9bdfee0a1c6def68054cd330194c14fa614eca501b191e37e081884ab72:Fjk7Y8dmH7HcSf158ciD9MepdtYrK6DQ:3_32_2_67108864',0,1750714417),(59,29,'96a79e7bdc0dc0f7bfcb1a085c1c056e4602c9f9958ccbc3186609337a97e388:47huF4O9kL8U0NK8JQAQsEF4c3db3JiC:3_32_2_67108864',0,1752784821),(60,30,'4763fddb2586d919d2005d325abe2c6262d3c14ef951efeb9d6ffdb859ad143f:orDyoFD6OpZLxjdS6nc3D0UcEKVwtp7X:3_32_2_67108864',0,1752784877),(61,29,'592af1c388c7e05055110bf3078a7d54098c6d26d984c9f4ae8e0315824f59d7:omLQVsZXQl1dd3h0CP1xpVxm1Nm5YXJ6:3_32_2_67108864',0,1752785475),(62,30,'235dd0e7804a7363ea848e6eb1786810241d2152700d2ff1089b66b86bcde232:jcweMMcAgr4boPBXdB80mssBx2Q6KOKi:3_32_2_67108864',0,1752838343),(63,31,'2e6c9179773d52c575572ed56218309f427e98739a1efd4c9d15c70ee8dc20b7:ptL38mEkX4PVu2ccCAaEZOGBUD9CRtBV:3_32_2_67108864',0,1756927227),(64,26,'6234684f4db50e975130eea200acef0c1c667cc4ac24d6837326217ab32e36c1:dd9KiPET88GadW5fLlL5bbbDBQXQNN90:3_32_2_67108864',0,1758560821),(65,18,'95825ea5629d0252c7e6df4778c8903f5c12f6f45764f3fc62746e11c9208b4d:8b4sIgaeKNqoaBDxwrxgCWgQm32vqr6Y:3_32_2_67108864',0,1759374806),(66,32,'f628d13daee5ab3edf1bcdf267d7c95386a62f3efbe24b760003cf0d582ebd46:3fi6SumOiry241XpbXMI34LXEg83REpD:3_32_2_67108864',0,1762285676);

--
-- Dumping data for table `admin_system_messages`
--

INSERT INTO `admin_system_messages` VALUES ('6574525426784678a4023b3d1743a4de',1,'2025-12-02 10:51:10'),('shipstation_not_configured',1,'2024-09-18 23:55:57');

--
-- Dumping data for table `admin_user`
--

INSERT INTO `admin_user` VALUES (1,'Dev','Team','dev@budsies.com','admin','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2024-09-18 18:24:14','2025-12-06 01:28:28','2025-08-19 09:34:56',7,0,1,'{\"configState\":{\"vsbridge_indexer_settings_general_settings\":\"1\",\"catalog_search\":\"1\",\"admin_security\":\"1\",\"admin_emails\":\"0\",\"admin_startup\":\"0\",\"admin_url\":\"0\",\"admin_dashboard\":\"0\",\"admin_grid\":\"0\",\"admin_captcha\":\"0\",\"admin_usage\":\"0\",\"vsbridge_indexer_settings_es_client\":\"1\",\"budsies_vuestorefrontbridge_jwt_settings\":\"1\",\"general_country\":\"1\",\"general_region\":\"1\",\"general_locale\":\"1\",\"general_single_store_mode\":\"1\",\"general_store_information\":\"1\",\"web_url\":\"1\",\"web_seo\":\"1\",\"web_unsecure\":\"1\",\"web_secure\":\"1\",\"web_default\":\"1\",\"web_default_layouts\":\"1\",\"web_cookie\":\"1\",\"web_session\":\"1\",\"web_browser_capabilities\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"0\",\"currency_fixerio_apilayer\":\"1\",\"currency_currencyconverterapi\":\"1\",\"currency_import\":\"1\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_custom1\":\"1\",\"contact_email\":\"1\",\"contact_contact\":\"1\",\"reports_dashboard\":\"1\",\"reports_options\":\"1\",\"cms_pagebuilder\":\"1\",\"cms_wysiwyg\":\"1\",\"affirm_affirm_promo\":\"1\",\"affirm_affirm_promo_homepage\":\"1\",\"affirm_affirm_promo_product\":\"1\",\"affirm_affirm_promo_category\":\"1\",\"affirm_affirm_pixel\":\"1\",\"catalog_fields_masks\":\"0\",\"catalog_frontend\":\"1\",\"catalog_review\":\"0\",\"catalog_placeholder\":\"0\",\"catalog_recently_products\":\"0\",\"catalog_price\":\"1\",\"catalog_productalert\":\"0\",\"catalog_productalert_cron\":\"0\",\"catalog_product_video\":\"0\",\"catalog_layered_navigation\":\"0\",\"catalog_seo\":\"1\",\"catalog_navigation\":\"0\",\"catalog_downloadable\":\"1\",\"catalog_custom_options\":\"0\",\"cataloginventory_options\":\"1\",\"cataloginventory_item_options\":\"1\",\"cataloginventory_bulk_operations\":\"1\",\"cataloginventory_indexer\":\"1\",\"cataloginventory_source_selection_distance_based\":\"1\",\"cataloginventory_source_selection_distance_based_google\":\"1\",\"newsletter_subscription\":\"1\",\"newsletter_general\":\"1\",\"customer_account_share\":\"1\",\"customer_online_customers\":\"1\",\"customer_password\":\"1\",\"customer_create_account\":\"1\",\"customer_account_information\":\"1\",\"customer_address\":\"1\",\"customer_startup\":\"1\",\"customer_address_templates\":\"1\",\"customer_captcha\":\"1\",\"carriers_flatrate\":\"0\",\"carriers_shipstation\":\"0\",\"carriers_freeshipping\":\"0\",\"carriers_tablerate\":\"0\",\"carriers_instore\":\"0\",\"carriers_fedex\":\"1\",\"sales_general\":\"1\",\"sales_totals_sort\":\"1\",\"sales_cancellation\":\"1\",\"sales_zerograndtotal_creditmemo\":\"1\",\"sales_reorder\":\"0\",\"sales_email_general\":\"1\",\"sales_email_order\":\"1\",\"sales_email_invoice\":\"1\",\"sales_email_shipment\":\"0\",\"sales_email_creditmemo\":\"0\",\"sales_email_order_comment\":\"0\",\"sales_email_invoice_comment\":\"0\",\"sales_email_shipment_comment\":\"0\",\"sales_email_creditmemo_comment\":\"0\",\"sales_email_order_ready_for_pickup\":\"0\",\"sales_pdf_invoice\":\"1\",\"sales_pdf_creditmemo\":\"1\",\"sales_pdf_shipment\":\"1\",\"tax_taxjar\":\"1\",\"tax_calculation\":\"1\",\"tax_classes\":\"1\",\"tax_sales_display\":\"1\",\"checkout_options\":\"1\",\"checkout_payment_failed\":\"1\",\"payment_us_free\":\"0\",\"payment_us_checkmo\":\"1\",\"payment_us_other_payment_methods\":\"1\",\"payment_us_other_paypal_payment_solutions\":\"1\",\"payment_us_account\":\"0\",\"payment_us_recommended_solutions\":\"1\",\"payment_us_paypal_group_all_in_one\":\"1\",\"payment_us_paypal_payment_gateways\":\"1\",\"payment_us_banktransfer\":\"0\",\"payment_us_cashondelivery\":\"0\",\"payment_us_purchaseorder\":\"0\",\"payment_us_affirm_gateway\":\"1\",\"magepal_editorderemail_about_magepal\":\"1\",\"magepal_editorderemail_general\":\"1\",\"guesttocustomer_general\":\"1\",\"guesttocustomer_merge\":\"1\",\"guesttocustomer_about_magepal\":\"1\",\"budsies_marketing_customer_stories\":\"1\",\"budsies_marketing_production_spot_countdown\":\"1\",\"budsies_fileuploader_image_handler\":\"1\",\"budsies_fileuploader_api\":\"1\",\"budsies_backend_integration_api\":\"1\",\"budsies_backend_integration_backend_application\":\"1\",\"budsies_holiday_holiday_delivery\":\"1\",\"budsies_holiday_holiday_rush_delivery\":\"1\",\"budsies_mailchimpintegration_bulkorder\":\"1\",\"budsies_mailchimpintegration_donglerBook\":\"1\",\"budsies_mailchimpintegration_inspirationmachine\":\"1\",\"budsies_bulkrequest_freshsales\":\"1\",\"budsies_bulkrequest_agreement\":\"1\",\"budsies_bulkrequest_general\":\"1\",\"system_smtp\":\"1\",\"system_cron\":\"0\",\"system_mysqlmq\":\"0\",\"system_currency\":\"0\",\"system_security\":\"0\",\"system_adminnotification\":\"0\",\"system_backup\":\"0\",\"system_full_page_cache\":\"0\",\"system_bulk\":\"0\",\"system_media_storage_configuration\":\"0\",\"system_upload_configuration\":\"0\",\"system_media_gallery\":\"0\",\"system_media_gallery_renditions\":\"0\",\"system_adobe_stock_integration\":\"0\",\"vsbridge_indexer_settings_indices_settings\":\"1\",\"vsbridge_indexer_settings_redis_cache_settings\":\"1\",\"vsbridge_indexer_settings_optimization_settings\":\"1\",\"vsbridge_indexer_settings_catalog_settings\":\"1\",\"vsbridge_indexer_settings_catalog_category_settings\":\"1\",\"amgiftcard_general\":\"1\",\"amgiftcard_display_options\":\"1\",\"amgiftcard_card\":\"1\",\"amgiftcard_email\":\"1\",\"amgiftcard_gift_card_account\":\"1\",\"amasty_acart_general\":\"1\",\"amasty_acart_email_templates\":\"1\",\"amasty_acart_testing\":\"1\",\"amasty_acart_debug\":\"1\",\"amasty_acart_information\":\"1\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_dhl\":\"0\",\"amfollowup_general\":\"1\",\"amfollowup_emails\":\"1\",\"amfollowup_test\":\"1\",\"amfollowup_information\":\"1\",\"mailchimp_general\":\"1\",\"mailchimp_ecommerce\":\"1\",\"mailchimp_abandonedcart\":\"1\",\"budsies_shopify_api\":\"1\",\"budsies_shopify_fulfillment_service\":\"1\"}}',NULL,NULL,'en_US',1,'2025-09-05 12:51:56',NULL),(2,'Andrey','Gorbunov','ca93e1657cb6ff93afcde6e8c1e60ba1@st.budsies.com','andrey','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:17:30','2025-12-06 01:28:28','2025-12-01 22:24:37',76,0,1,'{\"configState\":{\"tax_taxjar\":\"1\",\"vsbridge_indexer_settings_es_client\":\"1\",\"budsies_bulkrequest_freshsales\":\"1\",\"budsies_bulkrequest_agreement\":\"1\",\"budsies_bulkrequest_general\":\"1\",\"amgiftcard_display_options\":\"0\",\"amgiftcard_card\":\"1\",\"amgiftcard_general\":\"1\",\"amgiftcard_gift_card_account\":\"1\",\"magepal_editorderemail_general\":\"1\",\"guesttocustomer_merge\":\"1\",\"guesttocustomer_general\":\"1\",\"guesttocustomer_about_magepal\":\"1\",\"tax_calculation\":\"1\",\"tax_classes\":\"1\",\"tax_defaults\":\"1\",\"tax_display\":\"1\",\"tax_cart_display\":\"1\",\"tax_sales_display\":\"1\",\"tax_weee\":\"0\",\"amasty_acart_general\":\"1\",\"amasty_acart_email_templates\":\"1\",\"amasty_acart_testing\":\"1\",\"amasty_acart_debug\":\"1\",\"amasty_acart_information\":\"1\",\"payment_us_account\":\"0\",\"payment_us_recommended_solutions\":\"1\",\"payment_us_purchaseorder\":\"0\",\"payment_us_affirm_gateway\":\"1\",\"payment_us_cashondelivery\":\"0\",\"payment_us_banktransfer\":\"0\",\"payment_us_other_paypal_payment_solutions\":\"1\",\"amasty_products_instance_registration\":\"1\",\"mailchimp_general\":\"1\",\"mailchimp_ecommerce\":\"1\",\"shipstation_general_shipstation\":\"1\",\"mailchimp_abandonedcart\":\"1\",\"general_store_information\":\"1\",\"general_single_store_mode\":\"1\",\"general_locale\":\"1\",\"general_region\":\"1\",\"general_country\":\"1\",\"amfollowup_general\":\"1\",\"amfollowup_emails\":\"1\",\"amfollowup_test\":\"1\",\"amfollowup_information\":\"1\",\"budsies_marketing_customer_stories\":\"1\",\"budsies_marketing_production_spot_countdown\":\"1\",\"budsies_mailchimpintegration_inspirationmachine\":\"1\",\"budsies_mailchimpintegration_donglerBook\":\"1\",\"budsies_mailchimpintegration_bulkorder\":\"1\",\"newsletter_subscription\":\"1\",\"newsletter_general\":\"1\",\"admin_security\":\"1\",\"admin_emails\":\"0\",\"admin_startup\":\"1\",\"admin_url\":\"0\",\"admin_dashboard\":\"1\",\"admin_grid\":\"1\",\"admin_captcha\":\"1\",\"admin_usage\":\"1\",\"trans_email_ident_general\":\"1\",\"trans_email_ident_sales\":\"1\",\"budsies_storyblok_webhook\":\"1\",\"budsies_storyblok_integration\":\"1\",\"amgiftcard_email\":\"1\",\"carriers_ups\":\"1\",\"carriers_instore\":\"0\",\"carriers_usps\":\"1\",\"carriers_fedex\":\"1\",\"carriers_dhl\":\"1\",\"carriers_tablerate\":\"1\",\"carriers_freeshipping\":\"1\",\"carriers_shipstation\":\"1\",\"carriers_flatrate\":\"1\",\"budsies_storyblok_sitemap\":\"1\",\"sitemap_category\":\"1\",\"sitemap_product\":\"1\",\"sitemap_page\":\"1\",\"sitemap_store\":\"1\",\"sitemap_generate\":\"1\",\"sitemap_limit\":\"1\",\"sitemap_search_engines\":\"1\",\"web_url\":\"1\",\"web_seo\":\"1\",\"web_unsecure\":\"1\",\"web_secure\":\"1\",\"web_default\":\"1\",\"web_default_layouts\":\"1\",\"web_cookie\":\"1\",\"web_session\":\"1\",\"web_browser_capabilities\":\"1\",\"sales_general\":\"1\",\"sales_orders\":\"1\",\"sales_backpressure\":\"1\",\"sales_cancellation\":\"1\",\"checkout_cart\":\"1\",\"checkout_options\":\"0\",\"checkout_cart_link\":\"1\",\"checkout_sidebar\":\"0\",\"checkout_payment_failed\":\"1\",\"trustpilotGeneral_general\":\"1\",\"reports_options\":\"1\",\"reports_dashboard\":\"1\",\"analytics_general\":\"1\",\"budsies_holiday_holiday_delivery\":\"1\",\"budsies_holiday_no_holiday_delivery\":\"1\",\"budsies_holiday_holiday_rush_delivery\":\"1\",\"catalog_review\":\"1\",\"cataloginventory_item_options\":\"1\",\"cataloginventory_options\":\"1\",\"budsies_lowstocknotification_general\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_custom1\":\"1\",\"trans_email_ident_custom2\":\"1\",\"cms_pagebuilder\":\"1\",\"cms_wysiwyg\":\"1\",\"sales_email_general\":\"1\",\"sales_email_order\":\"1\",\"sales_email_order_comment\":\"1\",\"sales_email_invoice\":\"1\",\"sales_email_invoice_comment\":\"1\",\"sales_email_shipment\":\"1\",\"sales_email_shipment_comment\":\"1\",\"sales_email_creditmemo\":\"1\",\"sales_email_creditmemo_comment\":\"1\",\"sales_email_order_ready_for_pickup\":\"1\",\"customer_create_account\":\"1\",\"customer_password\":\"0\",\"customer_account_information\":\"1\",\"customer_address\":\"0\",\"customer_startup\":\"0\",\"customer_address_templates\":\"0\",\"customer_captcha\":\"0\",\"wishlist_wishlist_link\":\"1\",\"wishlist_email\":\"1\",\"wishlist_general\":\"1\",\"budsies_promotions_promotion_event\":\"0\",\"budsies_backend_integration_api\":\"1\",\"budsies_backend_integration_backend_application\":\"1\",\"budsies_fileuploader_api\":\"1\",\"budsies_fileuploader_image_handler\":\"1\",\"budsies_productcustomization_image_upload_by_email\":\"1\",\"vsbridge_indexer_settings_redis_cache_settings\":\"1\",\"vsbridge_indexer_settings_optimization_settings\":\"1\",\"vsbridge_indexer_settings_general_settings\":\"0\",\"vsbridge_indexer_settings_indices_settings\":\"1\",\"vsbridge_indexer_settings_catalog_settings\":\"1\",\"vsbridge_indexer_settings_catalog_category_settings\":\"0\",\"oauth_consumer\":\"1\",\"oauth_access_token_lifetime\":\"1\",\"budsies_mailgun_integration\":\"1\",\"budsies_mailgun_webhooks\":\"1\",\"klaviyo_reclaim_general_general\":\"1\",\"klaviyo_reclaim_newsletter_newsletter\":\"1\",\"klaviyo_reclaim_oauth_klaviyo_oauth\":\"1\",\"budsies_pals_pals_kit\":\"1\",\"payment_us_paypal_group_all_in_one\":\"1\",\"payment_us_paypal_payment_gateways\":\"1\",\"payment_us_other_payment_methods\":\"1\",\"payment_us_free\":\"0\",\"payment_us_checkmo\":\"1\",\"sales_reorder\":\"1\",\"system_security\":\"1\",\"currency_currencyconverterapi\":\"0\",\"currency_currencyapi\":\"1\",\"currency_import\":\"1\",\"currency_options\":\"1\",\"currency_fixerio\":\"0\",\"currency_fixerio_apilayer\":\"0\",\"budsies_sales_orders_history\":\"1\",\"budsies_sales_order_coupon_notification\":\"1\",\"customer_account_share\":\"1\",\"customer_online_customers\":\"1\",\"budsies_klaviyointegration_bulkrequest\":\"1\",\"budsies_klaviyointegration_donglerbook\":\"1\",\"budsies_klaviyointegration_imaginationkit\":\"1\",\"klaviyo_reclaim_consent_at_checkout_email_consent\":\"1\",\"budsies_catalog_openai_general\":\"1\",\"otp_general\":\"1\",\"otp_sign_in\":\"1\",\"otp_sign_up\":\"1\",\"klaviyo_reclaim_consent_at_checkout_sms_consent\":\"1\",\"system_smtp\":\"1\",\"shipping_shipping_policy\":\"1\",\"shipping_origin\":\"1\",\"budsies_shopify_fulfillment_service\":\"1\",\"budsies_shopify_api\":\"0\",\"budsies_shopify_order_data_update_webhook\":\"1\",\"budsies_portless_pipe17\":\"1\",\"fera_ai_fera_ai_group\":\"1\",\"fera_ai_sync_settings\":\"1\",\"fera_ai_general\":\"1\",\"budsies_portless_general\":\"1\",\"budsies_portless_shipment_notification\":\"1\",\"payment_us_amazon_pay\":\"1\",\"webapi_jwtauth\":\"1\",\"webapi_soap\":\"0\",\"webapi_graphql_validation\":\"0\",\"webapi_validation\":\"0\",\"webapi_webapisecurity\":\"0\",\"budsies_productfeed_general\":\"1\",\"product_feed_email\":\"1\",\"product_feed_general\":\"1\",\"product_feed_module\":\"1\",\"catalog_frontend\":\"1\",\"catalog_placeholder\":\"1\",\"system_upload_configuration\":\"1\",\"system_media_storage_configuration\":\"1\",\"system_bulk\":\"1\",\"system_media_gallery\":\"1\",\"system_media_gallery_renditions\":\"1\",\"budsies_addressvalidation_general\":\"1\",\"budsies_productcustomization_digital_deliverables\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL),(3,'Frankie','Burns','ae889566a6b9c331acac0a41094f9eca@st.budsies.com','frankie','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:26:01','2025-12-06 01:28:28','2025-12-04 19:13:48',62,0,1,'{\"configState\":{\"budsies_bulkrequest_general\":\"1\",\"budsies_bulkrequest_agreement\":\"1\",\"budsies_bulkrequest_freshsales\":\"0\",\"general_store_information\":\"1\",\"general_locale\":\"1\",\"general_country\":\"1\",\"carriers_flatrate\":\"1\",\"carriers_freeshipping\":\"1\",\"carriers_tablerate\":\"1\",\"carriers_shipstation\":\"0\",\"carriers_instore\":\"0\",\"carriers_ups\":\"0\",\"carriers_usps\":\"0\",\"carriers_fedex\":\"0\",\"carriers_dhl\":\"0\",\"shipping_shipping_policy\":\"1\",\"shipping_origin\":\"1\",\"shipping_shipping_tracking\":\"1\",\"amasty_acart_email_templates\":\"1\",\"amfollowup_general\":\"1\",\"amfollowup_emails\":\"1\"}}',NULL,NULL,'en_US',0,NULL,NULL),(4,'Melissa','Heist','e39c9c21f237c6d3a004bf502472b66e@st.budsies.com','melissa','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:32:15','2025-12-06 01:28:28','2025-12-01 15:44:16',121,0,1,'{\"configState\":{\"budsies_lowstocknotification_general\":\"1\",\"shipping_origin\":\"1\",\"shipping_shipping_policy\":\"1\",\"shipping_shipping_tracking\":\"1\",\"carriers_tablerate\":\"1\",\"carriers_usps\":\"1\",\"carriers_fedex\":\"1\",\"carriers_flatrate\":\"0\",\"carriers_shipstation\":\"0\",\"carriers_freeshipping\":\"0\",\"carriers_instore\":\"0\",\"carriers_ups\":\"0\",\"carriers_dhl\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL),(5,'Carli','Monashkin','ea093e02b6a418d613579ddb67de75ea@st.budsies.com','carli','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:34:57','2025-12-06 01:28:28','2025-12-04 23:45:26',229,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(6,'Catie','DiMaio','4f42646380e336204df235769cb77d16@st.budsies.com','catie','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:35:39','2025-12-06 01:28:28','2025-03-28 15:37:01',101,1,0,'null',NULL,NULL,'en_US',0,NULL,NULL),(7,'Cole','Widtfeldt','c95a7f8c490406163e9be49c1b4b3784@st.budsies.com','ColeW','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:51:04','2025-12-06 01:28:28','2025-12-05 18:15:48',60,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(8,'Kaylee','Crosby','34a025485f21906a1c2db34c30d492a8@st.budsies.com','kaylee','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:51:41','2025-12-06 01:28:28','2025-12-01 18:06:39',116,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(9,'Kelsey','Ali-Samhoul','f0fd69a4eb2233d64e3a9298d16736f6@st.budsies.com','kelsey','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:52:13','2025-12-06 01:28:28','2025-02-04 14:48:02',1,1,0,'null',NULL,NULL,'en_US',0,NULL,NULL),(10,'Lauren','Lamancusa','2830d31a37533b505d856a2408bf72be@st.budsies.com','laurenlamancusa','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:52:45','2025-12-06 01:28:28','2025-09-29 14:53:12',61,1,0,'null',NULL,NULL,'en_US',1,'2025-10-01 23:42:46',NULL),(11,'Libby','Lewis','029f9bef1b809d262aad6a174726e863@st.budsies.com','libby','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:53:23','2025-12-06 01:28:28','2025-12-05 16:08:32',763,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(12,'Lisa','Tran','ee3333695d716fea9c5689aecc652365@st.budsies.com','lisatran','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:53:58','2025-12-06 01:28:28',NULL,0,1,1,'null',NULL,NULL,'en_US',2,'2025-02-10 16:11:59',NULL),(13,'Lyricka','Smith','e71a4dec3f378980a3fbf090f1a9dad0@st.budsies.com','lyricka','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:54:41','2025-12-06 01:28:28','2025-12-05 14:14:37',187,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(14,'Maddy','Tarquin','6b8407a87a4b5a05b79856b49ffdfcb4@st.budsies.com','maddy','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:55:16','2025-12-06 01:28:28',NULL,0,1,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(15,'Marcus','Osnato','742c30c7d42d69b71b4a1b07d0a6d0aa@st.budsies.com','marcus','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:55:48','2025-12-06 01:28:28','2025-07-02 14:11:54',151,1,0,'null',NULL,NULL,'en_US',0,NULL,NULL),(16,'Michelle','Leckson','8de0524f200ae8d991e6f1c454e6b82a@st.budsies.com','michellel','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:56:20','2025-12-06 01:28:28','2025-12-05 17:14:22',160,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(17,'Monika','Grabowska','74001e0bbeee21a283887a15d1d5990f@st.budsies.com','monika','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:57:01','2025-12-06 01:28:28','2025-03-05 16:44:56',2,1,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(18,'Packing','Team','84494001888f13eb9b8ecc9856bcadc3@st.budsies.com','packingteam','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:57:34','2025-12-06 01:28:28','2025-09-30 13:36:55',94,1,0,'\"\\\"null\\\"\"',NULL,NULL,'en_US',1,'2025-10-10 13:28:59',NULL),(19,'Rhaimari','Gonzalez','8bbb51c0d77bfc4d4eacf769b165cab2@st.budsies.com','rhaimari.gonzalez','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:58:04','2025-12-06 01:28:28','2025-12-03 17:58:23',218,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(20,'Sammi','Castillo','6f6e460439c5bd609143a52c88304214@st.budsies.com','Sammi','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:58:35','2025-12-06 01:28:28','2025-12-03 17:53:01',70,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(21,'Scott','Meier','2db1835bb538f548931ddcd062f56e9a@st.budsies.com','scott-magento','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:59:05','2025-12-06 01:28:28','2025-12-02 17:04:21',125,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(22,'Stephany','Aguilar','137cdf45f39bf5661c80d7931ee08f05@st.budsies.com','stephany','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 14:59:35','2025-12-06 01:28:28','2025-12-04 22:54:37',83,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(23,'Rolando','Lopez','9136eeb72b8b011eeb00dc2253048de5@st.budsies.com','CFO_Assoc','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-03 15:02:17','2025-12-06 01:28:28',NULL,0,1,1,'null',NULL,NULL,'en_US',2,'2025-02-17 15:05:03',NULL),(24,'Aaron','Downing','6b150183d9e2522d85d68105b1cce61a@st.budsies.com','aaron','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-04 13:28:10','2025-12-06 01:28:28','2025-12-01 14:27:07',48,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(25,'BudsiesAccounting','CFO Assoc','40db7e1b51f1172facf9d83118d2f75d@st.budsies.com','Budsies_Accounting','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-17 16:27:37','2025-12-06 01:28:28','2025-04-24 13:49:03',6,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(26,'Naomi','Cagua','a7b8c5a2cca2bb00f329179f26ff9f9e@st.budsies.com','naomi','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-26 16:39:43','2025-12-06 01:28:28','2025-12-02 05:02:56',80,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(27,'Team','AOK','027f1f8d1815d7eb87decef2daa22257@st.budsies.com','aok-team','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-02-27 15:54:55','2025-12-06 01:28:28','2025-03-06 12:32:27',1,1,0,'null',NULL,NULL,'en_US',1,'2025-07-02 22:36:23',NULL),(28,'Amanda','Shankin','ee808e75438d6b06ce826fc477a8fb98@st.budsies.com','amanda','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-04-30 18:12:46','2025-12-06 01:28:28','2025-07-10 19:43:13',5,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),(29,'Dave','Burnett','bbb075e2bde2147fe6c823d9112adb8f@st.budsies.com','db_aok','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-07-17 20:40:21','2025-12-06 01:28:28','2025-07-17 20:51:26',1,1,0,'null',NULL,NULL,'en_US',0,NULL,NULL),(30,'Philip','Cross','eef3ba326cc8c01a8fa4bf0bc094f430@st.budsies.com','philllipc_aok','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-07-17 20:41:17','2025-12-06 01:28:28','2025-07-18 11:32:26',1,1,0,'null',NULL,NULL,'en_US',0,NULL,NULL),(31,'Elani','Cagua','47dac4dc2a728abcf53729bc6211fef0@st.budsies.com','elani','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-09-03 19:20:27','2025-12-06 01:28:28','2025-11-17 15:52:10',33,1,0,'null',NULL,NULL,'en_US',0,NULL,NULL),(32,'Isaac','Obsenares','551c61eff2f1f87e29b9f1abb51424a7@st.budsies.com','isaac','b91106c648dbaf990210f70018d1fcaaeafb6b5a1be23dd7b4b082e34e6c464a:rHxsifm5UsoeOV2uH7miyGut1882xoQ6:3_32_2_67108864','2025-11-04 19:47:56','2025-12-06 01:28:28','2025-11-04 20:29:11',1,1,0,'\"null\"',NULL,NULL,'en_US',0,NULL,NULL);

--
-- Dumping data for table `admin_user_expiration`
--

INSERT INTO `admin_user_expiration` VALUES (6,'2025-03-28 15:38:33'),(10,'2025-10-06 17:56:27');

--
-- Dumping data for table `admin_user_session`
--

INSERT INTO `admin_user_session` VALUES (2809,NULL,24,1,'2025-12-01 14:27:07','2025-12-05 20:40:22','2603:9001:23f0:'),(2812,NULL,7,1,'2025-12-01 15:25:23','2025-12-04 15:54:07','2607:f00:9:2b3e'),(2813,NULL,4,1,'2025-12-01 15:44:16','2025-12-05 23:17:54','73.46.140.81'),(2820,NULL,8,1,'2025-12-01 18:06:39','2025-12-05 19:04:29','2601:58b:1684:c'),(2828,NULL,2,1,'2025-12-01 22:24:37','2025-12-05 21:10:14','86.127.231.248'),(2829,NULL,26,1,'2025-12-02 05:02:56','2025-12-05 14:34:40','181.236.5.99'),(2834,NULL,21,1,'2025-12-02 17:04:21','2025-12-04 16:36:27','2607:f00:9:2b3e'),(2848,NULL,19,1,'2025-12-03 17:58:23','2025-12-05 19:57:13','73.125.160.3'),(2849,NULL,11,1,'2025-12-03 18:01:50','2025-12-04 13:13:20','2601:58b:1500:a'),(2856,NULL,16,1,'2025-12-03 21:36:32','2025-12-04 14:28:15','2600:4040:b57c:'),(2857,NULL,5,1,'2025-12-04 13:18:43','2025-12-04 20:34:01','2603:3020:4f7:8'),(2858,NULL,11,1,'2025-12-04 13:49:00','2025-12-04 13:49:00','2601:58b:1500:a'),(2859,NULL,11,1,'2025-12-04 13:58:35','2025-12-04 18:04:31','2601:58b:1500:a'),(2860,NULL,3,1,'2025-12-04 19:13:48','2025-12-05 19:28:31','162.238.64.119'),(2861,NULL,5,1,'2025-12-04 22:06:40','2025-12-04 23:22:44','2601:58b:481:2f'),(2862,NULL,16,1,'2025-12-04 22:42:34','2025-12-04 22:42:34','2600:4040:b57c:'),(2863,NULL,22,1,'2025-12-04 22:54:37','2025-12-05 18:29:05','75.91.152.65'),(2864,NULL,5,1,'2025-12-04 23:28:16','2025-12-04 23:33:32','2601:58b:481:2f'),(2865,NULL,5,1,'2025-12-04 23:38:03','2025-12-05 15:17:18','2601:58b:481:2f'),(2866,NULL,5,1,'2025-12-04 23:45:26','2025-12-04 23:46:28','2601:58b:481:2f'),(2867,NULL,11,1,'2025-12-05 11:04:45','2025-12-05 12:56:12','2601:58b:1500:a'),(2868,NULL,11,1,'2025-12-05 12:58:54','2025-12-05 13:05:01','2601:58b:1500:a'),(2869,NULL,13,1,'2025-12-05 14:14:37','2025-12-05 14:43:38','2600:1700:8ef0:'),(2870,NULL,11,1,'2025-12-05 16:08:32','2025-12-05 21:19:32','2601:58b:1500:a'),(2871,NULL,16,1,'2025-12-05 17:14:22','2025-12-05 18:16:26','2600:4040:b57c:'),(2872,NULL,7,1,'2025-12-05 18:15:48','2025-12-05 22:24:26','140.174.247.101');

--
-- Dumping data for table `adminnotification_inbox`
--

INSERT INTO `adminnotification_inbox` VALUES (1,4,'2013-07-21 12:51:25','Belvg\'s extension has been installed. Check the Admin > Configuration > Belvg Extensions.','You can see versions of the installed extensions right in the admin, as well as configure notifications about major updates.','http://store.belvg.com/blog/',1,0,0,NULL,NULL,0),(2,4,'2008-07-25 05:24:40','Magento 1.1 Production Version Now Available','We are thrilled to announce the availability of the production release of Magento 1.1. Read more about the release in the Magento Blog.','http://www.magentocommerce.com/blog/comments/magento-11-is-here-1/',1,0,0,NULL,NULL,0),(3,4,'2008-08-02 05:30:16','Updated iPhone Theme is now available','Updated iPhone theme for Magento 1.1 is now available on Magento Connect and for upgrade through your Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/updated-iphone-theme-for-magento-11-is-now-available/',1,0,0,NULL,NULL,0),(4,3,'2008-08-02 05:40:27','Magento version 1.1.2 is now available','Magento version 1.1.2 is now available for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-version-112-is-now-available/',1,0,0,NULL,NULL,0),(5,3,'2008-08-13 21:51:46','Magento version 1.1.3 is now available','Magento version 1.1.3 is now available','http://www.magentocommerce.com/blog/comments/magento-version-113-is-now-available/',1,0,0,NULL,NULL,0),(6,1,'2008-09-03 01:10:31','Magento Version 1.1.4 Security Update Now Available','Magento 1.1.4 Security Update Now Available. If you are using Magento version 1.1.x, we highly recommend upgrading to this version as soon as possible.','http://www.magentocommerce.com/blog/comments/magento-version-114-security-update/',1,0,0,NULL,NULL,0),(7,3,'2008-09-16 02:09:54','Magento version 1.1.5 Now Available','Magento version 1.1.5 Now Available.\n\nThis release includes many bug fixes, a new category manager and a new skin for the default Magento theme.','http://www.magentocommerce.com/blog/comments/magento-version-115-now-available/',1,0,0,NULL,NULL,0),(8,3,'2008-09-18 00:18:35','Magento version 1.1.6 Now Available','Magento version 1.1.6 Now Available.\n\nThis version includes bug fixes for Magento 1.1.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-116-now-available/',1,0,0,NULL,NULL,0),(9,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(10,3,'2008-11-20 06:31:12','Magento version 1.1.7 Now Available','Magento version 1.1.7 Now Available.\n\nThis version includes over 350 issue resolutions for Magento 1.1.x that are listed in the release notes section, and new functionality that includes:\n\n-Google Website Optimizer integration\n-Google Base integration\n-Scheduled DB logs cleaning option','http://www.magentocommerce.com/blog/comments/magento-version-117-now-available/',1,0,0,NULL,NULL,0),(11,3,'2008-11-27 02:24:50','Magento Version 1.1.8 Now Available','Magento version 1.1.8 now available.\n\nThis version includes some issue resolutions for Magento 1.1.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-118-now-available/',1,0,0,NULL,NULL,0),(12,3,'2008-12-30 12:45:59','Magento version 1.2.0 is now available for download and upgrade','We are extremely happy to announce the availability of Magento version 1.2.0 for download and upgrade.\n\nThis version includes numerous issue resolutions for Magento version 1.1.x and some highly requested new features such as:\n\n    * Support for Downloadable/Digital Products. \n    * Added Layered Navigation to site search result page.\n    * Improved site search to utilize MySQL fulltext search\n    * Added support for fixed-taxes on product level.\n    * Upgraded Zend Framework to the latest stable version 1.7.2','http://www.magentocommerce.com/blog/comments/magento-version-120-is-now-available/',1,0,0,NULL,NULL,0),(13,2,'2008-12-31 02:59:22','Magento version 1.2.0.1 now available','Magento version 1.2.0.1 now available.This version includes some issue resolutions for Magento 1.2.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-1201-available/',1,0,0,NULL,NULL,0),(14,2,'2009-01-13 01:41:49','Magento version 1.2.0.2 now available','Magento version 1.2.0.2 is now available for download and upgrade. This version includes an issue resolutions for Magento version 1.2.0.x as listed in the release notes.','http://www.magentocommerce.com/blog/comments/magento-version-1202-now-available/',1,0,0,NULL,NULL,0),(15,3,'2009-01-24 05:25:56','Magento version 1.2.0.3 now available','Magento version 1.2.0.3 is now available for download and upgrade. This version includes issue resolutions for Magento version 1.2.0.x as listed in the release notes.','http://www.magentocommerce.com/blog/comments/magento-version-1203-now-available/',1,0,0,NULL,NULL,0),(16,3,'2009-02-03 02:57:00','Magento version 1.2.1 is now available for download and upgrade','We are happy to announce the availability of Magento version 1.2.1 for download and upgrade.\n\nThis version includes some issue resolutions for Magento version 1.2.x. A full list of items included in this release can be found on the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-121-now-available/',1,0,0,NULL,NULL,0),(17,3,'2009-02-24 05:45:47','Magento version 1.2.1.1 now available','Magento version 1.2.1.1 now available.This version includes some issue resolutions for Magento 1.2.x that are listed in the release notes section.','http://www.magentocommerce.com/blog/comments/magento-version-1211-now-available/',1,0,0,NULL,NULL,0),(18,3,'2009-02-27 06:39:24','CSRF Attack Prevention','We have just posted a blog entry about a hypothetical CSRF attack on a Magento admin panel. Please read the post to find out if your Magento installation is at risk at http://www.magentocommerce.com/blog/comments/csrf-vulnerabilities-in-web-application-and-how-to-avoid-them-in-magento/','http://www.magentocommerce.com/blog/comments/csrf-vulnerabilities-in-web-application-and-how-to-avoid-them-in-magento/',1,0,0,NULL,NULL,0),(19,2,'2009-03-04 04:03:58','Magento version 1.2.1.2 now available','Magento version 1.2.1.2 is now available for download and upgrade.\nThis version includes some updates to improve admin security as described in the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-1212-now-available/',1,0,0,NULL,NULL,0),(20,3,'2009-03-31 06:22:40','Magento version 1.3.0 now available','Magento version 1.3.0 is now available for download and upgrade. This version includes numerous issue resolutions for Magento version 1.2.x and new features as described on the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-130-is-now-available/',1,0,0,NULL,NULL,0),(21,3,'2009-04-18 08:06:02','Magento version 1.3.1 now available','Magento version 1.3.1 is now available for download and upgrade. This version includes some issue resolutions for Magento version 1.3.x and new features such as Checkout By Amazon and Amazon Flexible Payment. To see a full list of updates please check the release notes page.','http://www.magentocommerce.com/blog/comments/magento-version-131-now-available/',1,0,0,NULL,NULL,0),(22,3,'2009-05-20 02:31:21','Magento version 1.3.1.1 now available','Magento version 1.3.1.1 is now available for download and upgrade. This version includes some issue resolutions for Magento version 1.3.x and a security update for Magento installations that run on multiple domains or sub-domains. If you are running Magento with multiple domains or sub-domains we highly recommend upgrading to this version.','http://www.magentocommerce.com/blog/comments/magento-version-1311-now-available/',1,0,0,NULL,NULL,0),(23,3,'2009-05-30 02:54:06','Magento version 1.3.2 now available','This version includes some improvements and issue resolutions for version 1.3.x that are listed on the release notes page. also included is a Beta version of the Compile module.','http://www.magentocommerce.com/blog/comments/magento-version-132-now-available/',1,0,0,NULL,NULL,0),(24,3,'2009-06-01 23:32:52','Magento version 1.3.2.1 now available','Magento version 1.3.2.1 now available for download and upgrade.\n\nThis release solves an issue for users running Magento with PHP 5.2.0, and changes to index.php to support the new Compiler Module.','http://www.magentocommerce.com/blog/comments/magento-version-1321-now-available/',1,0,0,NULL,NULL,0),(25,3,'2009-07-02 05:21:44','Magento version 1.3.2.2 now available','Magento version 1.3.2.2 is now available for download and upgrade.\n\nThis release includes issue resolution for Magento version 1.3.x. To see a full list of changes please visit the release notes page http://www.magentocommerce.com/download/release_notes.','http://www.magentocommerce.com/blog/comments/magento-version-1322-now-available/',1,0,0,NULL,NULL,0),(26,3,'2009-07-23 10:48:54','Magento version 1.3.2.3 now available','Magento version 1.3.2.3 is now available for download and upgrade.\n\nThis release includes issue resolution for Magento version 1.3.x. We recommend to upgrade to this version if PayPal payment modules are in use. To see a full list of changes please visit the release notes page http://www.magentocommerce.com/download/release_notes.','http://www.magentocommerce.com/blog/comments/magento-version-1323-now-available/',1,0,0,NULL,NULL,0),(27,4,'2009-08-28 22:26:28','PayPal is updating Payflow Pro and Website Payments Pro (Payflow Edition) UK.','If you are using Payflow Pro and/or Website Payments Pro (Payflow Edition) UK.  payment methods, you will need to update the URLâ€˜s in your Magento Administrator Panel in order to process transactions after September 1, 2009. Full details are available here: http://www.magentocommerce.com/wiki/paypal_payflow_changes','http://www.magentocommerce.com/wiki/paypal_payflow_changes',1,0,0,NULL,NULL,0),(28,2,'2009-09-24 00:16:49','Magento Version 1.3.2.4 Security Update','Magento Version 1.3.2.4 is now available. This version includes a security updates for Magento 1.3.x that solves possible XSS vulnerability issue on customer registration page and is available through SVN, Download Page and through the Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/magento-version-1324-security-update/',1,0,0,NULL,NULL,0),(29,4,'2009-09-25 18:57:54','Magento Preview Version 1.4.0.0-alpha2 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-alpha2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-alpha2-now-available/',1,0,0,NULL,NULL,0),(30,4,'2009-10-07 04:55:40','Magento Preview Version 1.4.0.0-alpha3 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-alpha3 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-alpha3-now-available/',1,0,0,NULL,NULL,0),(31,4,'2009-12-09 04:30:36','Magento Preview Version 1.4.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-beta1-now-available/',1,0,0,NULL,NULL,0),(32,4,'2009-12-31 14:22:12','Magento Preview Version 1.4.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version 1.4.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1400-rc1-now-available/',1,0,0,NULL,NULL,0),(33,4,'2010-02-13 08:39:53','Magento CE Version 1.4.0.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.0.0 Stable for upgrade and download.','http://bit.ly/c53rpK',1,0,0,NULL,NULL,0),(34,3,'2010-02-20 07:39:36','Magento CE Version 1.4.0.1 Stable is now available','Magento CE 1.4.0.1 Stable is now available for upgrade and download.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1401-stable-now-available/',1,0,0,NULL,NULL,0),(35,4,'2010-04-24 00:09:03','Magento Version CE 1.3.3.0 Stable - Now Available With Support for 3-D Secure','Based on community requests, we are excited to announce the release of Magento CE 1.3.3.0-Stable with support for 3-D Secure. This release is intended for Magento merchants using version 1.3.x, who want to add support for 3-D Secure.','http://www.magentocommerce.com/blog/comments/magento-version-ce-1330-stable-now-available-with-support-for-3-d-secure/',1,0,0,NULL,NULL,0),(36,4,'2010-05-31 21:20:21','Announcing the Launch of Magento Mobile','The Magento team is pleased to announce the launch of Magento mobile, a new product that will allow Magento merchants to easily create branded, native mobile storefront applications that are deeply integrated with Magentoâ€™s market-leading eCommerce platform. The product includes a new administrative manager, a native iPhone app that is fully customizable, and a service where Magento manages the submission and maintenance process for the iTunes App Store.\n\nLearn more by visiting the Magento mobile product page and sign-up to be the first to launch a native mobile commerce app, fully integrated with Magento.','http://www.magentocommerce.com/product/mobile',1,0,0,NULL,NULL,0),(37,4,'2010-06-11 00:08:08','Magento CE Version 1.4.1.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.1.0 Stable for upgrade and download. Some of the highlights of this release include: Enhanced PayPal integration (more info to follow), Change of Database structure of the Sales module to no longer use EAV, and much more.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1410-stable-now-available/',1,0,0,NULL,NULL,0),(38,4,'2010-07-27 01:37:34','Magento CE Version 1.4.1.1 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.1.1 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-now-available/',1,0,0,NULL,NULL,0),(39,4,'2010-07-28 09:12:12','Magento CE Version 1.4.2.0-beta1 Preview Release Now Available','This release gives a preview of the new Magento Connect Manager.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-beta1-now-available/',1,0,0,NULL,NULL,0),(40,4,'2010-07-29 00:15:01','Magento CE Version 1.4.1.1 Patch Available','As some users experienced issues with upgrading to CE 1.4.1.1 through PEAR channels we provided a patch for it that is available on our blog http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-patch/','http://www.magentocommerce.com/blog/comments/magento-ce-version-1411-stable-patch/',1,0,0,NULL,NULL,0),(41,4,'2010-10-12 04:13:25','Magento Mobile is now live!','Magento Mobile is now live! Signup today to have your own native iPhone mobile-shopping app in iTunes for the holiday season! Learn more at http://www.magentomobile.com/','http://www.magentomobile.com/',1,0,0,NULL,NULL,0),(42,4,'2010-11-09 02:52:06','Magento CE Version 1.4.2.0-RC1 Preview Release Now Available','We are happy to announce the availability of Magento Preview Version 1.4.2.0-RC1 for download.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-rc1-now-available/',1,0,0,NULL,NULL,0),(43,4,'2010-12-03 01:33:00','Magento CE Version 1.4.2.0-RC2 Preview Release Now Available','We are happy to announce the availability of Magento Preview Version 1.4.2.0-RC2 for download.','http://www.magentocommerce.com/blog/comments/magento-preview-version-1420-rc2-now-available/',1,0,0,NULL,NULL,0),(44,4,'2010-12-09 03:29:55','Magento CE Version 1.4.2.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.4.2.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1420-stable-now-available/',1,0,0,NULL,NULL,0),(45,4,'2010-12-18 04:23:55','Magento Preview Version CE 1.5.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-alpha1-now-available/',1,0,0,NULL,NULL,0),(46,4,'2010-12-30 04:51:08','Magento Preview Version CE 1.5.0.0-alpha2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-alpha2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-alpha2-now-available/',1,0,0,NULL,NULL,0),(47,4,'2011-01-14 05:35:36','Magento Preview Version CE 1.5.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-beta1-now-available/',1,0,0,NULL,NULL,0),(48,4,'2011-01-22 02:19:09','Magento Preview Version CE 1.5.0.0-beta2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-beta2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-beta2-now-available/',1,0,0,NULL,NULL,0),(49,4,'2011-01-28 02:27:57','Magento Preview Version CE 1.5.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-rc1-now-available/',1,0,0,NULL,NULL,0),(50,4,'2011-02-04 02:56:33','Magento Preview Version CE 1.5.0.0-rc2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.5.0.0-rc2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1500-rc2-now-available/',1,0,0,NULL,NULL,0),(51,4,'2011-02-09 00:43:23','Magento CE Version 1.5.0.0 Stable is now available','We are excited to announce the availability of Magento CE Version 1.5.0.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-community-professional-and-enterprise-editions-releases-now-availab/',1,0,0,NULL,NULL,0),(52,4,'2011-02-10 04:42:57','Magento CE 1.5.0.1 stable Now Available','We are excited to announce the availability of Magento CE Version 1.5.0.1 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-1501-stable-now-available/',1,0,0,NULL,NULL,0),(53,4,'2011-03-19 00:15:45','Magento CE 1.5.1.0-beta1 Now Available','We are happy to announce the availability of Magento Preview Version CE 1.5.1.0-beta1 for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1510-beta1-now-available/',1,0,0,NULL,NULL,0),(54,4,'2011-03-31 22:43:02','Magento CE 1.5.1.0-rc1 Now Available','We are happy to announce the availability of Magento Preview Version CE 1.5.1.0-rc1 for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1510-rc1-now-available/',1,0,0,NULL,NULL,0),(55,4,'2011-04-26 23:21:07','Magento CE 1.5.1.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.5.1.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1510-stable-now-available/',1,0,0,NULL,NULL,0),(56,4,'2011-05-26 23:33:23','Magento Preview Version CE 1.6.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-alpha1-now-available/',1,0,0,NULL,NULL,0),(57,4,'2011-06-15 22:12:08','Magento Preview Version CE 1.6.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-beta1for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-beta1-now-available/',1,0,0,NULL,NULL,0),(58,4,'2011-06-30 23:03:58','Magento Preview Version CE 1.6.0.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-rc1-now-available/',1,0,0,NULL,NULL,0),(59,4,'2011-07-11 23:07:39','Magento Preview Version CE 1.6.0.0-rc2 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.0.0-rc2 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1600-rc2-now-available/',1,0,0,NULL,NULL,0),(60,4,'2011-08-19 21:58:31','Magento CE 1.6.0.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.0.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1600-stable-now-available/',1,0,0,NULL,NULL,0),(61,4,'2011-09-17 05:31:26','Magento Preview Version CE 1.6.1.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.1.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1610-beta1-now-available/',1,0,0,NULL,NULL,0),(62,4,'2011-09-29 19:44:10','Magento Preview Version CE 1.6.1.0-rc1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.6.1.0-rc1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1610-rc1-now-available/',1,0,0,NULL,NULL,0),(63,4,'2011-10-19 21:50:05','Magento CE 1.6.1.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.1.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1610-stable-now-available/',1,0,0,NULL,NULL,0),(64,4,'2011-12-30 22:39:35','Magento Preview Version CE 1.7.0.0-alpha1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.7.0.0-alpha1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-alpha1-now-available/',1,0,0,NULL,NULL,0),(65,4,'2012-01-11 22:24:20','Magento CE 1.6.2.0-stable Now Available','We are excited to announce the availability of Magento CE Version 1.6.2.0 Stable for download and upgrade.','http://www.magentocommerce.com/blog/comments/magento-ce-version-1620-stable-now-available/',1,0,0,NULL,NULL,0),(66,4,'2012-03-03 00:54:12','Magento Preview Version CE 1.7.0.0-beta1 is now available','We are happy to announce the availability of Magento Preview Version CE 1.7.0.0-beta1 for download.\nAs this is a preview version it is NOT recommended in any way to be used in a production environment.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-beta1-now-available/',1,0,0,NULL,NULL,0),(67,4,'2012-04-23 14:02:40','Magento Community Preview Version CE 1.7.0.0-RC1 has been released!','Learn more about the exciting new features and updates in this release and how you can take it for a test drive. As this is a preview version, we need to stress that it\'s likely unstable and that we DON\'T recommend that you use it in any production environment just yet.','http://www.magentocommerce.com/blog/comments/magento-preview-version-ce-1700-rc1-now-available/',1,0,0,NULL,NULL,0),(68,4,'2012-05-11 09:46:54','Magento Community 1.7 and Magento Enterprise 1.12 now available!','Learn more about the exciting new features and updates in these releases.','http://www.magentocommerce.com/blog/comments/magento-enterprise-112-and-community-17-now-available/',1,0,0,NULL,NULL,0),(69,4,'2012-06-20 18:54:07','Magento Community Edition 1.7.0.1 now available! ','We have just released an updated version of Magento Community Edition, version 1.7.0.1. This update delivers new, minor functionality and fixes for some potential security vulnerabilities.','http://www.magentocommerce.com/blog/comments/magento-community-edition-1701-released/',1,0,0,NULL,NULL,0),(70,4,'2012-07-05 19:21:43','Important Security Update - Zend Platform Vulnerability','We have recently learned of a serious vulnerability in the Zend platform on which Magento is built. Learn more and access a patch that addresses this issue. ','http://www.magentocommerce.com/blog/comments/important-security-update-zend-platform-vulnerability/',1,0,0,NULL,NULL,0),(71,4,'2012-11-19 20:27:42','Wrap up more holiday sales with financing','Give your customers up to 6 months financing. You get paid right away with Bill Me Later, a PayPal service. It’s a great way to extend financing in time for the holidays. Learn More.','http://www.magentocommerce.com/paypal/billmelater?utm_source=CEMessaging&utm_medium=copy&utm_content=sixmonths&utm_campaign=BML',1,0,0,NULL,NULL,0),(72,4,'2012-12-07 11:22:30','Increase Your Sales With PayPal','Magento merchants using PayPal Express Checkout can help increase their sales on average 18%. It is one simple thing you can do right now to help boost your sales. Learn more.','http://www.magentocommerce.com/add-paypal?utm_source=CEModule&utm_medium=copy&utm_content=18&utm_campaign=choosepaypal',1,0,0,NULL,NULL,0),(73,4,'2013-01-15 22:02:07','Imagine 2013 Registration is Now Open!','Join 1500 merchants, partners, developers and enthusiasts from 35+ countries around the world for Magento’s premier global conference! Collaborate, learn, network and get inspired by the future of eCommerce. Tickets will sell out fast! April 8th – 10th in Las Vegas.','https://registration.imagineecommerce.com/',1,0,0,NULL,NULL,0),(74,4,'2013-02-12 17:53:42','Get More eCommerce Power with Magento Enterprise','Limited time offer: Get a free, customized evaluation of your Community Edition site from a Magento Solution Partner. This evaluation gives you a clear look at the numerous benefits you can achieve by upgrading to Enterprise Edition. ','http://www.magentocommerce.com/community-to-enterprise?utm_source=CEMM&utm_medium=copy&utm_campaign=CE2EE',1,0,0,NULL,NULL,0),(75,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(76,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(77,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(78,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(79,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(80,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(81,3,'2013-07-22 12:43:43','Speed up your Magento store with BelVG Full Cache extension.','Find out more about this legendary extension that enhances site performance, speeds up the loading time of all pages and improves the search engines’ rating of your eShop.','http://full-cache.belvg.com/?utm_source=free-fb&utm_medium=admin-page&utm_campaign=full-cache',1,0,0,NULL,NULL,0),(82,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(83,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(84,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(85,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(86,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(87,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(88,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(89,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(90,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(91,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(92,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(93,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(94,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(95,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(96,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(97,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(98,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(99,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(100,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(101,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(102,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(103,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(104,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(105,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(106,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(107,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(108,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(109,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(110,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(111,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(112,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(113,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(114,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(115,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(116,4,'2008-11-08 04:46:42','Reminder: Change Magento`s default phone numbers and callouts before site launch','Before launching your Magento store, please remember to change Magento`s default phone numbers that appear in email templates, callouts, templates, etc.',NULL,1,0,0,NULL,NULL,0),(117,2,'2013-09-27 17:28:13','Magento Community Edition 1.8.0.0 - now available for download!','Get tax, security, performance, and many other improvements. \n\nLearn more at http://www.magentocommerce.com/blog/comments/magento-community-edition-one-eight-now-available/ ','http://www.magentocommerce.com/blog/comments/magento-community-edition-one-eight-now-available/',1,0,0,NULL,NULL,0),(118,3,'2013-10-14 11:29:40','BelVG Facebook Connect Free extension have been updated!','BelVG Facebook Connect extension have been updated! This is a critical stability update, guaranteeing all functional to work with updated Facebook API.','http://store.belvg.com/facebook-connect-and-like-free.html?utm_source=facebook-admin-page&utm_medium=admin-page&utm_campaign=facebook-update',1,0,0,NULL,NULL,0),(119,3,'2013-10-31 11:29:40','Magento Promotional Banner Free is out!','Magento Promotional Banner FREE extension is a simple and easy to setup feature, allowing you to display a banner with some products hovering over your store page on a holiday. Nine neat looking themes for nine major holidays are built-in. Hang a banner on your store, promote some special holiday offers – and all that for free.','http://store.belvg.com/promotional-banner-free.html?utm_source=facebook-admin-page&utm_medium=admin-page&utm_campaign=promotional-banner',1,0,0,NULL,NULL,0),(120,3,'2013-11-15 13:41:11','Prepare your store for the upcoming hollidays with BelVG Promotional Banner Free. New skins were added!','Promotional Banner Free allows you to add special holiday-themed banners to your store pages in order to promote certain products in holiday period. The extension contains twelve different predefined themes which you can select from and thus always be ready for almost every popular event without any additional efforts!','http://store.belvg.com/promotional-banner-free.html?utm_source=facebook-admin-page&utm_medium=admin-page&utm_campaign=promotional-banner&v=2',1,0,0,NULL,NULL,0),(121,4,'2013-11-28 07:04:32','Magestore Thanksgiving Week : OFF 15% on any extension','To celebrate this year’s Thanksgiving day, Black Friday and Cyber Monday, we are glad to offer MAGESTORE THANKSGIVING WEEK, starting from today (Nov 25) to the end of Cyber Monday (Dec 02) (GMT-7) .\n\nDuring this time, you will get a %15 discount when buying any Magento extension from Magestore website. You would rarely have the chance to get all your dream Magento extensions at a shocking price like this to boost your year-end revenue and beyond.\n\nSound interesting?','http://www.magestore.com/magento-extensions.html',1,0,0,NULL,NULL,0),(122,3,'2013-11-29 11:54:38','A new UI enchantment for your Magento store - Product Slider extension!','Product Slider module is a good solution to arrange and present products on your Magento store. The module allows creating several types of sliders which can display either specific custom products or special Magento product types including New products, Category products, Discount products, etc.','http://store.belvg.com/product-slider.html?utm_source=facebook-admin-page&utm_medium=admin-page&utm_campaign=product-slider',1,0,0,NULL,NULL,0),(123,3,'2013-12-05 15:22:44','Liven up your boring static slider with new mind-blowing animation effects of the BelVG Magento Animated Slider!','BelVG Animated Slider Magento Extension allows you to create any number of sliders and slides with highly customizable dynamic content, animations and hyperlinks – everything you might need for successful marketing.','http://animated-slider.belvg.com/?utm_source=facebook-admin-page&utm_medium=admin-page&utm_campaign=animated-slider',1,0,0,NULL,NULL,0),(124,4,'2013-12-11 15:35:06','Magento Community Edition 1.8.1.0 is here!','This new version offers significant tax calculation, product quality, and security enhancements. Be sure to carefully review the upgrade instructions before starting. More information is available at http://www.magentocommerce.com/blog/comments/magento-community-edition-1810-is-here/','http://www.magentocommerce.com/blog/comments/magento-community-edition-1810-is-here/',1,0,0,NULL,NULL,0),(125,4,'2013-12-12 23:24:39','Important Magento Community Edition Patch','A security patch is available for Magento Community Edition 1.4.0.0 through 1.7.0.2; the issue has been fixed in Magento Community Edition 1.8.0.0 and later. It resolves a vulnerability discovered through our quarterly penetration testing process and has not been reported by merchants. We encourage all merchants to apply the patch in their next regularly scheduled maintenance cycle. The patch is available at http://www.magentocommerce.com/download in the Magento Community Edition Patches section.','http://www.magentocommerce.com/download',1,0,0,NULL,NULL,0),(126,4,'2014-01-21 18:34:48','PHP 5.4 Patch Now Available','Magento is advancing its platform and making development more efficient by adding support for PHP 5.4. Patches are available for download at www.magentocommerce.com/download and you can learn more about this update in our blog post at http://www.magentocommerce.com/blog/comments/magento-now-supports-php-54 .','http://www.magentocommerce.com/blog/comments/magento-now-supports-php-54',1,0,0,NULL,NULL,0),(127,3,'2014-01-31 14:30:17','With BelVG Store Locator extension the customer will never get lost on a way to the exact product he wants to get from your offline store! ','Fully integrated Google Map will show all of your stores and point the customer to the closest one. Have variable stocks? Take care of that by assigning the products to specific stores allowing the customer to see which store has the desired product!','http://store-locator.belvg.com/?utm_source=facebook-free&utm_medium=line&utm_campaign=store-locator',0,0,0,NULL,NULL,0),(128,4,'2014-02-03 16:14:54','Imagine 2014 Registration is Open','Register today to join us May 12-14 at the Hard Rock Hotel in Las Vegas for Imagine 2014, Magento\'s annual conference.\n\nEarly-bird registration pricing ends February 17 so don’t delay!\n\nhttp://www.imagineecommerce.com?utm_source=magento&utm_medium=cerss&utm_campaign=registrationopen\n\n','http://www.imagineecommerce.com?utm_source=magento&utm_medium=cerss&utm_campaign=registrationopen',0,0,0,NULL,NULL,0),(129,4,'2014-02-20 17:51:46','Discover Card Validation Patch Available','A patch that resolves an issue with validating Discover credit cards is now available for download at http://www.magentocommerce.com/download. More information on the patch is available in the Magento Knowledge Base at http://www.magentocommerce.com/knowledge-base/entry/discover-card-validation','http://www.magentocommerce.com/knowledge-base/entry/discover-card-validation ',0,0,0,NULL,NULL,0),(130,4,'2014-03-04 15:12:26','Learn How to Quickly Increase Sales on Your Site','Adding the PayPal Express Checkout button to your checkout page can help increase sales 18% on average. It’s fast and easy and you can do it right now to boost sales. Express Checkout is already seamlessly integrated into Community Edition.','http://magento.com/paypal/CE_Express_Checkout_NA?utm_source=messagemodule&utm_medium=message&utm_campaign=Ceexpresscheckout',0,0,0,NULL,NULL,0),(131,4,'2014-05-13 16:46:11','Magento Community Edition 1.9 is now available!','It accelerates your entry into the mobile commerce space by slashing the time and cost of getting a mobile device-friendly responsive site.  And a new Bill Me Later payment option helps boost your sales. Visit http://magento.com/blog/magento-news/magento-enables-responsive-sites-half-time to learn more.','http://magento.com/blog/magento-news/magento-enables-responsive-sites-half-time',1,0,0,NULL,NULL,0),(132,4,'2014-09-23 06:50:48','eBay Enterprise Display and Affiliate services can turbocharge your holiday sales. Learn how.','Learn more at www.ebayenterprise.com/turbochargesales.  DID YOU KNOW: Over 128 million shoppers visit eBay.com each month in Q4--and you can reach these highly qualified shoppers with eBay Enterprise Display. Also Magento merchants who use product-based retargeting ads average at least $5 in sales for every $1 in Retargeting spend. And on the Affiliate Network, you get access to over 200,000 active network publishers across 20+ promotional categories and 30+ verticals, and only pay when a consumer makes a purchase (Affiliate Network is only available in the U.S. & Canada). GET STARTED TODAY by visiting www.ebayenterprise.com/turbochargesales.','http://www.ebayenterprise.com/turbochargesales',0,0,0,NULL,NULL,0),(133,3,'2014-09-26 10:40:12','Making good use of your Facebook Free extension from BelVG?  Enjoy even more functional with an advanced version of this extension by the same developer – Facebook All in One','Facebook All In One includes all the functional possible to implement with a Facebook extension and wraps it into a ready to go from the box extension. Be social – as customers sharing your site are one of the best marketing tools!','http://store.belvg.com/facebook-all-in-one.html?utm_source=facebook-free&utm_medium=admin&utm_campaign=facebook',0,0,0,NULL,NULL,0),(134,4,'2014-10-08 04:55:06','It’s still not too late: Boost your 2014 Holiday sales today.','See results in as little as one week with eBay Enterprise Display and 2 business days with eBay Enterprise Affiliate. DID YOU KNOW: Get access to over 128 million highly qualified shoppers on eBay.com with eBay Enterprise Display. And the average retail client using product retargeting sees a $10 to $1 ROI on retargeting spend during Q4. With the eBay Enterprise Affiliate Network, get access to over 200,000 active network publishers across 30+ verticals, and only pay when a customer makes a purchase (Affiliate Network is only available in the U.S. & Canada).  GET STARTED TODAY by visiting www.ebayenterprise.com/turbochargesales','http://www.ebayenterprise.com/turbochargesales',0,0,0,NULL,NULL,0),(135,4,'2014-11-12 19:03:26','Important: PayPal Users Must Discontinue Using SSL 3.0 By December 3, 2014','To address a vulnerability with the SSL 3.0 security protocol, PayPal and other payment gateways will be disabling SSL 3.0 support. Merchants must upgrade to Transport Layer Service (TLS) by December 3, 2014 to avoid PayPal payment operation failures. Learn more about what you need to do at https://devblog.paypal.com/poodle-ssl-3-0-vulnerability/','https://devblog.paypal.com/poodle-ssl-3-0-vulnerability/',0,0,0,NULL,NULL,0),(136,4,'2014-11-24 23:25:21','Magento Community Edition 1.9.1 is available!','Magento Community Edition 1.9.1 empowers merchants to deliver compelling shopping experiences by offering enhanced responsive design capabilities, new swatches to display product variations, and improved performance through support for MySQL 5.6 and PHP 5.5. It also includes support for Google Universal Analytics and over 70 product improvements. Find out more at http://magento.com/blog/magento-news/magento-community-edition-191-now-available-download','http://magento.com/blog/magento-news/magento-community-edition-191-now-available-download',0,0,0,NULL,NULL,0),(137,3,'2014-11-28 09:10:12','30% OFF All Magento Extensions and Themes - BelVG Black Friday Deal','BelVG announces 30% off EVERYTHING! Go to our Magento store and enjoy these amazing low prices on all the extensions and themes!','http://store.belvg.com/extensions.html?utm_source=facebook-free&utm_medium=admin&utm_campaign=facebook',0,0,0,NULL,NULL,0),(138,4,'2015-01-22 17:47:08','Join Us at Imagine Commerce 2015 - April 20-22 at the Wynn Las Vegas','Join Magento, eBay Enterprise, and over 2,000 merchants, developers, and eCommerce experts at the premier Commerce event of the year. With three days of cutting-edge keynote presentations, special technical programs, dynamic breakout sessions, and incredible networking opportunities, Imagine Commerce 2015 will educate, enrich, and inspire you to take your business to new heights. Register now at http://imagine2015.magento.com/.','http://imagine2015.magento.com/',0,0,0,NULL,NULL,0),(139,1,'2015-04-16 16:17:07','Critical Reminder: Download and install Magento security patches.  Download now.','Download and implement 2 important security patches (SUPEE-5344 and SUPEE-1533) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  If you have not done so already, download and install 2 previously-released patches that prevent an attacker from remotely executing code on Magento software.  These issues affect all versions of Magento Community Edition.  A press release from Check Point Software Technologies in the coming days will make one of these issues widely known, possibly alerting hackers who may try to exploit it.  Ensure the patches are in place as a preventative measure before the issue is publicized.','https://www.magentocommerce.com/products/downloads/magento/ ',1,0,0,NULL,NULL,0),(140,1,'2015-04-19 22:37:00','Second Reminder: Download and install Magento critical security patches now.','If you have not done so already, download and install 2 previously-released security patches (SUPEE-5344 and SUPEE-1533) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  These security issues affect all versions of Magento Community Edition and enable an attacker to remotely execute code on Magento software. A press release from Check Point Software Technologies tomorrow  will make one of these issues widely known, possibly alerting hackers who may try to exploit it.  Ensure the patches are in place as a preventative measure before the issue is publicized.','https://www.magentocommerce.com/products/downloads/magento/',1,0,0,NULL,NULL,0),(141,1,'2015-04-23 19:43:31','Urgent: Immediately install Magento critical security patches','It is critical for you to download and install 2 previously-released security patches (SUPEE-5344 and SUPEE-1533) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  Please do this immediately, as Check Point Software Technologies has published a technical description of how they discovered the issue, which we feel might serve as a tutorial for implementing an attack against your website. ','https://www.magentocommerce.com/products/downloads/magento/',1,0,0,NULL,NULL,0),(142,1,'2015-05-15 00:34:01','Important: New Magento Security Patch - Install it Now','It is important for you to download and install a new security patch (SUPEE-5994) from the Magento Community Edition download page (https://www.magentocommerce.com/products/downloads/magento/).  Please apply this critical update immediately to help protect your site from exposure to multiple security vulnerabilities impacting all versions of the Magento Community Edition software. Please note that this patch should be installed in addition to the recent Shoplift patch (SUPEE-5344).','https://www.magentocommerce.com/products/downloads/magento/',1,0,0,NULL,NULL,0),(143,4,'2015-07-07 16:28:25','Now available:  Enhanced site quality and security with Community Edition 1.9.2','Magento Community Edition 1.9.2 is now available for download and features over 105 product improvements, nearly 170 automated functional tests to help internal development teams improve implementation quality and time to market, and several security enhancements. Read our blog announcement for more information (http://magento.com/blog/magento-news/magento-community-edition-192-now-available), or go to the Community Edition download page to get the software today (https://www.magentocommerce.com/products/downloads/magento/).','https://www.magentocommerce.com/products/downloads/magento/',0,0,0,NULL,NULL,0),(144,1,'2015-07-07 17:08:05','July 7, 2015: New Magento Security Patch (SUPEE-6285) – Install Immediately','Today we are providing a new security patch (SUPEE-6285) that addresses critical security vulnerabilities. The patch is available for Community Edition 1.4.1 to 1.9.1.1 and is part of the core code of our latest release, Community Edition 1.9.2, available for download today.  PLEASE NOTE:  You must first implement SUPEE-5994 to ensure SUPEE-6285 works properly. Download Community Edition 1.9.2 or the patch from the Community Edition download page: https://www.magentocommerce.com/products/downloads/magento/  ','https://www.magentocommerce.com/products/downloads/magento/',1,0,0,NULL,NULL,0),(145,1,'2015-08-04 17:28:26','August 4, 2015: New Magento Security Patch (SUPEE-6482) – Install Immediately','Today we are providing a new security patch (SUPEE-6482) that addresses 4 security issues; two issues related to APIs and two cross-site scripting risks. The patch is available for Community Edition 1.4 and later releases and is part of the core code of Community Edition 1.9.2.1, which is available for download today. Before implementing this new security patch, you must first implement all previous security patches. Download Community Edition 1.9.2.1 or the patch from the Community Edition download page at https://www.magentocommerce.com/products/downloads/magento/  ','https://www.magentocommerce.com/products/downloads/magento/  ',1,0,0,NULL,NULL,0),(146,2,'2015-08-05 20:12:55','August 5, 2015:  Security Patch (SUPEE-6482) Release Note CORRECTION','When we announced a new security patch (SUPEE-6482) for Community Edition yesterday we incorrectly said that it addresses 4 issues. It actually addresses 2 security issues: Autoloaded File Inclusion in Magento SOAP API and a SSRF Vulnerability in WSDL File. The patch and Community Edition 1.9.2.1 are complete, fully-tested, and ready to deploy. We strongly encourage you to deploy the patch or upgrade to the latest version of Community Edition if you haven’t done so already. You can find the patch at https://www.magentocommerce.com/products/downloads/magento/. ','https://www.magentocommerce.com/products/downloads/magento/',0,0,0,NULL,NULL,0),(147,4,'2015-10-01 17:32:53','Episode VI: Return of Imagine Commerce | 2016 Registration is Open!','The force is strong with this one. Join the Magento rebellion at Imagine Commerce 2016. Enlist Now at http://imagine.magento.com.','http://imagine.magento.com',0,0,0,NULL,NULL,0),(148,1,'2015-10-21 00:28:05','New Malware Issue. Make Sure You Have Implemented All Security Patches','We have received reports that some Magento sites are being targeted by Guruincsite malware (Neutrino exploit kit). We have NOT identified a new attack vector at this time. Nearly all the impacted sites checked so far were vulnerable to a previously identified and patched issue; sites not vulnerable to that issue show other unpatched issues. Visit the Magento Security Center at http://magento.com/security/news/important-security-update for more information on how to address this issue and make sure that you have implemented all recent security patches.\n','http://magento.com/security/news/important-security-update',1,0,0,NULL,NULL,0),(149,1,'2015-10-27 21:48:23','October 27, 2015: New Magento Security Patch (SUPEE-6788) – Install Immediately','Today, we are releasing a new patch (SUPEE-6788) and Community Edition 1.9.2.2 to address 10+ security issues, including remote code execution and information leak vulnerabilities. This patch is unrelated to the Guruincsite malware issue. Be sure to test the patch in a development environment first, as it can affect extensions and customizations. Download the patch from the Community Edition Download page and learn more at http://magento.com/security/patches/supee-6788  ','http://magento.com/security/patches/supee-6788  ',1,0,0,NULL,NULL,0),(150,1,'2015-11-18 00:25:00','New JavaScript Malware Issue. Make sure your site is secure.','Magento Commerce has received reports of a JavaScript malware exploit that forwards credit card information from checkout pages to an external site. No new attack vector has been identified. It appears most impacted sites have not implemented the February 2015 Shoplift patch, or the patch was implemented after the site was already compromised. Information on how to identify and remove the malicious code is available on the Magento Security Center at http://magento.com/security/news/new-javascript-malware-issue','http://magento.com/security/news/new-javascript-malware-issue ',1,0,0,NULL,NULL,0),(151,4,'2015-11-18 21:40:40','Magento 2.0 Is Available!','Magento 2.0, our next generation open source digital commerce platform is here!  Magento 2.0 offers enhanced performance and scalability, new features to deliver better shopping experiences and conversion rates, and business agility and productivity improvements.  Learn more http://magento.com/blog/magento-news/new-era-commerce-innovation.\n\n','http://magento.com/blog/magento-news/new-era-commerce-innovation',0,0,0,NULL,NULL,0),(152,4,'2016-01-13 22:51:52','Have questions? Magento has big answers at Imagine Commerce.','Big news, bigger experts, and an even bigger ecosystem. Will you be at Imagine Commerce? Join us. ','http://imagine.magento.com',0,0,0,NULL,NULL,0),(153,1,'2016-01-20 22:17:19','Important: New Security Patch (SUPEE-7405) and Release – 1/20/2016','Today, we are releasing a new patch (SUPEE-7405) and Community Edition 1.9.2.3 to improve the security of Magento sites. There are no confirmed attacks related to the security issues, but certain vulnerabilities can potentially be exploited to access customer information or take over administrator sessions. You can download the patch and release from the Community Edition Download Page and learn more at https://magento.com/security/patches/supee-7405. ','https://magento.com/security/patches/supee-7405',1,0,0,NULL,NULL,0),(154,1,'2016-02-24 08:06:43','Important: Updates to SUPEE-7405 Security Patch and Release – 2/23/2016','Updated versions of the recent SUPEE-7405 patch and Community Edition 1.9.2.3 release are now available. The updates add support for PHP 5.3 and address issues with upload file permissions, merging carts, and SOAP APIs experienced with the original release. They DO NOT address any new security issues, but all merchants should upgrade to the new versions to maintain compatibility with future releases. You can learn more about the updates at https://magento.com/security/patches/supee-7405','https://magento.com/security/patches/supee-7405',1,0,0,NULL,NULL,0),(155,1,'2016-03-31 00:25:07','Protect Your Business from Brute-Force Password Guessing Attacks','We just posted an article on the Magento Security Center that shares best practices for protecting stores from brute-force password guessing attacks. We’ve recently been made aware of a rise in these attacks, so we strongly recommend that you review the approaches outlined in this article with your developer and hosting provider immediately and implement the ones that are best suited to your unique situation. Learn more at https://magento.com/security/best-practices/protect-your-magento-installation-password-guessing ','https://magento.com/security/best-practices/protect-your-magento-installation-password-guessing ',1,0,0,NULL,NULL,0),(156,4,'2016-06-23 16:44:34','Increase your sales and productivity, while simplifying PCI compliance with exciting new Magento Community Edition 2.1 features.','Shoppers can now check out faster using credit cards stored with PayPal and a redesigned PayPal checkout. PCI compliance is easier thanks to Braintree Hosted Fields. Admin tools are redesigned to help you work more efficiently. Upgrade to Enterprise Edition for new Content Staging and Preview and Enhanced Site Search capabilities.','https://magento.com/blog/magento-news/magento-enterprise-edition-21-unleashes-power-marketers-and-merchandisers ',0,0,0,NULL,NULL,0),(157,4,'2016-07-15 16:37:35','Magento needs your input. Please take our 2-question survey. Ends on Friday, July 22nd.','We want to hear from you. As a valued Community Edition user, we are interested in learning about your future upgrade plans for your Magento store. The survey is only two questions and should be very quick to complete. We will keep your response completely confidential. Our goal is to understand if and when you plan to upgrade your software, so we can ensure we have the right tools and support to ensure your success. You can access our survey through the following link: https://www.research.net/r/R9R2MJV','https://www.research.net/r/R9R2MJV',0,0,0,NULL,NULL,0),(158,4,'2016-09-12 22:24:26','Share the Marketplaces/Social Media platforms that matter most to you with Magento. Take our brief survey.','As a valued Magento user, we are interested in learning how you use Marketplaces and Social Media platforms today to advertise and sell products from your Magento store. We are continuously looking at ways to improve our product and your feedback is essential. \n\nThe survey is simple and should not take more than 5 minutes to complete, and we will keep your response completely confidential. \n\nAccess our survey through the following link:  https://www.research.net/r/5BZCC2Q\n','https://www.research.net/r/5BZCC2Q',0,0,0,NULL,NULL,0),(159,4,'2016-09-12 22:54:08','Which Marketplaces/Social Media Platforms Matter Most? Take Our Brief Survey.','Here at Magento we are continuously looking to improve our product. \n\nWe want to know which marketplaces and social media platforms you use to advertise and sell products from your Magento store. This simple survey should take less than five minutes. Your feedback is essential and we will keep your response completely confidential.\n \nTake the survey:  https://www.research.net/r/5BZCC2Q\n','https://www.research.net/r/5BZCC2Q',0,0,0,NULL,NULL,0),(160,4,'2016-09-21 21:52:16','We Need Your Input! Take a Survey on CMS, Tax and Other Feature Needs','The Magento team is looking for your feedback to inform our product roadmap. We’re interested in which features you use, how we can improve built-in CMS and tax features, and what new capabilities are most important to you. Your responses will be kept confidential. Please complete the survey by September 28, 2016. Get started at https://www.research.net/r/L6TB52P\n\n','https://www.research.net/r/L6TB52P',0,0,0,NULL,NULL,0),(161,1,'2016-10-12 20:30:13','Community Edition 1.9.3 and SUPEE-8788 Provide Critical Security & Functional Updates – 10/12/2016','Community Edition 1.9.3 and SUPEE-8788 resolve multiple security issues, including critical vulnerabilities with certain payment methods and Zend Framework libraries. Community Edition 1.9.3 also includes over 120 product quality enhancements and support for PHP 5.6. Learn more about the security issues at https://magento.com/security/patches/supee-8788 and functional updates at http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html#ce19-1930 ','https://magento.com/security/patches/supee-8788 ',1,0,0,NULL,NULL,0),(162,4,'2016-10-19 16:36:02','SMTP Pro was installed successfully.','SMTP Pro has been installed successfully. Go to the system configuration section of your Magento admin to configure SMTP Pro and get it up and running.','https://github.com/aschroder/Magento-SMTP-Pro-Email-Extension',0,0,0,NULL,NULL,0),(163,1,'2016-10-25 16:51:10','Dirty COW Linux OS Vulnerability – 10/25/2016','Dirty COW (CVE-2016-5195) is a serious vulnerability affecting most Linux Operating Systems that can be exploited to gain root access to the server. More information on how to immediately update your Linux OS is available in the Magento Security Center at https://magento.com/security/vulnerabilities/new-linux-operating-system-vulnerability. ','https://magento.com/security/vulnerabilities/new-linux-operating-system-vulnerability',1,0,0,NULL,NULL,0),(164,4,'2016-11-14 21:08:04','Community Edition 1.9.3.1 is Now Available – 11/14/2016','Community Edition 1.9.3.1 addresses issues encountered by some merchants in our October 12 product releases. All merchants should either upgrade to Community Edition 1.9.3.1 or apply our latest patch, SUPEE-8788, to close several serious security vulnerabilities. More information is available in the release notes at: http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html#ce19-1931 ','http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html#ce19-1931 ',0,0,0,NULL,NULL,0),(165,4,'2016-12-30 17:53:18','We want your opinion! Take our Retail Trends survey for 2017.','Let us know what is important to you and your business for 2017. We invite you to take our retail trends survey which should take no more than a few minutes to complete. As always, any individual information you provide will remain strictly confidential. \n\nTo participate, go to:\nhttps://www.research.net/r/PWJCD2X','https://www.research.net/r/PWJCD2X',0,0,0,NULL,NULL,0),(166,4,'2017-01-03 04:05:15','Happy 2017! We want your opinion. Take our Retail Trends survey.','Let us know what is important to you and your business for 2017. We invite you to take our retail trends survey which should take no more than a few minutes to complete. As always, any individual information you provide will remain strictly confidential. \n\nTo participate, go to:\nhttps://www.research.net/r/PWJCD2X','https://www.research.net/r/PWJCD2X',0,0,0,NULL,NULL,0),(167,4,'2017-01-13 00:44:39','Are you struggling with managing inventory across multiple sources (aka nodes)?  If so, please take this important short survey. ','Please take a few minutes to tell us your thoughts on multi-node functionality. Does your business need the ability to manage discrete sets of inventory based on type and location (i.e., inventory in multiple locations such as in multiple warehouses and/ or in drop shippers, physical stores, etc).\n\nTake the survey at https://www.research.net/r/S26PJ6S.\n','https://www.research.net/r/S26PJ6S',0,0,0,NULL,NULL,0),(168,1,'2017-01-14 02:33:20','New Zend Framework Security Vulnerability – 1/13/2017','We’ve found a new vulnerability in a Zend Framework 1 and 2 email component used by all Magento 1 and Magento 2 software (as well as other PHP solutions). This vulnerability is serious and can lead to a remote code execution attack if your servers use Sendmail as a mail transport agent. Learn how to protect your sites at https://magento.com/security/news/new-zend-framework-1-security-vulnerability\n\n','https://magento.com/security/news/new-zend-framework-1-security-vulnerability',1,0,0,NULL,NULL,0),(169,4,'2017-01-19 16:58:24','New Magento DevBox Beta Speeds Magento 2 Setup – 1/19/2017','Magento DevBox Beta makes it faster and easier than ever to setup your Magento 2 development environment. Read our blog post to find out more at: https://magento.com/blog/technical/set-your-magento-2-development-environment-faster.','https://magento.com/blog/technical/set-your-magento-2-development-environment-faster',0,0,0,NULL,NULL,0),(170,1,'2017-02-07 20:03:15','Community Edition 1.9.3.2 and SUPEE-9652 Resolve Zend Framework Security Issue – 2/7/2017','Community Edition 1.9.3.2 and the SUPEE-9652 patch resolve the recent Zend Framework 1 Security vulnerability. Review the Magento Security Center post for more information:  https://magento.com/security/patches/supee-9652','https://magento.com/security/patches/supee-9652',1,0,0,NULL,NULL,0),(171,4,'2017-02-17 21:07:28','Inspirational athlete, Serena Williams, will join Magento at Imagine 2017.','Imagine 2017 will bring together 3000+ international commerce experts to exchange ideas on the future of commerce. Don’t miss this opportunity to hear from inspirational athlete, Serena Williams, and Stella & Dot CEO, Jessica Herrin. Join us in Las Vegas, April 3-5. Register Now at https://imagine.magento.com/\n','https://imagine.magento.com/',0,0,0,NULL,NULL,0),(172,1,'2017-05-31 20:03:50','Community Edition 1.9.3.3 and SUPEE-9767 Security Enhancements – 5/31/2017','Community Edition 1.9.3.3 and SUPEE-9767 includes critical security enhancements. Review the Security Center update for more information: https://magento.com/security/patches/supee-9767','https://magento.com/security/patches/supee-9767',1,0,0,NULL,NULL,0),(173,2,'2017-06-13 18:20:53','New Patch for PayPal Instant Payment Notification (IPN) Changes. Upgrade to 1.9.3.3 or SUPEE-8167 by June 30, 2017 to Avoid Service Disruptions – 6/13/2017','As of June 30, 2017, PayPal Instant Payment Notifications will no longer allow you to use HTTP to post messages back to PayPal for verification. To comply with these changes, all merchants using PayPal must upgrade to Community Edition 1.9.3.3 or apply the SUPEE-8167 patch. Updates must be in place by June 30, 2017 to avoid any service disruptions. The patch is available on the Community Edition Download Page (https://magento.com/tech-resources/download) and more information is available from PayPal at https://www.paypal-knowledge.com/infocenter/index?page=content&widgetview=true&id=FAQ1916&viewlocale=en_US\n\n','https://magento.com/tech-resources/download ',0,0,0,NULL,NULL,0),(174,4,'2017-07-05 09:25:37','Magento Business Intelligence Essentials: Now Available!','Magento Business Intelligence Essentials (BI) helps you and your teams to stay on top of the most important metrics to your business. Essentials works directly with your Magento order and customer data, and provides business insights far beyond what standard web analytics tools provide.\n\nWith Essentials, you can get up and running in only a few minutes and access over 75 pre-built reports instantly. Plus, it comes with a free 7-day trial where no credit card information is required. If you decide to stay, Essentials starts at just $100/month.\n\nFor more information, visit magento.com/products/business-intelligence/essentials.\n','https://magento.com/products/business-intelligence/essentials',0,0,0,NULL,NULL,0),(175,1,'2017-07-12 18:15:32','Community Edition 1.9.3.4 and SUPEE-9767 Version 2 Address Issues with May 31 Security Release','Community Edition 1.9.3.4 and SUPEE-9767 v2 (patch) are now available. The new release and updated patch address customer registration and other issues encountered by some merchants when using the original release. Please upgrade as soon as possible to keep your site secure. More information is available in the release notes at  http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html','http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(176,4,'2017-07-27 21:11:52','Listing your products in marketplaces like Amazon? We want your feedback!','If you sell your products in any marketplace/s today and/or are considering it in the future, we invite you to take our short survey. Your feedback will help us to determine the overall interest and need for integration with marketplace and fulfillment services from companies like Amazon.\n\nThank you in advance.\n\nThe Magento Strategy team','https://www.surveymonkey.com/r/3F5MT75',0,0,0,NULL,NULL,0),(177,4,'2017-08-18 14:42:29','Join the Magento BI Essentials Webinar on Aug 22: Make Data Easy ','Join our webinar on Tuesday, August 22nd and learn about why merchants like you are choosing Magento BI  Essentials to make it easier to harness the power of your data. \n\nBob Moore, Head of Magento BI, will be discussing the value of the reporting and dashboards that comes out-of-the-box with Essentials and the insights you can gain from them. \n\nRegister today. \n\nhttps://magento.com/resources/magento-bi-essentials-making-data-easy?lsdet=MBI-Webinar-RSS\n','https://magento.com/resources/magento-bi-essentials-making-data-easy?lsdet=MBI-Webinar-RSS',0,0,0,NULL,NULL,0),(178,4,'2017-08-21 20:17:07','Last Chance: Join the Magento BI Essentials Webinar on Aug 22: Make Data Easy ','Join our webinar on Tuesday, August 22nd and learn about why merchants like you are choosing Magento BI  Essentials to make it easier to harness the power of your data. \n\nBob Moore, Head of Magento BI, will be discussing the value of the reporting and dashboards that comes out-of-the-box with Essentials and the insights you can gain from them. \n\nRegister today. \n\nhttps://magento.com/resources/magento-bi-essentials-making-data-easy?lsdet=MBI-Webinar-RSS\n','https://magento.com/resources/magento-bi-essentials-making-data-easy?lsdet=MBI-Webinar-RSS',0,0,0,NULL,NULL,0),(179,4,'2017-09-08 18:07:06','Survey: Have physical retail stores? If yes, we\'d like your feedback.','If you sell online and through physical storefronts, we\'d like to hear from you.\n\nPlease take our online survey on in-store/ in-branch POS and digital tools.  This survey should take no more than a few minutes to complete.\n\nTo get started, go to: \nhttps://www.surveymonkey.com/r/ZSN9KWC\n\nThank you in advance for your participation.','https://www.surveymonkey.com/r/ZSN9KWC',0,0,0,NULL,NULL,0),(180,2,'2017-09-11 22:52:53','USPS Name Change Impacts “First-Class Mail Parcel” Service – 09/11/2017','USPS changed their “First-Class Mail Parcel” Service to “First-Class Package Service – Retail.” Merchants offering this service must change the name, as “First-Class Mail Parcel” will no longer work. Patches addressing this issue are available on the Magento Open Source download page. More information about the issue is available in a Technical Bulletin at http://devdocs.magento.com/guides/v2.1/release-notes/tech_bull_USPS-patch-Sept2017.html ','http://devdocs.magento.com/guides/v2.1/release-notes/tech_bull_USPS-patch-Sept2017.html ',0,0,0,NULL,NULL,0),(181,1,'2017-09-14 23:13:38','Magento Open Source 1.9.3.6 Security Enhancements – 9/14/2017','Magento Open Source 1.9.3.6 includes critical security enhancements. Please update your site as soon as possible. More information is available in the release notes: \nhttp://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html.\n','http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(182,1,'2017-09-15 17:50:16','Magento Open Source 1.9.3.6 and SUPEE-10266 Security Enhancements – 9/14/2017','Magento Open Source 1.9.3.6 and SUPEE-10266 include critical security enhancements. Please update your site as soon as possible. More information is available in the release notes: \nhttp://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html.\n','http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(183,4,'2017-09-26 22:42:02','Magento Open Source 2.2 Delivers Enhanced Commerce Capabilities – 9/26/2017','Magento Open Source 2.2 includes a range of platform enhancements, including a new deployment process that minimizes production downtime, optimized performance, platform updates that improve developer experience, and Magento Social marketing tools. Learn more at http://devdocs.magento.com/guides/v2.2/release-notes/bk-release-notes.html.\n\n','http://devdocs.magento.com/guides/v2.2/release-notes/bk-release-notes.html ',0,0,0,NULL,NULL,0),(184,4,'2017-10-17 13:09:36','Join us for an exclusive B2B merchant event in Chicago!','Transform your business at the Magento B2B Experience on November 2 in Chicago. \n\nNetwork with industry leaders, B2B merchants, and partners to gain insights on B2B best practices, and to discover how to create powerful buyer experiences using Magento to boost your growth. RSVP today! \n\nRegister for free at https://b2bexperience.magento.com\n\nNote: This is a merchant-only event.\n','https://b2bexperience.magento.com',0,0,0,NULL,NULL,0),(185,4,'2017-10-27 16:54:48','Last Chance: join us on Nov 2 at the Magento B2B merchant event in Chicago!','Transform your business at the Magento B2B Experience on November 2 in Chicago. \n\nNetwork with industry leaders, B2B merchants, and partners to gain insights on B2B best practices, and to discover how to create powerful buyer experiences using Magento to boost your growth. RSVP today! \n\nRegister for free at https://b2bexperience.magento.com\n\nNote: This is a merchant-only event.\n','https://b2bexperience.magento.com',0,0,0,NULL,NULL,0),(186,1,'2017-11-29 19:06:29','Magento Open Source 1.9.3.7 Enhances Security - 11/28/2017','Magento Open Source 1.9.3.7 includes critical security enhancements. We encourage you to upgrade or patch as soon as is reasonably possible. Review the release notes for more information: \nhttp://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html\n\n','http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(187,4,'2017-12-12 20:00:13','Magento Open Source 2.2.2 Accelerates Growth with Instant Purchase Checkout, Integrated Email Marketing Automation, Advanced Reporting, and More – 12/12/2017','Our newest release of Magento Open Source equips merchants with powerful tools to accelerate growth and improve operational efficiency. It boosts conversion rates with a streamlined Instant Purchase checkout, jump-starts sales with integrated dotmailer email marketing automation, delivers actionable insights through Advanced Reporting, and provides integrated multi-carrier shipping and fulfillment capabilities with Magento Shipping. https://magento.com/blog/magento-news/new-instant-purchase-checkout-boosts-sales ','https://magento.com/blog/magento-news/new-instant-purchase-checkout-boosts-sales ',0,0,0,NULL,NULL,0),(188,4,'2017-12-15 23:17:43','Survey: Do you use site personalization and optimization tools? If yes, we\'d to hear from you!','We\'d like to invite you to take our online survey on site personalization and optimization tools. Your input is valuable and will help to inform the products we bring to market.\n\nThe survey should take no more than 5-7 minutes. \n\nTo get started, go to: \nhttps://www.surveymonkey.com/r/NF9ZH8D\n\nThank you in advance for your participation.','https://www.surveymonkey.com/r/NF9ZH8D',0,0,0,NULL,NULL,0),(189,4,'2017-12-26 18:24:06','Survey: Do you use site personalization tools? If yes, please take our survey.','We\'d like to invite you to take our online survey on site personalization and optimization tools. Your input is valuable and will help to inform the products we bring to market.\n\nThe survey should take no more than 5 minutes to complete. \n\nTo get started, go to: \nhttps://www.surveymonkey.com/r/NF9ZH8D\n\nThank you in advance for your participation.','https://www.surveymonkey.com/r/NF9ZH8D',0,0,0,NULL,NULL,0),(190,4,'2017-12-27 15:46:32','Magento Survey: Take our quick survey on payments risk & fraud.','We\'d like to invite you to take our online survey on payments risk and fraud. The survey should take no more than 2 minutes to complete.\n\nTo get started, go to: \nhttps://www.surveymonkey.co.uk/r/J8SQ9VG\n\nThank you in advance for your participation.\n\n~The Magento Team','https://www.surveymonkey.co.uk/r/J8SQ9VG',0,0,0,NULL,NULL,0),(191,4,'2018-01-03 00:10:24','Survey: Tell us about your expectations for mobile commerce in less than 1 minute','Happy new year!\n\nHas mobile commerce lived up to your expectations? We\'d like to hear from you. Take our short survey and tell us what you think.\n\nGo to: https://www.surveymonkey.com/r/589GJVT\n\nCheers!\n\n~The Magento Team','https://www.surveymonkey.com/r/589GJVT',0,0,0,NULL,NULL,0),(192,4,'2018-01-03 17:34:06','Survey: Tell us about your expectations for mobile commerce with our 1 minute survey','Happy new year!\n\nHas mobile commerce lived up to your expectations? We\'d like to hear from you. Take our short survey and tell us what you think.\n\nGo to: https://www.surveymonkey.com/r/589GJVT\n\nCheers!\n\n~The Magento Team','https://www.surveymonkey.com/r/589GJVT',0,0,0,NULL,NULL,0),(193,3,'2017-08-28 02:16:16','Magento Inventory Report has already released','Magento Inventory Report has already launched. With this extension, you’ll be able to use a great variety of inventory reports and also sales report to get priceless statistic data in real time. ','https://www.magestore.com/magento-inventory-report-extension.html?utm_source=magestore&utm_medium=feed&utm_campaign=IM-report',0,0,0,NULL,NULL,0),(194,4,'2018-01-31 00:18:07','Are you a Magento Developer? Please participate in our developer survey. ','As a Magento developer, your feedback is critical to the success of the Magento platform. We invite you to complete a survey about your experience developing on the Magento 2 platform. The results will help us improve our product and services to enable your continued success. The survey should take no more than 10 minutes to complete and the information you provide will remain strictly confidential. \n\nThanks in advance for your participation. \n\nhttps://www.surveymonkey.com/r/X3KHNV3','https://www.surveymonkey.com/r/X3KHNV3',0,0,0,NULL,NULL,0),(195,4,'2018-02-07 13:57:07','New Magento Security Scan Tool is available!','Magento has rolled out a new security scan tool that enables you to regularly monitor your sites and receive updates regarding known security risks, malware, and unauthorized access. Our  goal is to assist in ensuring the on-going security of your Magento sites. \n\nSecurity Scan is a free service of Magento, and provides over 30 security tests to identify potential vulnerabilities, such as missing Magento patches, configuration issues, and failure to follow security best practices. In addition, you\'ll receive real-time security status of your Magento sites and how to fix potential vulnerabilities.\n\nYou and your team, including authorized developers, can access the new tool directly within your Magento Account. And it is very easy to set up. \n\nTo learn more about the Security Scan Tool, \nlog into your Magento Account at https://account.magento.com/customer/account/.\n\nMy Account > Security Scan','https://account.magento.com/customer/account/',0,0,0,NULL,NULL,0),(196,1,'2018-02-27 19:45:55','Magento Open Source 1.9.3.8 and SUPEE-10570 Enhance Security and Functionality – 2/27/2018','Magento Open Source 1.9.3.8 and the SUPEE-10570 patch include critical security enhancements and feature updates, including support for recent USPS API changes. Review the release notes for more information: http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html ','http://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(197,1,'2018-04-09 05:03:15','Take Steps to Protect Your Site ','Our goal is to help you deliver the highest level of security to your Magento site. \n\nYou now have access to a security scan tool that enables you to regularly monitor your sites and receive updates regarding known security risks, malware, and unauthorized access. It provides over 30 security tests to identify potential vulnerabilities, such as missing Magento patches, configuration issues, and failure to follow security best practices. Please be sure to set your site up for security scanning – activation is quick and easy. Access today in your Magento account.\n\nYou should also visit our Security Center which provides alerts around potential issues as well as best practices to help you protect your site against issues, such as brute force attacks. Brute-force password guessing attacks continue to target Magento Open Source (formerly Community Edition) sites worldwide and we have published an  article that explains multiple actions you can take to protect your site from such attacks. In some cases, these attacks have resulted in unauthorized administrative access, so it is important to implement these recommendations.\n\nTo visit the Magento Security Center:\nwww.magento.com/security\n\nTo view steps you can take to protect against issues like brute force, go to:\nwww.magento.com/security/best-practices/5-immediate-actions-protect-against-brute-force-attacks\n','https://magento.com/security/best-practices/5-immediate-actions-protect-against-brute-force-attacks',1,0,0,NULL,NULL,0),(198,4,'2018-04-18 16:45:05','Survey: Do you use digital ad tools? If yes, please take our 5 minute survey.','We\'d like to invite you to take our online survey on digital advertising tools. Your input is valuable to us and will help to inform future products.\n\nThe survey should take no more than 5 minutes to complete. \n\nTo get started, go to: \n\nhttps://www.surveymonkey.com/r/9QQLV67\n\nThank you in advance for your participation.\n','https://www.surveymonkey.com/r/9QQLV67',0,0,0,NULL,NULL,0),(199,4,'2018-05-02 21:07:01','Magento Open Source 2.2.4 Enables Better Shopping Experiences with Integrated Payment, Tax, and Shipping Solutions – 5/2/2018','The latest release of Magento Open Source empowers merchants to create better shopping experiences with performance enhancements and integrations with Amazon Pay, Klarna, and Vertex. Learn how these features can help you reduce cart abandonment and increase average order value, while simplifying your operations at https://magento.com/blog/magento-news/create-better-shopping-experiences-magento-commerce','https://magento.com/blog/magento-news/create-better-shopping-experiences-magento-commerce',0,0,0,NULL,NULL,0),(200,1,'2018-06-27 18:45:16','Magento Open Source 2.2.5 delivers important security updates along with performance and functionality enhancements – 6/27/2018','The latest release of Magento Open Source includes important security enhancements along with performance and functionality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. For more information about security updates included in these versions of Magento please see our Security Center: https://magento.com/security/patches/magento-2.2.5-and-2.1.14-security-update','https://devdocs.magento.com/guides/v2.2/release-notes/bk-release-notes.html',1,0,0,NULL,NULL,0),(201,4,'2018-07-16 23:55:59','Survey: Help us improve the Admin Panel usability by taking this 5 minute survey.','We\'d like to invite you to take our online survey on Admin Panel Usability. Your input is valuable to us and will help to inform the user experience direction. The survey should take no more than 5 minutes to complete.\n \nTo get started, go to:\nhttps://www.surveymonkey.com/r/SUS-AdHoc-M1 ','https://www.surveymonkey.com/r/SUS-AdHoc-M1 ',0,0,0,NULL,NULL,0),(202,1,'2018-09-06 15:22:45','Magento Open Source 1 software security patches thru June 2020','Magento Open Source 1 software security patches thru June 2020\n\nFor Magento Open Source 1.5 to 1.9, we are providing software security patches through June 2020 to ensure those sites remain secure and compliant. Visit our information page for more details about our software maintenance policy and other considerations for your business.\n\nhttps://info2.magento.com/M1OpenSource.html\n','https://info2.magento.com/M1OpenSource.html',1,0,0,NULL,NULL,0),(203,1,'2018-09-18 23:21:37','Magento Open Source 2.2.6 delivers important security updates along with performance and functionality enhancements – 9/18/2018','The latest release of Magento Open Source includes important security enhancements along with performance and functionality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. For more information about security updates included in these versions of Magento please see our Security Center: https://magento.com/security/patches/magento-2.2.6-and-2.1.15-security-update','https://devdocs.magento.com/guides/v2.2/release-notes/bk-release-notes.html',1,0,0,NULL,NULL,0),(204,2,'2018-09-27 15:49:45','PHP 7.2 support patches are now available for Magento 1','PHP 7.2 support patches for Magento 1 are now available. It is critical you are on a supported version of PHP to ensure your site is secure and in compliance. For compatibility and download details, please visit our developer forum post.\n\nhttps://community.magento.com/t5/News-Announcements/PHP-7-2-Support-Patches-for-Magento-1-are-now-available/m-p/106999#M211','https://community.magento.com/t5/News-Announcements/PHP-7-2-Support-Patches-for-Magento-1-are-now-available/m-p/106999#M211',0,0,0,NULL,NULL,0),(205,4,'2018-10-30 18:23:29','Help Magento improve our product - take a brief survey ','We want your perspectives on Personalization and Experience Optimization. \n\nYour feedback is 100% confidential.\n\nExperience Optimization refers to A/B/n Testing, Recommendations, and Experience Targeting (dynamic content, emails, promotions, etc.)\n\nThank you!\n\nClick here\nhttps://www.surveymonkey.com/r/M1-Exp-Opt-Oct2018','https://www.surveymonkey.com/r/M1-Exp-Opt-Oct2018',0,0,0,NULL,NULL,0),(206,1,'2018-11-28 21:03:26','Magento Commerce 1.9.4.0 adds PHP 7.2 support along with security enhancements – 11/28/2018','The latest release of Magento Open Source 1 adds support for PHP 7.2 and delivers important security enhancements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about these enhancements. For more information about security updates included in this version of Magento please see our Security Center: https://magento.com/security/patches/supee-10975','https://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(207,4,'2018-12-12 22:08:11','What does 2019 look like for you? Take our Retail Trends survey!','Let us know what\'s important to you and your business in 2019!\n\nWe invite you to take our retail trends survey which should take no more than a few minutes to complete. As always, any individual information you provide will remain strictly confidential.\n\nYou can take the survey at: \nwww.surveymonkey.com/r/GHNQTJ2','https://www.surveymonkey.com/r/GHNQTJ2',0,0,0,NULL,NULL,0),(208,4,'2018-12-18 22:29:24','Take our brief product survey.','We are evaluating adding a media library into the Magento content management system to enable merchants to access their own saved media without re-uploading it each time. This media library may also potentially include third-party stock media with a selection of free and paid media (images, videos, etc.).\n\nTake our survey here: https://www.surveymonkey.com/r/MWJJWQP \n\nYour survey answers will help us determine the level of interest in these features.','https://www.surveymonkey.com/r/MWJJWQP ',0,0,0,NULL,NULL,0),(209,4,'2019-01-31 18:04:25','Free Site Assessment to Drive Conversion','Magento Commerce 2 is here and there’s no better time to evolve your eCommerce strategy. Talk to us about getting a free site assessment and migration plan. We’ll help you identify opportunities to boost conversions by as much as 35%.\n\nLearn more: http://bit.ly/2WxJ6LQ\n','http://bit.ly/2WxJ6LQ',0,0,0,NULL,NULL,0),(210,4,'2019-02-07 18:12:11','Get 6 months free of Magento Commerce 2','Still using Magento Open Source 1? Embrace the power of Magento Commerce 2 with six months of free service. We’re here to help with a complimentary site assessment and seamless migration planning.\n\nDon’t wait until it’s too late, contact us today: http://bit.ly/2G9SJKM\n','http://bit.ly/2G9SJKM',0,0,0,NULL,NULL,0),(211,4,'2019-02-12 22:13:48','Take our brief product survey.','Hello Magento Community, \n\nThrough this survey, the product team at Magento wants seek feedback on three different topics i.e. Magento Security,  Sales Channel, and Magento Cloud. Your feedback will help us to make better product decisions in future.\n\n**if you are a partner/non-seller/non-merchant taking this survey, please respond to the survey on behalf of your clients/merchants to whom these questions/topics may apply.\n\nYour feedback is 100% confidential and will not be shared in any way.\n\nThanks\nMagento UX\n\nhttps://www.surveymonkey.com/r/M1_Feb2019_ProductUXSurvey\n','https://www.surveymonkey.com/r/M1_Feb2019_ProductUXSurvey',0,0,0,NULL,NULL,0),(212,4,'2019-02-12 22:41:12','Magento Open Source 1 is sunsetting. Migration assistance and funding available.','We’re sunsetting Magento Open Source 1, but a new day is dawning with Magento Commerce 2. We’ve teamed up with our trusted premiere partners to make migration a breeze for you.\n\nLearn how we can help evolve your online retail experience and drive sales growth: http://bit.ly/2WsMyXP','http://bit.ly/2WsMyXP',0,0,0,NULL,NULL,0),(213,4,'2019-02-25 14:58:09','5 Point Checklist to Drive Better Conversions','Do you support one-click checkout? Run relevant promotions? Set proper shipping expectations? Let our commerce experts analyze your site and demonstrate how Magento 2 can boost revenue and customer satisfaction. Contact us today to sign up for your free site assessment.\n\nLearn more: http://bit.ly/2WxJ6LQ','http://bit.ly/2WxJ6LQ',0,0,0,NULL,NULL,0),(214,1,'2019-03-01 20:19:27','Action required: Update Authorize.Net Direct Post from MD5 to SHA-512 – 3/1/2019','Magento\'s implementation of the Authorize.Net Direct Post payment method uses MD5 based hash, and on March 14, 2019 Authorize.net will stop supporting MD5 based hash usage. This will result in Magento merchants not being able to process payments using Authorize.Net Direct Post. To avoid disruption and to continue processing payments, merchants need to apply a patch provided by Magento and add a Signature Key (SHA-512) in the Magento Admin configuration settings. For information on applying this patch please see the Magento Help Center.\n\nhttps://support.magento.com/hc/en-us/articles/360024368392','https://support.magento.com/hc/en-us/articles/360024368392',1,0,0,NULL,NULL,0),(215,4,'2019-03-05 19:48:03','Increase Conversions with a Free Site Assessment','Magento Commerce 2 is here, and there’s no better time to evolve your eCommerce strategy. Talk to us about getting a free site assessment and migration plan. We’ll help you identify opportunities to boost conversions by as much as 35%.  \n\nLearn more: http://bit.ly/2WxJ6LQ','http://bit.ly/2WxJ6LQ',0,0,0,NULL,NULL,0),(216,4,'2019-03-13 19:21:18','Your version of Open Source 1 is sunsetting. Migration assistance available. ','We’re sunsetting Magento Open Source 1, but a new day is dawning with Magento Commerce 2. We’ve teamed up with our trusted partners to make migration a breeze for you. Learn how we can help evolve your online retail experience and drive sales growth.  http://bit.ly/2WsMyXP ','http://bit.ly/2WsMyXP ',0,0,0,NULL,NULL,0),(217,4,'2019-03-20 03:39:31','Support for your free version of Magento ends in 2020. It’s time to migrate to Magento 2 with funding assistance available.  ','Support for Magento Open Source 1 is winding down, but Magento Commerce 2 is ready to take you to the next level. And our premiere partners are here to make migration easy. Learn how we can help evolve your online retail experience and drive sales growth:  http://bit.ly/2WsMyXP ','http://bit.ly/2WsMyXP',0,0,0,NULL,NULL,0),(218,1,'2019-03-26 18:05:45','Magento Open Source 1.9.4.1 released with important security enhancements – 3/26/2019','The latest release of Magento Open Source 1 delivers important security enhancements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about these enhancements. For more information about security updates included in this version of Magento please see our Security Center: https://magento.com/security/','https://devdocs.magento.com/guides/m1x/ce19-ee114/ce1.9_release-notes.html',1,0,0,NULL,NULL,0),(219,4,'2019-03-27 22:48:32','2019: Your Time to Join the Progressive Web App Movement ','Progressive Web App technology is enabling smarter, faster mobile shopping experiences. Forrester presents their latest findings on this next-generation technology, now available on Magento Commerce 2. Read the report and reshape your customers mobile engagement.  Learn more: http://bit.ly/2HwliDK ','http://bit.ly/2HwliDK ',0,0,0,NULL,NULL,0),(220,4,'2019-04-03 05:02:39','Support for your free version of Magento ends in 2020. It’s time to migrate to Magento 2 with funding assistance available.  ','Let’s shed light on the perception that Magento Open Source is always the cheaper option. Spoiler alert – you may be surprised. Free is more expensive than you think. Learn how Magento Commerce accelerates time to market, simplifies content creation, scales with your business and more in our myth-busting guide: http://bit.ly/2WJVUxB \n\n \n\n \n','http://bit.ly/2WJVUxB ',0,0,0,NULL,NULL,0),(221,4,'2019-05-02 19:59:28','Support for your free version of Magento ends in 2020. Sign up for your free site assessment now. ','Talk to us about getting a free site assessment and migration plan. We’ll help you identify opportunities to boost conversions by as much as 35%.  \nLearn more: http://bit.ly/2WxJ6LQ ','http://bit.ly/2WxJ6LQ ',0,0,0,NULL,NULL,0),(222,4,'2019-05-05 21:07:17','Magento Total Cost of Opportunity Guide. Get free eBook now.','Magento provides multiple eCommerce offerings with unique benefits. The question becomes: Is your free version of Magento Open Source the best option for your business and budget? Properly evaluate the all-in costs of software, development, upkeep and support needs with this free guide: http://bit.ly/2WLcNIz ','http://bit.ly/2WLcNIz ',0,0,0,NULL,NULL,0),(223,1,'2019-05-10 21:36:33','Your Version of Magento Open Source Sunsets in 2020 ','It’s time to evolve your eCommerce strategy with Magento 2. Get started with a no obligation website assessment to identify your biggest opportunities to improve conversions. Hurry, offer ends May 31!\nLearn More: http://bit.ly/2WxJ6LQ ','http://bit.ly/2WxJ6LQ ',1,0,0,NULL,NULL,0),(224,1,'2019-05-28 22:33:41','Don’t miss out! This is the last week to get your free website conversion assessment. ','Many Magento customers have seen conversion increase by 30% or more after migrating to Magento Commerce 2. Let our team analyze your webstore and identify your biggest opportunities to improve conversions. Hurry, offer ends May 31! Get your results: http://bit.ly/2WxJ6LQ ','http://bit.ly/2WxJ6LQ ',1,0,0,NULL,NULL,0),(225,4,'2019-06-03 19:45:34','Support for your version of Magento Open Source ends in 2020.  Learn how Magento Commerce can reduce your costs and complexity. ','You get flexibility and access to code no matter what version you’re using. But Open Source comes with less out of the box. Magento Commerce includes drag and drop content creation, business intelligence tools, shipping, and more. Get our free guide full of tips for comparing the TCO of Magento Open Source vs. Magento Commerce: http://bit.ly/2WLcNIz ','http://bit.ly/2WLcNIz ',0,0,0,NULL,NULL,0),(226,4,'2019-06-03 19:50:22','Take your commerce strategy to the next level with Magento 2. Get started today- sign up for a complimentary site assessment.','We’re here to help grow your business and take your commerce strategy to the next level. Let our expert team evaluate your site and identify specific ways to boost conversion and customer satisfaction. Sign up today: http://bit.ly/2w1YYKs ','http://bit.ly/2w1YYKs ',0,0,0,NULL,NULL,0),(227,4,'2019-06-06 16:28:29','53% of people leave a mobile page if it takes more than 3 seconds to load. Is your site performance up to snuff?  ','If your traffic is up but your site speed is down, you aren’t alone. And it may be a signal that you’ve outgrown your current eCommerce setup and are missing out on revenue. Check out this helpful eBook which outlines 5 signs your growing business is ready for Magento Commerce: http://bit.ly/2Ws5REf','http://bit.ly/2Ws5REf',0,0,0,NULL,NULL,0),(228,4,'2019-06-13 18:20:50','How low can your commerce Total Cost of Ownership go?  ','Magento provides multiple eCommerce offerings with unique benefits. The question becomes: Is your free version of Magento Open Source the best option for your business and budget? Properly evaluate the all-in costs of software, development, upkeep and support needs with this free guide: http://bit.ly/2I7Zw8P','http://bit.ly/2I7Zw8P',0,0,0,NULL,NULL,0),(229,4,'2019-06-17 22:07:17','How low can your commerce Total Cost of Ownership go?  ','Magento provides multiple eCommerce offerings with unique benefits. The question becomes: Is your free version of Magento Open Source the best option for your business and budget? Properly evaluate the all-in costs of software, development, upkeep and support needs with this free guide: http://bit.ly/2WN7Za4','http://bit.ly/2WN7Za4',0,0,0,NULL,NULL,0),(230,4,'2019-06-20 03:49:49','Free eBook: Is Open Source Always a Better Value?','Let’s shed light on the perception that Magento Open Source is always the cheaper option. Spoiler alert – you may be surprised. Learn how Magento Commerce accelerates time to market, simplifies content creation, scales with your business and more in our myth-busting guide: http://bit.ly/2WJVUxB','http://bit.ly/2WJVUxB',0,0,0,NULL,NULL,0),(231,4,'2019-06-24 14:44:20','Success on Tap: Beer Hawk\'s upgrade to Magento Commerce 2','Read how this customer achieved astronomical eCommerce growth and successfully rode the wave of popularity for craft beer since their upgrade from Magento 1 Open Source to Magento Commerce 2. Case study:  http://bit.ly/2WTWYyO','http://bit.ly/2WTWYyO',0,0,0,NULL,NULL,0),(232,1,'2019-06-25 16:08:15','Important Security and Performance Updates Released in Magento 2.3.2  ','The latest releases of Magento include important security enhancements, along with performance and productivity improvements. We strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements and information on security updates included in these versions of Magento at our Security Center: https://magento.com/security/','https://devdocs.magento.com/guides/v2.3/release-notes/bk-release-notes.html',1,0,0,NULL,NULL,0),(233,4,'2019-07-08 15:12:19','Shoe retailer Loake saw a 45% increase in conversion rate after they migrated to Magento Commerce 2. Let us analyze your site now.','After migrating to Magento Commerce 2, Shoe retailer Loake increased their conversion rate by 45%. You can find out more about your own opportunities to evolve your eCommerce strategy with a free site assessment from our expert team.  And with Magento 1 sunsetting soon, there’s no better time to evolve your eCommerce strategy. Learn more: http://bit.ly/2KThop8','http://bit.ly/2KThop8',0,0,0,NULL,NULL,0),(234,4,'2019-07-18 19:48:31','Free Site Assessment to Drive Conversion','Let our expert team evaluate your site and identify specific areas for improvements. Many customers have seen their conversions improve by as much as 35%.  Magento Commerce 2 is here, and there’s no better time to evolve your eCommerce strategy. Learn more:http://bit.ly/30EK2Pr','http://bit.ly/30EK2Pr',0,0,0,NULL,NULL,0),(235,4,'2019-07-26 19:21:53','Learn how reimagining your eCommerce experience can drive revenue growth. Don\'t delay- register today for your free site assessment.','Don\'t miss this opportunity to boost your sales, streamline operations, and scale effortlessly by moving to Magento Commerce 2. Our team of experts are ready to evaluate your site and identify specific areas for enhancement. Reserve your spot today: http://bit.ly/30EK2Pr','http://bit.ly/30EK2Pr',0,0,0,NULL,NULL,0),(236,4,'2019-08-01 21:21:52','Ready, Set, Grow! Check out our five best practices for ensuring your eCommerce platform has the necessary scalability.','The future is full of opportunity, but your eCommerce platform has to be ready for it. We’ve got five best practices to ensure your platform has what it takes to grow with your business. Download guide here: http://bit.ly/2YFTrsI','http://bit.ly/2YFTrsI',0,0,0,NULL,NULL,0),(237,4,'2019-08-07 23:24:38','6 Must-Haves for a Fast, Flexible eCommerce Platform','The future of digital eCommerce is knocking. You\'ll need a competitive eCommerce platform which meets escalating operational demands and consumer experience expectations. Download eBook here: http://bit.ly/315BbGI','http://bit.ly/315BbGI',0,0,0,NULL,NULL,0),(238,4,'2019-08-15 13:39:29','Tackle the diverse demands of modern eCommerce with Magento Commerce 2.  Get started now- sign up today for your free site assessment. ','Gain an edge on the competition using the next-generation features found on Magento Commerce 2. Grow your revenue, personalize the customer experience, and streamline the checkout process. Learn more about our free site assessment by speaking with our team of experts today: http://bit.ly/30EK2Pr','http://bit.ly/30EK2Pr',0,0,0,NULL,NULL,0),(239,4,'2019-08-22 22:27:34','Your Version of Magento Open Source Sunsets in 2020','It’s time to evolve your eCommerce strategy with Magento 2. Get started with a no obligation website assessment to identify your biggest opportunities to improve conversions. Hurry, offer ends August 31! Learn More: http://bit.ly/30EK2Pr','http://bit.ly/30EK2Pr',0,0,0,NULL,NULL,0),(240,4,'2019-08-23 14:05:14','MagentoLive Europe 2019','Join 2000+ Commerce Innovators for MagentoLive Europe in Amsterdam from 22-23 October. Register Now!','https://live-eu.magento.com/',0,0,0,NULL,NULL,0),(241,4,'2019-08-27 14:06:03','Breaking news! Adobe (Magento) is recognized by Gartner as a Leader based on Magento Commerce in the 2019 Magic Quadrant for Digital Commerce. ','Learn why Magento Commerce is a Leader for a third year in a row and continues to move because of our ability to execute. Read the full report: http://bit.ly/31YIZdU','http://bit.ly/31YIZdU',0,0,0,NULL,NULL,0),(242,4,'2019-08-29 23:27:32','Your Version of Magento Open Source Sunsets in 2020. ','It’s time to evolve your eCommerce strategy with Magento 2. Get started with a no obligation website assessment to identify your biggest opportunities to improve conversions. Hurry, offer ends August 31! Learn More: http://bit.ly/30EK2Pr','http://bit.ly/30EK2Pr',0,0,0,NULL,NULL,0),(243,4,'2019-09-09 05:08:07','See how high your ROI can go with Magento Commerce 2. Get started with a free ROI evaluation today.','Get a free personalized cost savings and revenue growth evaluation.  Learn more: http://bit.ly/2kyYMA9','http://bit.ly/2kyYMA9',0,0,0,NULL,NULL,0),(244,4,'2019-09-10 05:16:26','See how Magento Commerce 2 can deliver a 165% ROI.','Study shows merchants who upgrade to Magento Commerce 2 have seen site traffic jump 25% and conversions increase 16%. Discover the business value of migrating by downloading the full report: http://bit.ly/2lIWONN','http://bit.ly/2lIWONN',0,0,0,NULL,NULL,0),(245,4,'2019-09-16 16:42:22','See how high your ROI can go with Magento Commerce 2. Get started with a free ROI evaluation.','Get a free personalized cost savings and revenue growth evaluation.  Learn more: http://bit.ly/2kyYMA9','http://bit.ly/2kyYMA9',0,0,0,NULL,NULL,0),(246,4,'2019-09-19 15:11:35','New study shows ROI of 165% after upgrading to Magento Commerce 2. ','See what Magento Commerce 2 can do for you with a free ROI evaluation. Sign up today: http://bit.ly/2kyYMA9','http://bit.ly/2kyYMA9',0,0,0,NULL,NULL,0),(247,4,'2019-09-24 16:05:05','Experience cost-effective revenue growth with Magento Commerce 2 ','Discover recent customer research revealing a 165% boost in ROI after upgrading to M2. Learn how migrating can boost your business value by downloading the full report: http://bit.ly/2lIWONN','http://bit.ly/2lIWONN',0,0,0,NULL,NULL,0),(248,4,'2019-10-01 15:34:14','Do you need to plan for future growth, but spend most of your time managing day-to-day operations?','Our guide to fast-track business planning can help you prepare for tomorrow, even as you meet deadlines today. Get guide here: http://bit.ly/2odHie3','http://bit.ly/2odHie3',0,0,0,NULL,NULL,0),(249,4,'2019-10-08 18:54:54','It’s time to get your digital business out of the slow lane.','Accelerate your revenue growth and drive customer satisfaction with these 5 must-have eCommerce features. Download this informative guide: http://bit.ly/2og3g0q','http://bit.ly/2og3g0q',0,0,0,NULL,NULL,0),(250,1,'2019-10-09 19:59:35','Magento Open Source 2.3.3 delivers important security updates along with performance and functionality enhancements – 10/9/2019 ','The latest release of Magento Open Source 2.3.3, Magento Open Source 2.2.10 and our new security-only patch 2.3.2-p2 are now available. Magento Open Source 2.3.3 includes important security enhancements along with new features, improved performance, and quality. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. For more information about security updates included in these versions of Magento please see our Security Center: https://magento.com/security/','https://devdocs.magento.com/guides/v2.3/release-notes/bk-release-notes.html',1,0,0,NULL,NULL,0),(251,4,'2019-10-16 13:52:13','You are invited: The True Cost Savings of Magento Commerce Webinar','Join other Magento Open Source customers for a live webinar on October 30th with commerce experts Matthew Boland and John Glasgow from Adobe to learn how upgrading from Open Source to Magento Commerce can trim your costs and deliver major ROI. Register today: http://bit.ly/31arLcK','http://bit.ly/31arLcK',0,0,0,NULL,NULL,0),(252,4,'2019-10-23 12:48:53','eBook: Advanced Strategies for Fast-Tracking Revenue Growth','Take your business in a new direction by selling more to a larger audience. Our guide explains 5 ways you can quickly add new revenue streams to your business. Link here: http://bit.ly/31LyWsY','http://bit.ly/31LyWsY',0,0,0,NULL,NULL,0),(253,4,'2019-11-04 21:24:12','Discover the value of a Magento Commerce Migration in our all-new video','Since 2008, Magento Open Source has delivered a solution to create digital commerce success stories. Now, it’s time to look forward to the future in our all new video, Mmmbrellas: A Tale of Two Stores. Learn why the time to migrate is now in this delightful demonstration of Magento Commerce. Learn more: http://bit.ly/2NEjxFd','http://bit.ly/2NEjxFd',0,0,0,NULL,NULL,0),(254,4,'2019-11-11 18:30:52','Special Offer for Open Source Customers through November 29th.','Take advantage of a special discount when you move to a Magento Commerce cloud subscription (formerly Enterprise Edition) through November 29th. With exciting new features like Page Builder and Content Staging and Preview, now is the perfect time to contact us. Link here: http://bit.ly/36O6ee5','http://bit.ly/36O6ee5',0,0,0,NULL,NULL,0),(255,4,'2019-11-14 16:37:20','We need your help! How do you fulfill and ship your orders?','We need your help! How do you fulfill and ship your orders?','http://selfserve.decipherinc.com/survey/selfserve/9d5/g013/191028 ',0,0,0,NULL,NULL,0),(256,4,'2019-12-02 15:08:23','2020 goal: Is your product content keeping up with your customers?','Magento Page Builder gives you fast content updates and even faster growth. Download our eBook to learn more. Link here: http://bit.ly/2OEpJyr','http://bit.ly/2OEpJyr',0,0,0,NULL,NULL,0),(257,4,'2019-12-09 18:08:00','Online B2B purchases are set to skyrocket to $9 trillion in the US alone this year. Get in on the action with B2B and B2C selling. ','The lines between B2B and B2C commerce are blurring. Here’s 5 reasons to go hybrid with your commerce strategy in 2020. http://bit.ly/2Rr14zf','http://bit.ly/2Rr14zf',0,0,0,NULL,NULL,0),(258,4,'2019-12-16 18:38:38','Did you know? A whopping 89% of B2B businesses now rely on digital content to guide their purchasing process.','Learn how you can integrate compelling content into your B2B sales strategy with our latest eBook. Download Now: http://bit.ly/36dpMaK','http://bit.ly/36dpMaK',0,0,0,NULL,NULL,0),(259,4,'2020-01-02 18:25:32','With Magento 1 reaching end of life in 6 months, make upgrading your resolution for 2020.','Upgrading to Magento Commerce might cost less than you think. Watch our webinar to learn the true cost savings of upgrading to Magento Commerce 2. Watch Now: http://bit.ly/31arLcK','http://bit.ly/31arLcK',0,0,0,NULL,NULL,0),(260,4,'2020-01-13 18:02:19','eCommerce is an ocean of opportunity. Take our quiz and find out if you are a pilot fish, octopus, or shark.','Find out if you’re ready to sell with the big fish by taking our brief quiz designed to identify your competitive selling potential. Answer our set of quick questions to see where you stack up and receive personalized resources to give your digital growth strategy some teeth. http://bit.ly/2QNibKU','http://bit.ly/2QNibKU',0,0,0,NULL,NULL,0),(261,4,'2020-01-21 17:04:53','2020: The Year You Reimagine Your Mobile Platform','Smarter, faster mobile shopping experiences are now achievable with Progressive Web App technology. Forrester reveals how to leverage this next-generation technology, now available on Magento Commerce 2. Reimagine your mobile environment with this exclusive report. Link here: http://bit.ly/2TvfsaV','http://bit.ly/2TvfsaV',0,0,0,NULL,NULL,0),(262,4,'2020-01-27 16:00:46','Learn The 6 Sweet Features Behind Every Irresistible eCommerce Experience.','92% percent of online shoppers call it quits before checkout over poor site performance. Discover the six essential features your commerce platform needs to create truly memorable customer moments. Link here: http://bit.ly/2tNpqKd\n','http://bit.ly/2tNpqKd',0,0,0,NULL,NULL,0),(263,1,'2020-01-28 20:08:37','Magento Open Source 2.3.4 delivers important security updates and features to help you build a more engaging customer experience – 1/28/2020','The latest releases of Magento Open Source – 2.3.4, 2.3.3-p1, and 2.2.11 – are now generally available. The latest release of Magento Open Source includes important security enhancements along with new functionality and platform quality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. Learn how this release can help you build a more engaging customer experience at Magento.com/blog.','https://devdocs.magento.com/guides/v2.3/release-notes/bk-release-notes.html',1,0,0,NULL,NULL,0),(264,4,'2020-02-03 19:53:16','You are invited: Seize the New Year– 5 Growth Strategies for 2020.','Join us for a live webinar on February 13th with Magento experts Shannon Hane and Matthew Wasley from Adobe to learn the latest eCommerce strategies to accelerate revenue growth in 2020. Register today: http://bit.ly/2GPoQyr','http://bit.ly/2GPoQyr',0,0,0,NULL,NULL,0),(265,4,'2020-02-10 16:41:04','Are you putting off integrating your ERP and eCommerce?','Get started on the journey to a more integrated and profitable eCommerce business. Download our comprehensive guide, eCommerce + ERP: Better Together. http://bit.ly/2OWw5th','http://bit.ly/2OWw5th',0,0,0,NULL,NULL,0),(266,4,'2020-02-12 15:10:48','Join Tomorrow\'s Webinar: Seize the New Year– 5 Growth Strategies for 2020.','Join us for a live webinar tomorrow, February 13th with Magento experts Shannon Hane and Matthew Wasley from Adobe to learn the latest eCommerce strategies to accelerate revenue growth in 2020. Register today: http://bit.ly/2GPoQyr','http://bit.ly/2GPoQyr',0,0,0,NULL,NULL,0),(267,2,'2020-02-19 17:03:45','Support for Magento Open Source 1 sunsets June 30th...Are you ready?','Continued use of unsupported software risks negative impacts to your business. Start your upgrade today with a free site assessment. Our team of experts will evaluate your site and identify specific areas for conversion improvements. Reserve your site assessment: http://bit.ly/2SCuoTy','http://bit.ly/2SCuoTy',0,0,0,NULL,NULL,0),(268,2,'2020-02-26 17:12:07','Find out how to grow your revenue and lower TCO with this free offer from Magento.','As a Magento Open Source 1 Customer, you qualify for a free site assessment! Let our expert team evaluate your site and identify specific areas for improvements. Many customers have seen their conversions improve by 35%. Remember, Open Source 1 software sunsets June 30th. Reserve your spot today: http://bit.ly/32mZySh','http://bit.ly/32mZySh',0,0,0,NULL,NULL,0),(269,4,'2019-09-12 22:47:41','Affirm Extension Version 3.6.2 is now available','Affirm Extension Version 3.6.2 for Magento is now available for download and upgrade. To see a full list of updates please check the release notes page.','https://github.com/Affirm/Magento_Affirm/releases',0,0,0,NULL,NULL,0),(270,4,'2021-04-15 15:59:38','Amasty`s extension has been installed. Remember to flush all cache, recompile, log-out and log back in.','You can see versions of the installed extensions right in the admin, as well as configure notifications about major updates.','https://amasty.com/knowledge-base/how-to-disable-base-module-notifications-in-magento-1.html',0,0,1,NULL,NULL,0),(271,4,'2021-04-16 08:44:15','How to customize your site without errors','Site customization comes with its risks. Because of the poor implementation of custom features, one-third of Magento websites tend to break down. This creates headaches, expenses, and downtime we`d all like to avoid. Here`s how to solve this','https://u.amasty.com/3hr',0,1,1,'2021-04-23 08:44:15','https://amasty.com/static/news/256.svg',0),(272,4,'2021-04-23 11:52:59','Drive more sales with ILN major update','We`re excited to announce a collection of new UI/UX changes to Improved Layered Navigation to further improve everyone`s experience.','https://u.amasty.com/3jy',0,1,1,'2021-04-30 11:52:59','https://amasty.com/static/news/258.svg',0),(273,4,'2021-04-21 08:23:10','29 MM WhatsApp messages are sent every min. How to get profit from this for your store?','Instant communication with leads can improve customer service and conversions. Convert your leads into sales with our latest extension - WhatsApp Combo, by our new partner.','https://u.amasty.com/3il',0,1,1,'2021-04-28 08:23:10','https://amasty.com/static/news/257.svg',0),(274,4,'2021-04-30 10:12:46','April updates for your Amasty extensions!','Hello to April updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2021-05-07 10:12:46','https://amasty.com/static/news/260.svg',0),(275,4,'2021-05-05 09:56:06','Deals that make your sales explode! [MAY SPECIALS]','Each month we bring you the best deals on our latest extensions and services. This time, we`re offering tools with optimized UX and UI to help your business grow by offering your customers optimal customer experience.','https://u.amasty.com/3nz',0,1,1,'2021-05-12 09:56:07','https://amasty.com/static/news/261.svg',0),(276,4,'2021-05-07 11:38:55','New Facebook Pixel extension is live! No to traffic ad, yes to conversions ad','Do you market yourself using Facebook ads? If you do, you may be excited to know that we`re introducing Facebook Pixel support for your Magento site.','https://u.amasty.com/3oz',0,1,1,'2021-05-14 11:38:55','https://amasty.com/static/news/262.svg',0),(277,4,'2021-05-14 08:42:48','Google postpones to take action, but you should not!','Originally scheduled for May, Google has announced that it will now be releasing its major algorithm change starting mid-June. If you haven`t prepared for the new search engine ranking update, now`s a good time to ensure your website is optimized for performance. See how.','https://u.amasty.com/3qc',0,1,1,'2021-05-21 08:42:48','https://amasty.com/static/news/264.svg',0),(278,4,'2021-05-12 06:46:10','Reach millions with voice-enabled shopping. See how','With a continuing rise in virtual digital assistants in homes all over, supporting voice commerce can increase revenue streams for your store. Today, we`re excited to announce our newest partner`s product Voicefront, which enables voice shopping on Magento. Click for details.','https://u.amasty.com/3pd',0,1,1,'2021-05-19 06:46:10','https://amasty.com/static/news/263.svg',0),(279,4,'2021-05-19 08:55:12','You`re just a sec away from soaring to the top of SERP','As you may know by now, Google has optimized its algorithm to favor speed. Fast websites improve user experience and can now bump your site to the top of the SERP. What steps can you take to improve site performance?','https://u.amasty.com/3sj',0,1,1,'2021-05-26 08:55:12','https://amasty.com/static/news/265.svg',0),(280,4,'2021-05-24 12:13:16','Managing website content with drag-n-drop and no coding? Easy!','Customers using page builders spend up to 80% less time on content management and thousands of dollars on development services. You should do that too with our new Page Builder!','https://u.amasty.com/3uc',0,1,1,'2021-05-31 12:13:17','https://amasty.com/static/news/267.svg',0),(281,4,'2021-05-27 08:12:29','Your May deals say bye-bye next Tuesday!','Check out plugins and bundles designed to deliver better business results with advanced instant messaging, seamless import/export, and 7 other top-notch solutions.','https://u.amasty.com/3v2',0,1,1,'2021-05-31 08:12:29','https://amasty.com/static/news/268.svg',0),(282,4,'2021-05-28 09:58:16','Don’t overpay for features you won’t need. Lite, Pro, or Premium','Why pay for extension features you don`t use? Our new approach to offering you extensions customized for your business divides our products into three categories. You can select the plan that works best for you with the option to choose between Lite, Pro, or Premium. ','https://u.amasty.com/3va',0,1,1,'2021-06-04 09:58:16','https://amasty.com/static/news/269.svg',0),(283,4,'2021-06-02 10:29:12','Endless discounts in special offers for June','Our monthly specials are here, and we`re excited to share with you the many ways you can save. Every store is unique, that`s why this time you can get exclusive deals suited to your specific needs.','https://u.amasty.com/3vz',0,1,1,'2021-06-09 10:29:12','https://amasty.com/static/news/271.svg',0),(284,4,'2021-06-08 12:48:01','More organic traffic for your Magento site? Easy →','Ranking higher in search results will bring more organic traffic to your site. With a properly optimized Magento website, you can maintain or increase your position on search engine results pages. Click to see how!','https://u.amasty.com/3wy',0,1,1,'2021-06-15 12:48:01','https://amasty.com/static/news/273.svg',0),(285,4,'2021-06-10 11:48:43','Revamp your website to stay relevant!','Staying on the outdated platform you won`t look professional. Worse still, you put vulnerable data at risk, lag behind top positions on SERP, complicate the entire shopping process, and will never earn a good reputation among users. Learn how to ensure a smooth experience for yourself and your customers','https://u.amasty.com/3xg',0,1,1,'2021-06-17 11:48:43','https://amasty.com/static/news/274.svg',0),(286,4,'2021-06-18 12:13:19','Fuel sales growth with data-driven decision making [NEW Custom Reports]','Analytics help you make informed decisions to better drive revenue and target your audiences. However, synchronizing your Magento data with third-party analytical tools can take up valuable time and resources. Find out more about this new Custom Reports Builder.','https://u.amasty.com/3yl',0,1,1,'2021-06-25 12:13:19','https://amasty.com/static/news/276.svg',0),(287,4,'2021-06-23 12:13:14','Connecting Magento to 3rd-party systems has never been easier','With new Import Customers, you can keep your target audience within reach through automatic data synchronization. Learn more.','https://u.amasty.com/3za',0,1,1,'2021-06-30 12:13:14','https://amasty.com/static/news/277.svg',0),(288,4,'2021-06-25 09:12:13','Extra 30% to your revenue with bundled products? Here`s how','If you`re looking to increase your revenue while improving your customer experience, offering an option to bundle products is a quick and easy solution. Click to see how it works.','https://u.amasty.com/3zk',0,1,1,'2021-07-02 09:12:13','https://amasty.com/static/news/278.svg',0),(289,4,'2021-06-30 08:56:55','June updates for your Amasty extensions!','Hello to June updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2021-07-07 08:56:55','https://amasty.com/static/news/279.svg',0),(290,4,'2021-07-08 12:22:14','Google update killed unprepared sites in June. Ready for the next one?','Beginning mid-June, Google will be using a visitor`s page experience as part of its ranking system. The update will be gradually rolled out through the end of August to allow site owners to adapt and prepare. Click to see how.','https://u.amasty.com/41g',0,1,1,'2021-07-15 12:22:14','https://amasty.com/static/news/281.svg',0),(291,4,'2021-07-14 08:33:10','Save 80% of DEV team capacity with New CMS Upgrade Scripts →','A new partner`s product — CMS Upgrade Scripts, reduces the workload on your admins, so they can focus on optimizing other parts of your business. See how!','https://u.amasty.com/429',0,1,1,'2021-07-21 08:33:11','https://amasty.com/static/news/282.svg',0),(292,4,'2021-07-16 10:18:22','95 out of 100 shoppers prefer multi-vendor marketplaces. Why not open yours?','A new partner`s product — CMS Upgrade Scripts, reduces the workload on your admins, so they can focus on optimizing other parts of your business. Click the link to learn more!','https://u.amasty.com/42j',0,1,1,'2021-07-23 10:18:22','https://amasty.com/static/news/283.svg',0),(293,4,'2021-07-23 08:52:39','Save on development costs with NEW Import Products','With a precise verification system and the ability to work with multiple formats and import sources, Import Products sets you up to synchronize your product catalog with third-party systems without a developer.','https://u.amasty.com/433',0,1,1,'2021-07-30 08:52:39','https://amasty.com/static/news/285.svg',0),(294,4,'2021-07-30 10:47:54','July updates for your Amasty extensions!','Hello to July updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2021-08-06 10:47:54','https://amasty.com/static/news/288.svg',0),(295,4,'2021-08-03 11:54:28','New sales and discounts every two weeks? Yes, please →','Whatever you`re working on — savvy, feature-rich tools will help you save tons of time and effort, allowing you to focus on running your business. Click to browse the new Promo Program and save on costs too!','https://u.amasty.com/44g',0,1,1,'2021-08-10 11:54:28','https://amasty.com/static/news/289.svg',0),(296,4,'2021-08-05 11:16:18','Is speed costing you sales? Find out a quick way to boost your conversion →','How many times have you clicked off from a site due to its loading speed... Could people be doing the same with your store? Click here to stop losing sales from slow website speed!','https://u.amasty.com/45a',0,1,1,'2021-08-12 11:16:19','https://amasty.com/static/news/290.svg',0),(297,4,'2021-08-12 09:35:49','Upgrade your Magento to v.2.4.3 to decrease maintenance costs!','An upgrade to the latest Magento 2.4.3 version can give you access to new features and a better security level, help you get rid of the little bugs that are slowing your website down. Learn how to get your Magento upgraded to the latest version.','https://u.amasty.com/46b',0,1,1,'2021-08-19 09:35:49','https://amasty.com/static/news/292.svg',0),(298,4,'2021-08-19 10:37:41','Don’t overpay for features you won’t need! Pick Lite, Pro, or Premium pack →','Why pay for extension features you don`t use? Our new approach to offering you solutions customized for your business divides our products into three categories: Lite, Pro, and Premium. Click to see what products already support the new tiered structure.','https://u.amasty.com/46w',0,1,1,'2021-08-26 10:37:41','https://amasty.com/static/news/294.svg',0),(299,4,'2021-08-24 12:18:13','Add buy now, pay later to your store to skyrocket revenue! Discover now →','Have you ever wanted a product but the price at the current time isn`t right? Let your customers enjoy your products now without having to pay the full sum at once with this new Partial Payments extension. Learn what benefits will you get → ','https://u.amasty.com/47o',0,1,1,'2021-08-31 12:18:13','https://amasty.com/static/news/295.svg',0),(300,4,'2021-08-26 09:00:14','Get worldwide payments with PayU Latam Gateway! Find out more →','Any good e-commerce business needs a solid gateway for processing your payments from your local customers to someone across half the world away. Click to learn how to collect payments from 250+ countries.','https://u.amasty.com/482',0,1,1,'2021-09-02 09:00:14','https://amasty.com/static/news/296.svg',0),(301,4,'2021-09-01 09:32:53','25% OFF all \"Navigation and Search\" mods. Save now! (till Sept. 13th only)','Optimize the process of viewing and purchasing products at your store with advanced tools for navigation and search at 25% OFF from our new Promo Program. Click to grab tools on sale!','https://u.amasty.com/48r',0,1,1,'2021-09-08 09:32:54','https://amasty.com/static/news/298.svg',0),(302,4,'2021-09-07 11:31:00','High sales even after the holiday spike? Yes, with a GOOD SITE!','Do you sell products offline? Doesn`t your current website meet all your business needs? Click here to make the most of the peak season with a new site!','https://u.amasty.com/4b9',0,1,1,'2021-09-14 11:31:00','https://amasty.com/news/300.svg',0),(303,4,'2021-09-09 10:56:00','Why let poor site maintenance cost you your business?','If you want your website to be at the top of its performance, you need regular maintenance checks to know that everything works as it should. Learn how to cut down on your maintenance costs.','https://u.amasty.com/4bt',0,1,1,'2021-09-16 10:56:00','https://amasty.com/news/301.svg',0),(304,4,'2021-09-14 10:40:00','25% OFF all \"User Experience\" mods. Save now! (till Sept. 27th only)','88% of users won’t return to your website after a bad UX. Improve your website user experience with new tools and save 25% of their pricing. Learn more →','https://u.amasty.com/4d1',0,1,1,'2021-09-21 10:40:00','https://amasty.com/news/302.svg',0),(305,4,'2021-09-23 06:56:00','NEW Auto Invoice & Shipment will save your time on orders processing!','As your business grows, manual order processing will inevitably lead to TIME losses. Click here to start saving your time with effortless invoicing!','https://u.amasty.com/4j0',0,1,1,'2021-09-30 06:56:00','https://amasty.com/news/305.svg',0),(306,4,'2021-10-01 11:46:00','25% OFF all “Checkout” mods. Get all initiated orders complete! Limited-time offer →','18% of users don`t submit the order due to a long, complicated process. Click to stop losing customers before they pay.','https://u.amasty.com/4mf',0,1,1,'2021-10-08 11:46:00','https://amasty.com/news/307.svg',0),(307,4,'2021-09-30 12:29:00','September updates for your Amasty extensions!','Hello to September updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2021-10-07 12:29:00','https://amasty.com/news/306.svg',0),(308,4,'2021-10-07 11:57:00','It’s upgrade time - and we’ve got you back!','Performing timely Magento upgrades is key to ensure your software is running smoothly and that you`re up to date with the latest features and fixes. Click to learn how to keep your store compatible with other updated technologies without any frustration.','https://u.amasty.com/4r8',0,1,1,'2021-10-14 11:57:00','https://amasty.com/news/309.svg',0),(309,4,'2021-10-05 13:22:00','Import & Export just got a major update! Take a look →','We`re excited to announce Import and Export version 1.4.0. It has more functionality than ever before to ensure it helps you accomplish any import/export tasks in less time. Click to learn what`s new','https://u.amasty.com/4n3',0,1,1,'2021-10-12 13:22:00','https://amasty.com/news/308.svg',0),(310,4,'2021-10-12 11:51:00','Act fast — your 25% discount on all \"Catalog Management\" mods is on!','A well-organized catalog brings more conversions. Save 25% on any of our extensions in the category of &quot;Catalog Management&quot; within our new fortnight sales. Click here for more details.','https://u.amasty.com/4vx',0,1,1,'2021-10-19 11:51:00','https://amasty.com/news/310.svg',0),(311,4,'2021-10-21 09:22:00','Start small — stop overpaying for features you don`t use!','Every once in a while, it`s important to assess your business costs and determine which tools are getting you the results you want.  Learn about our newest solutions available in three packages and save money on features you don`t need.','https://u.amasty.com/52h',0,1,1,'2021-10-28 09:22:00','https://amasty.com/news/312.svg',0),(312,4,'2021-10-19 07:15:00','You have a NEW SMS alert — check out our fresh extension!','Did you know that over 58% of consumers agree that SMS notifications are effective for updates on delivery, order confirmations, and meeting reminders? Click and learn how to keep your customers in the know while they’re on-the-go.','https://u.amasty.com/509',0,1,1,'2021-10-26 07:15:00','https://amasty.com/news/311.svg',0),(313,4,'2021-10-28 08:44:00','Halloween Sale is on! Grab your 25% OFF while you can →','Starting today, October 28 through to November 2, buy any extensions and get 15% off automatically! Not enough? Click to learn how you can increase your discount.','https://u.amasty.com/575',0,1,1,'2021-11-02 08:44:00','https://amasty.com/news/313.svg',0),(314,4,'2021-11-02 08:26:00','Last day, LAST CHANCE to claim your Halloween discounts!','Our Halloween Sale ends today! Time’s almost up!  Grab your 25% OFF while you can →','https://u.amasty.com/58u',0,1,1,'2021-11-03 05:26:00','https://amasty.com/news/315.svg',0),(315,4,'2021-11-04 10:51:00','15% OFF all services until Nov. 31st. Get your store renovated for less!','The holidays are the busiest time for e-commerce. Lucky for you, until November 31st, you can save up to 15% on a suite of services designed to help your online business thrive. Check out the services eligible for this sale →','https://u.amasty.com/5cr',0,1,1,'2021-11-11 10:51:00','https://amasty.com/news/316.svg',0),(316,4,'2021-11-11 11:34:00','NEW Maintenance Page will save you nerves and money!','Every minute of unplanned website downtime is costing a company at least $2. And if your store averages $5.000 in sales per hour, it can cost you over $80 a minute. Learn how to don`t let downtime get your business down in sales → ','https://u.amasty.com/5fz',0,1,1,'2021-11-16 11:34:00','https://amasty.com/news/319.svg',0),(317,4,'2021-11-16 11:03:00','Sync your offline stores with online ones effortlessly. New POS is here!','Though e-commerce surged high during the pandemic, in-person shopping has resumed — especially in time for the holidays. Connect your physical stores to your online ones and grow sales with our new Point of Sale (POS) System. Check out how you can benefit from this extension →','https://u.amasty.com/5hh',0,1,1,'2021-11-22 11:03:00','https://amasty.com/news/320.svg',0),(318,4,'2021-11-22 09:36:00','TRIPLE the savings — up to 45% OFF! Get in now!','Today we`re launching our Triple Sale occurring from November 22nd to November 30th where you can save as much as 45% off! Check out these insane deals and add them to your cart now!','https://u.amasty.com/5l0',0,1,1,'2021-11-30 09:36:00','https://amasty.com/news/322.svg',0),(319,4,'2021-12-01 06:37:00','November updates for your Amasty extensions!','Hello to November updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2021-12-08 06:37:00','https://amasty.com/news/324.svg',0),(320,4,'2021-12-08 10:43:00','End of Year Sale is on! Up to 25% OFF','Don`t miss out on great savings on new extensions for your store! Click to learn what`s in our end-of-year specials','https://u.amasty.com/5sn',0,1,1,'2021-12-15 10:43:00','https://amasty.com/news/326.svg',0),(321,4,'2021-12-09 11:15:00','New year — new website on Magento 2. Let’s give your store an upgrade!','The new year is just around the corner. Take advantage of the holiday break and get your Magento 1 store migrated to Magento 2 to ensure a smoother future. Learn what you get out of the upgrade','https://u.amasty.com/5tg',0,1,1,'2021-12-16 11:15:00','https://amasty.com/news/327.svg',0),(322,4,'2021-12-16 13:44:00','Alleviate product management tasks with this new toolkit →','Imagine if there was a way to keep your product information routinely updated, alleviate manual tasks and answer customers` inquiries all at once? Great news, the solution is here! Click to learn more.','https://u.amasty.com/5vp',0,1,1,'2021-12-23 13:44:00','https://amasty.com/news/329.svg',0),(323,4,'2021-12-24 12:31:00','December updates for your Amasty extensions!','Hello to December updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2021-12-31 12:31:00','https://amasty.com/news/330.svg',0),(324,4,'2022-01-12 13:53:00','If your site doesn`t load that fast, you`ll drop in search results!','In 2022, your website should load in 1-2 seconds. A 2-second delay in load time results in abandonment rates of up to 87%. And Google aims for under 0.5 second load time while complicating its algorithms with each new update. Learn how to bump your site to the top of Google search results.','https://u.amasty.com/5zq',0,1,1,'2022-01-19 13:53:00','https://amasty.com/news/331.svg',0),(325,4,'2022-01-13 13:59:00','Timely Magento updates can cut vulnerability fixing costs in half→','As online commerce grows, so does the number of cyber attacks. It`s critical to maintain your store in operation while remaining up-to-date with the latest security patches from Magento. Click to keep your store secure with the latest Magento version installed','https://u.amasty.com/60f',0,1,1,'2022-01-20 13:59:00','https://amasty.com/news/332.svg',0),(326,4,'2022-01-18 10:06:00','Up to 25% off bestsellers, FREE mods, and more. Find your ideal deal here →','Whatever you`re working on — feature-rich tools will help you optimize your Magento website and bring additional value to your users and team. Unlock new tools at a great price. Click to see our special offers for January','https://u.amasty.com/61j',0,1,1,'2022-01-25 10:06:00','https://amasty.com/news/333.svg',0),(327,4,'2022-01-27 12:20:00','How to go mobile with a PWA and convert more shopping traffic?','More than 50% of all your customers shop online from mobile devices. But — going mobile and re-engaging users with a new mobile app is both challenging and costly. Learn more about the advantages of PWA and how to launch and improve your PWA online store','https://u.amasty.com/64n',0,1,1,'2022-02-03 12:20:00','https://amasty.com/news/334.svg',0),(328,4,'2022-01-31 16:15:00','January updates for your Amasty extensions!','Hello to January updates! Follow the link to see what we’ve done to make your Magento extensions better: https://amasty.com/blog/magento-extensions-updates/','https://amasty.com/blog/magento-extensions-updates/?utm_source=backend&utm_medium=text&utm_campaign=updates',0,1,1,'2022-02-07 16:15:00','https://amasty.com/news/335.svg',0),(329,4,'2022-02-03 13:36:00','Up to 20% OFF Speed, Navigation, Checkout solutions — get more for less!','Don`t miss out on great savings on must-have solutions for your store. For this month only, save up to 20% on purchasing the best solutions for speed, navigation, and checkout. Click to browse our fresh special offers!','https://u.amasty.com/65w',0,1,1,'2022-02-10 13:36:00','https://amasty.com/news/336.svg',0),(330,4,'2022-02-10 12:48:00','Magento 2.4.4 is coming. It’s upgrade time — and we’ve got your back!','Releasing in March, Magento 2.4.4 is expected to bring a bunch of new features. Upgrading your version timely is key to ensuring you are up to date with the latest features and fixes. Treat your customers and yourself to an optimal Magento experience with the latest versions!','https://u.amasty.com/66o',0,1,1,'2022-02-17 12:48:00','https://amasty.com/news/338.svg',0),(331,4,'2022-02-17 12:18:00','Your customers will love this Social Login update →','Did you know that 66% of consumers will leave a website if the registration process is too complex? Click to learn how to get more registrations today','https://u.amasty.com/67p',0,1,1,'2022-02-24 12:18:00','https://amasty.com/news/340.svg',0),(332,4,'2022-02-22 08:11:00','Use case: One Step Checkout for Magento 2','Did you know that it is possible to reduce the cart abandonment rate by 40% using the One Step Checkout extension? Check out this use case to learn how to achieve the results you want','https://u.amasty.com/67w',0,1,1,'2022-02-28 08:11:00','https://amasty.com/news/341.svg',0),(333,4,'2022-02-24 13:17:00','Google is banning third-party cookies. Be proactive →','Most users consider third-party cookies highly personal and advertising based on them — invading their privacy. Following this trend, Google is going to ban third-party cookies and start preparations this March. Learn how to improve the level and the quality of information you’re getting from users!','https://u.amasty.com/68j',0,1,1,'2022-03-03 13:17:00','https://amasty.com/news/342.svg',0),(334,4,'2022-04-13 11:54:00','Get your Magento upgraded to v.2.4.4 and covered with warranty','An upgrade to the latest Magento 2.4.4 version can give you access to new features and a better security level, help you get rid of the little bugs that are slowing your website down. Click to get the latest version installed for you today!','https://u.amasty.com/6df',0,1,1,'2022-04-20 11:54:00','https://amasty.com/news/343.svg',0),(335,4,'2022-04-15 06:31:00','Score a perfect 90+ on Google PageSpeed Insight ????','Have you checked your site speeds lately? There`s a possibility that your site could use some tweaking to get into the green zone of the PageSpeed Insights. Learn how to make your website faster!','https://u.amasty.com/6ds',0,1,1,'2022-04-21 06:31:00','https://amasty.com/news/344.svg',0),(336,4,'2022-04-21 12:31:00','NEW Full-Cycle Checkout — get more customers through your checkout!','If optimizing your checkout page, you can return thousands in lost spending. Most of the ready-made checkout optimizers only eliminate distractions so buyers can focus on finding and purchasing the item of interest. Click to learn about a new Full-Cycle Checkout solution.','https://u.amasty.com/6ei',0,1,1,'2022-04-28 12:31:00','https://amasty.com/news/346.svg',0),(337,4,'2022-11-21 19:11:00','Website SEO Health Checker is live! Try it for free.','https://u.amasty.com/6zg','https://u.amasty.com/6zg',0,1,1,'2022-11-28 19:11:00','https://feed.amasty.net/news/348.svg',0),(338,4,'2019-06-24 00:00:00','Thank you for installing OpenMage M1 LTS!','','https://openmage.github.io/Web_Notifications//2019/06/24/OpenMage.html',0,0,0,NULL,NULL,0),(339,4,'2022-08-02 00:00:00','Stop russian war. Free Ukraine!','','https://openmage.github.io/Web_Notifications//2022/08/02/Ukraine.html',0,0,0,NULL,NULL,0),(340,9,'2024-03-14 00:00:00','UPS APIs will stop working on 3rd June 2024','','https://openmage.github.io/Web_Notifications//2024/03/14/Ups.html',0,0,0,NULL,NULL,0),(341,1,'2024-03-17 00:00:00','UPS APIs will stop working on 3rd June 2024','','https://openmage.github.io/Web_Notifications//2024/03/17/Ups.html',1,0,0,NULL,NULL,0),(342,4,'2024-11-15 20:09:04','Affirm Extension Version 4.0.5 is now available','Affirm Extension Version 4.0.5 for Magento is now available for download and upgrade. To see a full list of updates please check the release notes page.','https://github.com/Affirm/Magento2_Affirm/releases',0,0,0,NULL,NULL,0),(343,4,'2025-02-07 17:03:11','Affirm Extension Version 4.0.6 is now available','Affirm Extension Version 4.0.6 for Magento is now available for download and upgrade. To see a full list of updates please check the release notes page.','https://github.com/Affirm/Magento2_Affirm/releases',0,0,0,NULL,NULL,0),(344,2,'2025-03-04 18:52:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(345,2,'2025-03-21 14:39:09','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(346,2,'2025-03-31 16:41:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(347,2,'2025-04-17 14:54:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(348,2,'2025-04-17 14:54:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(349,2,'2025-05-05 18:46:08','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(350,2,'2025-05-08 17:24:09','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(351,2,'2025-05-08 17:32:34','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(352,2,'2025-05-08 17:50:07','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(353,2,'2025-06-23 21:33:09','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(354,2,'2025-06-23 21:34:30','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(355,2,'2025-06-23 21:53:08','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(356,2,'2025-06-23 22:03:24','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(357,1,'2025-07-14 09:50:11','Thank you for installing No Password Login. Now we recommend that you configure your\n                 transactional emails. You can find information about how to do that here.','','https://www.aitoc.com/docs/no-password-login/',1,0,0,NULL,NULL,0),(358,2,'2025-07-16 20:42:11','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(359,2,'2025-07-17 14:23:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(360,2,'2025-08-04 15:20:09','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(361,4,'2025-08-06 16:42:00','Critical Action Required!','https://amasty.com/blog/important-changes-to-amasty-composer-access-keys/','https://amasty.com/blog/important-changes-to-amasty-composer-access-keys/',0,0,1,'2026-01-01 16:42:00','https://feed.amasty.netnews/349.svg',0),(362,4,'2025-08-14 16:53:01','Affirm Extension Version 4.0.7 is now available','Affirm Extension Version 4.0.7 for Magento is now available for download and upgrade. To see a full list of updates please check the release notes page.','https://github.com/Affirm/Magento2_Affirm/releases',0,0,0,NULL,NULL,0),(363,2,'2025-09-18 16:50:11','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(364,2,'2025-10-09 19:21:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0),(365,2,'2025-11-24 20:54:10','Your coupons are ready','You can check your coupons at sales rule page','',0,0,0,NULL,NULL,0);

--
-- Dumping data for table `adobe_stock_asset`
--


--
-- Dumping data for table `adobe_stock_category`
--


--
-- Dumping data for table `adobe_stock_creator`
--


--
-- Dumping data for table `adobe_user_profile`
--


--
-- Dumping data for table `amasty_acart_attribute`
--


--
-- Dumping data for table `amasty_acart_blacklist`
--

INSERT INTO `amasty_acart_blacklist` VALUES (274,'003bb14273fc7138c2fb34b439a85906@st.budsies.com'),(438,'004ffd31c0c7daf976777e2856e83d34@st.budsies.com'),(299,'00b0eaa123c75555cebf56dcd75a2b85@st.budsies.com'),(449,'0154977ee4b9336141826a4960c9845c@st.budsies.com'),(106,'01fa66b7fbc5e60db04b6d744071f613@st.budsies.com'),(245,'0284072d1208641096cd25aa5f95a469@st.budsies.com'),(204,'02b23c0198f60a7d3083e5ef575be49b@st.budsies.com'),(279,'03399c188ea3251e64bce2a5ec9853c3@st.budsies.com'),(264,'0392d66f2011b87e55c73489da7c521f@st.budsies.com'),(96,'03cc4008f7e19b31483043f40de7536f@st.budsies.com'),(442,'0439b2008aa6d7e48585f20ee174fba1@st.budsies.com'),(36,'0534cab1fc5aae5a4643e4db9217ca38@st.budsies.com'),(195,'057daf83b97547e3d86e90e532d3ecce@st.budsies.com'),(315,'06606c4abca8d6b839fbe16a268ebdfe@st.budsies.com'),(368,'071e1ff7a745f1c6844e78d2f338f98f@st.budsies.com'),(395,'073d879b7d14a7dbe73400e258451fcc@st.budsies.com'),(277,'07716e8414a31df0f57fee9ab69facb1@st.budsies.com'),(283,'07943954b51a2dabd101eb8e49198764@st.budsies.com'),(479,'07a5dbdda2aac50fbe9a528a95d1037d@st.budsies.com'),(295,'07c941bc92ce0eea80ff4049ce866eb9@st.budsies.com'),(218,'07ec00acb125a05ec31a144528929ce1@st.budsies.com'),(191,'083a74c4df43dd5bd47daa0504a99960@st.budsies.com'),(291,'08e3e4b395c2326354d5da4e6b07dffc@st.budsies.com'),(393,'09e4254ce056c54cdba7c356a28a1523@st.budsies.com'),(347,'0a15b086c0d5076d582bc40aeed52f29@st.budsies.com'),(52,'0a2d058709cb6ff38f8f358b11b7b971@st.budsies.com'),(492,'0a4203f26b72070f844a4581d60a229d@st.budsies.com'),(493,'0b0c7e7eae125c99c3e3845fca6879c3@st.budsies.com'),(446,'0c95df813941d76cf631e0506a293971@st.budsies.com'),(419,'0d2f6dfd9d0ed3d2cd9ca3833d6cba54@st.budsies.com'),(69,'0dfae948ca2818ff28df70d5e6bf740f@st.budsies.com'),(324,'0e0242ba8e75242264027979914631a2@st.budsies.com'),(37,'0e64610a37e4cb67f1dd30f27c0ce6af@st.budsies.com'),(65,'0ea8922e4009ed0131a1ab0936c124bf@st.budsies.com'),(143,'0f40a0b28551693b58ed51fcbe411976@st.budsies.com'),(275,'0fcb3ee757bcee489baf20dbb00d0872@st.budsies.com'),(303,'0fee35cb07f485c7f250eabc5ec0b44b@st.budsies.com'),(430,'104884388a7416357334523b7ffe42db@st.budsies.com'),(34,'105d0312fc4bac840b6c72b4028eb818@st.budsies.com'),(346,'10b3fdfbdcd61d4650f5cb0e681fed58@st.budsies.com'),(265,'1136094c4effdcfdfc9064f135182495@st.budsies.com'),(389,'12c613775a3ff779c94f623ae107fef8@st.budsies.com'),(331,'1301c7d037d08b5f8522cbb2b12d39fc@st.budsies.com'),(405,'131d4519f8b3f2848ba0703360e39b24@st.budsies.com'),(460,'14539f6b30ba1393cb3a6f8c6f74d115@st.budsies.com'),(219,'156f278f74073059f9f68602d210b6be@st.budsies.com'),(455,'158dbd997f2a77793a02fb5d4e0aa414@st.budsies.com'),(222,'15a32eaf2ab34c7d7f286822a3c3815d@st.budsies.com'),(310,'15f80673ba3a5ed4d0be623ea4bad36e@st.budsies.com'),(20,'16ffabd163015b0e3732bc0c7b4308ec@st.budsies.com'),(202,'178c16cd6d9ad4d3ae2e3d769741c804@st.budsies.com'),(424,'18ad0db14d478c416229cf57801c0fca@st.budsies.com'),(114,'1a593a4f09b1d23e05fc975763cb46bc@st.budsies.com'),(383,'1b68f37d9433348394659d1e10cae633@st.budsies.com'),(496,'1b925ce3c5cc19f6082a938cbc628169@st.budsies.com'),(26,'1b98d84ca5e98f6db77aece1c66ba8c6@st.budsies.com'),(487,'1bbe2e5a90f03008d994e7e178de2b3c@st.budsies.com'),(365,'1c443a1e575ef69ad440a2b2b5d69883@st.budsies.com'),(498,'1c7cbfa4ac668c2fde91834aca799421@st.budsies.com'),(142,'1ca16e00a1005891655cf713694ffcc6@st.budsies.com'),(138,'1db412dc21429c4a0dda45f971a486c2@st.budsies.com'),(439,'1e42f21359006dd3c416fecce4b89828@st.budsies.com'),(473,'1e6fb6a4b5dab37e4511b77b80e38601@st.budsies.com'),(381,'1eb10794508b2da6897975a8e6388e7b@st.budsies.com'),(91,'1ee130448c39a7a934e7377781c67ab9@st.budsies.com'),(126,'1f1ddc4619136a7602d49a9400cfbb68@st.budsies.com'),(401,'203a17385ab1964965daaeb0fb372f43@st.budsies.com'),(396,'205f9ea6569c3528ff2b04fd0aa30879@st.budsies.com'),(444,'2083f7c7cb9aff28c6f44a01afab5c22@st.budsies.com'),(384,'210573daaba7c4864d93758ca16f39c0@st.budsies.com'),(83,'211fd0fc4cb36c38efaa2012c2747cf7@st.budsies.com'),(308,'2187e9dd1b187085982f96e7e57bab78@st.budsies.com'),(345,'21c702f7abd0b7a64667179018f974db@st.budsies.com'),(156,'22306fe4b1e61037fc6b1cdda9816596@st.budsies.com'),(301,'227aeffa82cc7f7a5c56c7ad0a5f1b3b@st.budsies.com'),(358,'229f296bae2123de693bb0351040c4e2@st.budsies.com'),(166,'230f37e04c6d42a9dbc446691175ff56@st.budsies.com'),(144,'238b58da81261d0dfc46e7727047c3aa@st.budsies.com'),(6,'24108dcef2376fa06afbb6ec56c294f5@st.budsies.com'),(378,'2469caf43f2c9e6318058680c9d7c5cd@st.budsies.com'),(8,'24ab394273f83311c9dca6f7751c24ca@st.budsies.com'),(49,'259999092dd3fefe339a091470e85d8f@st.budsies.com'),(129,'25ae4caf4bd7b455a80d05f694ca469c@st.budsies.com'),(168,'262f6c53c27b30c03d846fc5eff070c4@st.budsies.com'),(17,'269b6cdd56361db55a47eaa6163dfdc5@st.budsies.com'),(334,'26c6004580241eb7bac84e3adfae024e@st.budsies.com'),(490,'27098db38de1ab81f6fa533cd94bb28c@st.budsies.com'),(364,'2759c88f53cd2a56a606c54087a94e1f@st.budsies.com'),(317,'28b4f5e15195f939fd6b43a48a1b09e1@st.budsies.com'),(45,'293769ef97ebd338085ea17fc384007d@st.budsies.com'),(255,'2a975c31b4146259802fbabf56b38153@st.budsies.com'),(199,'2ab5f286b0b46008619b5d707b624f03@st.budsies.com'),(456,'2c0f3e58a3b25f5a7933e5f035a18111@st.budsies.com'),(151,'2c216d084c5d5d6249616946794b922b@st.budsies.com'),(161,'2c32e0df53efa3acd2251d69b709139c@st.budsies.com'),(468,'2c386e9cd1d69fc4585c2ab8ebb8b6f8@st.budsies.com'),(239,'2c643be1beaa399e4b4afaa4db1a6a82@st.budsies.com'),(135,'2c6fb1082a3384c0272f404647633443@st.budsies.com'),(42,'2ca518460935d9ec970c1f5d81d9f0df@st.budsies.com'),(461,'2cb9d5e21e130e277c52d92d5986e5dc@st.budsies.com'),(13,'2ea6b6b00bf38351cda269885b8f7a9e@st.budsies.com'),(229,'2ec8ef01fb928dbcb0bbf160ec8836f0@st.budsies.com'),(206,'305e245ed7725ed28800f1d1dadebfc2@st.budsies.com'),(411,'320021b4ef802b367a37fa636849b5bb@st.budsies.com'),(184,'3250f83ff37053781f1e6d967811e5cc@st.budsies.com'),(252,'32cded784369029ab0a7536f5a480d73@st.budsies.com'),(25,'32d5482cd6ea9fe20b0247b2af41c61b@st.budsies.com'),(15,'3462518d7832bb3958ccbc4a4bc7d8a2@st.budsies.com'),(209,'348d681aca35472c18297e2142820da7@st.budsies.com'),(273,'355170d0b89b3516b8ff016c5dffc8a9@st.budsies.com'),(453,'3588b470044cbebebea0cc7ca9f1effc@st.budsies.com'),(154,'358b14b9ef862172aff2a2b1589642fa@st.budsies.com'),(225,'36385fd0d42e4a608aef07cf073b2fde@st.budsies.com'),(313,'36b855d0924f12d7bed1f892ac782245@st.budsies.com'),(382,'36cc50b3c92c6b070ab415aefbb90936@st.budsies.com'),(160,'3747cd1d952f6263a3921a4e95b93d48@st.budsies.com'),(29,'37655b3bfa682cd32d1d6a6f7bb750bb@st.budsies.com'),(478,'3779f67ac2d8507d297608eebe6e71b4@st.budsies.com'),(499,'37c2f90c8b223e2470d9ffe1976e5f6e@st.budsies.com'),(177,'3843a104e58bddaba46f8396417c6d7e@st.budsies.com'),(422,'3887ed842ee8018281e12845a52a012a@st.budsies.com'),(287,'38e36cceda8d6e7aee8571356e4af0f2@st.budsies.com'),(306,'38e3b51b0b530f588095e37a18aeb4ec@st.budsies.com'),(494,'393cec20f18fc870114cc6b41e3a2386@st.budsies.com'),(436,'3b7eb9b0547f607cf45dde18659d2813@st.budsies.com'),(150,'3d1756853b1de9ad998ef922dff20c82@st.budsies.com'),(314,'3d8e711aefece9f9b90b8cc6ec7f23e4@st.budsies.com'),(182,'3e17378fdd06b64d43bd6efbc09fca16@st.budsies.com'),(215,'3e78c7d0874362fda36f3274b1ef65a4@st.budsies.com'),(172,'3f090ea882f9fa7632f5a800642f18b9@st.budsies.com'),(466,'4112044349d0e8c898ed54032cfe501d@st.budsies.com'),(234,'41dbcc29e03f7b06553e58a144df9f5e@st.budsies.com'),(5,'4241428e424097e94f04dce02bb1f8a9@st.budsies.com'),(231,'42701e15e522db20dd148ea494de1273@st.budsies.com'),(193,'427afc416863e7d77f6b84272b7cb5eb@st.budsies.com'),(180,'42b5d11ce69c2767a2ccb67ab49741da@st.budsies.com'),(373,'42ef07522e756d643705fee8d99aa7d8@st.budsies.com'),(322,'438287015414b6009a07769c92bf5c6e@st.budsies.com'),(176,'4470a5b1e37812a13e16a2a2e2e05e36@st.budsies.com'),(74,'45510e423e47e6b0380f5300c85bc061@st.budsies.com'),(95,'458c235aa82eba32fa2755feda159c46@st.budsies.com'),(294,'45f863bb2c5243496aa39c4c8857e797@st.budsies.com'),(192,'46630de0a538b8a9e2510f3fe9194124@st.budsies.com'),(28,'470a93ce62eaad415369da798bad6c00@st.budsies.com'),(58,'47206b6e92c96853afa832d168cee4f5@st.budsies.com'),(458,'47a34de03d83b771ef56a39502460fac@st.budsies.com'),(12,'48313693e2062e0663dfa5eae3d609fc@st.budsies.com'),(278,'487fad09416f4541ecd04322956b79c8@st.budsies.com'),(54,'48b71d7a2c9d348703a4a8282f220607@st.budsies.com'),(32,'4a60a494f980d5035b4284fddad1d064@st.budsies.com'),(197,'4ab002fed4b880b6988e9573b2a02f04@st.budsies.com'),(244,'4ac18f7b58059e77a41fbf8bdbb75f38@st.budsies.com'),(84,'4ba789d949b5d368d3daaa45efe362dc@st.budsies.com'),(409,'4bb07cb4cc2de82d7ee8eeb580f915fc@st.budsies.com'),(203,'4c504a11e286f7c313cce83c4ab5b42c@st.budsies.com'),(427,'4d0656a95c51adf21070c23cc067c4f6@st.budsies.com'),(198,'4e377a80d6e3bec5e5cdc1fd7c24c4e6@st.budsies.com'),(119,'4e3d9c9a59f93db8ddade0c9c5b6f123@st.budsies.com'),(426,'4e436bfb665326a4b9dded77a0298518@st.budsies.com'),(375,'4e6f3884df55deb5e9903f6a3ea46669@st.budsies.com'),(327,'4ef9894d5344c6ff1380aea25eaa63f4@st.budsies.com'),(377,'4fda131b8c82aca5c9d1fa8b910f3d72@st.budsies.com'),(46,'5073f4207ec177537e41ea7166590eff@st.budsies.com'),(332,'51bd0d9c7e68de751b412d894bcb62f1@st.budsies.com'),(471,'5219c452d8dd49b99622c76c6181cada@st.budsies.com'),(312,'52fa5b48820ca324ec7d455d6674ab4f@st.budsies.com'),(350,'53d0da66c8238343b5552658520704a6@st.budsies.com'),(387,'540f16904a971a59a2f068e3f019225d@st.budsies.com'),(304,'5475b7d5ef2b9fd46171c6e9413792c4@st.budsies.com'),(429,'547984930f2dbabc6ec3ae8ea5dfc29e@st.budsies.com'),(412,'54ebf4a985ad9816551877710420e2a4@st.budsies.com'),(501,'55011b13e95af3a75840c1357e804815@st.budsies.com'),(61,'5558d0fb914066bd78628b50550dc571@st.budsies.com'),(169,'55af513fc699fb7a451a0e7653509eec@st.budsies.com'),(485,'567451c06add021b753af0fe8021a242@st.budsies.com'),(302,'56d148d61e453c2910eca9a2eefd9154@st.budsies.com'),(132,'56de6d6eab58e6895b69f773ec0dce1d@st.budsies.com'),(431,'57c82a918d2bff1f23efb02078dbe197@st.budsies.com'),(329,'5866ca3df21b1f4abdb237741ae60b6b@st.budsies.com'),(367,'58d965d9f942a643a974dd2986e5343b@st.budsies.com'),(99,'59a9c50347457000b53a6ec9668cdc0e@st.budsies.com'),(213,'59e4f57f7fec71f493b1317fb9b5a96f@st.budsies.com'),(316,'5a13265ef688553b3b7eb4e9ee169069@st.budsies.com'),(60,'5ae08d6388280fc05265cdeb0ac0e8ec@st.budsies.com'),(417,'5b318db3c74e7ebd42a56e9920b0b055@st.budsies.com'),(414,'5b7248aa98dc492e6fda09ea23840a12@st.budsies.com'),(141,'5baa8d94fcb47ac1530ecc7e013ad760@st.budsies.com'),(477,'5bb6569dbec67fda431049e1c327ba32@st.budsies.com'),(232,'5c2e74ed827786852f549b69a5c7b3a5@st.budsies.com'),(57,'5c50f972ad2ba2d576d9b82a16f68b09@st.budsies.com'),(97,'5d2ab19ebe9465913e4676ef61763bd4@st.budsies.com'),(406,'5dbcd3b0106d4b3a7cbfc2835e0f3746@st.budsies.com'),(40,'5e2d7fcb4da7dfa8b551e73598f4ad5d@st.budsies.com'),(484,'5e816c02e94102bddc999a5c998e33c2@st.budsies.com'),(251,'5e9fa2f249fd94b03e56af6dd7adb883@st.budsies.com'),(122,'5ee57d347c1d71cac6962dbfbd957bae@st.budsies.com'),(325,'5f6543991bcfb47b7b5fcecc3c9bd988@st.budsies.com'),(261,'5f68854835ace472096ee60b434f5257@st.budsies.com'),(269,'6015b300104a95730e20b31cdefc3aa3@st.budsies.com'),(263,'6042eceb43f14dc5b08173809c01313e@st.budsies.com'),(328,'6164a46670b06e796e6151857a5707b3@st.budsies.com'),(196,'6190f60bdacea5f142f335ec76cd309a@st.budsies.com'),(288,'61ff66ad1800df705727c8821445af94@st.budsies.com'),(289,'6355d3ddc6ec4dc60d3144438a0c2ba7@st.budsies.com'),(205,'637d59c987102dd3590cbf3414927d4d@st.budsies.com'),(356,'639fad872cce6041da656ff77e84f36a@st.budsies.com'),(109,'644765605b0a9fe9645ed54a0c79d438@st.budsies.com'),(53,'65425b5369d02dba9b89de49343841ee@st.budsies.com'),(92,'659b8620971fc4eb38c988b499bef3ee@st.budsies.com'),(165,'660356e3e05b6a09ec39f37763c55e38@st.budsies.com'),(481,'6625043bfd01f4f536f47459f454c4fc@st.budsies.com'),(121,'662664a6da71a59ee1c854c83e9cd7d1@st.budsies.com'),(256,'67c20b29501ccd79d9c98a1eafd9c392@st.budsies.com'),(259,'682f20141bfb8c0101f24e861ac6f11b@st.budsies.com'),(185,'68a32a502bce49bad4308dc67bdb0b6d@st.budsies.com'),(410,'68d44de9b27cc563dd35bb663d5ef229@st.budsies.com'),(281,'691c42bc52ab774d909d56eee486fd01@st.budsies.com'),(392,'6ace93d6b154e8cd7dc4fe73ac7e65f5@st.budsies.com'),(270,'6b84043aba69ab22c50a276d3c338c53@st.budsies.com'),(475,'6ccf7f53c51f11a5485450c817913119@st.budsies.com'),(290,'6cf3bed62f15e45836a023dd994c1d40@st.budsies.com'),(305,'6ddb6339c1960eb7756993717d3dd83e@st.budsies.com'),(467,'6e7742c0fc302e258ccb9d8ae8a2843a@st.budsies.com'),(311,'6e806e18b5653aad7aad373e4eff9a38@st.budsies.com'),(216,'6ecaa88f1b4dd51e119b7d5ed941874d@st.budsies.com'),(257,'6f95532d4da434fbb1876267a0ec3904@st.budsies.com'),(399,'6fbe9cf6a0aba9c6c2a2bbf8c93603a3@st.budsies.com'),(372,'7037859e874c50574e2006e884eccb01@st.budsies.com'),(125,'703ec02e35d9a1ca5df32a313a48cd33@st.budsies.com'),(343,'713f77d527e971d899e9a1660e6ce5e6@st.budsies.com'),(186,'715f3c232a0f173bb0aa8e3b39093edb@st.budsies.com'),(167,'7203ddf24565899fd597c48f76956710@st.budsies.com'),(285,'732d8be8e1437529aa57b62594d52591@st.budsies.com'),(472,'73b07ae95cd790f68c1f04fb8e818b38@st.budsies.com'),(237,'74263fb3be6cdf258fd7b142bfb5f4fc@st.budsies.com'),(56,'75180a5bd5d23201c633dd4862a64211@st.budsies.com'),(110,'75949d7274ce5f4b3877848de1709458@st.budsies.com'),(24,'77447c6e29fc50549f8750d28be04124@st.budsies.com'),(335,'77be4b99d51d4968b1f8820948188473@st.budsies.com'),(363,'781918319c8fc3f2848ac238553ad67c@st.budsies.com'),(134,'7836cfcb2a2faca740399d6d5f957cd7@st.budsies.com'),(413,'784b9622f1e97cfb338aaff7c389f705@st.budsies.com'),(452,'7875eb77d9c200d7b2aba6703ac47f6e@st.budsies.com'),(88,'7b77186a0024d20283ad6083ecb9d023@st.budsies.com'),(243,'7ca82e401cac67bb1e8c56a470d29315@st.budsies.com'),(212,'7dabcf7332c10455a24e23349c01636d@st.budsies.com'),(357,'7ded658689473fab6f12bc1af812fe0a@st.budsies.com'),(214,'7f2ca2323bc46e6652e4c548ab21e72c@st.budsies.com'),(175,'7f945c261e1b04cb3367bd3079154870@st.budsies.com'),(338,'80f5e850cf915ce8b41f2ec22c3615e6@st.budsies.com'),(286,'811b55b66285f2c6973653dea5140fb4@st.budsies.com'),(127,'824ae785b8c9752d8d74c85443d86d46@st.budsies.com'),(72,'825c8e9a4147f86b86b348eceba5df42@st.budsies.com'),(482,'83af1e774900ec2f20d985b4b9a43633@st.budsies.com'),(500,'83bd2329f7854ba8110e55a66b57ae70@st.budsies.com'),(398,'84314b0990eda1d96479186913472cd3@st.budsies.com'),(280,'848d57703ae58ef2182a1203dcd5fe58@st.budsies.com'),(178,'866bb84a0de804ae580ece5f66544d0a@st.budsies.com'),(47,'867b72886e3bad635eda32f17b2c7507@st.budsies.com'),(228,'881baff0b95bc6d5a4a9dca9b029b55e@st.budsies.com'),(102,'88b65e8808ef845ab8cdcc25afd173b2@st.budsies.com'),(21,'897f6afd5537bc992271733245eaca01@st.budsies.com'),(124,'89b048deafe140679438dc9829521c7e@st.budsies.com'),(227,'89eb86db748ba495f6c2159cfa12f4a8@st.budsies.com'),(258,'8a19ef3c14930a0b8cb32713ba963951@st.budsies.com'),(266,'8a7e84f897a2ca5b98b05fb5b3f54047@st.budsies.com'),(162,'8af8ead60209d0e175db813f0d58d586@st.budsies.com'),(48,'8b45344c3edf66fefbd84bd86a876cfe@st.budsies.com'),(497,'8d51a85116edbf785ede3c4a9d3faff6@st.budsies.com'),(79,'8d594df1b30bd48876dc17e94db78207@st.budsies.com'),(50,'8eb92542d86bd2943269f03bf4d7076b@st.budsies.com'),(495,'8f5e0ae4551e44ec9cc0275cb5e3b6d0@st.budsies.com'),(51,'8f5e572efb292237305709e459b46009@st.budsies.com'),(435,'90023c7e82b33ad169b76fd198fedba9@st.budsies.com'),(418,'90b2ac67109cdf2d94bf81f36736dd9d@st.budsies.com'),(241,'90d022d31ba008826f6b8d36e35eb697@st.budsies.com'),(43,'90d99e902129c25ac6c9050c14636259@st.budsies.com'),(70,'91d0ea35f55a46b63ef8ab66f185fd12@st.budsies.com'),(211,'925b6d8063398c41477dcd599355d091@st.budsies.com'),(16,'929464ac0c03e3186ce089b2b1b937f8@st.budsies.com'),(272,'933cda4ce5452fb47def13d3b28fc716@st.budsies.com'),(254,'945125cfb7b5a3158f359dbf990e113c@st.budsies.com'),(77,'94728411228914634df4ca46e8b2da67@st.budsies.com'),(443,'95c3a44a64b6dbf9e6a04960497030c0@st.budsies.com'),(250,'9606afaf2883c82222ded370e76b0424@st.budsies.com'),(415,'9633c6a149fa9d61ac629cf4865009a7@st.budsies.com'),(86,'96b865302fac6b5987a5a52744a139a3@st.budsies.com'),(131,'97de325dfff731a9cca0859e53880944@st.budsies.com'),(246,'97fff8951b8005ec128ebbd4e275031f@st.budsies.com'),(238,'981249eae5bf2b590800aab5619ae634@st.budsies.com'),(68,'9825c92cbd855f5c98433ee2cede82ac@st.budsies.com'),(292,'989724ba642fcf66b91f2d122a8ef934@st.budsies.com'),(101,'991bfe11741aa89b03af5f85a1d45616@st.budsies.com'),(224,'9a3e0fa8dfab454802712d6f81276e04@st.budsies.com'),(366,'9a5ad7b2d018ff1f78be3a87c658f438@st.budsies.com'),(221,'9b177a71b7141194412a4bea458fe51a@st.budsies.com'),(137,'9b97f57713aee25038317062565edc11@st.budsies.com'),(236,'9bf77487925c152efa7d72404c4ee573@st.budsies.com'),(340,'9d1680aab432a776187267aa6f123cbc@st.budsies.com'),(448,'9d3ff880bc32475978c00c23192687de@st.budsies.com'),(391,'9d881c07bd7a556c0725da8c14bdde2a@st.budsies.com'),(66,'9dd33a8a565ddc52c8424a2304aada5a@st.budsies.com'),(130,'9dee9978e92bdeb7e27ea7b1ade9de08@st.budsies.com'),(90,'9e78811355170982d72a8b455199d17d@st.budsies.com'),(240,'9f92826b645f7a4447b7f8e2bd235d38@st.budsies.com'),(164,'9fa956c75a7d5cafc0e07fe97497a3ad@st.budsies.com'),(370,'a2ff9337ccb5edc35a48c10970776c12@st.budsies.com'),(320,'a319ae2a53e1de181b15e2b3df0c26f2@st.budsies.com'),(217,'a33961d92e8e9ff7fe3eb172ca92bc6d@st.budsies.com'),(480,'a358e72e1de02f8773ebcb52908aba56@st.budsies.com'),(179,'a404037147b5340717dd230145f0a2e0@st.budsies.com'),(457,'a8439a2a14baa5186ca5fca1bea7b04e@st.budsies.com'),(488,'a8b1169f71d6cd02e37879440116f9e1@st.budsies.com'),(82,'a9247e54bc34bb59083d41f6b049363e@st.budsies.com'),(148,'a9a1d358e2f4cd6c938ff4a326b6ba9e@st.budsies.com'),(44,'aae1d77b7de676e5664a9a8805a0f495@st.budsies.com'),(63,'ab45d5b8819322558e236fc067029296@st.budsies.com'),(27,'ab889742668adcc27791d1c72c049b0c@st.budsies.com'),(445,'ac269f7bcb839cc395d2233c9426e16d@st.budsies.com'),(253,'ac28f4e2f2555189c122bece1c8a402b@st.budsies.com'),(242,'ace839d5b8bf4aaa9009fe5d0f5f813d@st.budsies.com'),(376,'ad28e6dd3631c0af76becb970f6ab043@st.budsies.com'),(330,'ad818e316debf9270103ef3b27a1303b@st.budsies.com'),(85,'ada54b91a4d5754e666adaa625062bd3@st.budsies.com'),(470,'add0c3217c421eb0c331095d85c61590@st.budsies.com'),(62,'ae89a611e716da8a098e0d0c5e861ea1@st.budsies.com'),(469,'af99ad08831afb3be6100e13d97f162e@st.budsies.com'),(123,'afdf9a4693ec8f7f7eb253b1e6da1a81@st.budsies.com'),(394,'b0863493dbc23183adcbe335b2766743@st.budsies.com'),(416,'b0df28fb260f1fe84096714a349be123@st.budsies.com'),(19,'b1a6fbfb9924a1d709ed5a6b55a5e1a6@st.budsies.com'),(369,'b2540c1077f513e5e0ef56205dc6b9bd@st.budsies.com'),(3,'b397532f7283e09d41a63ae3a2cd9086@st.budsies.com'),(87,'b40dd475667a3f5e0b38bebf27ff4483@st.budsies.com'),(220,'b42dc2f27b66a32260307c54c6d64ea8@st.budsies.com'),(271,'b44bc9c236982521309c201fb9512174@st.budsies.com'),(403,'b4b6fb7af6064fde5fc9518c2bd7d12c@st.budsies.com'),(149,'b53b90bb055120aa14e20c4a99787dc2@st.budsies.com'),(41,'b5de2d7f2c0d535f797d0ad0054082a5@st.budsies.com'),(139,'b6b45ecbfa4310787156271403e6580f@st.budsies.com'),(362,'b6c4ef0fd9f836564894062173225420@st.budsies.com'),(323,'b712cf95515e8ce9142dfada811bcd22@st.budsies.com'),(147,'b86a65a99f2f059a1c1d6f10971e35d9@st.budsies.com'),(297,'b88284199039c44cb85dac2b2bb44185@st.budsies.com'),(120,'b8d38960b36a0b9c6da7981751b0d2e6@st.budsies.com'),(464,'b95c3e198f31de4a4324e151f9c22ca4@st.budsies.com'),(59,'ba3033964ec6f4d5830bc05aca954c21@st.budsies.com'),(22,'ba37c965470945feabee4a1af6374a15@st.budsies.com'),(388,'bb45ab9337dc377106d7dcbb81180b2e@st.budsies.com'),(293,'bc04ceaffbf5a2a6188c6ffb9b6e14b6@st.budsies.com'),(1,'bc954d95cfa2f0bdbd953ea1f5ea32e7@st.budsies.com'),(262,'bcb4da63b4d4bc6c01717d0f235af2ba@st.budsies.com'),(183,'bd90195587a28c27a3619007edf51c33@st.budsies.com'),(73,'bf79c64053493296d00428d9406a7e43@st.budsies.com'),(30,'bfe8418e8695448c00eef03836614b57@st.budsies.com'),(187,'c0645ad817b2f08ff4a004ae5c86f21c@st.budsies.com'),(463,'c0b33a7bdba3f4bf9777fc241bd849be@st.budsies.com'),(80,'c1236006e170aaca3fdcb1e74a83a530@st.budsies.com'),(385,'c1c07b3a3e7d8c4f8dd9c2f553b0686d@st.budsies.com'),(423,'c1f8803cfaed3d48b596f89e4e8e1256@st.budsies.com'),(171,'c20cfb8f34a07c93b4d6336c7c081225@st.budsies.com'),(319,'c2822d96e4b8f56506482318ddb4652a@st.budsies.com'),(155,'c296388564f327eff4e9b958fd2c0c1a@st.budsies.com'),(353,'c29f971cdb9e379aa8c19f450c4fc949@st.budsies.com'),(11,'c2fdd554bcb45aa0f34162ba684faa23@st.budsies.com'),(163,'c39ec89dcbb5e84f6e04d3b3406a7130@st.budsies.com'),(489,'c47d936ed2dbe248f203f2edd3731a6d@st.budsies.com'),(208,'c4ba4cb2cea718ac80d9f8900e92269b@st.budsies.com'),(361,'c585b76e4cb5f43e0d941027655bdacd@st.budsies.com'),(189,'c63a3ec4f6f5a540d7d7cae03e28ed2c@st.budsies.com'),(233,'c695846a6132cd586148448b4c3e7219@st.budsies.com'),(341,'c720e55dbfb4275f5d4896627ac8e37c@st.budsies.com'),(76,'c7980bd66de2e7c14e00f0d794130d93@st.budsies.com'),(379,'c79c4e78841a56e6c09849eacd59243a@st.budsies.com'),(35,'c87dce886418c16a5773d5fdae0868e9@st.budsies.com'),(465,'c99283d750b533cf546257de31fbb5f3@st.budsies.com'),(200,'cad64573e3d4288b5b3af0868251db1e@st.budsies.com'),(31,'caefa3f4c8e4ff301f568331ba21d941@st.budsies.com'),(333,'cb8dc8f441d7450a7ddc57f559c8cab6@st.budsies.com'),(71,'cbae50d68bd070e74d9e5ce151896234@st.budsies.com'),(94,'cc6490a19df6a435c35c76dcf616b23f@st.budsies.com'),(336,'ce528bf0dda1f0e307496d5ceb3571ad@st.budsies.com'),(104,'ce6ca0d29656fd503c59e086130d1647@st.budsies.com'),(128,'ceb60c3d3261bcf4b5deb9e246c592fc@st.budsies.com'),(201,'cf8740040543bcca28c1b2ffbee774fd@st.budsies.com'),(93,'cffdb874f420fca67aa2b509d4ac24cc@st.budsies.com'),(441,'d003feb3c21b052b717afebf6a6869bb@st.budsies.com'),(89,'d1036ef24839b430db4936cfd716ae0f@st.budsies.com'),(226,'d117029c939a61e25e86d3a8621ad7ba@st.budsies.com'),(112,'d12b5886c41ffbb9d6f07cc58937be15@st.budsies.com'),(152,'d1518a22e2226fdb26d6ed1b05c847e7@st.budsies.com'),(98,'d160fa2fbba51ffb836cdc4fcc35a355@st.budsies.com'),(351,'d194ea3b53b16bc1c2082acf6625efbe@st.budsies.com'),(108,'d1ff01ee92a3dff732349f56dbfb20de@st.budsies.com'),(360,'d22b0fea141f6f9bd97ea89733b1984f@st.budsies.com'),(354,'d28b3581b1c39fb6b2b540c6b7da2ae4@st.budsies.com'),(75,'d2c58ead86c46890afc24988e90956ce@st.budsies.com'),(450,'d2eb89a1f06d27478a22680a1c7ea80b@st.budsies.com'),(23,'d3185a4bfd8090be4981ba7d506009c2@st.budsies.com'),(4,'d31cf11fc80983b4941843063dcb87f6@st.budsies.com'),(425,'d406ec09b878c9d2589642541eea2f03@st.budsies.com'),(18,'d42c82b3ab4b5e3b9c8cda468c0a765f@st.budsies.com'),(440,'d462755cfd9f968a49b1b765c46bcf33@st.budsies.com'),(235,'d4982a4d8341d2fb460841494d6178f5@st.budsies.com'),(81,'d4a822008b55d219adea267258f2a1e7@st.budsies.com'),(38,'d4d4e4e6fdd2c2c47e6242ad3349fea2@st.budsies.com'),(454,'d4e859e99186fcb7ad992e6d8ad1cffe@st.budsies.com'),(107,'d4f0c66d409a7e9351e41205cf8984a0@st.budsies.com'),(173,'d4f104885ce8531dd8272d0b95c023c2@st.budsies.com'),(210,'d53899fab26025fce37dae4125b4090c@st.budsies.com'),(116,'d586cacd303f46744438cc27a69e07a5@st.budsies.com'),(390,'d5f10511ad0a8f187413cfdddd003c1d@st.budsies.com'),(342,'d6573b126fe669528077547c7520bda5@st.budsies.com'),(380,'d65e152ae7b59ef6838186487a62d061@st.budsies.com'),(408,'d6674e781b3710130a089916b656ec0c@st.budsies.com'),(437,'d6c80efd4adad6d00847d203b5fcd462@st.budsies.com'),(374,'d74ed45596978ae2872d18de4beb3019@st.budsies.com'),(349,'d882240cd43f5854f965863281c51466@st.budsies.com'),(249,'d88441ef9a1c8cce08f01b692ced6154@st.budsies.com'),(103,'d9838ec0be6ed72138fb09c39cb5b833@st.budsies.com'),(462,'d9953d44f5ec35c1c4920f6f8cf0f214@st.budsies.com'),(326,'db1df21e5cdc4c73b10f5eac061e9228@st.budsies.com'),(158,'db5d667479a3271e07c42481f87e6a5c@st.budsies.com'),(318,'dc09a4fed07b1f28697bb458fcec26ba@st.budsies.com'),(157,'dc5683ac2749db33da48d59f64c6d554@st.budsies.com'),(159,'dca131c0f65c6701d525dd3952810b1e@st.budsies.com'),(404,'dd614b66d3bfce3036909c87e59263cc@st.budsies.com'),(111,'de373c24a4b0e19f14c9107460e786ba@st.budsies.com'),(140,'de46b7d08f66861a6254f0bd937cddf8@st.budsies.com'),(307,'dee8b93e52829ed8a5f8e3bbc31b7811@st.budsies.com'),(145,'df214599f9907ac9201f5d924212aab9@st.budsies.com'),(300,'dfb2322081576c2dcf9cd56e536080da@st.budsies.com'),(451,'e02132ea2d879bdb542f53f253d9d7bd@st.budsies.com'),(267,'e0976524ddac5ce73ef1aef1ba61b96c@st.budsies.com'),(33,'e1c0d83258728e45b89069b0628d74f4@st.budsies.com'),(146,'e22737b91d7c821a317caed9c9923938@st.budsies.com'),(247,'e27334f490e807b78eb0df3a60bc9f6f@st.budsies.com'),(260,'e2bee4e6af207da1d6cc8fe559bcba29@st.budsies.com'),(105,'e4341742482e4c9e35421ec34a33f59c@st.budsies.com'),(2,'e498c3f69f1dda331af8135d3b806c80@st.budsies.com'),(118,'e4abe10262bbb7c4ee573b50a5388913@st.budsies.com'),(64,'e624bfd6d468f0885c727e1966cc2949@st.budsies.com'),(386,'e6f2303e44f6b81023393ef460493610@st.budsies.com'),(397,'e78b593a8dcaf27ea8a908b5b110f1eb@st.budsies.com'),(284,'e797c39d1bc281d88dbd19fc4f002082@st.budsies.com'),(432,'e81d50a4d1e60d60016f30023565aa28@st.budsies.com'),(434,'e8357852e032107105877e00913d737a@st.budsies.com'),(10,'e85e44ce3fa6f83f6c1fdbbfdc88799c@st.budsies.com'),(115,'e8dfba1889834babf49f7e551de580cf@st.budsies.com'),(309,'e8f2ffcfa607e47f516a91f9140c4296@st.budsies.com'),(476,'e91440486a8d80e8859307d9d28c0086@st.budsies.com'),(355,'e918883cefd3c63675ad2db794c701f7@st.budsies.com'),(276,'e91a2bf80a27efe286c0966794434c0f@st.budsies.com'),(136,'e959c97f69637538f0b08fccf79b59a9@st.budsies.com'),(117,'e991c3b66172dbc26e593bb6229216f1@st.budsies.com'),(268,'e9fc2fcf4a22ff66b81d9182cc0a0e6a@st.budsies.com'),(14,'eadd7523cc0d3b87300aae1097141768@st.budsies.com'),(344,'ebb8c1daa08481b61a0763eb25125233@st.budsies.com'),(282,'ec7d5fe8f1f999a294131c5753c769b2@st.budsies.com'),(67,'edd3c23c7e5ecb53c09f640c8481972e@st.budsies.com'),(459,'ef0b43a07247ed0dd95a022aeefba7ad@st.budsies.com'),(371,'ef65ceb62fae593a14b3b31df049339d@st.budsies.com'),(407,'ef6830523e5ebd6dc2901414c611e728@st.budsies.com'),(248,'efee82dbef39589702a5d49214290864@st.budsies.com'),(337,'f00bcb446c3323376a8580aff48e6653@st.budsies.com'),(174,'f02761690d773449bdf6fcdeb5c9a3ad@st.budsies.com'),(181,'f0ee0393b53b5f2454c6bb3c22d6b536@st.budsies.com'),(339,'f189a7d9eac5f38d283af65195d1db65@st.budsies.com'),(133,'f2341ec7b0167aba861c9df482accd75@st.budsies.com'),(420,'f2692a4438f6dbc6ccfc36a5b82e3668@st.budsies.com'),(170,'f293b90ac3d05dcc8443fdd575ac936f@st.budsies.com'),(296,'f368946ca5d670ad475f47ff0b606783@st.budsies.com'),(474,'f3a107b92e1aa857be8de712ce09546f@st.budsies.com'),(194,'f3a8d2ddf1352e50433c3f4716f678ef@st.budsies.com'),(7,'f42989e98749919aca429e57377bd2ba@st.budsies.com'),(428,'f49afe675f079d4cae605d8c8e581b4b@st.budsies.com'),(352,'f54b32cbce58fa1cc63b2bff2cb1c0f0@st.budsies.com'),(433,'f554909be7b4f0e578f9f5aedfcc4252@st.budsies.com'),(230,'f59eaafc8c3758186484d506ce279604@st.budsies.com'),(491,'f5c18ddde317bee1a689f174ba527ab0@st.budsies.com'),(359,'f5d5fb591a56b02e67fb1e6881d8b153@st.budsies.com'),(402,'f5dee6586159f3cf0d9860429bc559a4@st.budsies.com'),(207,'f6c00b419625689b6eec0a4a00e84d26@st.budsies.com'),(188,'f95a74ee9dd4f986562ad62a00ccadc8@st.budsies.com'),(348,'f9737e6c39693473969acbd2b5329239@st.budsies.com'),(447,'fabe5c9fdae228b1b676c6f7c1945603@st.budsies.com'),(113,'fb05bb5affb50f09283e6ebebd3f0ae3@st.budsies.com'),(298,'fbe6a383af0cf94409fd64d2e3c0dc34@st.budsies.com'),(223,'fbf43c33bda1a76c800dbb003aa3c724@st.budsies.com'),(9,'fca16d6c361a2a8cd45acd0f7bbc2012@st.budsies.com'),(321,'fcdd28eff12863c2e51bec9e208de0f2@st.budsies.com'),(100,'fd77e32fd3b0e88bad9b8f2f7d031d43@st.budsies.com'),(190,'fdaa05f40307e1c11f2d7d16d4b8c825@st.budsies.com'),(55,'fe114eaeff4d1c34e342e37579665f33@st.budsies.com'),(400,'fe583051bc7f04dd4bdd9f8e77515501@st.budsies.com'),(153,'febd05599a9f951f4b1c7a79e9193227@st.budsies.com'),(78,'ffa31d96a8400012505852513d076d33@st.budsies.com'),(39,'fffc6734e9777617046357bdbaf5b35f@st.budsies.com');

--
-- Dumping data for table `amasty_acart_email_template`
--

INSERT INTO `amasty_acart_email_template` VALUES (1,1,'AmastyAbandonedCartReminder66ec74bb5cb7e','',NULL,2,'',NULL,0),(2,2,'AmastyAbandonedCartReminder66ec74bb605fa','',NULL,2,'',NULL,0),(3,3,'AmastyAbandonedCartReminder66ec74bb65507','',NULL,2,'',NULL,0),(4,7,'AmastyAbandonedCartReminder66ec74f4f25f1','',NULL,2,'',NULL,0),(5,8,'AmastyAbandonedCartReminder66ec74f501861','',NULL,2,'',NULL,0),(6,9,'AmastyAbandonedCartReminder66ec74f503322','',NULL,2,'',NULL,0),(7,10,'AmastyAbandonedCartReminder67a26cb1d28b7','',NULL,2,'',NULL,0),(8,11,'AmastyAbandonedCartReminder67a26cb1d938a','',NULL,2,'',NULL,0),(9,12,'AmastyAbandonedCartReminder67a26cb1e08cb','',NULL,2,'',NULL,0),(10,4,'AmastyAbandonedCartReminder67a26f35730aa','',NULL,2,'',NULL,0),(11,5,'AmastyAbandonedCartReminder67a26f3576e12','',NULL,2,'',NULL,0),(12,6,'AmastyAbandonedCartReminder67a26f357b0b7','',NULL,2,'',NULL,0);

--
-- Dumping data for table `amasty_acart_guest_customer_quotes`
--


--
-- Dumping data for table `amasty_acart_history`
--


--
-- Dumping data for table `amasty_acart_history_details`
--


--
-- Dumping data for table `amasty_acart_quote_email`
--


--
-- Dumping data for table `amasty_acart_rule`
--

INSERT INTO `amasty_acart_rule` VALUES (1,'Budsies campaign',1,0,'{\"type\":\"Amasty\\\\Acart\\\\Model\\\\SalesRule\\\\Condition\\\\Combine\",\"attribute\":null,\"operator\":null,\"value\":\"1\",\"is_value_processed\":null,\"aggregator\":\"all\"}','clicked,all_products_went_out_of_stock,all_products_were_disabled','aitoc','email',NULL,NULL,'cart-alert'),(2,'Petsies campaign',1,0,'{\"type\":\"Amasty\\\\Acart\\\\Model\\\\SalesRule\\\\Condition\\\\Combine\",\"attribute\":null,\"operator\":null,\"value\":\"1\",\"is_value_processed\":null,\"aggregator\":\"all\"}','clicked,all_products_went_out_of_stock,all_products_were_disabled','aitoc','email',NULL,NULL,'cart-alert'),(3,'Bulkorders campaign',1,0,'{\"type\":\"Amasty\\\\Acart\\\\Model\\\\SalesRule\\\\Condition\\\\Combine\",\"attribute\":null,\"operator\":null,\"value\":\"1\",\"is_value_processed\":null,\"aggregator\":\"all\"}','clicked,all_products_went_out_of_stock,all_products_were_disabled','aitoc','email',NULL,NULL,'cart-alert'),(4,'Waggables campaign',1,0,'{\"type\":\"Amasty\\\\Acart\\\\Model\\\\SalesRule\\\\Condition\\\\Combine\",\"attribute\":null,\"operator\":null,\"value\":\"1\",\"is_value_processed\":null,\"aggregator\":\"all\"}','clicked,all_products_went_out_of_stock,all_products_were_disabled','aitoc','email',NULL,NULL,'cart-alert');

--
-- Dumping data for table `amasty_acart_rule_customer_group`
--


--
-- Dumping data for table `amasty_acart_rule_quote`
--


--
-- Dumping data for table `amasty_acart_rule_store`
--

INSERT INTO `amasty_acart_rule_store` VALUES (54,2,3),(55,2,6),(56,2,7),(57,1,1),(58,1,9),(59,3,5),(60,4,4);

--
-- Dumping data for table `amasty_acart_schedule`
--

INSERT INTO `amasty_acart_schedule` VALUES (1,1,39,NULL,2,0,NULL,0.0000,NULL,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(2,1,40,2,0,0,'by_percent',10.0000,12,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(3,1,41,5,0,0,NULL,10.0000,NULL,NULL,0,NULL,0,NULL,NULL,1,1,NULL,NULL,NULL),(4,2,91,NULL,2,0,NULL,0.0000,NULL,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(5,2,92,2,0,0,'by_percent',10.0000,12,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(6,2,93,5,0,0,NULL,10.0000,NULL,NULL,0,NULL,0,NULL,NULL,1,1,NULL,NULL,NULL),(7,3,152,NULL,2,0,NULL,0.0000,NULL,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(8,3,153,2,0,0,'by_percent',10.0000,12,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(9,3,154,5,0,0,NULL,10.0000,NULL,NULL,0,NULL,0,NULL,NULL,1,1,NULL,NULL,NULL),(10,4,135,NULL,2,0,NULL,0.0000,NULL,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(11,4,136,2,0,0,'by_percent',10.0000,12,NULL,0,NULL,0,NULL,NULL,0,1,NULL,NULL,NULL),(12,4,137,5,0,0,NULL,10.0000,NULL,NULL,0,NULL,0,9,NULL,1,1,NULL,NULL,NULL);

--
-- Dumping data for table `amasty_amfollowup_attribute`
--


--
-- Dumping data for table `amasty_amfollowup_blacklist`
--

INSERT INTO `amasty_amfollowup_blacklist` VALUES (1,'e3685958ca39ea096949a389eee6646c@st.budsies.com','2025-02-04 09:51:12'),(2,'05e79a42d093501116a6bf4b141c83a9@st.budsies.com','2025-02-04 09:51:12'),(3,'53d43e96537b6fcc7b616f30be7b9b7a@st.budsies.com','2025-02-04 09:51:12'),(4,'cf7f5d9c498e06e616f2777b7ad14e43@st.budsies.com','2025-02-04 09:51:12'),(5,'1341d4082865cdfa8929d531962a9467@st.budsies.com','2025-02-04 09:51:12'),(6,'2a6340b0e64f284c517c69ab04361877@st.budsies.com','2025-02-04 09:51:12'),(7,'7118cd4830605d10bf84d9f7248079d5@st.budsies.com','2025-02-04 09:51:12'),(8,'075a5b7b0512ef9b5a160efc334e2cbc@st.budsies.com','2025-02-04 09:51:12'),(9,'253da7abc8b8cb4d948923cb1d29db46@st.budsies.com','2025-02-04 09:51:12'),(10,'4010bd0dd633e015d65b8e12a7326f30@st.budsies.com','2025-02-04 09:51:12'),(11,'a37f330a28ecc5df787ab5fa0121d364@st.budsies.com','2025-02-04 09:51:12'),(12,'dd4d1cc7288baaed6c0550de74b369be@st.budsies.com','2025-02-04 09:51:12'),(13,'1918a5202ea6a2f08ca40f40af136dfd@st.budsies.com','2025-02-04 09:51:12'),(14,'38b42bb9febae364a21aede15bb7da3c@st.budsies.com','2025-02-04 09:51:12'),(15,'daa78e1bc1fedcd33f8ec60691227ecf@st.budsies.com','2025-02-04 09:51:12'),(16,'3ad55e6d632d03aa7cbad175c0b8f0d7@st.budsies.com','2025-02-04 09:51:12'),(17,'8aea16c328547fb1057ae478d82041ae@st.budsies.com','2025-02-04 09:51:12'),(18,'ec5f275a77a3561957e3cad28bd25e4e@st.budsies.com','2025-02-04 09:51:12'),(19,'d2e439e4e289e0e6d9200f7d8a40e27b@st.budsies.com','2025-02-04 09:51:12'),(20,'1161e9420fff9d24b0f16532d79d6d95@st.budsies.com','2025-02-04 09:51:12'),(21,'c5ea8648095ecab587f92a7124945531@st.budsies.com','2025-02-04 09:51:12'),(22,'b6cec8de5887c719fcc2f573e9b4eef9@st.budsies.com','2025-02-04 09:51:12'),(23,'48b6bc5974f9aaf2532d2a29dcfbe193@st.budsies.com','2025-02-04 09:51:12'),(24,'35b55f022b5d0d953551c389a32fdeed@st.budsies.com','2025-02-04 09:51:12'),(25,'95d5c5077867ac4799358c802144b37f@st.budsies.com','2025-02-04 09:51:12'),(26,'94e29e2e9a652c94b519fcd038d3e096@st.budsies.com','2025-02-04 09:51:12'),(27,'55c72cc090088f1bb86be77989f78d6e@st.budsies.com','2025-02-04 09:51:12'),(28,'de65d1d61c2dbef7b332e5b984e3a9de@st.budsies.com','2025-02-04 09:51:12'),(29,'042dd2f1af4dbaacb8e14d9425213a76@st.budsies.com','2025-02-04 09:51:12'),(30,'4f58a665d1e83063e454f58174ce8331@st.budsies.com','2025-02-04 09:51:12'),(31,'196c3f171cf3d4e130dcabfc18d46c79@st.budsies.com','2025-02-04 09:51:12'),(32,'73021e8ce8748520b299ac5e8e3d2195@st.budsies.com','2025-02-04 09:51:12'),(33,'29b447a823769704d0191ae21c2284ee@st.budsies.com','2025-02-04 09:51:12'),(34,'b2a377f8eb988bfb77a922dcaa620167@st.budsies.com','2025-02-04 09:51:12'),(35,'2a64d4dc7b79cd106622ed965ef88b9f@st.budsies.com','2025-02-04 09:51:12'),(36,'7cd1713f619599c812ffc00c5ff7d756@st.budsies.com','2025-02-04 09:51:12'),(37,'58b83640732745dc96af03c85e025424@st.budsies.com','2025-02-04 09:51:12'),(38,'90f6b23d7fb034908c23180a395d79da@st.budsies.com','2025-02-04 09:51:12'),(39,'f79f798105a8366d63efc9c451af3574@st.budsies.com','2025-02-04 09:51:12'),(40,'1178d23cf1db3641ceb4d729f064aa5b@st.budsies.com','2025-02-04 09:51:12'),(41,'4fa7121649cb5bd484122e55ae65af79@st.budsies.com','2025-02-04 09:51:12'),(42,'5dd092c91f90ca8ad68e279a3cb9e842@st.budsies.com','2025-02-04 09:51:12'),(43,'43f69f32a1a6012777cf7cba06a940bf@st.budsies.com','2025-02-04 09:51:12'),(44,'a6cc0ccec33fe16bbcf5e4f4700f4306@st.budsies.com','2025-02-04 09:51:12'),(45,'4379a187c0305878aabeb23355d2f242@st.budsies.com','2025-02-04 09:51:12'),(46,'4ba366dfa96d89ff1dea286d2142bfb6@st.budsies.com','2025-02-04 09:51:12'),(47,'6ad5bafe668d73935e32826514c17247@st.budsies.com','2025-02-04 09:51:12'),(48,'db28bb654d2b8ee812010c7ece95bfce@st.budsies.com','2025-02-04 09:51:12'),(49,'fa2c59626d1973f498c6075737c7fcf0@st.budsies.com','2025-02-04 09:51:12'),(50,'c72d2675bd9721e495fdba4d43774f13@st.budsies.com','2025-02-04 09:51:12'),(51,'9b68b684cbb76de44aa08974535a5381@st.budsies.com','2025-02-04 09:51:12'),(52,'2e61d5688777550048b6cb38a93cee98@st.budsies.com','2025-02-04 09:51:12'),(53,'6bad156e5845a618ad1eb8a6c7e77cc9@st.budsies.com','2025-02-04 09:51:12'),(54,'bb34cd0bcfc05cd60e8b7b547cf11e9e@st.budsies.com','2025-02-04 09:51:12'),(55,'5115c2a5273e372252d0aa871a2503c4@st.budsies.com','2025-02-04 09:51:12'),(56,'947f9c05d08bfa9905eb0087a1cbb8d7@st.budsies.com','2025-02-04 09:51:12'),(57,'66e118d7008a48221fe9d1a780a0c523@st.budsies.com','2025-02-04 09:51:12'),(58,'c2329fa5aa5ee5e2ec847d65fc0fc1f5@st.budsies.com','2025-02-04 09:51:12'),(59,'8a837ff037905f74d6b3f94932ba035d@st.budsies.com','2025-02-04 09:51:12'),(60,'6a7ff7e0bede42d3320add5cacfd711b@st.budsies.com','2025-02-04 09:51:12'),(61,'8b9f3e5f723bf6f7b33c6ff1f17b55ca@st.budsies.com','2025-02-04 09:51:12'),(62,'343ad1b6c9d6abe233d46684183446d6@st.budsies.com','2025-02-04 09:51:12'),(63,'e5a7388d83d6fff8e198e75a2fb3b4cd@st.budsies.com','2025-02-04 09:51:12'),(64,'8390c7013d36356a876e80979d354bbd@st.budsies.com','2025-02-04 09:51:12'),(65,'e9430f573435a9847a9c3bf5d56b0335@st.budsies.com','2025-02-04 09:51:12'),(66,'c525d4d1fb317d6172d1f0a5092e9b5d@st.budsies.com','2025-02-04 09:51:12'),(67,'c9359259d03d773576868ee1472b089d@st.budsies.com','2025-02-04 09:51:12'),(68,'4c42f89b86b7a39d5c346c455a0d41d0@st.budsies.com','2025-02-04 09:51:12'),(69,'a8dea3c09c3f80be1d3ac6806abac2d3@st.budsies.com','2025-02-04 09:51:12'),(70,'544436ec69e9fba7586fee153d92c878@st.budsies.com','2025-02-04 09:51:12'),(71,'e8c27020995f7c6925d3f76be5bd469e@st.budsies.com','2025-02-04 09:51:12'),(72,'cd4ac9727ae3998a795fb69bb75750fb@st.budsies.com','2025-02-04 09:51:12'),(73,'88df1cfe97343a5ce27185208248d59f@st.budsies.com','2025-02-04 09:51:12'),(74,'89765526f33dcf9ffa8c26844abf824f@st.budsies.com','2025-02-04 09:51:12'),(75,'fae9e51b46760ea54535c8f0d0204772@st.budsies.com','2025-02-04 09:51:12'),(76,'b919356bc965103e966f97aa94e654bf@st.budsies.com','2025-02-04 09:51:12'),(77,'51a536a2017ea034285187265b0452e8@st.budsies.com','2025-02-04 09:51:12'),(78,'ff2b7a60d6baa56ad294d94acb0f6e1e@st.budsies.com','2025-02-04 09:51:12'),(79,'760ec4d857817d6cfdb4981eb401ec6b@st.budsies.com','2025-02-04 09:51:12'),(80,'a7028a0484a282e3283ac82d5409e492@st.budsies.com','2025-02-04 09:51:12'),(81,'2a08f7130cdf22277f2d89ce2923c91a@st.budsies.com','2025-02-04 09:51:12'),(82,'60fe36fe33835f80957a0e70b062d8bc@st.budsies.com','2025-02-04 09:51:12'),(83,'15253cd97ed5da9f3a36be6da9510407@st.budsies.com','2025-02-04 09:51:12'),(84,'2d7939dff81ae2739462f202e5d60a4f@st.budsies.com','2025-02-04 09:51:12'),(85,'e2e84100154c63781bcc0a700bcf88c7@st.budsies.com','2025-02-04 09:51:12'),(86,'62802a8443b6bc9f5f738b783627a62f@st.budsies.com','2025-02-04 09:51:12'),(87,'c73579d28e3e84716d1a474a0bf4fc46@st.budsies.com','2025-02-04 09:51:12'),(88,'5c6dac87cb53a50c68c11366a41cadde@st.budsies.com','2025-02-04 09:51:12'),(89,'61e36df47de68de6a4d35766cc98f5fa@st.budsies.com','2025-02-04 09:51:12'),(90,'fdc7b0363ea68b04565dd2fe4a67c675@st.budsies.com','2025-02-04 09:51:12'),(91,'e8f7f244e76dc5b0c4ced20c1f34f3b2@st.budsies.com','2025-02-04 09:51:12'),(92,'a85ee40c1c63b4d42f2751ce41986aae@st.budsies.com','2025-02-04 09:51:12'),(93,'876eb3910110b0b2e1ca75f5a0ae6ecb@st.budsies.com','2025-02-04 09:51:12'),(94,'8d1f963e196139ba463b24bb8b817179@st.budsies.com','2025-02-04 09:51:12'),(95,'d251e3871bfc759e1173cacff27cff47@st.budsies.com','2025-02-04 09:51:12'),(96,'a93bfb1fd94e01e65be412694300230a@st.budsies.com','2025-02-04 09:51:12'),(97,'9255c01fedfbfd0f6fae1cfcbea2ec5b@st.budsies.com','2025-02-04 09:51:12'),(98,'bbfac6cf09b78ff48c56297363db6532@st.budsies.com','2025-02-04 09:51:12'),(99,'5d625b872d627f90f85510ee43b0698e@st.budsies.com','2025-02-04 09:51:12'),(100,'443c58be49280e8094e94a7a1e861075@st.budsies.com','2025-02-04 09:51:12'),(101,'95ef975dd1b91e4093ad2f19a11f417d@st.budsies.com','2025-02-04 09:51:12'),(102,'6ab4d4e0b87073e5d3b4d3d2afb19e2e@st.budsies.com','2025-02-04 09:51:12'),(103,'d4c84354e8e0ecd568b30521f36a6b6c@st.budsies.com','2025-02-04 09:51:12'),(104,'e9924d337d1d2006a06fc246427e04c2@st.budsies.com','2025-02-04 09:51:12'),(105,'4a26b79dcf071de1288256873c8d5044@st.budsies.com','2025-02-04 09:51:12'),(106,'779b945eac4646af8eacb387e625479c@st.budsies.com','2025-02-04 09:51:12'),(107,'9b7b82ff99990bd757c14b7f872c3b19@st.budsies.com','2025-02-04 09:51:12'),(108,'13f0f49d9d2acfbae4d00927756190b6@st.budsies.com','2025-02-04 09:51:12'),(109,'f5a632afee4cd51b299ae932c336c581@st.budsies.com','2025-02-04 09:51:12'),(110,'d67d9c9fc948482b1b83bbe9c666f479@st.budsies.com','2025-02-04 09:51:12'),(111,'c80534250597ff629e6d26833c9864d8@st.budsies.com','2025-02-04 09:51:12'),(112,'74095e6f602b1b05ee9edae342a7fe0a@st.budsies.com','2025-02-04 09:51:12'),(113,'5c0722df0d0d4dda4bf12b59a1c28445@st.budsies.com','2025-02-04 09:51:12'),(114,'402711e08ffa0683725e5caf01cc4ed2@st.budsies.com','2025-02-04 09:51:12'),(115,'7ae057a5b3e9e5026d15285642ec6695@st.budsies.com','2025-02-04 09:51:12'),(116,'b75f11a5ba07e8811da01b4545331836@st.budsies.com','2025-02-04 09:51:12'),(117,'599c2a028cd843165e095eca3244b5ec@st.budsies.com','2025-02-04 09:51:12'),(118,'8cde95fa56a976858e3d97f5fb7555af@st.budsies.com','2025-02-04 09:51:12'),(119,'873c4183c035853c162b76787348fb27@st.budsies.com','2025-02-04 09:51:12'),(120,'a11c31f2c31d0ff79cb88a11d1ebbc1c@st.budsies.com','2025-02-04 09:51:12'),(121,'cddba6c114c73ba7822027b5dcec7e4b@st.budsies.com','2025-02-04 09:51:12'),(122,'e977f28b5445807afc8e2dd7ec52d028@st.budsies.com','2025-02-04 09:51:12'),(123,'e7fa4840416d99dfd2467f7d755ac906@st.budsies.com','2025-02-04 09:51:12'),(124,'c5bd6cdf7f8ba6eb6450a944a9f3541e@st.budsies.com','2025-02-04 09:51:12'),(125,'7ac5936a469c7146e36d8127cf34ad26@st.budsies.com','2025-02-04 09:51:12'),(126,'a69cbd2660868008d585a6d5b80eaf9d@st.budsies.com','2025-02-04 09:51:12'),(127,'b56409d312b1aea3a7047af3741da6f3@st.budsies.com','2025-02-04 09:51:12'),(128,'fecad8300ac97c8562c57388068b6095@st.budsies.com','2025-02-04 09:51:12'),(129,'a8ac1d0dbfaf365dcb2ba70b1997edd2@st.budsies.com','2025-02-04 09:51:12'),(130,'5a458a064e365ef53dbd798414e9e808@st.budsies.com','2025-02-04 09:51:12'),(131,'31a2b084ec6e28095f57986c2ed0f17a@st.budsies.com','2025-02-04 09:51:12'),(132,'931f238d35d40cc6dd25b090373577fa@st.budsies.com','2025-02-04 09:51:12'),(133,'ba5677230449115811bdcbd6f5c61388@st.budsies.com','2025-02-04 09:51:12'),(134,'7ac7bd38ba156d5e026e2e1c953309d7@st.budsies.com','2025-02-04 09:51:12'),(135,'fc978adaa8e8720e278794d72f298b5a@st.budsies.com','2025-02-04 09:51:12'),(136,'c1903bcd8387d53dcb297153c8ef0399@st.budsies.com','2025-02-04 09:51:12'),(137,'c961888280db63eb4b17bcf46f36d9b8@st.budsies.com','2025-02-04 09:51:12'),(138,'b1341b616fb9048893b509f6f9399da4@st.budsies.com','2025-02-04 09:51:12'),(139,'ac96d59137ecc67a1c7d6ce9c5df307a@st.budsies.com','2025-02-04 09:51:12'),(140,'b5f1504aff04438938447dd038044452@st.budsies.com','2025-02-04 09:51:12'),(141,'399e06dcf7cb66c734dd8c89aac689e9@st.budsies.com','2025-02-04 09:51:12'),(142,'685ecae48b1e2b8b2524ed65fdf6eabf@st.budsies.com','2025-02-04 09:51:12'),(143,'61425028e1bb07346240360314a4ade3@st.budsies.com','2025-02-04 09:51:12'),(144,'e6fdd025e62f68abcc67892ebfccdde6@st.budsies.com','2025-02-04 09:51:12'),(145,'7eaf4b478fba16aba562d91459b01553@st.budsies.com','2025-02-04 09:51:12'),(146,'3bbf20a2b4593770d8248ec7b5fba1b2@st.budsies.com','2025-02-04 09:51:12'),(147,'f6800cfec1d7c5c9ace85dff884f05d4@st.budsies.com','2025-02-04 09:51:12'),(148,'611c14b3cf9d6b8ecf163a2b64fdeb39@st.budsies.com','2025-02-04 09:51:12'),(149,'b234f7bd21bac2ad1c8150e7535397fb@st.budsies.com','2025-02-04 09:51:12'),(150,'18c789adf6500b40f5ef960b596a520a@st.budsies.com','2025-02-04 09:51:12'),(151,'ec1f4a4d94b02f3137f96507bae96820@st.budsies.com','2025-02-04 09:51:12'),(152,'051606247bd37d97119bba785e2709fb@st.budsies.com','2025-02-04 09:51:12'),(153,'b7870558d0d879aecccd51bed3311e64@st.budsies.com','2025-02-04 09:51:12'),(154,'e554dfde95c1355ec062122bcea14064@st.budsies.com','2025-02-04 09:51:12'),(155,'49872747234b8d1a5ae3c07b0d68ca44@st.budsies.com','2025-02-04 09:51:12'),(156,'bde6ad9a9345dceb0b425980c56d332c@st.budsies.com','2025-02-04 09:51:12'),(157,'3561a955d8e63979a6e48949e393e74e@st.budsies.com','2025-02-04 09:51:12'),(158,'a5c181fa8040cff0497139108b7f268e@st.budsies.com','2025-02-04 09:51:12'),(159,'c6d0a48319264142dc8d8f429d32682f@st.budsies.com','2025-02-04 09:51:12'),(160,'8284948d70f5cb1344542fed34ee8b6e@st.budsies.com','2025-02-04 09:51:12'),(161,'3af6e5ce910b2318c6538f44009a2a87@st.budsies.com','2025-02-04 09:51:12'),(162,'57a7e2f031f83a705bcbf3e97e7a6fbb@st.budsies.com','2025-02-04 09:51:12'),(163,'82c63152f5e23db10f5f305ae1bfc8ab@st.budsies.com','2025-02-04 09:51:12'),(164,'e404cbd3757763ca20bed3b5d5739dd1@st.budsies.com','2025-02-04 09:51:12'),(165,'016f88bf578d547966f1163617117759@st.budsies.com','2025-02-04 09:51:12'),(166,'2dc44642006e2ef26cadfca63bf6a5da@st.budsies.com','2025-02-04 09:51:12'),(167,'c8a6eca522f1bceab3648402f4529f75@st.budsies.com','2025-02-04 09:51:12'),(168,'434d487518037af97e06f812bc7c4cde@st.budsies.com','2025-02-04 09:51:12'),(169,'9bd1a8bb2d3a080470bff7a6c76aa7e8@st.budsies.com','2025-02-04 09:51:12'),(170,'6edf4c69b68796440cd086a2b8290891@st.budsies.com','2025-02-04 09:51:12'),(171,'8c65b509fdbcf5ea9e5ed012186da05d@st.budsies.com','2025-02-04 09:51:12'),(172,'b2536c602f7e8d258bdd06b285201b65@st.budsies.com','2025-02-04 09:51:12'),(173,'7a65cf45ed344e2380488e5fed2cd849@st.budsies.com','2025-02-04 09:51:12'),(174,'0c584aad1436cbb71b1f780bbbb2ad79@st.budsies.com','2025-02-04 09:51:12'),(175,'352e3854932708500198b1562f790ab2@st.budsies.com','2025-02-04 09:51:12'),(176,'1b382b309934f618b60f0f81a10b4871@st.budsies.com','2025-02-04 09:51:12'),(177,'0da3a79b9be2503b11fab362744ba836@st.budsies.com','2025-02-04 09:51:12'),(178,'54a2741ec15e0da63eb58ef518635686@st.budsies.com','2025-02-04 09:51:12'),(179,'8859637a2d55c4b1db5b978bdfc7dc01@st.budsies.com','2025-02-04 09:51:12'),(180,'bbd685187b23d4854bd4977e7e9545fd@st.budsies.com','2025-02-04 09:51:12'),(181,'35e9f2cd4cae5eae7c82dc74183b1c4f@st.budsies.com','2025-02-04 09:51:12'),(182,'c6cc28fc2a86a7ca7fec26fd1401d7b7@st.budsies.com','2025-02-04 09:51:12'),(183,'311f3f2e593254a3da2f2d73673eb312@st.budsies.com','2025-02-04 09:51:12'),(184,'b7024e4efbf9728e6a4808d2c3a00d6d@st.budsies.com','2025-02-04 09:51:12'),(185,'f68fcd361f3d2945d33da63f3ab232be@st.budsies.com','2025-02-04 09:51:12'),(186,'994da66ed7c390592283a808e72c0494@st.budsies.com','2025-02-04 09:51:12'),(187,'614b8e405a18f4f043a6f1a15a8a1279@st.budsies.com','2025-02-04 09:51:12'),(188,'7423a9b5fce5a3142ad694eb2d278b28@st.budsies.com','2025-02-04 09:51:12'),(189,'457511af8dcb769709ca3f85cbc99881@st.budsies.com','2025-02-04 09:51:12'),(190,'606018ec22556e3e9825978aadb3b615@st.budsies.com','2025-02-04 09:51:12'),(191,'e5b1f06e620f8f6e4d2a4b8372e0599f@st.budsies.com','2025-02-04 09:51:12'),(192,'4b33fbf6b3fd4c61c61ffac8341ee313@st.budsies.com','2025-02-04 09:51:12'),(193,'365bd53c668405d62b95de81d78c0ba1@st.budsies.com','2025-02-04 09:51:12'),(194,'3df8d631f0d01c7c0dd1c86920e4e05a@st.budsies.com','2025-02-04 09:51:12'),(195,'fb98d903d7b4222434ffa4a75415788e@st.budsies.com','2025-02-04 09:51:12'),(196,'5d9407f8bbd93777a969d12392142cc7@st.budsies.com','2025-02-04 09:51:12'),(197,'607020dfdef7a5772e4abb374b629507@st.budsies.com','2025-02-04 09:51:12'),(198,'083f4ab4e74dbacc2e15bd73e081bf61@st.budsies.com','2025-02-04 09:51:12'),(199,'09e4175815baf91b137325f7c338ad22@st.budsies.com','2025-02-04 09:51:12'),(200,'f7b17f0434a973f844c6cc9333d1fabf@st.budsies.com','2025-02-04 09:51:12'),(201,'364f0e9283dfdfa0f406227c22bacfbf@st.budsies.com','2025-02-04 09:51:12'),(202,'abb20c1ff03c23fd81b448d54deace41@st.budsies.com','2025-02-04 09:51:12'),(203,'7fd69280ee0458f753ad68ba1891020b@st.budsies.com','2025-02-04 09:51:12'),(204,'588ed849094364d2f3a895469483dc79@st.budsies.com','2025-02-04 09:51:12'),(205,'3f982a0decf0815b71708a77d8428ffc@st.budsies.com','2025-02-04 09:51:12'),(206,'35b1f0b13dfef25396a77f832cacd996@st.budsies.com','2025-02-04 09:51:12'),(207,'6a3ee804a87355b22e7dbde936af51b4@st.budsies.com','2025-02-04 09:51:12'),(208,'f8349217671a2497a95dc93d0ef317e6@st.budsies.com','2025-02-04 09:51:12'),(209,'2a900e0b12f46754a5ebad014bdb093e@st.budsies.com','2025-02-04 09:51:12'),(210,'8db3958efd5bf0ec0a32b8a9bb11948c@st.budsies.com','2025-02-04 09:51:12'),(211,'802db73e423556b4ca3d61e28f37a58c@st.budsies.com','2025-02-04 09:51:12'),(212,'ffcdc4a51975bbeb88d27f8202fbdbbd@st.budsies.com','2025-02-04 09:51:12'),(213,'a293d72ec83260860e3cb8fd363997da@st.budsies.com','2025-02-04 09:51:12'),(214,'a2367a732cafed9d9717a0d055562467@st.budsies.com','2025-02-04 09:51:12'),(215,'9ca985532e45f9e452be49db451f1b3b@st.budsies.com','2025-02-04 09:51:12'),(216,'a4625a271b4af852f79bc41d78a7a593@st.budsies.com','2025-02-04 09:51:12'),(217,'3a9aa4d9a51af805d990a6d4e3183888@st.budsies.com','2025-02-04 09:51:12'),(218,'101c72c110e9c955766d30559d0f9df4@st.budsies.com','2025-02-04 09:51:12'),(219,'b42a0b90326f080ec2d80de297b7d3e9@st.budsies.com','2025-02-04 09:51:12'),(220,'2460964223adf4bf2c652684d8f17c77@st.budsies.com','2025-02-04 09:51:12'),(221,'ffcc74f547cf274ecd199b8f43c704a6@st.budsies.com','2025-02-04 09:51:12'),(222,'d7d1fce4c6d74f1a95dee9ea89865590@st.budsies.com','2025-02-04 09:51:12'),(223,'8c2800a7be99c831224ac5e96b7976a3@st.budsies.com','2025-02-04 09:51:12'),(224,'236b47fb19b788807dce6c2d6c111c0c@st.budsies.com','2025-02-04 09:51:12'),(225,'b22c5f82566975251b75b4731625b257@st.budsies.com','2025-02-04 09:51:12'),(226,'ac33e0c0810b59ac0fc8333a94855f85@st.budsies.com','2025-02-04 09:51:12'),(227,'1405e7a53cfa83165f3c1b26bb844b19@st.budsies.com','2025-02-04 09:51:12'),(228,'1604632e49c7dd77b5aa11bb5baecc79@st.budsies.com','2025-02-04 09:51:12'),(229,'3223ec021f5835dcb516dff1f8e747b1@st.budsies.com','2025-02-04 09:51:12'),(230,'ccbedbbb1bad0f4b93a22ea740e5883f@st.budsies.com','2025-02-04 09:51:12'),(231,'a84a7077b2d431ba70a9105d8428d537@st.budsies.com','2025-02-04 09:51:12'),(232,'62e306a228d60c7ac066bf53ed88fc3c@st.budsies.com','2025-02-04 09:51:12'),(233,'0a2ce028f2b3a394db67eaca718e76ba@st.budsies.com','2025-02-04 09:51:12'),(234,'4f75e75030cd38ef20b5bfdd20b801d1@st.budsies.com','2025-02-04 09:51:12'),(235,'e34bc4d6e9f39592875a409837db61fb@st.budsies.com','2025-02-04 09:51:12'),(236,'b3a96693184dc7479cfa069b7be1fa7a@st.budsies.com','2025-02-04 09:51:12'),(237,'d0c8c6ea6e5bed5ccfee1092df57e5c7@st.budsies.com','2025-02-04 09:51:12'),(238,'722116821490af8ae578b95d1763eb72@st.budsies.com','2025-02-04 09:51:12'),(239,'b9a2bcf19c9d72d38183e2aa4d8708f0@st.budsies.com','2025-02-04 09:51:12'),(240,'33ff1c9365bbaca57e80dadbf253f4df@st.budsies.com','2025-02-04 09:51:12'),(241,'b0fb6c7376de5fb0fc6d44a4f610f517@st.budsies.com','2025-02-04 09:51:12'),(242,'a16b9d95c6b41b73f23d34b71bc76c21@st.budsies.com','2025-02-04 09:51:12'),(243,'e27783589898280625de170ec23eb5d8@st.budsies.com','2025-02-04 09:51:12'),(244,'88317b75d04d3ef6bc3689b37445c0f5@st.budsies.com','2025-02-04 09:51:12'),(245,'649a2d551b5b2e674ed26a93094c3faa@st.budsies.com','2025-02-04 09:51:12'),(246,'3276e4665a704504196b1f312e2a17d0@st.budsies.com','2025-02-04 09:51:12'),(247,'e74bf3d5c4de14943cafd9bcb613f85b@st.budsies.com','2025-02-04 09:51:12'),(248,'f19bc4cc41cdcbb6d3ab5f3fe43efe9d@st.budsies.com','2025-02-04 09:51:12'),(249,'dcc596e8293e31349d84e468d40b23a5@st.budsies.com','2025-02-04 09:51:12'),(250,'70dd17e355122d1808ff4becb8d031e4@st.budsies.com','2025-02-04 09:51:12'),(251,'d1ddc202e2cd82a54eb74f15b83ef339@st.budsies.com','2025-02-04 09:51:12'),(252,'8dcd5795616c4689b61ddc48a5210beb@st.budsies.com','2025-02-04 09:51:12'),(253,'e35f9ece352aff659c1e655e598ec735@st.budsies.com','2025-02-04 09:51:12'),(254,'d437a8063f225549cf586c0af7a95c2e@st.budsies.com','2025-02-04 09:51:12'),(255,'649c494e37555fde01c311896b7eeaf1@st.budsies.com','2025-02-04 09:51:12'),(256,'885b3cd5ed757c38bb0319d02924b75a@st.budsies.com','2025-02-04 09:51:12'),(257,'cafe6dedb1e595dabd5530f14e34eb9b@st.budsies.com','2025-02-04 09:51:12'),(258,'6f3dd93c927299d91a03329f98ef4202@st.budsies.com','2025-02-04 09:51:12'),(259,'d6b4cd0a7d447c1e31523620fb9ca61e@st.budsies.com','2025-02-04 09:51:12'),(260,'610d1f227e669fa14f02a9b3a2724e4a@st.budsies.com','2025-02-04 09:51:12'),(261,'921f22b96703fb54d286872787c5857d@st.budsies.com','2025-02-04 09:51:12'),(262,'4876c3ac382b008b873f6b3b2a9a3163@st.budsies.com','2025-02-04 09:51:12'),(263,'4c36501003f60e47f9fca60a4c736dfb@st.budsies.com','2025-02-04 09:51:12'),(264,'8e20f6501a6ad23a156bb5391fcf2eae@st.budsies.com','2025-02-04 09:51:12'),(265,'45a867ba39f7cb28735f17f86ed6cc8a@st.budsies.com','2025-02-04 09:51:12'),(266,'f546a8b44891e96f048245565ec027a9@st.budsies.com','2025-02-04 09:51:12'),(267,'959881b1a90cebc2d4ee3fcbdb662256@st.budsies.com','2025-02-04 09:51:12'),(268,'a6f26b63dd722acc43cbef3a63d1d78a@st.budsies.com','2025-02-04 09:51:12'),(269,'6aa4d8d4edab2b1f8998236930bf3c45@st.budsies.com','2025-02-04 09:51:12'),(270,'8788168509d341bdcb8b852aca0a3d74@st.budsies.com','2025-02-04 09:51:12'),(271,'66a074b797861d15627ca72a1f575d79@st.budsies.com','2025-02-04 09:51:12'),(272,'1c4952b373f7a5b6ceba17b58aa7e917@